/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ca.affairs.card;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.jetbrains.annotations.NotNull;
import yem.base.common.utils.BigDecimalUtils;
import yem.wm.conmmon.common.GraphUtils;

public class DashCustomsCardPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        PieChart yem_piechartap = (PieChart)this.getControl("yem_piechartap");
        yem_piechartap.addClickListener((ClickListener)this);
        PieChart yem_piechartap1 = (PieChart)this.getControl("yem_piechartap1");
        yem_piechartap1.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handleQuery();
    }

    public void click(EventObject evt) {
        super.click(evt);
        ChartClickEvent chartClickEvent = (ChartClickEvent)evt;
        String key = ((Control)evt.getSource()).getKey();
        String name = chartClickEvent.getName();
        if ("yem_piechartap".equals(key)) {
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"yem_ca_cusdec", (String)"id,billno,yem_sumlocdecltotal,yem_billtypefield,yem_agentname", (QFilter[])new QFilter[]{new QFilter("yem_agentname", "=", (Object)name), new QFilter("yem_billtypefield.number", "=", (Object)"I")});
            ArrayList<String> list = new ArrayList<String>();
            BigDecimal yemSumlocdecltotal = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : load) {
                String billno = (String)dynamicObject.get("billno");
                yemSumlocdecltotal = yemSumlocdecltotal.add(dynamicObject.getBigDecimal("yem_sumlocdecltotal"));
                list.add(billno);
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"yem_ca_taxpayment", (String)"id,billno,yem_traamt", (QFilter[])new QFilter[]{new QFilter("yem_entryid", "in", list)});
            BigDecimal yemTraamt = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : dynamicObjects) {
                yemTraamt = yemTraamt.add(dynamicObject.getBigDecimal("yem_traamt"));
            }
            kd.bos.form.control.Label yem_labelap13 = (kd.bos.form.control.Label)this.getView().getControl("yem_labelap13");
            yemTraamt = yemTraamt.stripTrailingZeros();
            yem_labelap13.setText(yemTraamt.toString());
            kd.bos.form.control.Label yem_labelap14 = (kd.bos.form.control.Label)this.getView().getControl("yem_labelap14");
            yemSumlocdecltotal = BigDecimalUtils.div((Object)yemSumlocdecltotal, (Object)1, (int)2);
            yem_labelap14.setText(yemSumlocdecltotal.toString());
        } else if ("yem_piechartap1".equals(key)) {
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"yem_ca_cusdec", (String)"id,billno,yem_sumlocdecltotal,yem_agentname,yem_billtypefield", (QFilter[])new QFilter[]{new QFilter("yem_agentname", "=", (Object)name), new QFilter("yem_billtypefield.number", "=", (Object)"E")});
            ArrayList<String> list = new ArrayList<String>();
            for (DynamicObject dynamicObject : load) {
                String billno = (String)dynamicObject.get("billno");
                list.add(billno);
            }
            DynamicObject[] loaded = BusinessDataServiceHelper.load((String)"yem_ca_cuslaration", (String)"id,billno,yem_entryid,yem_ca_cuslcard,yem_ca_cuslcard.yem_decltotal", (QFilter[])new QFilter[]{new QFilter("yem_entryid", "in", list)});
            BigDecimal yemDecltotal = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : loaded) {
                DynamicObjectCollection yemCaCuslcard = dynamicObject.getDynamicObjectCollection("yem_ca_cuslcard");
                for (DynamicObject object : yemCaCuslcard) {
                    yemDecltotal = yemDecltotal.add(object.getBigDecimal("yem_decltotal"));
                }
            }
            kd.bos.form.control.Label yem_labelap19 = (kd.bos.form.control.Label)this.getView().getControl("yem_labelap19");
            if (yemDecltotal.compareTo(BigDecimal.ZERO) > 0) {
                yemDecltotal = BigDecimalUtils.div((Object)yemDecltotal, (Object)1, (int)2);
                yem_labelap19.setText(yemDecltotal.toString());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("yem_datefield".equals(name)) {
            Date yemDatefield = (Date)this.getModel().getValue("yem_datefield");
            PointLineChart chart = (PointLineChart)this.getControl("yem_pointlinechartap");
            LinkedHashMap<String, Map<String, BigDecimal>> data = this.initChartData(yemDatefield);
            GraphUtils.handleDrawChart((PointLineChart)chart, data, new LinkedHashMap(), (String)"\u5546\u54c1", (String)"\u62a5\u5173\u91d1\u989d\uff08\u4e07\u5143\uff09", (Collection)data.keySet().stream().map(month -> month).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
    }

    private void handleQuery() {
        DynamicObjectCollection yemEntryentity = this.getModel().getEntryEntity("yem_entryentity");
        DynamicObjectCollection yem_entryentity1 = this.getModel().getEntryEntity("yem_entryentity1");
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        HashMap<String, Integer> dataMaps = new HashMap<String, Integer>();
        DynamicObject[] yemCaCusdecI = BusinessDataServiceHelper.load((String)"yem_ca_cusdec", (String)"id,billno,yem_sumlocdecltotal,yem_agentname,yem_spdecseqno,yem_entryid,yem_sumlocdecltotal,yem_fiedatets", (QFilter[])new QFilter[]{new QFilter("yem_billtypefield.number", "=", (Object)"I")});
        BigDecimal yemSumlocdecltotalI = DashCustomsCardPlugin.getYemSumlocdecltotalI(yemCaCusdecI, yemEntryentity, dataMap);
        DynamicObject[] yemCaCusdecE = BusinessDataServiceHelper.load((String)"yem_ca_cusdec", (String)"id,billno,yem_sumlocdecltotal,yem_agentname,yem_spdecseqno,yem_entryid,yem_sumlocdecltotal,yem_fiedatets", (QFilter[])new QFilter[]{new QFilter("yem_billtypefield.number", "=", (Object)"E")});
        BigDecimal yemSumlocdecltotalE = DashCustomsCardPlugin.getYemSumlocdecltotalE(yemCaCusdecE, yem_entryentity1, dataMaps);
        kd.bos.form.control.Label yem_labelap1 = (kd.bos.form.control.Label)this.getView().getControl("yem_labelap1");
        kd.bos.form.control.Label yem_labelap11 = (kd.bos.form.control.Label)this.getView().getControl("yem_labelap11");
        kd.bos.form.control.Label yem_labelap12 = (kd.bos.form.control.Label)this.getView().getControl("yem_labelap12");
        yem_labelap1.setText(BigDecimalUtils.div((Object)yemSumlocdecltotalI, (Object)1, (int)2).toPlainString());
        yem_labelap11.setText(BigDecimalUtils.div((Object)yemSumlocdecltotalE, (Object)1, (int)2).toPlainString());
        yem_labelap12.setText(BigDecimalUtils.div((Object)yemSumlocdecltotalI.add(yemSumlocdecltotalE), (Object)1, (int)2).toPlainString());
        PointLineChart chart = (PointLineChart)this.getControl("yem_pointlinechartap");
        YearMonth currentYearMonth = YearMonth.now();
        LocalDate firstDayOfMonth = currentYearMonth.atDay(1);
        Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
        LinkedHashMap<String, Map<String, BigDecimal>> data = this.initChartData(date);
        GraphUtils.handleDrawChart((PointLineChart)chart, data, new LinkedHashMap(), (String)"\u5546\u54c1", (String)"\u62a5\u5173\u91d1\u989d\uff08\u4e07\u5143\uff09", (Collection)data.keySet().stream().map(month -> month).collect(Collectors.toCollection(LinkedHashSet::new)));
        this.pieChar("yem_piechartap", dataMap);
        this.pieChar("yem_piechartap1", dataMaps);
    }

    @NotNull
    private static BigDecimal getYemSumlocdecltotalI(DynamicObject[] yemCaCusdecI, DynamicObjectCollection yemEntryentity, Map<String, Integer> dataMap) {
        BigDecimal yemSumlocdecltotalI = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : yemCaCusdecI) {
            String billno = dynamicObject.getString("billno");
            BigDecimal yem_sumlocdecltotal = dynamicObject.getBigDecimal("yem_sumlocdecltotal");
            yemSumlocdecltotalI = yemSumlocdecltotalI.add(yem_sumlocdecltotal);
            dataMap.merge(dynamicObject.getString("yem_agentname"), yem_sumlocdecltotal.intValue(), Integer::sum);
            DynamicObject[] yemEntryids = BusinessDataServiceHelper.load((String)"yem_ca_taxpayment", (String)"id,billno,yem_traamt,yem_entryid,yem_taxtypename,yem_fiedatets", (QFilter[])new QFilter[]{new QFilter("yem_entryid", "=", (Object)billno)});
            BigDecimal newbigdecimal = BigDecimal.ZERO;
            BigDecimal newyemTraamt = BigDecimal.ZERO;
            BigDecimal newyemTraamt1 = BigDecimal.ZERO;
            BigDecimal newyemTraamt2 = BigDecimal.ZERO;
            for (DynamicObject yemEntryid : yemEntryids) {
                BigDecimal yemTraamt = yemEntryid.getBigDecimal("yem_traamt");
                newbigdecimal = newbigdecimal.add(yemTraamt);
                String yemTaxtypename = yemEntryid.getString("yem_taxtypename");
                if (yemTaxtypename.equals("\u5173\u7a0e")) {
                    newyemTraamt = newyemTraamt.add(yemTraamt);
                    continue;
                }
                if (yemTaxtypename.equals("\u589e\u503c\u7a0e")) {
                    newyemTraamt1 = newyemTraamt1.add(yemTraamt);
                    continue;
                }
                if (!yemTaxtypename.equals("\u6d88\u8d39\u7a0e")) continue;
                newyemTraamt2 = newyemTraamt2.add(yemTraamt);
            }
            BigDecimal yemSumlocdecltotal = dynamicObject.getBigDecimal("yem_sumlocdecltotal");
            if (yemSumlocdecltotal.compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject addNew = yemEntryentity.addNew();
            addNew.set("yem_textfield", (Object)dynamicObject.getString("yem_spdecseqno"));
            addNew.set("yem_textfield1", (Object)dynamicObject.getString("yem_entryid"));
            addNew.set("yem_amountfield", (Object)dynamicObject.getString("yem_sumlocdecltotal"));
            addNew.set("yem_datetimefield", (Object)dynamicObject.getDate("yem_fiedatets"));
            addNew.set("yem_amountfield1", (Object)newbigdecimal);
            addNew.set("yem_amountfield2", (Object)newyemTraamt);
            addNew.set("yem_amountfield3", (Object)newyemTraamt1);
            addNew.set("yem_amountfield4", (Object)newyemTraamt2);
        }
        return yemSumlocdecltotalI;
    }

    public static String removeTimeSuffix(String dateStr) {
        String suffix = " 00:00:00.0";
        if (dateStr.endsWith(suffix)) {
            return dateStr.substring(0, dateStr.length() - suffix.length());
        }
        return dateStr;
    }

    @NotNull
    private static BigDecimal getYemSumlocdecltotalE(DynamicObject[] yemCaCusdecE, DynamicObjectCollection yem_entryentity1, Map<String, Integer> dataMaps) {
        BigDecimal yemSumlocdecltotalE = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : yemCaCusdecE) {
            String billno = dynamicObject.getString("billno");
            BigDecimal yem_sumlocdecltotal = dynamicObject.getBigDecimal("yem_sumlocdecltotal");
            yemSumlocdecltotalE = yemSumlocdecltotalE.add(yem_sumlocdecltotal);
            if (dataMaps.size() < 15) {
                dataMaps.merge(dynamicObject.getString("yem_agentname"), yem_sumlocdecltotal.intValue(), Integer::sum);
            }
            DynamicObject[] yemEntryids = BusinessDataServiceHelper.load((String)"yem_ca_cuslaration", (String)"id,billno,yem_traamt,yem_ca_cuslcard.yem_gqty,yem_ca_cuslcard.,yem_ca_cuslcard.,yem_ca_cuslcard.", (QFilter[])new QFilter[]{new QFilter("yem_entryid", "=", (Object)billno)});
            BigDecimal yemGqty = BigDecimal.ZERO;
            BigDecimal yem_decltotal = BigDecimal.ZERO;
            BigDecimal yem_rmbprice = BigDecimal.ZERO;
            BigDecimal yem_usdprice = BigDecimal.ZERO;
            for (DynamicObject yemEntryid : yemEntryids) {
                DynamicObjectCollection yemCaCuslcard = yemEntryid.getDynamicObjectCollection("yem_ca_cuslcard");
                for (DynamicObject object : yemCaCuslcard) {
                    yemGqty = yemGqty.add(object.getBigDecimal("yem_gqty"));
                    yem_decltotal = yem_decltotal.add(object.getBigDecimal("yem_decltotal"));
                    yem_rmbprice = yem_rmbprice.add(object.getBigDecimal("yem_rmbprice"));
                    yem_usdprice = yem_usdprice.add(object.getBigDecimal("yem_usdprice"));
                }
            }
            BigDecimal yemSumlocdecltotal = dynamicObject.getBigDecimal("yem_sumlocdecltotal");
            if (yemSumlocdecltotal.compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject addNew = yem_entryentity1.addNew();
            addNew.set("yem_textfield2", (Object)dynamicObject.getString("yem_spdecseqno"));
            addNew.set("yem_textfield3", (Object)dynamicObject.getString("yem_entryid"));
            addNew.set("yem_amountfield5", (Object)dynamicObject.getString("yem_sumlocdecltotal"));
            addNew.set("yem_datetimefield1", (Object)dynamicObject.getDate("yem_fiedatets"));
            addNew.set("yem_decimalfield", (Object)yemGqty);
            addNew.set("yem_amountfield6", (Object)yem_decltotal);
            addNew.set("yem_amountfield7", (Object)yem_rmbprice);
            addNew.set("yem_amountfield8", (Object)yem_usdprice);
            addNew.set("yem_decimalfield1", (Object)BigDecimalUtils.div((BigDecimal)yem_rmbprice, (BigDecimal)yem_usdprice, (int)2));
        }
        return yemSumlocdecltotalE;
    }

    private void pieChar(String model, Map<String, Integer> dataMap) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("tpv_integer", "" + dataMap.size());
        PieChart pieChart = (PieChart)this.getControl(model);
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u8fdb\u53e3\u62a5\u5173\u884c\u5360\u6bd4", (String)"CarTypePieEdit_0", (String)"yem_em_cartypepie", (Object[])new Object[0]));
        series.setRadius("60", "100");
        ItemValue[] itemValues01 = new ItemValue[dataMap.size()];
        String[] str = DashCustomsCardPlugin.getRandColor(dataMap);
        int i = 0;
        for (String key : dataMap.keySet()) {
            itemValues01[i] = new ItemValue(key, (Number)dataMap.get(key), str[i]);
            ++i;
        }
        if (itemValues01.length == 0) {
            itemValues01 = new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"CarTypePieEdit_1", (String)"yem_em_cartypepie", (Object[])new Object[0]), (Number)0, "#cccccc")};
        }
        series.setData(itemValues01);
        String qty = this.getView().getPageCache().get("tpv_integer");
        PieSeries series2 = pieChart.createPieSeries(ResManager.loadKDString((String)"\u8fdb\u53e3\u62a5\u5173\u884c\u5360\u6bd4", (String)"CarTypePieEdit_0", (String)"yem_em_cartypepie", (Object[])new Object[0]));
        series2.setRadius("60");
        Label label = new Label();
        label.setShow(true);
        label.setFontSize("12");
        label.setFormatter(qty);
        label.setPosition(Position.inside);
        label.setColor("#b2b2b2");
        series2.setLabel(label);
        pieChart.refresh();
    }

    public static String[] getRandColor(Map<String, Integer> dataMap) {
        String[] str = new String[dataMap.size()];
        for (int i = 0; i < str.length; ++i) {
            Random random = new Random();
            String r = Integer.toHexString(random.nextInt(256)).toUpperCase();
            String g = Integer.toHexString(random.nextInt(256)).toUpperCase();
            String b = Integer.toHexString(random.nextInt(256)).toUpperCase();
            r = r.length() == 1 ? "0" + r : r;
            g = g.length() == 1 ? "0" + g : g;
            b = b.length() == 1 ? "0" + b : b;
            str[i] = "#" + r + g + b;
        }
        return str;
    }

    private LinkedHashMap<String, Map<String, BigDecimal>> initChartData(Date firstDayOfMonth) {
        LinkedHashMap<String, Map<String, BigDecimal>> data = new LinkedHashMap<String, Map<String, BigDecimal>>();
        DynamicObject[] yemCaCusdecI = BusinessDataServiceHelper.load((String)"yem_ca_cusdec", (String)"id,billno,yem_ca_cddetailedentry,yem_ca_cddetailedentry.yem_gname,yem_ca_cddetailedentry.yem_rmbdecltotal,yem_ca_cddetailedentry.yem_rmbdecltotal,yem_sumlocdecltotal,yem_agentname", (QFilter[])new QFilter[]{new QFilter("yem_fiedatets", "=", (Object)firstDayOfMonth)});
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (DynamicObject dynamicObject : yemCaCusdecI) {
            DynamicObjectCollection yemCaCddetailedentry = dynamicObject.getDynamicObjectCollection("yem_ca_cddetailedentry");
            for (DynamicObject object : yemCaCddetailedentry) {
                String yemCodets = object.getString("yem_gname");
                if (map.size() >= 10) continue;
                if (map.get(yemCodets) == null) {
                    map.put(yemCodets, object.getBigDecimal("yem_rmbdecltotal"));
                    continue;
                }
                map.put(yemCodets, ((BigDecimal)map.get(yemCodets)).add(object.getBigDecimal("yem_rmbdecltotal")));
            }
        }
        for (String string : map.keySet()) {
            data.put(string, this.quickMap("\u91d1\u989d", map.getOrDefault(string, BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP)));
        }
        return data;
    }

    private LinkedHashMap<String, BigDecimal> quickMap(String x, BigDecimal y) {
        LinkedHashMap<String, BigDecimal> map = new LinkedHashMap<String, BigDecimal>();
        map.put(x, y);
        return map;
    }
}

