/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ca.affairs.card;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.apache.commons.compress.utils.Lists;
import yem.base.common.utils.DateUtil;
import yem.base.common.utils.YEM;
import yem.wm.conmmon.common.GraphUtils;

public class DeclarationAnalysisCardPlugin
extends AbstractFormPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handleQuery();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_query", "yem_reset"});
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            default: {
                break;
            }
            case "yem_query": {
                this.handleQuery();
                break;
            }
            case "yem_reset": {
                this.handleReset();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (name) {
            default: {
                return;
            }
            case "yem_filter_bd": 
        }
        this.bringFilterData(model);
    }

    private void handleQuery() {
        PointLineChart chart = (PointLineChart)this.getControl("yem_declaration_chart");
        LinkedHashMap<String, Map<String, BigDecimal>> data = this.initChartData();
        GraphUtils.handleDrawChart((PointLineChart)chart, data, new LinkedHashMap(), (String)"\u6708\u4efd", (String)"\u62a5\u5173\u91d1\u989d\uff08\u4e07\u5143\uff09", (Collection)data.keySet().stream().map(month -> Integer.parseInt(month) + "\u6708\u4efd").collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    private LinkedHashMap<String, Map<String, BigDecimal>> initChartData() {
        LinkedHashMap<String, Map<String, BigDecimal>> data = new LinkedHashMap<String, Map<String, BigDecimal>>();
        IDataModel model = this.getModel();
        DynamicObject customsbroker = (DynamicObject)model.getValue("yem_companys");
        String cusbrkhscode = (String)model.getValue("yem_comphscodes");
        String companyName = (String)model.getValue("yem_customsbrokers");
        String terprisecode = (String)model.getValue("yem_cusbrkhscodes");
        Date date = (Date)model.getValue("yem_date");
        ArrayList<QFilter> qFilter = new ArrayList<QFilter>();
        qFilter.add(new QFilter("yem_localcurrency.number", "=", (Object)"CNY"));
        if (YEM.isNotEmpty((Object)customsbroker)) {
            qFilter.add(new QFilter("yem_consignorcname", "=", (Object)customsbroker.getString("name")));
        }
        if (YEM.isNotEmpty((Object)cusbrkhscode)) {
            qFilter.add(new QFilter("yem_cnsntradecode", "=", (Object)cusbrkhscode));
        }
        if (YEM.isNotEmpty((Object)companyName)) {
            qFilter.add(new QFilter("yem_agentname", "=", (Object)companyName));
        }
        if (YEM.isNotEmpty((Object)terprisecode)) {
            qFilter.add(new QFilter("yem_agentcode", "=", (Object)terprisecode));
        }
        if (YEM.isNotEmpty((Object)date)) {
            Date rangeStart = DateUtil.getLastYearEnd((Date)date);
            Date rangeEnd = DateUtil.getYearLast((Date)date);
            qFilter.add(new QFilter("yem_fiedatets", "<=", (Object)rangeEnd));
            qFilter.add(new QFilter("yem_fiedatets", ">=", (Object)rangeStart));
        }
        ArrayList selectFields = Lists.newArrayList();
        selectFields.add("yem_consignorcname");
        selectFields.add("yem_agentname");
        selectFields.add("yem_agentcode");
        selectFields.add("yem_sumlocdecltotal");
        selectFields.add("yem_fiedatets");
        DataSet dataSet = ORM.create().queryDataSet(this.algoKey, "yem_ca_cusdec", String.join((CharSequence)",", selectFields), qFilter.toArray(new QFilter[0]));
        dataSet = dataSet.select("TO_CHAR(yem_fiedatets, 'MM') date, yem_sumlocdecltotal / 10000 yem_sumlocdecltotal").groupBy(new String[]{"date"}).sum("yem_sumlocdecltotal").finish();
        DynamicObjectCollection c = ORM.create().toPlainDynamicObjectCollection(dataSet);
        Map<String, BigDecimal> mouthData = c.stream().collect(Collectors.toMap(k -> k.getString("date"), v -> v.getBigDecimal("yem_sumlocdecltotal")));
        for (int i = 1; i <= 12; ++i) {
            String key = String.format("%02d", i);
            data.put(key, this.quickMap("\u91d1\u989d", mouthData.getOrDefault(key, BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP)));
        }
        return data;
    }

    private LinkedHashMap<String, BigDecimal> quickMap(String x, BigDecimal y) {
        LinkedHashMap<String, BigDecimal> map = new LinkedHashMap<String, BigDecimal>();
        map.put(x, y);
        return map;
    }

    private void handleReset() {
        IDataModel model = this.getModel();
        model.setValue("yem_filter_bd", null);
        PointLineChart chart = (PointLineChart)this.getControl("yem_declaration_chart");
        model.setValue("yem_companys", null);
        model.setValue("yem_comphscodes", null);
        model.setValue("yem_customsbrokers", null);
        model.setValue("yem_cusbrkhscodes", null);
        model.setValue("yem_date", null);
        LinkedHashMap<String, LinkedHashMap<String, BigDecimal>> data = new LinkedHashMap<String, LinkedHashMap<String, BigDecimal>>();
        for (int i = 1; i <= 12; ++i) {
            String key = String.valueOf(i);
            data.put(key, this.quickMap("\u91d1\u989d", new BigDecimal("0.0")));
        }
        ArrayList xFields = new ArrayList(data.keySet());
        xFields.sort(Comparator.comparingInt(Integer::parseInt));
        GraphUtils.handleDrawChart((PointLineChart)chart, data, new LinkedHashMap(), (String)"\u6708\u4efd", (String)"\u62a5\u5173\u91d1\u989d\uff08\u4e07\u5143\uff09", (Collection)data.keySet().stream().map(month -> month + "\u6708\u4efd").collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    private void bringFilterData(IDataModel model) {
        DynamicObject filter_bd = (DynamicObject)model.getValue("yem_filter_bd");
        if (YEM.isEmpty((Object)filter_bd)) {
            model.setValue("yem_companys", null);
            model.setValue("yem_comphscodes", null);
            model.setValue("yem_customsbrokers", null);
            model.setValue("yem_cusbrkhscodes", null);
            return;
        }
        DynamicObject company = filter_bd.getDynamicObject("yem_compan_bd");
        String compcodes = filter_bd.getString("yem_compcodes");
        String customsbroker = filter_bd.getString("yem_customsbroker");
        String cusbrkhscode = filter_bd.getString("yem_cusbrkhscode");
        Date date = filter_bd.getDate("yem_date");
        model.setValue("yem_companys", (Object)company);
        model.setValue("yem_comphscodes", (Object)compcodes);
        model.setValue("yem_customsbrokers", (Object)customsbroker);
        model.setValue("yem_cusbrkhscodes", (Object)cusbrkhscode);
        model.setValue("yem_date", (Object)date);
    }
}

