/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.bill.carfreight.dynamic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.nacos.common.utils.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.Label;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import org.apache.commons.compress.utils.Lists;
import yem.base.common.utils.DateUtil;
import yem.base.common.utils.YEM;
import yem.wm.gs.common.utils.DateUtils;
import yem.wm.gs.service.map.dal.FitBoundsData;
import yem.wm.gs.service.map.dal.MapMessage;
import yem.wm.gs.service.map.dal.MarkData;
import yem.wm.gs.service.map.dal.MarkerStyle;
import yem.wm.gs.service.map.dal.SetViewData;
import yem.wm.gs.service.map.dal.StatisticsData;
import yem.wm.gs.service.map.dal.TrajectoryData;
import yem.wm.gs.service.map.dal.TrajectoryPoint;
import yem.wm.gs.service.map.enums.MapIconEnums;
import yem.wm.gs.service.map.enums.MapMessageType;
import yem.wm.gs.service.map.enums.ShowTypeEnums;
import yem.wm.gs.trsnport.bill.seafreight.dynamic.dto.TrajectoryInfo;
import yem.wm.gs.trsnport.bill.seafreight.dynamic.enums.ShippingStatusConstants;

public class CarTrackingFormPlugin
extends AbstractFormPlugin
implements Plugin,
RowClickEventListener {
    private static final int bolCardMaxCapacity = 1;
    private static final int sumCardMaxCapacity = 4;
    private String MAP = "https://map.wmyun.com";
    private static final Map<Long, String> SHIP_TYPE_MAP = new HashMap<Long, String>();
    private static final SimpleDateFormat sdf;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handleInit();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String pageId = view.getPageId();
        this.MAP = this.MAP + "?pageId=" + pageId;
        FormShowParameter fsp = view.getFormShowParameter();
        Map data = fsp.getCustomParams();
        if (data.containsKey("params")) {
            Map params = (Map)data.get("params");
            if (params.containsKey("yem_bol")) {
                String yemBol = params.get("yem_bol").toString();
                model.setValue("yem_bol", (Object)yemBol);
                this.handleSearch();
            }
        } else {
            this.initVoyageData();
        }
    }

    private void handleInit() {
        int i;
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        cache.put("current_focus", "yem_card_1");
        cache.put("current_page", "init");
        for (i = 1; i <= 1; ++i) {
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_card_" + i});
        }
        for (i = 1; i <= 4; ++i) {
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_card_ent_" + i});
        }
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_timestep"});
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_sumlist"});
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_bollist"});
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_btn_back"});
    }

    private void handleBack() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.handleInit();
        this.initVoyageData();
        view.addClientCallBack("clear");
        model.setValue("yem_contract", null);
        model.setValue("yem_bol", null);
        model.setValue("yem_vesselname", null);
        model.setValue("yem_voyage", null);
    }

    private void initVoyageData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        JSONArray responseArray = this.getPresetVoyageData();
        for (int i = 0; i < responseArray.size() && i <= 3; ++i) {
            int idx = i + 1;
            JSONObject object = (JSONObject)responseArray.get(i);
            String pol = object.getString("polName");
            String pod = object.getString("podName");
            String polEn = object.getString("polNameEn");
            String podEn = object.getString("podNameEn");
            JSONArray data = object.getJSONArray("data");
            this.set(idx, "yem_ent_pol_", pol);
            this.set(idx, "yem_ent_pod_", pod);
            this.set(idx, "yem_ent_polen_", polEn);
            this.set(idx, "yem_ent_poden_", podEn);
            view.setVisible(Boolean.valueOf(true), new String[]{"yem_card_ent_" + idx});
            model.deleteEntryData("yem_ent_" + idx);
            for (int j = 0; j < data.size(); ++j) {
                JSONObject sub = (JSONObject)data.get(j);
                String shipName = sub.getString("shipName");
                String voyage = sub.getString("voyage");
                String bol = sub.getString("bol");
                String eta = DateUtil.formatDate((Date)new Date(sub.getLong("eta")));
                String etd = DateUtil.formatDate((Date)new Date(sub.getLong("etd")));
                model.createNewEntryRow("yem_ent_" + idx);
                model.setValue("yem_e_shipname_" + idx, (Object)shipName, j);
                model.setValue("yem_e_voy_" + idx, (Object)voyage, j);
                model.setValue("yem_e_eta_" + idx, (Object)eta, j);
                model.setValue("yem_e_etd_" + idx, (Object)etd, j);
                model.setValue("yem_e_bol_" + idx, (Object)bol, j);
            }
        }
    }

    private JSONArray getPresetVoyageData() {
        JSONArray data = new JSONArray();
        JSONObject route1 = new JSONObject();
        route1.put("polName", (Object)"\u7ea6\u7ff0\u5185\u65af\u5821");
        route1.put("podName", (Object)"\u5185\u7f57\u6bd5");
        route1.put("polNameEn", (Object)"Johannesburg");
        route1.put("podNameEn", (Object)"Nairobi");
        JSONArray route1Data = new JSONArray();
        JSONObject trip1 = new JSONObject();
        trip1.put("shipName", (Object)"ZA-KE-001");
        trip1.put("voyage", (Object)"202412-01");
        trip1.put("bol", (Object)"CAR-ZA-001");
        trip1.put("eta", (Object)(System.currentTimeMillis() + 432000000L));
        trip1.put("etd", (Object)(System.currentTimeMillis() - 172800000L));
        route1Data.add((Object)trip1);
        JSONObject trip2 = new JSONObject();
        trip2.put("shipName", (Object)"ZA-KE-002");
        trip2.put("voyage", (Object)"202412-02");
        trip2.put("bol", (Object)"CAR-ZA-002");
        trip2.put("eta", (Object)(System.currentTimeMillis() + 604800000L));
        trip2.put("etd", (Object)System.currentTimeMillis());
        route1Data.add((Object)trip2);
        route1.put("data", (Object)route1Data);
        data.add((Object)route1);
        JSONObject route2 = new JSONObject();
        route2.put("polName", (Object)"\u5f00\u7f57");
        route2.put("podName", (Object)"\u4e9a\u7684\u65af\u4e9a\u8d1d\u5df4");
        route2.put("polNameEn", (Object)"Cairo");
        route2.put("podNameEn", (Object)"Addis Ababa");
        JSONArray route2Data = new JSONArray();
        JSONObject trip3 = new JSONObject();
        trip3.put("shipName", (Object)"EG-ET-001");
        trip3.put("voyage", (Object)"202412-03");
        trip3.put("bol", (Object)"CAR-EG-001");
        trip3.put("eta", (Object)(System.currentTimeMillis() + 259200000L));
        trip3.put("etd", (Object)(System.currentTimeMillis() - 86400000L));
        route2Data.add((Object)trip3);
        route2.put("data", (Object)route2Data);
        data.add((Object)route2);
        JSONObject route3 = new JSONObject();
        route3.put("polName", (Object)"\u8fbe\u7d2f\u65af\u8428\u62c9\u59c6");
        route3.put("podName", (Object)"\u574e\u5e15\u62c9");
        route3.put("polNameEn", (Object)"Dar es Salaam");
        route3.put("podNameEn", (Object)"Kampala");
        JSONArray route3Data = new JSONArray();
        JSONObject trip4 = new JSONObject();
        trip4.put("shipName", (Object)"TZ-UG-001");
        trip4.put("voyage", (Object)"202412-04");
        trip4.put("bol", (Object)"CAR-TZ-001");
        trip4.put("eta", (Object)(System.currentTimeMillis() + 345600000L));
        trip4.put("etd", (Object)(System.currentTimeMillis() - 86400000L));
        route3Data.add((Object)trip4);
        route3.put("data", (Object)route3Data);
        data.add((Object)route3);
        return data;
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        super.entryRowDoubleClick(e);
        EntryGrid source = (EntryGrid)e.getSource();
        IFormView view = this.getView();
        String key = source.getKey();
        IDataModel model = this.getModel();
        int idx = Integer.parseInt(key.substring(key.lastIndexOf("_") + 1));
        int[] rows = source.getSelectRows();
        if (rows.length > 0) {
            int j = rows[0];
            model.setValue("yem_bol", model.getValue("yem_e_bol_" + idx), j);
            model.setValue("yem_contract", null);
            model.setValue("yem_vesselname", model.getValue("yem_e_shipname_" + idx), j);
            model.setValue("yem_voyage", model.getValue("yem_e_voy_" + idx), j);
            view.addClientCallBack("search");
        }
    }

    private void setDefaultPicture() {
        IDataModel model = this.getModel();
        DynamicObject picture = BusinessDataServiceHelper.loadSingleFromCache((String)"yem_gs_bdpicture", (QFilter[])new QFilter[0]);
        if (YEM.isNotEmpty((Object)picture)) {
            model.setValue("yem_picture", picture.get("yem_picture"));
        }
    }

    private void initStatisticsInfo() {
        JSONObject response = this.getPresetStatisticsInfo();
        ArrayList msg = Lists.newArrayList();
        if (response.containsKey((Object)"totalCount")) {
            msg.add(new StatisticsData("\u603b\u8f66\u8f86\u6570", response.getString("totalCount"), null));
        }
        if (response.containsKey((Object)"onWayCount")) {
            msg.add(new StatisticsData("\u5728\u9014\u8f66\u8f86\u6570", response.getString("onWayCount"), null));
        }
        if (response.containsKey((Object)"arrivedCount")) {
            msg.add(new StatisticsData("\u8fd0\u62b5\u8f66\u8f86\u6570", response.getString("arrivedCount"), null));
        }
        if (response.containsKey((Object)"willArrivedCount")) {
            msg.add(new StatisticsData("\u5373\u5c06\u5230\u8fbe", response.getString("willArrivedCount"), null));
        }
        MapMessage mapMessage = new MapMessage();
        mapMessage.setType(MapMessageType.INIT_STATS);
        mapMessage.setPayload((Object)msg);
        this.sendPostMessage(mapMessage);
    }

    private JSONObject getPresetStatisticsInfo() {
        JSONObject stats = new JSONObject();
        stats.put("totalCount", (Object)"25");
        stats.put("onWayCount", (Object)"18");
        stats.put("arrivedCount", (Object)"5");
        stats.put("willArrivedCount", (Object)"2");
        return stats;
    }

    public void registerListener(EventObject e) {
        int i;
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_btn_search", "yem_btn_back"});
        for (i = 1; i <= 1; ++i) {
            this.addClickListeners(new String[]{"yem_card_" + i});
            this.addClickListeners(new String[]{"yem_boxinfo_" + i});
            this.addClickListeners(new String[]{"yem_a_relayinfo_" + i});
        }
        for (i = 1; i <= 4; ++i) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("yem_ent_" + i);
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void click(EventObject evt) {
        HashMap data;
        String bol;
        String idx;
        IPageCache cache;
        String currentFocus;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        if (key.equals("yem_btn_search")) {
            this.handleSearch();
        }
        if (key.equals("yem_btn_back")) {
            this.handleBack();
        }
        if (key.startsWith("yem_card_") && !key.equals(currentFocus = (cache = view.getPageCache()).get("current_focus"))) {
            cache.put("current_focus", key);
            this.handleCardFocusChange();
        }
        if (key.startsWith("yem_boxinfo_")) {
            idx = key.substring(key.lastIndexOf("_") + 1);
            bol = this.get("yem_card_title_" + idx);
            data = Maps.newHashMap();
            data.put("bol", bol);
            this.openForm("yem_gs_sea_boxinfo", data);
        }
        if (key.startsWith("yem_a_relayinfo_")) {
            idx = key.substring(key.lastIndexOf("_") + 1);
            bol = this.get("yem_card_title_" + idx);
            data = Maps.newHashMap();
            data.put("bol", bol);
            this.openForm("yem_gs_sea_relayinfo", data);
        }
    }

    private void openForm(String formId, Map<String, String> params) {
        IFormView view = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        for (Map.Entry<String, String> e : params.entrySet()) {
            parameter.setCustomParam(e.getKey(), (Object)e.getValue());
        }
        view.showForm(parameter);
    }

    private void handleCardFocusChange() {
        IFormView view = this.getView();
        int value = this.getCurrentFocusIdx();
        String bol = this.get("yem_card_title_" + value);
        this.updateBillStepStatusDataByBOL(bol);
        view.addClientCallBack("map-init");
    }

    public int getCurrentFocusIdx() {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        String currentFocus = cache.get("current_focus");
        return Integer.parseInt(currentFocus.substring(currentFocus.lastIndexOf("_") + 1));
    }

    private void handleSearch() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_timestep"});
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_sumlist"});
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_bollist"});
        cache.put("current_page", "search");
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_btn_back"});
        String contract = (String)model.getValue("yem_contract");
        LinkedHashSet bol = Sets.newLinkedHashSet();
        if (YEM.isNotEmpty((Object)contract)) {
            bol = this.queryLadingBillNoByContractNo(contract);
        }
        String inputBol = (String)model.getValue("yem_bol");
        if (!bol.isEmpty() && YEM.isNotEmpty((Object)inputBol)) {
            LinkedHashSet filter = Sets.newLinkedHashSet();
            for (String s : bol) {
                if (!s.equals(inputBol)) continue;
                filter.add(inputBol);
            }
            bol = filter;
        }
        if (bol.isEmpty() && YEM.isEmpty((Object)inputBol)) {
            view.showErrorNotification("\u8f93\u5165\u6709\u6548\u6570\u636e!");
            return;
        }
        if (bol.isEmpty() && YEM.isNotEmpty((Object)inputBol)) {
            bol.add((String)inputBol);
        }
        for (int i = 1; i <= bol.size() && i <= 1; ++i) {
            view.setVisible(Boolean.valueOf(true), new String[]{"yem_card_" + i});
        }
        if (!bol.isEmpty()) {
            this.fetchBillInfoByBOL(bol);
            this.updateBillStepStatusDataByBOL((String)bol.iterator().next());
            this.fetchBoxDataByBOL(bol);
            view.addClientCallBack("map-init");
        } else {
            view.showErrorNotification("\u672a\u627e\u5230\u6709\u6548\u6570\u636e!");
        }
        String vesselname = (String)model.getValue("yem_vesselname");
        String voyage = (String)model.getValue("yem_voyage");
    }

    private LinkedHashSet<String> queryLadingBillNoByContractNo(String contract) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("CAR-ZA-001");
        set.add("CAR-EG-001");
        set.add("CAR-TZ-001");
        set.add("CAR-ZA-002");
        return set;
    }

    private void fetchBoxDataByBOL(LinkedHashSet<String> bol) {
        JSONObject responseObject = this.getPresetBoxInfoByBOL(bol);
        Map response = (Map)responseObject.toJavaObject((TypeReference)new TypeReference<Map<String, List<JSONObject>>>(){});
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        int index = 1;
        ArrayList<String> list = new ArrayList<String>(bol);
        for (int i = 0; i < list.size() && i < 1; ++i) {
            String value = (String)list.get(i);
            map.put(value, index++);
        }
        for (Map.Entry e : response.entrySet()) {
            String k = (String)e.getKey();
            List value = (List)e.getValue();
            if (!map.containsKey(k)) continue;
            int i = (Integer)map.get(k);
            this.setBoxData(i, value);
        }
    }

    private JSONObject getPresetBoxInfoByBOL(LinkedHashSet<String> bols) {
        JSONObject result = new JSONObject();
        for (String bolNo : bols) {
            JSONObject box1;
            ArrayList<JSONObject> boxes = new ArrayList<JSONObject>();
            if ("CAR-ZA-001".equals(bolNo)) {
                box1 = new JSONObject();
                box1.put("ctnrNo", (Object)"CONT-ZA-001");
                box1.put("sealNo", (Object)"SEAL-001");
                box1.put("ctnrSize", (Object)"40");
                box1.put("ctnrType", (Object)"GP");
                box1.put("pkgs", (Object)"100");
                box1.put("gwgt", (Object)"15000");
                boxes.add(box1);
                JSONObject box2 = new JSONObject();
                box2.put("ctnrNo", (Object)"CONT-ZA-002");
                box2.put("sealNo", (Object)"SEAL-002");
                box2.put("ctnrSize", (Object)"40");
                box2.put("ctnrType", (Object)"HQ");
                box2.put("pkgs", (Object)"120");
                box2.put("gwgt", (Object)"18000");
                boxes.add(box2);
            } else if ("CAR-EG-001".equals(bolNo)) {
                box1 = new JSONObject();
                box1.put("ctnrNo", (Object)"CONT-EG-001");
                box1.put("sealNo", (Object)"SEAL-003");
                box1.put("ctnrSize", (Object)"20");
                box1.put("ctnrType", (Object)"GP");
                box1.put("pkgs", (Object)"80");
                box1.put("gwgt", (Object)"12000");
                boxes.add(box1);
            } else if ("CAR-TZ-001".equals(bolNo)) {
                box1 = new JSONObject();
                box1.put("ctnrNo", (Object)"CONT-TZ-001");
                box1.put("sealNo", (Object)"SEAL-004");
                box1.put("ctnrSize", (Object)"40");
                box1.put("ctnrType", (Object)"GP");
                box1.put("pkgs", (Object)"150");
                box1.put("gwgt", (Object)"20000");
                boxes.add(box1);
            }
            result.put(bolNo, boxes);
        }
        return result;
    }

    private void setBoxData(int i, List<JSONObject> value) {
        HashSet boxnum = Sets.newHashSet();
        HashSet sealno = Sets.newHashSet();
        HashSet size = Sets.newHashSet();
        HashSet type = Sets.newHashSet();
        HashSet qty = Sets.newHashSet();
        HashSet gwgt = Sets.newHashSet();
        for (JSONObject data : value) {
            boxnum.add(this.get(data, "ctnrNo"));
            sealno.add(this.get(data, "sealNo"));
            size.add(this.get(data, "ctnrSize"));
            type.add(this.get(data, "ctnrType"));
            qty.add(this.get(data, "pkgs"));
            gwgt.add(this.get(data, "gwgt"));
        }
        this.set(i, "yem_b_boxnum_", "\u7bb1\u53f7", this.join(boxnum));
        this.set(i, "yem_b_sealno_", "\u94c5\u5c01\u53f7", this.join(sealno));
        this.set(i, "yem_b_size_", "\u5c3a\u5bf8", this.join(size));
        this.set(i, "yem_b_type_", "\u7bb1\u578b", this.join(type));
        this.set(i, "yem_b_qty_", "\u4ef6\u6570", this.join(qty));
        this.set(i, "yem_b_gwgt_", "\u6bdb\u91cd", this.join(gwgt));
        this.set(i, "yem_b_totalqty_", "\u7bb1\u5b50\u603b\u6570", String.valueOf(value.size()));
    }

    private String join(Set<String> set) {
        if ((set = set.stream().filter(StringUtils::hasText).collect(Collectors.toSet())).isEmpty()) {
            return "\u6682\u65e0\u6570\u636e";
        }
        return String.join((CharSequence)",", set);
    }

    private String extractFirstItem(String joinedStr) {
        if (StringUtils.isEmpty((String)joinedStr) || "\u6682\u65e0\u6570\u636e".equals(joinedStr)) {
            return "";
        }
        Set set = Arrays.stream(joinedStr.split(",")).map(String::trim).filter(StringUtils::hasText).collect(Collectors.toSet());
        return set.isEmpty() ? "" : (String)set.iterator().next();
    }

    private String get(JSONObject data, String k) {
        if (data.containsKey((Object)k) && YEM.isNotEmpty((Object)data.get((Object)k))) {
            return data.getString(k);
        }
        return "";
    }

    private void fetchBillInfoByBOL(LinkedHashSet<String> bol) {
        JSONArray response = this.getPresetBillInfoByBOL(bol);
        List responseList = response.toJavaList(JSONObject.class);
        CarTrackingFormPlugin.sortByReferenceNo(responseList, bol);
        Map<String, Boolean> isRelay = this.fetchIsRelayTransport(bol);
        for (JSONObject resObj : responseList) {
            String referenceNo = resObj.getString("referenceNo");
            if (!isRelay.containsKey(referenceNo)) continue;
            resObj.put("isRelay", (Object)isRelay.get(referenceNo));
        }
        this.setBillInfo(responseList);
        this.fetchAISInfo(responseList);
    }

    private JSONArray getPresetBillInfoByBOL(LinkedHashSet<String> bols) {
        JSONArray result = new JSONArray();
        for (String bolNo : bols) {
            JSONObject bill = new JSONObject();
            bill.put("referenceNo", (Object)bolNo);
            if ("CAR-ZA-001".equals(bolNo)) {
                bill.put("vesselName", (Object)"ZA-KE-001");
                bill.put("pol", (Object)"\u7ea6\u7ff0\u5185\u65af\u5821");
                bill.put("pod", (Object)"\u5185\u7f57\u6bd5");
                bill.put("etd", (Object)new Date(System.currentTimeMillis() - 172800000L));
                bill.put("eta", (Object)new Date(System.currentTimeMillis() + 432000000L));
            } else if ("CAR-EG-001".equals(bolNo)) {
                bill.put("vesselName", (Object)"EG-ET-001");
                bill.put("pol", (Object)"\u5f00\u7f57");
                bill.put("pod", (Object)"\u4e9a\u7684\u65af\u4e9a\u8d1d\u5df4");
                bill.put("etd", (Object)new Date(System.currentTimeMillis() - 86400000L));
                bill.put("eta", (Object)new Date(System.currentTimeMillis() + 259200000L));
            } else if ("CAR-TZ-001".equals(bolNo)) {
                bill.put("vesselName", (Object)"TZ-UG-001");
                bill.put("pol", (Object)"\u8fbe\u7d2f\u65af\u8428\u62c9\u59c6");
                bill.put("pod", (Object)"\u574e\u5e15\u62c9");
                bill.put("etd", (Object)new Date(System.currentTimeMillis() - 86400000L));
                bill.put("eta", (Object)new Date(System.currentTimeMillis() + 345600000L));
            } else if ("CAR-ZA-002".equals(bolNo)) {
                bill.put("vesselName", (Object)"ZA-KE-002");
                bill.put("pol", (Object)"\u7ea6\u7ff0\u5185\u65af\u5821");
                bill.put("pod", (Object)"\u5185\u7f57\u6bd5");
                bill.put("etd", (Object)new Date(System.currentTimeMillis()));
                bill.put("eta", (Object)new Date(System.currentTimeMillis() + 604800000L));
            }
            result.add((Object)bill);
        }
        return result;
    }

    private Map<String, Boolean> fetchIsRelayTransport(LinkedHashSet<String> bol) {
        HashMap result = Maps.newHashMap();
        for (String bolNo : bol) {
            result.put(bolNo, false);
        }
        return result;
    }

    public static List<JSONObject> sortByReferenceNo(List<JSONObject> responseList, LinkedHashSet<String> bol) {
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        int index = 0;
        for (String key : bol) {
            orderMap.put(key, index++);
        }
        responseList.sort((o1, o2) -> {
            String ref1 = o1.getString("referenceNo");
            String ref2 = o2.getString("referenceNo");
            Integer index1 = (Integer)orderMap.get(ref1);
            Integer index2 = (Integer)orderMap.get(ref2);
            if (index1 == null || index2 == null) {
                throw new IllegalArgumentException("referenceNo not found in bol: " + (index1 == null ? ref1 : ref2));
            }
            return Integer.compare(index1, index2);
        });
        return responseList;
    }

    private void setBillInfo(List<JSONObject> data) {
        IFormView view = this.getView();
        for (int idx = 0; idx < data.size() && idx < 1; ++idx) {
            JSONObject response = data.get(idx);
            int i = idx + 1;
            this.set(i, "yem_card_title_", "\u8fd0\u5355\u53f7", response.getString("referenceNo"));
            this.set(i, "yem_a_shipname_", "\u8f66\u8f86\u53f7", response.getString("vesselName"));
            this.set(i, "yem_a_pol_", "\u51fa\u53d1\u5730", response.getString("pol"));
            this.set(i, "yem_a_pod_", "\u76ee\u7684\u5730", response.getString("pod"));
            this.set(i, "yem_a_eta_", "ETA", DateUtils.getData((Date)response.getDate("etd"), (String)"yyyy-MM-dd HH:mm:ss"));
            this.set(i, "yem_a_etd_", "ETD", DateUtils.getData((Date)response.getDate("eta"), (String)"yyyy-MM-dd HH:mm:ss"));
            this.set(i, "yem_ac_pol_", "", response.getString("pol"));
            this.set(i, "yem_ac_pod_", "", response.getString("pod"));
            this.set(i, "yem_ac_eta_", "", DateUtils.getData((Date)response.getDate("etd"), (String)"yyyy-MM-dd HH:mm:ss"));
            this.set(i, "yem_ac_etd_", "", DateUtils.getData((Date)response.getDate("eta"), (String)"yyyy-MM-dd HH:mm:ss"));
            String isRelay = response.getBoolean("isRelay") != false ? "\u662f" : "\u5426";
            this.set(i, "yem_a_relay_", "\u662f\u5426\u4e2d\u8f6c", isRelay);
            if ("\u662f".equals(isRelay)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"yem_a_relayinfo_" + i});
                continue;
            }
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_a_relayinfo_" + i});
        }
    }

    private void fetchAISInfo(List<JSONObject> data) {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        HashMap dataRelation = Maps.newHashMap();
        for (int idx = 0; idx < data.size() && idx < 1; ++idx) {
            JSONObject response = data.get(idx);
            dataRelation.put(response.getString("vesselName"), idx + 1);
        }
        HashMap responseData = Maps.newHashMap();
        JSONArray array = this.getPresetVehicleLocation(dataRelation.keySet());
        List list = array.toJavaList(JSONObject.class);
        for (JSONObject obj : list) {
            String vslName = obj.getString("vslName");
            if (!dataRelation.containsKey(vslName)) continue;
            responseData.put(dataRelation.get(vslName), obj);
        }
        cache.put("ais_info", JSON.toJSONString((Object)responseData));
        this.setAISInfo(responseData);
    }

    private JSONArray getPresetVehicleLocation(Set<String> vehicleNames) {
        JSONArray result = new JSONArray();
        for (String vehicleName : vehicleNames) {
            JSONObject vehicle = new JSONObject();
            vehicle.put("vslName", (Object)vehicleName);
            vehicle.put("callSign", (Object)("LAND-" + vehicleName));
            vehicle.put("imo", (Object)"");
            vehicle.put("mmsi", (Object)"");
            vehicle.put("dest", (Object)"");
            vehicle.put("shipType", (Object)70L);
            vehicle.put("builtYear", (Object)"2020");
            vehicle.put("dwt", (Object)"25000");
            vehicle.put("length", (Object)"12");
            vehicle.put("width", (Object)"2.5");
            vehicle.put("cog", (Object)"180");
            vehicle.put("hdg", (Object)"180");
            vehicle.put("draught", (Object)"");
            vehicle.put("naviStatus", (Object)0L);
            vehicle.put("sog", (Object)"60");
            if ("ZA-KE-001".equals(vehicleName)) {
                vehicle.put("longitude", (Object)"32.5");
                vehicle.put("latitude", (Object)"-6.0");
            } else if ("EG-ET-001".equals(vehicleName)) {
                vehicle.put("longitude", (Object)"33.0");
                vehicle.put("latitude", (Object)"7.5");
            } else if ("TZ-UG-001".equals(vehicleName)) {
                vehicle.put("longitude", (Object)"33.5");
                vehicle.put("latitude", (Object)"-1.5");
            } else {
                vehicle.put("longitude", (Object)"30.0");
                vehicle.put("latitude", (Object)"0.0");
            }
            result.add((Object)vehicle);
        }
        return result;
    }

    private void setAISInfo(Map<Integer, JSONObject> responseData) {
        for (Map.Entry<Integer, JSONObject> e : responseData.entrySet()) {
            Integer i = e.getKey();
            JSONObject data = e.getValue();
            Long shipTypeCode = data.getLong("shipType");
            String shipTypeName = SHIP_TYPE_MAP.getOrDefault(shipTypeCode, "\u9646\u8fd0\u8f66\u8f86");
            String naviStatus = 0L == data.getLong("naviStatus") ? "\u5728\u9014" : "\u5df2\u5230\u8fbe";
            this.set(i, "yem_a_callno_", "\u8f66\u724c\u53f7", data.getString("callSign"));
            this.set(i, "yem_a_imo_", "IMO", data.getString("imo"));
            this.set(i, "yem_a_podn_", "\u4e0b\u4e00\u7ad9", data.getString("dest"));
            this.set(i, "yem_ac_shiptype_", "\u8f66\u8f86\u7c7b\u578b", shipTypeName);
            this.set(i, "yem_ac_bdyear_", "\u6ce8\u518c\u65e5\u671f", data.getString("builtYear"));
            this.set(i, "yem_ac_payload_", "\u8f7d\u91cd", data.getString("dwt"));
            this.set(i, "yem_ac_length_", "\u8f66\u8f86\u957f\u5ea6", data.getString("length"));
            this.set(i, "yem_ac_width_", "\u8f66\u8f86\u5bbd\u5ea6", data.getString("width"));
            this.set(i, "yem_ac_cog_", "\u822a\u5411", data.getString("cog"));
            this.set(i, "yem_ac_hdg_", "\u822a\u824f\u5411", data.getString("hdg"));
            this.set(i, "yem_ac_draught_", "\u8f66\u8f86\u9ad8\u5ea6", data.getString("draught"));
            this.set(i, "yem_ac_longitude_", "", data.getString("longitude"));
            this.set(i, "yem_ac_latitude_", "", data.getString("latitude"));
            this.set(i, "yem_ac_status_", "\u8fd0\u8f93\u72b6\u6001", naviStatus);
            this.set(i, "yem_ac_cstatus_", "", naviStatus);
            this.set(i, "yem_ac_sog_", "\u901f\u5ea6", data.getString("sog"));
        }
    }

    private void set(int idx, String key, Object v) {
        this.set(idx, key, null, v.toString());
    }

    private void set(int idx, String key, String prefix, String v) {
        String k = key + idx;
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        Label label = (Label)view.getControl(k);
        if (YEM.isEmpty((Object)label)) {
            throw new KDBizException(String.format("\u4e0d\u5b58\u5728\u6807\u7b7e %s \uff0c\u8bf7\u68c0\u67e5!", k));
        }
        if (YEM.isNotEmpty((Object)prefix)) {
            label.setText(prefix + ":" + v);
        } else {
            label.setText(v);
        }
        cache.put("PREFIX_" + k, v);
    }

    private void set(String k, String v) {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        Label label = (Label)view.getControl(k);
        if (YEM.isEmpty((Object)label)) {
            throw new KDBizException(String.format("\u4e0d\u5b58\u5728\u6807\u7b7e %s \uff0c\u8bf7\u68c0\u67e5!", k));
        }
        label.setText(v);
        cache.put("PREFIX_" + k, v);
    }

    private String get(String k) {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        return cache.get("PREFIX_" + k);
    }

    private String value(String name, String val) {
        return name + ":" + val;
    }

    private void updateBillStepStatusDataByBOL(String bol) {
        JSONArray response = this.getPresetStatusNodeByBOL(bol);
        Wizard wizard = (Wizard)this.getControl("yem_wizardap");
        List stepsOptions = wizard.getStepsOptions();
        stepsOptions.clear();
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        boolean hasSetCurrentStep = false;
        for (Object o : response) {
            LocaleString describe;
            String status;
            JSONObject data = (JSONObject)o;
            String stateDescCn = data.getString("stateDescCn");
            Date actualityTime = data.getDate("actualityTime");
            Date planTime = data.getDate("planTime");
            Date currentTime = new Date();
            if (actualityTime != null) {
                status = "finish";
                currentStepMap.put("currentStep", stepsOptions.size());
                currentStepMap.put("currentStatus", "finish");
                hasSetCurrentStep = true;
                long delayDays = 0L;
                if (planTime != null && actualityTime.after(planTime)) {
                    delayDays = (actualityTime.getTime() - planTime.getTime()) / 86400000L;
                }
                describe = delayDays > 0L ? new LocaleString(DateUtil.formatDate((Date)actualityTime) + "\u5ef6" + delayDays + "\u5929") : new LocaleString(DateUtil.formatDate((Date)actualityTime));
            } else if (planTime != null && currentTime.after(planTime)) {
                status = "process";
                describe = new LocaleString("\u9884\u8ba1:" + DateUtil.formatDate((Date)planTime) + "(\u5ef6\u8bef)");
            } else if (planTime != null) {
                status = "process";
                describe = new LocaleString("\u9884\u8ba1:" + DateUtil.formatDate((Date)planTime));
            } else {
                status = "wait";
                describe = null;
            }
            stepsOptions.add(new StepsOption(new LocaleString(stateDescCn), describe, status));
        }
        if (!hasSetCurrentStep) {
            currentStepMap.put("currentStep", 1);
            currentStepMap.put("currentStatus", "wait");
        }
        wizard.setWizardStepsOptions(stepsOptions);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    private JSONArray getPresetStatusNodeByBOL(String bol) {
        JSONArray result = new JSONArray();
        long now = System.currentTimeMillis();
        JSONObject step1 = new JSONObject();
        step1.put("stateDescCn", (Object)"\u5df2\u521b\u5efa");
        step1.put("actualityTime", (Object)new Date(now - 345600000L));
        step1.put("planTime", (Object)new Date(now - 345600000L));
        result.add((Object)step1);
        JSONObject step2 = new JSONObject();
        step2.put("stateDescCn", (Object)"\u51c6\u5907\u53d1\u8d27");
        step2.put("actualityTime", (Object)new Date(now - 259200000L));
        step2.put("planTime", (Object)new Date(now - 259200000L));
        result.add((Object)step2);
        JSONObject step3 = new JSONObject();
        step3.put("stateDescCn", (Object)"\u5df2\u53d1\u8d27");
        step3.put("actualityTime", (Object)new Date(now - 172800000L));
        step3.put("planTime", (Object)new Date(now - 172800000L));
        result.add((Object)step3);
        JSONObject step4 = new JSONObject();
        step4.put("stateDescCn", (Object)"\u8fd0\u8f93\u4e2d");
        step4.put("actualityTime", null);
        step4.put("planTime", (Object)new Date(now + 172800000L));
        result.add((Object)step4);
        JSONObject step5 = new JSONObject();
        step5.put("stateDescCn", (Object)"\u5df2\u5230\u8fbe");
        step5.put("actualityTime", null);
        step5.put("planTime", (Object)new Date(now + 432000000L));
        result.add((Object)step5);
        JSONObject step6 = new JSONObject();
        step6.put("stateDescCn", (Object)"\u6b63\u5728\u63a5\u6536");
        step6.put("actualityTime", null);
        step6.put("planTime", (Object)new Date(now + 518400000L));
        result.add((Object)step6);
        JSONObject step7 = new JSONObject();
        step7.put("stateDescCn", (Object)"\u8fd0\u8f93\u5b8c\u6210");
        step7.put("actualityTime", null);
        step7.put("planTime", (Object)new Date(now + 604800000L));
        result.add((Object)step7);
        return result;
    }

    private void loadEmptyMap() {
        IFrame map = this.getMap();
        IFormView view = this.getView();
        if (YEM.isEmpty((Object)map)) {
            throw new KDBizException("\u672a\u627e\u5230IFrame\u63a7\u4ef6!");
        }
        map.setSrc(this.MAP);
    }

    private IFrame getMap() {
        return (IFrame)this.getControl("yem_iframe");
    }

    private void sendPostMessage(MapMessage data) {
        data.setPageId(this.getView().getPageId());
        IFrameMessage message = new IFrameMessage();
        MapMessageType type = data.getType();
        message.setType(type.name());
        message.setContent((Object)data);
        message.setOrigin(this.MAP);
        IFrame map = this.getMap();
        map.postMessage(message);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadEmptyMap();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        String currentFocus = cache.get("current_focus");
        if ("map-init".equals(name)) {
            int value = Integer.parseInt(currentFocus.substring(currentFocus.lastIndexOf("_") + 1));
            this.clearExistData();
            String bolNo = this.get("yem_card_title_" + value);
            if (YEM.isNotEmpty((Object)bolNo)) {
                List<TrajectoryInfo> trajectoryInfos = this.getPresetTrajectoryInfoByBOL(bolNo);
                ArrayList endPoint = Lists.newArrayList();
                for (TrajectoryInfo info : trajectoryInfos) {
                    List<TrajectoryPoint> points = this.initPresetTrajectory(info);
                    if (points.isEmpty()) continue;
                    endPoint.add(points.get(points.size() - 1));
                }
                if (!trajectoryInfos.isEmpty() && !endPoint.isEmpty()) {
                    TrajectoryInfo currentInfo = trajectoryInfos.get(0);
                    this.drawADottedLine(currentInfo.getBoxNumber(), endPoint);
                }
            }
        }
        if ("search".equals(name)) {
            this.handleSearch();
        }
        if ("clear".equals(name)) {
            this.initMapCenter();
            this.initMapBoard();
            this.clearExistData();
            this.initStatisticsInfo();
            this.initAISShip();
        }
    }

    private List<TrajectoryInfo> getPresetTrajectoryInfoByBOL(String bolNo) {
        ArrayList result = Lists.newArrayList();
        long now = System.currentTimeMillis();
        if ("CAR-ZA-001".equals(bolNo)) {
            TrajectoryInfo info = new TrajectoryInfo();
            info.setShipName("ZA-KE-001");
            info.setVoyage("202412-01");
            info.setBoxNumber("CONT-ZA-001");
            info.setStartTime(DateUtil.formatDateHms((Date)new Date(now - 172800000L)));
            info.setEndTime(DateUtil.formatDateHms((Date)new Date(now + 432000000L)));
            info.setStatusCd(ShippingStatusConstants.BDAR);
            info.setRelayStart(false);
            info.setRelayEnd(false);
            result.add(info);
        } else if ("CAR-ZA-002".equals(bolNo)) {
            TrajectoryInfo info = new TrajectoryInfo();
            info.setShipName("ZA-KE-002");
            info.setVoyage("202412-02");
            info.setBoxNumber("CONT-ZA-003");
            info.setStartTime(DateUtil.formatDateHms((Date)new Date(now)));
            info.setEndTime(DateUtil.formatDateHms((Date)new Date(now + 604800000L)));
            info.setStatusCd(ShippingStatusConstants.BDAR);
            info.setRelayStart(false);
            info.setRelayEnd(false);
            result.add(info);
        } else if ("CAR-EG-001".equals(bolNo)) {
            TrajectoryInfo info = new TrajectoryInfo();
            info.setShipName("EG-ET-001");
            info.setVoyage("202412-03");
            info.setBoxNumber("CONT-EG-001");
            info.setStartTime(DateUtil.formatDateHms((Date)new Date(now - 86400000L)));
            info.setEndTime(DateUtil.formatDateHms((Date)new Date(now + 259200000L)));
            info.setStatusCd(ShippingStatusConstants.BDAR);
            info.setRelayStart(false);
            info.setRelayEnd(false);
            result.add(info);
        } else if ("CAR-TZ-001".equals(bolNo)) {
            TrajectoryInfo info = new TrajectoryInfo();
            info.setShipName("TZ-UG-001");
            info.setVoyage("202412-04");
            info.setBoxNumber("CONT-TZ-001");
            info.setStartTime(DateUtil.formatDateHms((Date)new Date(now - 86400000L)));
            info.setEndTime(DateUtil.formatDateHms((Date)new Date(now + 345600000L)));
            info.setStatusCd(ShippingStatusConstants.BDAR);
            info.setRelayStart(false);
            info.setRelayEnd(false);
            result.add(info);
        }
        return result;
    }

    private JSONArray getPresetBoxStatusByBoxNumber(String boxNumber) {
        JSONArray result = new JSONArray();
        long now = System.currentTimeMillis();
        JSONObject status1 = new JSONObject();
        status1.put("ctnrNo", (Object)boxNumber);
        status1.put("vesselName", (Object)"ZA-KE-001");
        status1.put("voyage", (Object)"202412-01");
        status1.put("statusCd", (Object)"BDAR");
        status1.put("eventTime", (Object)(now - 172800000L));
        status1.put("dateUpdateTime", (Object)now);
        status1.put("isEstimate", (Object)false);
        result.add((Object)status1);
        return result;
    }

    private void initMapCenter() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.SET_VIEW);
        SetViewData data = new SetViewData();
        data.setZoom(Integer.valueOf(4));
        data.setLatitude(Double.valueOf(0.0));
        data.setLongitude(Double.valueOf(25.0));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void initMapBoard() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.FIT_BOUNDS);
        FitBoundsData data = new FitBoundsData();
        data.setLeft(Double.valueOf(-85.0));
        data.setBottom(Double.valueOf(-1000000.0));
        data.setRight(Double.valueOf(85.0));
        data.setTop(Double.valueOf(1000000.0));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void drawADottedLine(String boxNumber, List<TrajectoryPoint> endPoint) {
        JSONObject port = this.getPresetDestPortInfoByBoxNumber(boxNumber);
        ArrayList dashPoint = Lists.newArrayList();
        if (!endPoint.isEmpty()) {
            TrajectoryPoint latestPoint = endPoint.get(endPoint.size() - 1);
            TrajectoryPoint start = new TrajectoryPoint();
            start.setLatitude(latestPoint.getLatitude());
            start.setLongitude(latestPoint.getLongitude());
            dashPoint.add(start);
        }
        Double longitude = port.getDouble("longitude");
        Double latitude = port.getDouble("latitude");
        TrajectoryPoint end = new TrajectoryPoint();
        end.setLongitude(String.valueOf(longitude));
        end.setLatitude(String.valueOf(latitude));
        dashPoint.add(end);
        dashPoint.add(end);
        HashMap endKVB = Maps.newHashMap();
        endKVB.put("\u76ee\u7684\u5730", port.getString("name"));
        endKVB.put("\u56fd\u5bb6", port.getString("countryName"));
        end.setPopupData((Map)endKVB);
        end.setPointType("end");
        end.setPopupTitle("\u76ee\u7684\u5730");
        end.setMarkerStyle(new MarkerStyle("red", Integer.valueOf(15)));
        if (dashPoint.size() >= 2) {
            this.initDashedTrajectory(dashPoint);
        }
    }

    private JSONObject getPresetDestPortInfoByBoxNumber(String boxNumber) {
        JSONObject port = new JSONObject();
        port.put("name", (Object)"\u5185\u7f57\u6bd5");
        port.put("countryName", (Object)"\u80af\u5c3c\u4e9a");
        port.put("longitude", (Object)36.8219);
        port.put("latitude", (Object)-1.2921);
        return port;
    }

    private void initAISShip() {
        JSONArray array = this.getPresetAllOnWayVehicleInfo();
        for (Object o : array) {
            JSONObject item = (JSONObject)o;
            this.createShip(item, MapIconEnums.TRUCK_LOCATE);
        }
    }

    private JSONArray getPresetAllOnWayVehicleInfo() {
        JSONArray result = new JSONArray();
        String[] vehicles = new String[]{"ZA-KE-001", "EG-ET-001", "TZ-UG-001"};
        double[][] positions = new double[][]{{32.5, -6.0}, {33.0, 7.5}, {33.5, -1.5}};
        for (int i = 0; i < vehicles.length; ++i) {
            JSONObject vehicle = new JSONObject();
            vehicle.put("vslName", (Object)vehicles[i]);
            vehicle.put("longitude", (Object)positions[i][0]);
            vehicle.put("latitude", (Object)positions[i][1]);
            vehicle.put("callSign", (Object)("LAND-" + vehicles[i]));
            vehicle.put("imo", (Object)"");
            vehicle.put("mmsi", (Object)"");
            vehicle.put("shipType", (Object)70L);
            vehicle.put("builtYear", (Object)"2020");
            vehicle.put("dwt", (Object)"25000");
            vehicle.put("length", (Object)"12");
            vehicle.put("width", (Object)"2.5");
            vehicle.put("cog", (Object)"180");
            vehicle.put("hdg", (Object)"180");
            vehicle.put("draught", (Object)"");
            vehicle.put("sog", (Object)"60");
            vehicle.put("naviStatus", (Object)0L);
            vehicle.put("dest", (Object)"");
            vehicle.put("eta", (Object)"");
            vehicle.put("lastTime", (Object)DateUtil.formatDateHms((Date)new Date()));
            vehicle.put("nationality", (Object)"");
            vehicle.put("capacity", (Object)"");
            result.add((Object)vehicle);
        }
        return result;
    }

    private void clearExistData() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.CLEAR_ALL);
        message.setPayload(null);
        this.sendPostMessage(message);
    }

    private List<TrajectoryPoint> initPresetTrajectory(TrajectoryInfo info) {
        String shipname = info.getShipName();
        String startTime = info.getStartTime();
        String endTime = info.getEndTime();
        String voyage = info.getVoyage();
        int idx = this.getCurrentFocusIdx();
        String pod = this.get("yem_ac_pod_" + idx);
        String etd = this.get("yem_ac_etd_" + idx);
        JSONArray data = this.getPresetVehicleTrajectory(shipname, startTime, endTime);
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.DRAW_TRAJECTORY);
        TrajectoryData payload = new TrajectoryData();
        payload.setTrajectoryId(UUID.randomUUID().toString());
        payload.setName(shipname);
        payload.setColor("blue");
        payload.setWeight(Integer.valueOf(2));
        payload.setOpacity(Double.valueOf(100.0));
        payload.setAutoAdjustCenter(Boolean.valueOf(true));
        ArrayList<TrajectoryPoint> trajectory = new ArrayList<TrajectoryPoint>();
        if (data.isEmpty() || data.size() < 2) {
            return trajectory;
        }
        try {
            data = CarTrackingFormPlugin.sortByUtc(data);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        for (Object datum : data) {
            JSONObject p = (JSONObject)datum;
            trajectory.add(new TrajectoryPoint(p.getString("latitude"), p.getString("longitude")));
        }
        int total = data.size();
        int parts = 10;
        int step = total / parts;
        for (int k = 1; k < parts - 1; ++k) {
            int i = k * step;
            JSONObject p = (JSONObject)data.get(i);
            TrajectoryPoint point = (TrajectoryPoint)trajectory.get(i);
            MarkerStyle markerStyle = new MarkerStyle();
            markerStyle.setColor("blue");
            markerStyle.setSize(Integer.valueOf(12));
            point.setMarkerStyle(markerStyle);
            point.setPointType("waypoint_time");
            HashMap popupData = Maps.newHashMap();
            popupData.put("\u8f66\u8f86\u53f7", shipname);
            popupData.put("\u8f66\u6b21", voyage);
            popupData.put("\u9884\u62b5\u65f6\u95f4", etd);
            popupData.put("\u9884\u62b5\u76ee\u7684\u5730", pod);
            point.setPopupData((Map)popupData);
            point.setShowType(ShowTypeEnums.HOVER);
            point.setTimestamp(p.getString("utc"));
        }
        TrajectoryPoint startPoint = (TrajectoryPoint)trajectory.get(0);
        JSONObject startP = (JSONObject)data.get(0);
        HashMap startKVA = Maps.newHashMap();
        if (info.getRelayStart().booleanValue()) {
            startKVA.put("\u8f66\u8f86\u53f7", info.getShipName());
            startKVA.put("\u8f66\u6b21", info.getVoyage());
            startKVA.put("\u51fa\u53d1\u65f6\u95f4(UTC)", startP.getString("utc"));
            startPoint.setPopupData((Map)startKVA);
            startPoint.setPointType("start");
            startPoint.setPopupTitle("\u51fa\u53d1");
            startPoint.setMarkerStyle(new MarkerStyle("orange", Integer.valueOf(15)));
        } else {
            startKVA.put("\u65f6\u95f4(UTC)", startP.getString("utc"));
            startKVA.put("\u5750\u6807", startP.getDouble("latitude").toString() + ", " + startP.getDouble("longitude").toString());
            startPoint.setPopupData((Map)startKVA);
            startPoint.setPointType("start");
            startPoint.setPopupTitle("\u8d77\u70b9");
            startPoint.setMarkerStyle(new MarkerStyle("green", Integer.valueOf(20)));
        }
        TrajectoryPoint endPoint = (TrajectoryPoint)trajectory.get(trajectory.size() - 1);
        HashMap endKVB = Maps.newHashMap();
        JSONObject endP = (JSONObject)data.get(trajectory.size() - 1);
        if (info.getRelayEnd().booleanValue()) {
            endKVB.put("\u8f66\u8f86\u53f7", info.getShipName());
            endKVB.put("\u8f66\u6b21", info.getVoyage());
            endKVB.put("\u5230\u8fbe\u65f6\u95f4(UTC)", endP.getString("utc"));
            endPoint.setPopupData((Map)endKVB);
            endPoint.setPointType("start");
            endPoint.setPopupTitle("\u5230\u8fbe");
            endPoint.setMarkerStyle(new MarkerStyle("red", Integer.valueOf(15)));
        } else {
            endKVB.put("\u65f6\u95f4(UTC)", endP.getString("utc"));
            endKVB.put("\u5750\u6807", endP.getDouble("latitude").toString() + ", " + endP.getDouble("longitude").toString());
            endPoint.setPopupData((Map)endKVB);
            endPoint.setPointType("end");
            endPoint.setPopupTitle("\u7ec8\u70b9");
            endPoint.setMarkerStyle(new MarkerStyle("orange", Integer.valueOf(20)));
        }
        payload.setData(trajectory);
        message.setPayload((Object)payload);
        this.sendPostMessage(message);
        int currentPosIndex = (int)((double)total * 0.6);
        if (currentPosIndex >= 0 && currentPosIndex < total) {
            JSONObject currentPos = data.getJSONObject(currentPosIndex);
            this.showVehicleAtPosition(shipname, currentPos, voyage);
        }
        return payload.getData();
    }

    private void showVehicleAtPosition(String vehicleName, JSONObject positionData, String voyage) {
        JSONObject vehicleData = new JSONObject();
        vehicleData.put("vslName", (Object)vehicleName);
        vehicleData.put("latitude", (Object)positionData.getDouble("latitude"));
        vehicleData.put("longitude", (Object)positionData.getDouble("longitude"));
        vehicleData.put("callSign", (Object)("LAND-" + vehicleName));
        vehicleData.put("imo", (Object)"");
        vehicleData.put("mmsi", (Object)"");
        vehicleData.put("shipType", (Object)70L);
        vehicleData.put("builtYear", (Object)"2020");
        vehicleData.put("dwt", (Object)"25000");
        vehicleData.put("length", (Object)"12");
        vehicleData.put("width", (Object)"2.5");
        vehicleData.put("cog", (Object)"180");
        vehicleData.put("hdg", (Object)"180");
        vehicleData.put("draught", (Object)"3");
        vehicleData.put("naviStatus", (Object)0L);
        vehicleData.put("sog", (Object)"60");
        vehicleData.put("nationality", (Object)"ZA");
        vehicleData.put("capacity", (Object)"25T");
        vehicleData.put("dest", (Object)"");
        vehicleData.put("eta", (Object)"");
        vehicleData.put("lastTime", (Object)positionData.getString("utc"));
        this.createShip(vehicleData, MapIconEnums.TRUCK_LOCATE);
    }

    private JSONArray getPresetVehicleTrajectory(String vehicleName, String startTime, String endTime) {
        JSONArray result = new JSONArray();
        if ("ZA-KE-001".equals(vehicleName) || "ZA-KE-002".equals(vehicleName)) {
            double[][] points = new double[][]{{-26.2023, 28.0436}, {-17.8277, 31.0534}, {-15.4167, 28.2833}, {-6.776, 39.1783}, {-1.2833, 36.8167}};
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long start = sdf.parse(startTime).getTime();
                long end = sdf.parse(endTime).getTime();
                long interval = (end - start) / (long)(points.length - 1);
                for (int i = 0; i < points.length; ++i) {
                    JSONObject point = new JSONObject();
                    point.put("latitude", (Object)points[i][0]);
                    point.put("longitude", (Object)points[i][1]);
                    point.put("utc", (Object)sdf.format(new Date(start + (long)i * interval)));
                    result.add((Object)point);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("EG-ET-001".equals(vehicleName)) {
            double[][] points = new double[][]{{30.0333, 31.2333}, {24.0889, 32.8998}, {15.5085, 32.5229}, {9.0054, 38.7636}};
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long start = sdf.parse(startTime).getTime();
                long end = sdf.parse(endTime).getTime();
                long interval = (end - start) / (long)(points.length - 1);
                for (int i = 0; i < points.length; ++i) {
                    JSONObject point = new JSONObject();
                    point.put("latitude", (Object)points[i][0]);
                    point.put("longitude", (Object)points[i][1]);
                    point.put("utc", (Object)sdf.format(new Date(start + (long)i * interval)));
                    result.add((Object)point);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("TZ-UG-001".equals(vehicleName)) {
            double[][] points = new double[][]{{-6.776, 39.1783}, {-1.9536, 30.0606}, {0.3476, 32.5825}};
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long start = sdf.parse(startTime).getTime();
                long end = sdf.parse(endTime).getTime();
                long interval = (end - start) / (long)(points.length - 1);
                for (int i = 0; i < points.length; ++i) {
                    JSONObject point = new JSONObject();
                    point.put("latitude", (Object)points[i][0]);
                    point.put("longitude", (Object)points[i][1]);
                    point.put("utc", (Object)sdf.format(new Date(start + (long)i * interval)));
                    result.add((Object)point);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            double[][] points = new double[][]{{-6.776, 39.1783}, {-1.2833, 36.8167}};
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long start = sdf.parse(startTime).getTime();
                long end = sdf.parse(endTime).getTime();
                long interval = (end - start) / (long)(points.length - 1);
                for (int i = 0; i < points.length; ++i) {
                    JSONObject point = new JSONObject();
                    point.put("latitude", (Object)points[i][0]);
                    point.put("longitude", (Object)points[i][1]);
                    point.put("utc", (Object)sdf.format(new Date(start + (long)i * interval)));
                    result.add((Object)point);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void initDashedTrajectory(List<TrajectoryPoint> dashPoint) {
        TrajectoryData payload = new TrajectoryData();
        MapMessage message = new MapMessage();
        payload.setData(dashPoint);
        payload.setTrajectoryId(UUID.randomUUID().toString());
        payload.setColor("gray");
        payload.setWeight(Integer.valueOf(5));
        payload.setOpacity(Double.valueOf(50.0));
        payload.setAutoAdjustCenter(Boolean.valueOf(false));
        payload.setDashed(Boolean.valueOf(true));
        message.setPayload((Object)payload);
        message.setType(MapMessageType.DRAW_TRAJECTORY);
        this.sendPostMessage(message);
    }

    private void createShip(JSONObject data, MapIconEnums icon) {
        if (data == null) {
            return;
        }
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.DRAW_SHIP);
        MarkData mark = new MarkData();
        mark.setMarkId(UUID.randomUUID().toString());
        mark.setMarkName(data.getString("vslName"));
        mark.setLatitude(data.getString("latitude"));
        mark.setLongitude(data.getString("longitude"));
        ArrayList fields = Lists.newArrayList();
        HashMap group1 = Maps.newHashMap();
        group1.put("\u8f66\u8f86\u53f7", data.getString("vslName"));
        group1.put("\u6ce8\u518c\u65e5\u671f", data.getString("builtYear"));
        group1.put("\u8f66\u724c\u53f7", data.getString("callSign"));
        Long shipTypeCode = data.getLong("shipType");
        String shipTypeName = SHIP_TYPE_MAP.getOrDefault(shipTypeCode, "\u9646\u8fd0\u8f66\u8f86");
        group1.put("\u8f66\u8f86\u7c7b\u578b", shipTypeName);
        group1.put("\u56fd\u7c4d", data.getString("nationality"));
        fields.add(group1);
        HashMap group2 = Maps.newHashMap();
        group2.put("\u8f66\u8f86\u957f\u5ea6(\u7c73)", String.valueOf(data.getString("length")));
        group2.put("\u8f66\u8f86\u5bbd\u5ea6(\u7c73)", String.valueOf(data.getString("width")));
        group2.put("\u8f66\u8f86\u9ad8\u5ea6(\u7c73)", String.valueOf(data.getString("draught")));
        group2.put("\u88c5\u8f7d\u91cf", data.getString("capacity"));
        group2.put("\u8f7d\u91cd(KG)", data.getString("dwt"));
        fields.add(group2);
        HashMap group3 = Maps.newHashMap();
        group3.put("\u7eac\u5ea6(\u5ea6)", String.valueOf(data.getDouble("latitude")));
        group3.put("\u7ecf\u5ea6(\u5ea6)", String.valueOf(data.getDouble("longitude")));
        group3.put("\u901f\u5ea6(km/h)", data.getString("sog"));
        group3.put("\u884c\u9a76\u65b9\u5411(\u5ea6)", data.getString("cog"));
        String naviStatus = 0L == data.getLong("naviStatus") ? "\u5728\u9014" : "\u5df2\u5230\u8fbe";
        group3.put("\u8fd0\u8f93\u72b6\u6001", naviStatus);
        fields.add(group3);
        HashMap group4 = Maps.newHashMap();
        group4.put("\u4e0b\u4e00\u7ad9", data.getString("dest"));
        group4.put("\u9884\u8ba1\u5230\u8fbe\u65f6\u95f4(UTC)", data.getString("eta"));
        group4.put("\u66f4\u65b0\u65f6\u95f4(UTC+8)", data.getString("lastTime"));
        fields.add(group4);
        mark.setPopupData((List)fields);
        ArrayList tabData = Lists.newArrayList();
        HashMap titleField = Maps.newHashMap();
        titleField.put("title", "\u4e1a\u52a1\u4fe1\u606f");
        tabData.add(titleField);
        HashMap contractInfo = Maps.newHashMap();
        contractInfo.put("\u5408\u540c\u53f7", "CU-2025-0089");
        contractInfo.put("\u9500\u552e\u7ec4\u7ec7", "\u975e\u6d32\u77ff\u4e1a\u96c6\u56e2");
        contractInfo.put("\u9500\u552e\u90e8\u95e8", "\u7269\u6d41\u90e8");
        contractInfo.put("\u9500\u552e\u5458", "\u674e\u534e");
        contractInfo.put("\u8ba2\u8d27\u5ba2\u6237", "KCM Mining Ltd.");
        tabData.add(contractInfo);
        HashMap tradeTerms = Maps.newHashMap();
        tradeTerms.put("\u4ef7\u683c\u6761\u6b3e", "FCA");
        tradeTerms.put("\u8d38\u6613\u56fd\u522b", "\u80af\u5c3c\u4e9a");
        tradeTerms.put("\u8d38\u6613\u5546\u54c1", "\u94dc\u7cbe\u77ff");
        tradeTerms.put("\u7ed3\u7b97\u5e01", "\u7f8e\u5143");
        tabData.add(tradeTerms);
        HashMap quantityAmount = Maps.newHashMap();
        quantityAmount.put("\u6570\u91cf", "25.0\u5428");
        quantityAmount.put("\u91d1\u989d", "$45000");
        tabData.add(quantityAmount);
        HashMap cargoInfo = Maps.newHashMap();
        cargoInfo.put("\u8d27\u7269\u7c7b\u578b", "\u94dc\u7cbe\u77ff");
        cargoInfo.put("\u5305\u88c5\u65b9\u5f0f", "\u888b\u88c5");
        cargoInfo.put("\u4ef6\u6570", "500");
        cargoInfo.put("\u6bdb\u91cd", "25000");
        tabData.add(cargoInfo);
        mark.setTabData((List)tabData);
        mark.setIconUrl(icon.getUrl());
        mark.setIconWidth(Double.valueOf(icon.getIconWidth()));
        mark.setIconHeight(Double.valueOf(icon.getIconHeight()));
        mark.setIconScale(Double.valueOf(icon.getIconScale()));
        mark.setIconOffsetX(Double.valueOf(icon.getIconOffsetX()));
        mark.setIconOffsetY(Double.valueOf(icon.getIconOffsetY()));
        if (icon == MapIconEnums.TRUCK_LOCATE) {
            mark.setIconAngle(Double.valueOf(0.0));
        }
        mark.setDefaultOpenPopup(false);
        mark.setPreviewShowType(ShowTypeEnums.ALWAYS);
        ArrayList previewData = Lists.newArrayList();
        HashMap shipInfo = Maps.newHashMap();
        shipInfo.put("\u8f66\u8f86\u53f7", data.getString("vslName"));
        Random random = new Random();
        int num = 1000000 + random.nextInt(9000000);
        String randomBlNo = "CAR-" + num;
        shipInfo.put("\u8fd0\u5355\u53f7", randomBlNo);
        previewData.add(shipInfo);
        mark.setPreviewData((List)previewData);
        message.setPayload((Object)mark);
        this.sendPostMessage(message);
    }

    public static JSONArray sortByUtc(JSONArray data) throws ParseException {
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            JSONObject obj = data.getJSONObject(i);
            String utc = obj.getString("utc");
            long time = sdf.parse(utc).getTime();
            list.add(new AbstractMap.SimpleEntry<Long, JSONObject>(time, obj));
        }
        list.sort(Comparator.comparingLong(Map.Entry::getKey));
        JSONArray result = new JSONArray();
        for (Map.Entry entry : list) {
            result.add(entry.getValue());
        }
        return result;
    }

    public void customEvent(CustomEventArgs e) {
        JSONObject content;
        JSONObject args;
        super.customEvent(e);
        IFormView view = this.getView();
        String pageId = view.getPageId();
        String eventName = e.getEventName();
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        if (pageId.equals(key) && "invokeCustomEvent".equals(eventName) && (args = JSON.parseObject((String)eventArgs)).containsKey((Object)"content") && (content = args.getJSONObject("content")).containsKey((Object)"event") && "map-loaded".equals(content.getString("event"))) {
            FormShowParameter fsp = view.getFormShowParameter();
            Map data1 = fsp.getCustomParams();
            this.initMapCenter();
            this.initMapBoard();
            this.initStatisticsInfo();
            if (!data1.containsKey("params")) {
                this.initAISShip();
            }
        }
    }

    static {
        SHIP_TYPE_MAP.put(60L, "\u5ba2\u8f66");
        SHIP_TYPE_MAP.put(70L, "\u8d27\u8f66");
        SHIP_TYPE_MAP.put(80L, "\u6cb9\u7f50\u8f66");
        SHIP_TYPE_MAP.put(90L, "\u5176\u4ed6");
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

