/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.bill.catshipdash.dynamic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import yem.base.common.utils.YEM;
import yem.wm.gs.service.map.dal.FitBoundsData;
import yem.wm.gs.service.map.dal.MapMessage;
import yem.wm.gs.service.map.dal.MarkData;
import yem.wm.gs.service.map.dal.SetViewData;
import yem.wm.gs.service.map.enums.MapIconEnums;
import yem.wm.gs.service.map.enums.MapMessageType;
import yem.wm.gs.service.map.enums.ShowTypeEnums;

public class CarShipDashboardFormPlugin
extends AbstractFormPlugin {
    private String MAP = "https://map.wmyun.com";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFrame map = this.getMap();
        IFormView view = this.getView();
        String pageId = view.getPageId();
        this.MAP = this.MAP + "?pageId=" + pageId;
        if (YEM.isEmpty((Object)map)) {
            throw new KDBizException("\u672a\u627e\u5230IFrame\u63a7\u4ef6\uff01");
        }
        map.setSrc(this.MAP);
        this.initAllPieCharts();
        this.initInTransitVsArrivedBarChart();
        this.initEntryData();
    }

    public static List<Map<String, String>> getPresetDetailData() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        LinkedHashMap<String, String> row1 = new LinkedHashMap<String, String>();
        row1.put("yem_textfield", "2025-12-15");
        row1.put("yem_textfield1", "7");
        row1.put("yem_textfield2", "CAR-ZA-001");
        row1.put("yem_textfield3", "CU-2025-089");
        row1.put("yem_textfield4", "ZA-KE-001");
        row1.put("yem_textfield5", "\u7ea6\u7ff0\u5185\u65af\u5821");
        row1.put("yem_textfield6", "\u5185\u7f57\u6bd5");
        row1.put("yem_textfield7", "2025-12-06");
        row1.put("yem_textfield8", "5");
        list.add(row1);
        LinkedHashMap<String, String> row2 = new LinkedHashMap<String, String>();
        row2.put("yem_textfield", "2025-12-11");
        row2.put("yem_textfield1", "3");
        row2.put("yem_textfield2", "CAR-EG-001");
        row2.put("yem_textfield3", "CU-2025-092");
        row2.put("yem_textfield4", "EG-ET-001");
        row2.put("yem_textfield5", "\u5f00\u7f57");
        row2.put("yem_textfield6", "\u4e9a\u7684\u65af\u4e9a\u8d1d\u5df4");
        row2.put("yem_textfield7", "2025-12-07");
        row2.put("yem_textfield8", "1");
        list.add(row2);
        LinkedHashMap<String, String> row3 = new LinkedHashMap<String, String>();
        row3.put("yem_textfield", "2025-12-12");
        row3.put("yem_textfield1", "4");
        row3.put("yem_textfield2", "CAR-TZ-001");
        row3.put("yem_textfield3", "CO-2025-101");
        row3.put("yem_textfield4", "TZ-UG-001");
        row3.put("yem_textfield5", "\u8fbe\u7d2f\u65af\u8428\u62c9\u59c6");
        row3.put("yem_textfield6", "\u574e\u5e15\u62c9");
        row3.put("yem_textfield7", "2025-12-07");
        row3.put("yem_textfield8", "1");
        list.add(row3);
        LinkedHashMap<String, String> row4 = new LinkedHashMap<String, String>();
        row4.put("yem_textfield", "2025-12-22");
        row4.put("yem_textfield1", "14");
        row4.put("yem_textfield2", "CAR-ZA-002");
        row4.put("yem_textfield3", "CU-2025-108");
        row4.put("yem_textfield4", "ZA-KE-002");
        row4.put("yem_textfield5", "\u7ea6\u7ff0\u5185\u65af\u5821");
        row4.put("yem_textfield6", "\u5185\u7f57\u6bd5");
        row4.put("yem_textfield7", "2025-12-08");
        row4.put("yem_textfield8", "0");
        list.add(row4);
        LinkedHashMap<String, String> row5 = new LinkedHashMap<String, String>();
        row5.put("yem_textfield", "2025-12-18");
        row5.put("yem_textfield1", "10");
        row5.put("yem_textfield2", "CAR-ZM-001");
        row5.put("yem_textfield3", "SP-2025-115");
        row5.put("yem_textfield4", "ZM-CD-001");
        row5.put("yem_textfield5", "\u5362\u8428\u5361");
        row5.put("yem_textfield6", "\u79d1\u5362\u97e6\u9f50");
        row5.put("yem_textfield7", "2025-12-10");
        row5.put("yem_textfield8", "0");
        list.add(row5);
        return list;
    }

    private void initEntryData() {
        IDataModel model = this.getModel();
        List<Map<String, String>> presetDetailData = CarShipDashboardFormPlugin.getPresetDetailData();
        int i = 0;
        for (Map<String, String> presetDetailDatum : presetDetailData) {
            for (Map.Entry<String, String> entry : presetDetailDatum.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                model.setValue(key, (Object)value, i);
            }
            ++i;
        }
    }

    private void initInTransitVsArrivedBarChart() {
        HistogramChart barchart = (HistogramChart)this.getControl("yem_barchartap");
        this.setHistogramChartStyle(barchart);
        Axis x = barchart.createXAxis("\u6708\u4efd", AxisType.category);
        Axis y = barchart.createYAxis("\u6570\u91cf\uff08\u8f66\u6b21\uff09", AxisType.value);
        LocalDate today = LocalDate.now();
        String[] months = new String[6];
        for (int i = 5; i >= 0; --i) {
            LocalDate date = today.minusMonths(i);
            months[5 - i] = date.format(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708"));
        }
        x.setPropValue("data", (Object)months);
        Number[] inTransitData = new Number[]{45, 52, 48, 61, 58, 55};
        Number[] arrivedData = new Number[]{42, 48, 51, 56, 59, 62};
        BarSeries series1 = barchart.createBarSeries("\u5f53\u6708\u5728\u9014");
        series1.setData(inTransitData);
        series1.setBarWidth("20%");
        BarSeries series2 = barchart.createBarSeries("\u5f53\u6708\u5230\u8fbe");
        series2.setData(arrivedData);
        series2.setBarWidth("20%");
        barchart.setShowTooltip(true);
        barchart.setShowLegend(false);
        barchart.refresh();
    }

    private void setHistogramChartStyle(HistogramChart barchart) {
        barchart.clearData();
        barchart.setShowTitle(true);
        barchart.setTitlePropValue("text", (Object)"");
        barchart.setShowLegend(true);
        barchart.setLegendVertical(false);
        barchart.setLegendPropValue("bottom", (Object)10);
        barchart.setMargin(Position.left, "15px");
        barchart.setMargin(Position.top, "30px");
        barchart.setShowTooltip(true);
    }

    private void initAllPieCharts() {
        PieChart pie1 = (PieChart)this.getControl("yem_piechart1");
        PieChart pie2 = (PieChart)this.getControl("yem_piechart2");
        PieChart pie3 = (PieChart)this.getControl("yem_piechart3");
        ItemValue[] kcmData = new ItemValue[]{new ItemValue("\u94dc\u7cbe\u77ff 48%", (Number)new BigDecimal("4800")), new ItemValue("\u94b4\u4ea7\u54c1 28%", (Number)new BigDecimal("2800")), new ItemValue("\u786b\u9178 16%", (Number)new BigDecimal("1600")), new ItemValue("\u5176\u4ed6 8%", (Number)new BigDecimal("800"))};
        this.setupPieChart(pie1, "KCM-\u77ff\u5c71", kcmData, new String[]{"#E15759", "#F28E2B", "#76B7B2", "#B07AA1"});
        ItemValue[] tfmData = new ItemValue[]{new ItemValue("\u94dc\u77ff\u77f3 52%", (Number)new BigDecimal("5200")), new ItemValue("\u94b4\u7cbe\u77ff 31%", (Number)new BigDecimal("3100")), new ItemValue("\u5e9f\u77f3 11%", (Number)new BigDecimal("1100")), new ItemValue("\u5176\u4ed6 6%", (Number)new BigDecimal("600"))};
        this.setupPieChart(pie2, "TFM-\u77ff\u5c71", tfmData, new String[]{"#59A14F", "#EDC948", "#B07AA1", "#FF9DA7"});
        ItemValue[] totalData = new ItemValue[]{new ItemValue("TFM\u4ea7\u51fa 44%", (Number)new BigDecimal("8800")), new ItemValue("KCM\u4ea7\u51fa 42%", (Number)new BigDecimal("8400")), new ItemValue("\u5728\u9014/\u4ed3\u50a8 14%", (Number)new BigDecimal("2800"))};
        this.setupPieChart(pie3, "\u6c47\u603b", totalData, new String[]{"#4E79A7", "#F28E2B", "#E15759"});
    }

    private void setupPieChart(PieChart chart, String title, ItemValue[] data, String[] colors) {
        chart.setShowTooltip(true);
        chart.setShowLegend(false);
        PieSeries serie = chart.createPieSeries(title);
        serie.setRadius("80%");
        serie.setCenter("50%", "60%");
        Label label = new Label();
        label.setFontSize("16");
        serie.setLabel(label);
        serie.setData(data);
        HashMap labelMap = new HashMap(8);
        HashMap<String, Object> normalMap = new HashMap<String, Object>(8);
        normalMap.put("show", true);
        normalMap.put("position", "inside");
        normalMap.put("fontSize", 10);
        normalMap.put("color", "#fff");
        HashMap richMap = new HashMap(8);
        HashMap<String, Object> bMap = new HashMap<String, Object>();
        bMap.put("fontSize", 10);
        bMap.put("color", "#fff");
        richMap.put("b", bMap);
        HashMap<String, Object> hrMap = new HashMap<String, Object>();
        hrMap.put("borderColor", "#fff");
        hrMap.put("width", "100%");
        hrMap.put("borderWidth", 1);
        hrMap.put("height", 0);
        richMap.put("hr", hrMap);
        HashMap<String, Object> cMap = new HashMap<String, Object>();
        cMap.put("fontSize", 8);
        cMap.put("color", "#fff");
        richMap.put("c", cMap);
        HashMap<String, Object> perMap = new HashMap<String, Object>();
        perMap.put("fontSize", 10);
        perMap.put("color", "#fff");
        richMap.put("per", perMap);
        normalMap.put("rich", richMap);
        labelMap.put("normal", normalMap);
        serie.setPropValue("label", labelMap);
        chart.refresh();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        IFormView view = this.getView();
    }

    private void drawVehiclesOnMap() {
        this.drawVehicleAtLocation("-6.0", "32.5", "ZA-KE-001", MapIconEnums.TRUCK_LOCATE);
        this.drawVehicleAtLocation("15.5", "32.5", "EG-ET-001", MapIconEnums.TRUCK_LOCATE);
        this.drawVehicleAtLocation("-1.95", "30.06", "TZ-UG-001", MapIconEnums.TRUCK_LOCATE);
        this.drawVehicleAtLocation("-15.42", "28.28", "ZA-KE-002", MapIconEnums.TRUCK_LOCATE);
        this.drawVehicleAtLocation("-12.53", "27.88", "ZM-CD-001", MapIconEnums.TRUCK_LOCATE);
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.SET_VIEW);
        SetViewData data = new SetViewData();
        data.setZoom(Integer.valueOf(4));
        data.setLatitude(Double.valueOf(0.0));
        data.setLongitude(Double.valueOf(25.0));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void drawVehicleAtLocation(String lat, String lon, String vehicleName, MapIconEnums icon) {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.DRAW_SHIP);
        MarkData mark = new MarkData();
        mark.setMarkId(UUID.randomUUID().toString());
        mark.setMarkName(vehicleName);
        mark.setLatitude(lat);
        mark.setLongitude(lon);
        ArrayList fields = Lists.newArrayList();
        HashMap group1 = Maps.newHashMap();
        group1.put("\u8f66\u8f86\u53f7", vehicleName);
        group1.put("\u6ce8\u518c\u65e5\u671f", "2020");
        group1.put("\u8f66\u724c\u53f7", "LAND-" + vehicleName);
        group1.put("\u8f66\u8f86\u7c7b\u578b", "\u8d27\u8f66");
        group1.put("\u56fd\u7c4d", "ZA");
        fields.add(group1);
        HashMap group2 = Maps.newHashMap();
        group2.put("\u8f66\u8f86\u957f\u5ea6(\u7c73)", "12");
        group2.put("\u8f66\u8f86\u5bbd\u5ea6(\u7c73)", "2.5");
        group2.put("\u8f66\u8f86\u9ad8\u5ea6(\u7c73)", "3");
        group2.put("\u88c5\u8f7d\u91cf", "25T");
        group2.put("\u8f7d\u91cd(KG)", "25000");
        fields.add(group2);
        HashMap group3 = Maps.newHashMap();
        group3.put("\u7eac\u5ea6(\u5ea6)", lat);
        group3.put("\u7ecf\u5ea6(\u5ea6)", lon);
        group3.put("\u901f\u5ea6(km/h)", "60");
        group3.put("\u884c\u9a76\u65b9\u5411(\u5ea6)", "180");
        group3.put("\u8fd0\u8f93\u72b6\u6001", "\u5728\u9014");
        fields.add(group3);
        HashMap group4 = Maps.newHashMap();
        group4.put("\u4e0b\u4e00\u7ad9", "\u5185\u7f57\u6bd5");
        group4.put("\u9884\u8ba1\u5230\u8fbe\u65f6\u95f4(UTC)", "2025-12-15 10:00");
        group4.put("\u66f4\u65b0\u65f6\u95f4(UTC+8)", "2025-12-08 15:00");
        fields.add(group4);
        mark.setPopupData((List)fields);
        ArrayList tabData = Lists.newArrayList();
        HashMap titleField = Maps.newHashMap();
        titleField.put("title", "\u4e1a\u52a1\u4fe1\u606f");
        tabData.add(titleField);
        HashMap contractInfo = Maps.newHashMap();
        contractInfo.put("\u5408\u540c\u53f7", "CU-2025-0089");
        contractInfo.put("\u9500\u552e\u7ec4\u7ec7", "\u975e\u6d32\u77ff\u4e1a\u96c6\u56e2");
        contractInfo.put("\u9500\u552e\u90e8\u95e8", "\u7269\u6d41\u90e8");
        contractInfo.put("\u9500\u552e\u5458", "\u674e\u534e");
        contractInfo.put("\u8ba2\u8d27\u5ba2\u6237", "KCM Mining Ltd.");
        tabData.add(contractInfo);
        HashMap tradeTerms = Maps.newHashMap();
        tradeTerms.put("\u4ef7\u683c\u6761\u6b3e", "FCA");
        tradeTerms.put("\u8d38\u6613\u56fd\u522b", "\u80af\u5c3c\u4e9a");
        tradeTerms.put("\u8d38\u6613\u5546\u54c1", "\u94dc\u7cbe\u77ff");
        tradeTerms.put("\u7ed3\u7b97\u5e01", "\u7f8e\u5143");
        tabData.add(tradeTerms);
        HashMap quantityAmount = Maps.newHashMap();
        quantityAmount.put("\u6570\u91cf", "25.0\u5428");
        quantityAmount.put("\u91d1\u989d", "$45000");
        tabData.add(quantityAmount);
        HashMap cargoInfo = Maps.newHashMap();
        cargoInfo.put("\u8d27\u7269\u7c7b\u578b", "\u94dc\u7cbe\u77ff");
        cargoInfo.put("\u5305\u88c5\u65b9\u5f0f", "\u888b\u88c5");
        cargoInfo.put("\u4ef6\u6570", "500");
        cargoInfo.put("\u6bdb\u91cd", "25000");
        tabData.add(cargoInfo);
        mark.setTabData((List)tabData);
        ArrayList previewData = Lists.newArrayList();
        HashMap nameMap = Maps.newHashMap();
        nameMap.put("\u8f66\u8f86\u53f7", vehicleName);
        Random random = new Random();
        int num = 1000000 + random.nextInt(9000000);
        String randomWbNo = "CAR-" + num;
        nameMap.put("\u8fd0\u5355\u53f7", randomWbNo);
        previewData.add(nameMap);
        mark.setPreviewData((List)previewData);
        mark.setPreviewShowType(ShowTypeEnums.ALWAYS);
        mark.setIconUrl(icon.getUrl());
        mark.setIconWidth(Double.valueOf(icon.getIconWidth()));
        mark.setIconHeight(Double.valueOf(icon.getIconHeight()));
        mark.setIconScale(Double.valueOf(icon.getIconScale()));
        mark.setIconOffsetX(Double.valueOf(icon.getIconOffsetX()));
        mark.setIconOffsetY(Double.valueOf(icon.getIconOffsetY()));
        mark.setIconAngle(Double.valueOf(0.0));
        mark.setDefaultOpenPopup(false);
        message.setPayload((Object)mark);
        this.sendPostMessage(message);
    }

    private void initMapCenter() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.SET_VIEW);
        SetViewData data = new SetViewData();
        data.setZoom(Integer.valueOf(4));
        data.setLatitude(Double.valueOf(0.0));
        data.setLongitude(Double.valueOf(25.0));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void initMapBoard() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.FIT_BOUNDS);
        FitBoundsData data = new FitBoundsData();
        data.setLeft(Double.valueOf(-85.0));
        data.setBottom(Double.valueOf(-1000000.0));
        data.setRight(Double.valueOf(85.0));
        data.setTop(Double.valueOf(1000000.0));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void sendPostMessage(MapMessage data) {
        data.setPageId(this.getView().getPageId());
        IFrameMessage message = new IFrameMessage();
        MapMessageType type = data.getType();
        message.setType(type.name());
        message.setContent((Object)data);
        message.setOrigin(this.MAP);
        IFrame map = this.getMap();
        map.postMessage(message);
    }

    private IFrame getMap() {
        return (IFrame)this.getControl("yem_iframe");
    }

    public void customEvent(CustomEventArgs e) {
        JSONObject content;
        JSONObject args;
        super.customEvent(e);
        IFormView view = this.getView();
        String pageId = view.getPageId();
        String eventName = e.getEventName();
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        if (pageId.equals(key) && "invokeCustomEvent".equals(eventName) && (args = JSON.parseObject((String)eventArgs)).containsKey((Object)"content") && (content = args.getJSONObject("content")).containsKey((Object)"event") && "map-loaded".equals(content.getString("event"))) {
            this.initMapBoard();
            this.drawVehiclesOnMap();
        }
    }
}

