/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.bill.map.dynamic;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.entity.IFrameMessage;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.compress.utils.Lists;
import yem.base.common.utils.DateUtil;
import yem.base.common.utils.YEM;
import yem.wm.gs.service.map.dal.ArrowStyle;
import yem.wm.gs.service.map.dal.MapMessage;
import yem.wm.gs.service.map.dal.MarkData;
import yem.wm.gs.service.map.dal.MarkerStyle;
import yem.wm.gs.service.map.dal.SetViewData;
import yem.wm.gs.service.map.dal.TrajectoryData;
import yem.wm.gs.service.map.dal.TrajectoryPoint;
import yem.wm.gs.service.map.enums.MapMessageType;
import yem.wm.gs.service.map.enums.ShowTypeEnums;

public class GsMapFormPlugin
extends AbstractFormPlugin {
    private final String MAP = "https://map.wmyun.com?plugin=GsMapFormPlugin";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadEmptyMap();
        this.getView().addClientCallBack("map-init", Integer.valueOf(1000));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        if ("map-init".equals(name)) {
            this.setMapCenter();
            this.initPresetTrajectory();
            this.initPresetShip();
        }
    }

    private void setMapCenter() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.SET_VIEW);
        SetViewData data = new SetViewData();
        data.setZoom(Integer.valueOf(5));
        data.setLatitude(Double.valueOf(34.25721057315292));
        data.setLongitude(Double.valueOf(108.9467458659389));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void initPresetTrajectory() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.DRAW_TRAJECTORY);
        TrajectoryData payload = new TrajectoryData();
        payload.setTrajectoryId(UUID.randomUUID().toString());
        payload.setName("XXX\u8f68\u8ff9");
        payload.setColor("red");
        payload.setWeight(Integer.valueOf(3));
        payload.setOpacity(Double.valueOf(100.0));
        payload.setAutoAdjustCenter(Boolean.valueOf(false));
        ArrayList<TrajectoryPoint> data = new ArrayList<TrajectoryPoint>();
        data.add(new TrajectoryPoint("30.9588683", "123.2936117"));
        data.add(new TrajectoryPoint("30.9850283", "123.291855"));
        data.add(new TrajectoryPoint("31.0137967", "123.2910783"));
        data.add(new TrajectoryPoint("30.8988133", "123.2027583"));
        data.add(new TrajectoryPoint("30.8328883", "123.0018833"));
        data.add(new TrajectoryPoint("30.637465", "122.9884683"));
        data.add(new TrajectoryPoint("30.4903467", "122.882045"));
        data.add(new TrajectoryPoint("30.48384", "122.6627317"));
        data.add(new TrajectoryPoint("30.46968", "122.5015667"));
        data.add(new TrajectoryPoint("30.4689783", "122.5009383"));
        data.add(new TrajectoryPoint("30.4691533", "122.499105"));
        data.add(new TrajectoryPoint("30.468985", "122.499385"));
        data.add(new TrajectoryPoint("30.468925", "122.498865"));
        data.add(new TrajectoryPoint("30.468795", "122.4993717"));
        data.add(new TrajectoryPoint("30.4687667", "122.4996367"));
        data.add(new TrajectoryPoint("30.4688017", "122.500375"));
        data.add(new TrajectoryPoint("30.4691467", "122.5006517"));
        data.add(new TrajectoryPoint("30.5112667", "122.497325"));
        data.add(new TrajectoryPoint("30.546175", "122.35846"));
        data.add(new TrajectoryPoint("30.5633767", "122.2311367"));
        data.add(new TrajectoryPoint("30.628835", "122.0400367"));
        data.add(new TrajectoryPoint("30.653915", "122.0166467"));
        data.add(new TrajectoryPoint("30.654035", "122.016555"));
        data.add(new TrajectoryPoint("30.6540883", "122.0165667"));
        data.add(new TrajectoryPoint("30.65387", "122.0166283"));
        data.add(new TrajectoryPoint("30.6538983", "122.016605"));
        data.add(new TrajectoryPoint("30.654025", "122.0165483"));
        data.add(new TrajectoryPoint("30.6538983", "122.0165533"));
        data.add(new TrajectoryPoint("30.6539617", "122.01638"));
        data.add(new TrajectoryPoint("30.6539517", "122.0165533"));
        data.add(new TrajectoryPoint("30.6539333", "122.0166167"));
        data.add(new TrajectoryPoint("30.6539267", "122.0165483"));
        data.add(new TrajectoryPoint("30.653935", "122.0166467"));
        data.add(new TrajectoryPoint("30.6539717", "122.0165617"));
        data.add(new TrajectoryPoint("30.6540033", "122.0166533"));
        data.add(new TrajectoryPoint("30.653955", "122.016675"));
        data.add(new TrajectoryPoint("30.6539533", "122.0166467"));
        data.add(new TrajectoryPoint("30.6539183", "122.0165733"));
        data.add(new TrajectoryPoint("30.6539383", "122.0166817"));
        data.add(new TrajectoryPoint("30.6538833", "122.0166417"));
        data.add(new TrajectoryPoint("30.6538933", "122.0166083"));
        data.add(new TrajectoryPoint("30.653905", "122.01666"));
        data.add(new TrajectoryPoint("30.5855217", "122.1165567"));
        data.add(new TrajectoryPoint("30.5384067", "122.33779"));
        data.add(new TrajectoryPoint("30.46509", "122.54878"));
        data.add(new TrajectoryPoint("30.4601283", "122.4710683"));
        data.add(new TrajectoryPoint("30.4598533", "122.4706767"));
        data.add(new TrajectoryPoint("30.4596817", "122.4704167"));
        data.add(new TrajectoryPoint("30.4597467", "122.4699167"));
        data.add(new TrajectoryPoint("30.45971", "122.4700983"));
        data.add(new TrajectoryPoint("30.4597", "122.470095"));
        data.add(new TrajectoryPoint("30.4597633", "122.4703817"));
        data.add(new TrajectoryPoint("30.45994", "122.4707"));
        data.add(new TrajectoryPoint("30.4599367", "122.4707183"));
        data.add(new TrajectoryPoint("30.459905", "122.470655"));
        data.add(new TrajectoryPoint("30.4598467", "122.4706267"));
        data.add(new TrajectoryPoint("30.4598267", "122.4706283"));
        data.add(new TrajectoryPoint("30.4597383", "122.4704067"));
        data.add(new TrajectoryPoint("30.4596117", "122.470235"));
        data.add(new TrajectoryPoint("30.4595383", "122.469925"));
        data.add(new TrajectoryPoint("30.459555", "122.4699033"));
        data.add(new TrajectoryPoint("30.4595867", "122.4697667"));
        data.add(new TrajectoryPoint("30.459585", "122.4696767"));
        data.add(new TrajectoryPoint("30.45961", "122.4700033"));
        data.add(new TrajectoryPoint("30.4597467", "122.4704567"));
        data.add(new TrajectoryPoint("30.459775", "122.4704367"));
        data.add(new TrajectoryPoint("30.4599167", "122.470745"));
        data.add(new TrajectoryPoint("30.4599717", "122.470765"));
        data.add(new TrajectoryPoint("30.4598", "122.4704067"));
        data.add(new TrajectoryPoint("30.4597167", "122.4700767"));
        data.add(new TrajectoryPoint("30.46285", "122.4948817"));
        data.add(new TrajectoryPoint("30.4723133", "122.7092817"));
        data.add(new TrajectoryPoint("30.473105", "123.004575"));
        data.add(new TrajectoryPoint("30.8133133", "123.0137933"));
        data.add(new TrajectoryPoint("31.1400333", "123.00369"));
        data.add(new TrajectoryPoint("31.49396", "123.02069"));
        data.add(new TrajectoryPoint("31.923665", "123.0100217"));
        data.add(new TrajectoryPoint("35.6940567", "121.8339817"));
        data.add(new TrajectoryPoint("35.5717567", "122.0820583"));
        data.add(new TrajectoryPoint("34.317275", "124.43054"));
        data.add(new TrajectoryPoint("33.7919717", "125.7252483"));
        data.add(new TrajectoryPoint("33.7825483", "125.91881"));
        data.add(new TrajectoryPoint("33.77144", "126.1203133"));
        data.add(new TrajectoryPoint("33.7683517", "127.1342517"));
        data.add(new TrajectoryPoint("33.7694733", "127.41395"));
        data.add(new TrajectoryPoint("33.779455", "127.6467167"));
        data.add(new TrajectoryPoint("34.493435", "129.009305"));
        data.add(new TrajectoryPoint("34.5771567", "129.06045"));
        data.add(new TrajectoryPoint("34.577545", "129.0602733"));
        data.add(new TrajectoryPoint("34.5124117", "129.0389267"));
        data.add(new TrajectoryPoint("34.69322", "128.9992833"));
        data.add(new TrajectoryPoint("34.8730667", "128.8885467"));
        data.add(new TrajectoryPoint("35.0537867", "128.783255"));
        data.add(new TrajectoryPoint("35.0773433", "128.8265783"));
        data.add(new TrajectoryPoint("35.0773783", "128.8265933"));
        data.add(new TrajectoryPoint("35.0773817", "128.8264533"));
        data.add(new TrajectoryPoint("35.0773417", "128.826545"));
        data.add(new TrajectoryPoint("35.077335", "128.82665"));
        data.add(new TrajectoryPoint("35.0773367", "128.826605"));
        data.add(new TrajectoryPoint("35.0773617", "128.8265817"));
        data.add(new TrajectoryPoint("35.0773533", "128.8265917"));
        data.add(new TrajectoryPoint("35.0773217", "128.8265933"));
        data.add(new TrajectoryPoint("35.0772967", "128.8265967"));
        data.add(new TrajectoryPoint("35.077335", "128.8266033"));
        data.add(new TrajectoryPoint("35.0773067", "128.8266133"));
        data.add(new TrajectoryPoint("35.0773133", "128.8266283"));
        data.add(new TrajectoryPoint("35.07736", "128.8266167"));
        data.add(new TrajectoryPoint("35.0773517", "128.8266317"));
        data.add(new TrajectoryPoint("35.07736", "128.826595"));
        data.add(new TrajectoryPoint("35.0773717", "128.8266633"));
        data.add(new TrajectoryPoint("35.0773317", "128.826605"));
        data.add(new TrajectoryPoint("35.0773083", "128.826505"));
        data.add(new TrajectoryPoint("35.07734", "128.82662"));
        data.add(new TrajectoryPoint("35.0773117", "128.8267117"));
        data.add(new TrajectoryPoint("35.0773033", "128.8265817"));
        data.add(new TrajectoryPoint("35.077325", "128.826605"));
        data.add(new TrajectoryPoint("35.0773317", "128.826565"));
        data.add(new TrajectoryPoint("35.0772417", "128.8266317"));
        data.add(new TrajectoryPoint("35.0773233", "128.82634"));
        data.add(new TrajectoryPoint("35.0771317", "128.8262883"));
        data.add(new TrajectoryPoint("35.0762867", "128.8262183"));
        data.add(new TrajectoryPoint("34.9759233", "128.8021283"));
        data.add(new TrajectoryPoint("34.8144983", "128.9491683"));
        data.add(new TrajectoryPoint("34.5449717", "129.0197083"));
        data.add(new TrajectoryPoint("34.2522167", "128.9427983"));
        data.add(new TrajectoryPoint("33.9532867", "128.8713883"));
        data.add(new TrajectoryPoint("33.6679283", "128.7512767"));
        data.add(new TrajectoryPoint("33.3622817", "128.6715017"));
        data.add(new TrajectoryPoint("33.066985", "128.5836783"));
        data.add(new TrajectoryPoint("32.6304133", "128.4810667"));
        data.add(new TrajectoryPoint("32.3750733", "128.6442517"));
        data.add(new TrajectoryPoint("32.1317733", "128.8722883"));
        data.add(new TrajectoryPoint("31.8908467", "129.09494"));
        data.add(new TrajectoryPoint("31.64978", "129.31829"));
        data.add(new TrajectoryPoint("31.4043717", "129.5555667"));
        data.add(new TrajectoryPoint("31.2131867", "129.8164683"));
        data.add(new TrajectoryPoint("31.0551583", "130.105515"));
        data.add(new TrajectoryPoint("30.9294083", "130.4095267"));
        data.add(new TrajectoryPoint("30.90364", "130.75433"));
        data.add(new TrajectoryPoint("30.9121883", "131.1032017"));
        data.add(new TrajectoryPoint("30.9474417", "131.4604333"));
        data.add(new TrajectoryPoint("30.9687617", "131.8088967"));
        data.add(new TrajectoryPoint("31.0159633", "132.163715"));
        data.add(new TrajectoryPoint("31.247995", "132.671205"));
        data.add(new TrajectoryPoint("31.46554", "133.1500367"));
        data.add(new TrajectoryPoint("31.7626917", "133.74975"));
        data.add(new TrajectoryPoint("32.0144733", "134.23634"));
        data.add(new TrajectoryPoint("32.1628083", "134.5449033"));
        data.add(new TrajectoryPoint("32.3404033", "134.874545"));
        data.add(new TrajectoryPoint("32.69517", "135.52792"));
        data.add(new TrajectoryPoint("32.8760183", "135.842685"));
        data.add(new TrajectoryPoint("33.0448467", "136.165565"));
        data.add(new TrajectoryPoint("33.3025083", "136.6201433"));
        data.add(new TrajectoryPoint("33.4560617", "136.9071533"));
        data.add(new TrajectoryPoint("33.6133567", "137.2065783"));
        data.add(new TrajectoryPoint("33.7689033", "137.5212683"));
        data.add(new TrajectoryPoint("34.057055", "138.055975"));
        data.add(new TrajectoryPoint("34.1972517", "138.3300767"));
        data.add(new TrajectoryPoint("34.3205233", "138.6099717"));
        data.add(new TrajectoryPoint("34.4426983", "138.889265"));
        data.add(new TrajectoryPoint("34.6311267", "139.1406633"));
        data.add(new TrajectoryPoint("34.8455667", "139.3231083"));
        data.add(new TrajectoryPoint("34.9947317", "139.5530683"));
        data.add(new TrajectoryPoint("35.0312567", "139.6778133"));
        data.add(new TrajectoryPoint("35.16582", "139.777195"));
        data.add(new TrajectoryPoint("35.365755", "139.7015583"));
        data.add(new TrajectoryPoint("35.3979433", "139.679985"));
        data.add(new TrajectoryPoint("35.3978567", "139.6799017"));
        data.add(new TrajectoryPoint("35.3979833", "139.680055"));
        data.add(new TrajectoryPoint("35.3978933", "139.6799917"));
        data.add(new TrajectoryPoint("35.3979317", "139.68002"));
        data.add(new TrajectoryPoint("35.3979867", "139.680295"));
        data.add(new TrajectoryPoint("35.39808", "139.6800367"));
        data.add(new TrajectoryPoint("35.398015", "139.68004"));
        data.add(new TrajectoryPoint("35.398025", "139.68007"));
        data.add(new TrajectoryPoint("35.397825", "139.6800383"));
        data.add(new TrajectoryPoint("35.397935", "139.6799667"));
        data.add(new TrajectoryPoint("35.3979983", "139.6800233"));
        data.add(new TrajectoryPoint("35.3979267", "139.6799683"));
        data.add(new TrajectoryPoint("35.3167083", "139.7177317"));
        data.add(new TrajectoryPoint("35.1358767", "139.749375"));
        data.add(new TrajectoryPoint("34.878295", "139.7131867"));
        data.add(new TrajectoryPoint("34.824485", "140.1104267"));
        data.add(new TrajectoryPoint("34.83338", "140.5767"));
        data.add(new TrajectoryPoint("34.8403583", "141.0306133"));
        data.add(new TrajectoryPoint("34.8395167", "141.5114083"));
        data.add(new TrajectoryPoint("34.8396517", "141.968675"));
        data.add(new TrajectoryPoint("34.8457", "142.4158033"));
        data.add(new TrajectoryPoint("34.8596633", "142.8231917"));
        data.add(new TrajectoryPoint("34.8571483", "143.2248983"));
        data.add(new TrajectoryPoint("34.85771", "143.5928083"));
        data.add(new TrajectoryPoint("34.8698667", "143.9237333"));
        data.add(new TrajectoryPoint("34.8720683", "144.2927533"));
        data.add(new TrajectoryPoint("34.8756183", "144.6121383"));
        data.add(new TrajectoryPoint("34.8793167", "144.9472"));
        data.add(new TrajectoryPoint("34.8695117", "145.3330033"));
        data.add(new TrajectoryPoint("34.8690883", "145.7302483"));
        data.add(new TrajectoryPoint("34.8846167", "146.1008733"));
        data.add(new TrajectoryPoint("34.8402117", "146.4294633"));
        data.add(new TrajectoryPoint("34.79322", "146.7550933"));
        payload.setArrowStyle(new ArrowStyle("red", Integer.valueOf(10), Integer.valueOf(3)));
        for (int i = 10; i < data.size(); i += 20) {
            TrajectoryPoint point = (TrajectoryPoint)data.get(i);
            MarkerStyle markerStyle = new MarkerStyle();
            markerStyle.setColor("red");
            markerStyle.setSize(Integer.valueOf(12));
            point.setMarkerStyle(markerStyle);
            point.setPointType("waypoint_time");
            HashMap popupData = Maps.newHashMap();
            popupData.put("\u8239\u540d", "XX");
            popupData.put("\u822a\u6b21", "XX");
            popupData.put("\u9884\u62b5\u65f6\u95f4", "XXXX.XX." + i);
            popupData.put("\u9884\u62b5\u76ee\u7684\u6e2f", "XX\u6e2f\u53e3" + i);
            point.setPopupData((Map)popupData);
            point.setShowType(ShowTypeEnums.HOVER);
            point.setTimestamp(DateUtil.formatDate((Date)new Date()));
        }
        TrajectoryPoint startPoint = (TrajectoryPoint)data.get(0);
        HashMap startKVA = Maps.newHashMap();
        startKVA.put("\u8f68\u8ff9", "TEST");
        startKVA.put("\u65f6\u95f4", "2024\u5e7412\u67081\u65e5");
        startKVA.put("\u5750\u6807", "146.4294633, 34.8402117");
        startPoint.setPopupData((Map)startKVA);
        startPoint.setPointType("start");
        startPoint.setPopupTitle("\u8d77\u70b9");
        startPoint.setMarkerStyle(new MarkerStyle("green", Integer.valueOf(18)));
        TrajectoryPoint endPoint = (TrajectoryPoint)data.get(data.size() - 1);
        HashMap endKVB = Maps.newHashMap();
        endKVB.put("\u8f68\u8ff9", "TEST");
        endKVB.put("\u901f\u5ea6", "10 \u8282");
        endKVB.put("\u822a\u5411", "10");
        endPoint.setPopupData((Map)endKVB);
        endPoint.setPointType("end");
        endPoint.setPopupTitle("\u7ec8\u70b9");
        endPoint.setMarkerStyle(new MarkerStyle("orange", Integer.valueOf(18)));
        payload.setData(data);
        message.setPayload((Object)payload);
        this.sendPostMessage(message);
    }

    private void initPresetShip() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.DRAW_SHIP);
        MarkData data = new MarkData();
        ArrayList fields = Lists.newArrayList();
        HashMap fieldGpA = Maps.newHashMap();
        fieldGpA.put("MMSI", "MMSI");
        fieldGpA.put("IMONO", "IMONO");
        fieldGpA.put("CALLNO", "\u547c\u53f7");
        fields.add(fieldGpA);
        HashMap fieldGpB = Maps.newHashMap();
        fieldGpB.put("\u8239\u8236\u7c7b\u578b", "\u96c6\u88c5\u7bb1\u8d27\u8239");
        fieldGpB.put("\u8239\u957f", "500\u7c73");
        fieldGpB.put("\u8239\u5bbd", "80\u7c73");
        fieldGpB.put("\u824f\u5411", "108\u00b0");
        fieldGpB.put("\u5403\u6c34", "24\u7c73");
        fields.add(fieldGpB);
        HashMap fieldGpC = Maps.newHashMap();
        fieldGpC.put("\u822a\u901f", "30\u8282");
        fieldGpC.put("\u822a\u884c\u72b6\u6001", "\u5728\u884c");
        fieldGpC.put("\u76ee\u7684\u6e2f", "\u9999\u6e2f-\u7ef4\u591a\u5229\u4e9a\u6e2f");
        fieldGpC.put("\u5230\u6e2f\u65f6\u95f4", "2025\u5e748\u67081\u65e5");
        fields.add(fieldGpC);
        HashMap fieldGpD = Maps.newHashMap();
        fieldGpD.put("\u6570\u636e\u66f4\u65b0\u65f6\u95f4", "2025\u5e747\u670825\u65e5");
        fields.add(fieldGpD);
        data.setMarkId(UUID.randomUUID().toString());
        data.setMarkName("XX\u8239\u540d\u79f0");
        data.setLatitude("34.8457");
        data.setLongitude("142.4158033");
        data.setPopupData((List)fields);
        data.setIconUrl("/assets/image/cargo-ship.png");
        data.setIconWidth(Double.valueOf(50.0));
        data.setIconHeight(Double.valueOf(50.0));
        data.setIconScale(Double.valueOf(1.2));
        data.setIconOffsetX(Double.valueOf(25.0));
        data.setIconOffsetY(Double.valueOf(25.0));
        data.setIconAngle(Double.valueOf(-20.0));
        data.setDefaultOpenPopup(true);
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void loadEmptyMap() {
        IFrame map = this.getMap();
        if (YEM.isEmpty((Object)map)) {
            throw new KDBizException("\u672a\u627e\u5230IFrame\u63a7\u4ef6\uff01");
        }
        map.setSrc("https://map.wmyun.com?plugin=GsMapFormPlugin");
    }

    private IFrame getMap() {
        return (IFrame)this.getControl("yem_iframe");
    }

    private void sendPostMessage(MapMessage data) {
        IFrameMessage message = new IFrameMessage();
        MapMessageType type = data.getType();
        message.setType(type.name());
        message.setContent((Object)data);
        message.setOrigin("https://map.wmyun.com?plugin=GsMapFormPlugin");
        IFrame map = this.getMap();
        map.postMessage(message);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("load_data".equals(operateKey)) {
            this.initPresetTrajectory();
        }
    }
}

