/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.bill.seafreight.dynamic;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.portal.util.SerializationUtils;
import yem.base.common.utils.YEM;
import yem.wm.gs.trsnport.bill.seafreight.dynamic.utils.GsApiUtils;

public class POCBoxInfoFormPlugin
extends AbstractFormPlugin {
    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventArgs = e.getEventArgs();
        if (YEM.isNotEmpty((Object)eventArgs) && "afterShowSlideBill".equals(e.getKey())) {
            Map evtParamsMap = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            Map params = (Map)evtParamsMap.get("params");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
            model.deleteEntryData("yem_entryentity");
            String box_number = (String)params.get("yem_poc_xh");
            if (YEM.isNotEmpty((Object)box_number)) {
                this.initBoxNodeData(box_number);
            } else {
                box_number = "BMOU2086941";
                this.initBoxNodeData(box_number);
            }
        }
    }

    private void initBoxNodeData(String boxNumber) {
        GsApiUtils api = new GsApiUtils();
        String response = api.queryBoxStatusNode(boxNumber);
        if (!api.validateResponse(response).booleanValue()) {
            return;
        }
        JSONObject respDataObj = api.parseResponseObject(response);
        if (respDataObj == null || !respDataObj.containsKey((Object)"list")) {
            return;
        }
        JSONArray array = respDataObj.getJSONArray("list");
        if (array == null || array.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("yem_xh", (Object)boxNumber);
        model.deleteEntryData("yem_entryentity");
        ArrayList<JSONObject> sortedList = new ArrayList<JSONObject>();
        for (int i = 0; i < array.size(); ++i) {
            sortedList.add(array.getJSONObject(i));
        }
        sortedList.sort(Comparator.comparing(item -> {
            Long eventTime = item.getLong("eventTime");
            return eventTime != null ? eventTime : 0L;
        }));
        for (JSONObject item2 : sortedList) {
            String ctnrNo = item2.getString("ctnrNo");
            String statusCd = item2.getString("statusCd");
            String statusDesc = item2.getString("statusDesc");
            String statusDescEn = item2.getString("statusDescEn");
            Long eventTime = item2.getLong("eventTime");
            String placeCd = item2.getString("placeCd");
            String place = item2.getString("place");
            String vesselName = item2.getString("vesselName");
            String voyage = item2.getString("voyage");
            String sourceCd = item2.getString("sourceCd");
            String transportMode = item2.getString("transportMode");
            Date dqsj = eventTime != null ? new Date(eventTime) : null;
            String dtdm = statusCd + "   " + statusDesc;
            String ly = this.getSourceName(sourceCd);
            this.setNewRowValue(ctnrNo, dtdm, statusDescEn, dqsj, placeCd, place, vesselName, voyage, ly, transportMode);
        }
    }

    private String getSourceName(String sourceCd) {
        if (YEM.isEmpty((Object)sourceCd)) {
            return "";
        }
        switch (sourceCd) {
            case "1": {
                return "\u8239\u4e1c";
            }
            case "4": {
                return "\u4e91\u5f53\u8ba1\u7b97";
            }
        }
        return sourceCd;
    }

    private void setNewRowValue(String xh, String dtdm, String dqdt, Date dqsj, String dqdd, String dtdd, String cm, String hc, String ly, String ysfs) {
        IDataModel model = this.getModel();
        int index = model.createNewEntryRow("yem_entryentity");
        model.setValue("yem_poc_xh", (Object)xh, index);
        model.setValue("yem_poc_dtdm", (Object)dtdm, index);
        model.setValue("yem_poc_dqdt", (Object)dqdt, index);
        model.setValue("yem_poc_dqsj", (Object)dqsj, index);
        model.setValue("yem_poc_dqdd", (Object)dqdd, index);
        model.setValue("yem_poc_dtdd", (Object)dtdd, index);
        model.setValue("yem_poc_cm", (Object)cm, index);
        model.setValue("yem_poc_hc", (Object)hc, index);
        model.setValue("yem_poc_ly", (Object)ly, index);
        model.setValue("yem_poc_ysfs", (Object)ysfs, index);
    }
}

