/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.bill.seafreight.dynamic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.nacos.common.utils.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.Label;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import org.apache.commons.compress.utils.Lists;
import yem.base.common.utils.DateUtil;
import yem.base.common.utils.YEM;
import yem.wm.gs.common.utils.DateUtils;
import yem.wm.gs.service.map.dal.FitBoundsData;
import yem.wm.gs.service.map.dal.MapMessage;
import yem.wm.gs.service.map.dal.MarkData;
import yem.wm.gs.service.map.dal.MarkerStyle;
import yem.wm.gs.service.map.dal.SetViewData;
import yem.wm.gs.service.map.dal.StatisticsData;
import yem.wm.gs.service.map.dal.TrajectoryData;
import yem.wm.gs.service.map.dal.TrajectoryPoint;
import yem.wm.gs.service.map.enums.MapIconEnums;
import yem.wm.gs.service.map.enums.MapMessageType;
import yem.wm.gs.service.map.enums.ShowTypeEnums;
import yem.wm.gs.trsnport.bill.seafreight.dynamic.dto.TrajectoryInfo;
import yem.wm.gs.trsnport.bill.seafreight.dynamic.enums.ShippingStatusConstants;
import yem.wm.gs.trsnport.bill.seafreight.dynamic.utils.GsApiUtils;

public class ShippingTrackingFormPlugin
extends AbstractFormPlugin
implements Plugin,
RowClickEventListener {
    private static final int bolCardMaxCapacity = 1;
    private static final int sumCardMaxCapacity = 4;
    private String MAP = "https://map.wmyun.com";
    private static final Map<Long, String> SHIP_TYPE_MAP = new HashMap<Long, String>();
    private static final SimpleDateFormat sdf;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handleInit();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String pageId = view.getPageId();
        this.MAP = this.MAP + "?pageId=" + pageId;
        FormShowParameter fsp = view.getFormShowParameter();
        Map data = fsp.getCustomParams();
        if (data.containsKey("params")) {
            Map params = (Map)data.get("params");
            if (params.containsKey("yem_bol")) {
                String yemBol = params.get("yem_bol").toString();
                model.setValue("yem_bol", (Object)yemBol);
                this.handleSearch();
            }
        } else {
            this.initVoyageData();
        }
    }

    private void handleInit() {
        int i;
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        cache.put("current_focus", "yem_card_1");
        cache.put("current_page", "init");
        for (i = 1; i <= 1; ++i) {
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_card_" + i});
        }
        for (i = 1; i <= 4; ++i) {
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_card_ent_" + i});
        }
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_timestep"});
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_sumlist"});
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_bollist"});
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_btn_back"});
    }

    private void handleBack() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.handleInit();
        this.initVoyageData();
        view.addClientCallBack("clear");
        model.setValue("yem_contract", null);
        model.setValue("yem_bol", null);
        model.setValue("yem_vesselname", null);
        model.setValue("yem_voyage", null);
    }

    private void initVoyageData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        GsApiUtils api = new GsApiUtils();
        String responseData = api.queryShipVoyageInfo();
        if (api.validateResponse(responseData).booleanValue()) {
            JSONArray responseArray = api.parseResponseArray(responseData);
            for (int i = 0; i < responseArray.size() && i <= 3; ++i) {
                int idx = i + 1;
                JSONObject object = (JSONObject)responseArray.get(i);
                String pol = object.getString("polName");
                String pod = object.getString("podName");
                String polEn = object.getString("polNameEn");
                String podEn = object.getString("podNameEn");
                JSONArray data = object.getJSONArray("data");
                this.set(idx, "yem_ent_pol_", pol);
                this.set(idx, "yem_ent_pod_", pod);
                this.set(idx, "yem_ent_polen_", polEn);
                this.set(idx, "yem_ent_poden_", podEn);
                view.setVisible(Boolean.valueOf(true), new String[]{"yem_card_ent_" + idx});
                model.deleteEntryData("yem_ent_" + idx);
                for (int j = 0; j < data.size(); ++j) {
                    JSONObject sub = (JSONObject)data.get(j);
                    String shipName = sub.getString("shipName");
                    String voyage = sub.getString("voyage");
                    String bol = sub.getString("bol");
                    String eta = DateUtil.formatDate((Date)new Date(sub.getLong("eta")));
                    String etd = DateUtil.formatDate((Date)new Date(sub.getLong("etd")));
                    model.createNewEntryRow("yem_ent_" + idx);
                    model.setValue("yem_e_shipname_" + idx, (Object)shipName, j);
                    model.setValue("yem_e_voy_" + idx, (Object)voyage, j);
                    model.setValue("yem_e_eta_" + idx, (Object)eta, j);
                    model.setValue("yem_e_etd_" + idx, (Object)etd, j);
                    model.setValue("yem_e_bol_" + idx, (Object)bol, j);
                }
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        super.entryRowDoubleClick(e);
        EntryGrid source = (EntryGrid)e.getSource();
        IFormView view = this.getView();
        String key = source.getKey();
        IDataModel model = this.getModel();
        int idx = Integer.parseInt(key.substring(key.lastIndexOf("_") + 1));
        int[] rows = source.getSelectRows();
        if (rows.length > 0) {
            int j = rows[0];
            model.setValue("yem_bol", model.getValue("yem_e_bol_" + idx), j);
            model.setValue("yem_contract", null);
            model.setValue("yem_vesselname", model.getValue("yem_e_shipname_" + idx), j);
            model.setValue("yem_voyage", model.getValue("yem_e_voy_" + idx), j);
            view.addClientCallBack("search");
        }
    }

    private void setDefaultPicture() {
        IDataModel model = this.getModel();
        DynamicObject picture = BusinessDataServiceHelper.loadSingleFromCache((String)"yem_gs_bdpicture", (QFilter[])new QFilter[0]);
        if (YEM.isNotEmpty((Object)picture)) {
            model.setValue("yem_picture", picture.get("yem_picture"));
        }
    }

    private void initStatisticsInfo() {
        GsApiUtils api = new GsApiUtils();
        String responseData = api.queryStatisticsInfo();
        if (api.validateResponse(responseData).booleanValue()) {
            JSONObject response = api.parseResponseObject(responseData);
            ArrayList msg = Lists.newArrayList();
            if (response.containsKey((Object)"totalCount")) {
                msg.add(new StatisticsData("\u603b\u8239\u8236\u6570", response.getString("totalCount"), null));
            }
            if (response.containsKey((Object)"onWayCount")) {
                msg.add(new StatisticsData("\u5728\u9014\u8239\u8236\u6570", response.getString("onWayCount"), null));
            }
            if (response.containsKey((Object)"arrivedCount")) {
                msg.add(new StatisticsData("\u8fd0\u62b5\u8239\u8236\u6570", response.getString("arrivedCount"), null));
            }
            if (response.containsKey((Object)"willArrivedCount")) {
                msg.add(new StatisticsData("\u5373\u5c06\u5230\u6e2f", response.getString("willArrivedCount"), null));
            }
            MapMessage mapMessage = new MapMessage();
            mapMessage.setType(MapMessageType.INIT_STATS);
            mapMessage.setPayload((Object)msg);
            this.sendPostMessage(mapMessage);
        }
    }

    public void registerListener(EventObject e) {
        int i;
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_btn_search", "yem_btn_back"});
        for (i = 1; i <= 1; ++i) {
            this.addClickListeners(new String[]{"yem_card_" + i});
            this.addClickListeners(new String[]{"yem_boxinfo_" + i});
            this.addClickListeners(new String[]{"yem_a_relayinfo_" + i});
        }
        for (i = 1; i <= 4; ++i) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("yem_ent_" + i);
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void click(EventObject evt) {
        HashMap data;
        String bol;
        String idx;
        IPageCache cache;
        String currentFocus;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        if (key.equals("yem_btn_search")) {
            this.handleSearch();
        }
        if (key.equals("yem_btn_back")) {
            this.handleBack();
        }
        if (key.startsWith("yem_card_") && !key.equals(currentFocus = (cache = view.getPageCache()).get("current_focus"))) {
            cache.put("current_focus", key);
            this.handleCardFocusChange();
        }
        if (key.startsWith("yem_boxinfo_")) {
            idx = key.substring(key.lastIndexOf("_") + 1);
            bol = this.get("yem_card_title_" + idx);
            data = Maps.newHashMap();
            data.put("bol", bol);
            this.openForm("yem_gs_sea_boxinfo", data);
        }
        if (key.startsWith("yem_a_relayinfo_")) {
            idx = key.substring(key.lastIndexOf("_") + 1);
            bol = this.get("yem_card_title_" + idx);
            data = Maps.newHashMap();
            data.put("bol", bol);
            this.openForm("yem_gs_sea_relayinfo", data);
        }
    }

    private void openForm(String formId, Map<String, String> params) {
        IFormView view = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        for (Map.Entry<String, String> e : params.entrySet()) {
            parameter.setCustomParam(e.getKey(), (Object)e.getValue());
        }
        view.showForm(parameter);
    }

    private void handleCardFocusChange() {
        IFormView view = this.getView();
        int value = this.getCurrentFocusIdx();
        String bol = this.get("yem_card_title_" + value);
        this.updateBillStepStatusDataByBOL(bol);
        view.addClientCallBack("map-init");
    }

    public int getCurrentFocusIdx() {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        String currentFocus = cache.get("current_focus");
        return Integer.parseInt(currentFocus.substring(currentFocus.lastIndexOf("_") + 1));
    }

    private void handleSearch() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_timestep"});
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_sumlist"});
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_bollist"});
        cache.put("current_page", "search");
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_btn_back"});
        String contract = (String)model.getValue("yem_contract");
        LinkedHashSet bol = Sets.newLinkedHashSet();
        if (YEM.isNotEmpty((Object)contract)) {
            bol = this.queryLadingBillNoByContractNo(contract);
        }
        String inputBol = (String)model.getValue("yem_bol");
        if (!bol.isEmpty() && YEM.isNotEmpty((Object)inputBol)) {
            LinkedHashSet filter = Sets.newLinkedHashSet();
            for (String s : bol) {
                if (!s.equals(inputBol)) continue;
                filter.add(inputBol);
            }
            bol = filter;
        }
        if (bol.isEmpty() && YEM.isEmpty((Object)inputBol)) {
            view.showErrorNotification("\u8f93\u5165\u6709\u6548\u6570\u636e\uff01");
            return;
        }
        if (bol.isEmpty() && YEM.isNotEmpty((Object)inputBol)) {
            bol.add((String)inputBol);
        }
        for (int i = 1; i <= bol.size() && i <= 1; ++i) {
            view.setVisible(Boolean.valueOf(true), new String[]{"yem_card_" + i});
        }
        if (!bol.isEmpty()) {
            this.fetchBillInfoByBOL(bol);
            this.updateBillStepStatusDataByBOL((String)bol.iterator().next());
            this.fetchBoxDataByBOL(bol);
            view.addClientCallBack("map-init");
        } else {
            view.showErrorNotification("\u672a\u627e\u5230\u6709\u6548\u6570\u636e\uff01");
        }
        String vesselname = (String)model.getValue("yem_vesselname");
        String voyage = (String)model.getValue("yem_voyage");
    }

    private LinkedHashSet<String> queryLadingBillNoByContractNo(String contract) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("COSU6426289040");
        set.add("257300165");
        set.add("TAUO50366300");
        set.add("SHHP50182100");
        return set;
    }

    private void fetchBoxDataByBOL(LinkedHashSet<String> bol) {
        GsApiUtils api = new GsApiUtils();
        String resp = api.batchQueryBoxInfoByLadingBill(bol);
        if (api.validateResponse(resp).booleanValue()) {
            JSONObject responseObject = api.parseResponseObject(resp);
            Map response = (Map)responseObject.toJavaObject((TypeReference)new TypeReference<Map<String, List<JSONObject>>>(){});
            LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
            int index = 1;
            ArrayList<String> list = new ArrayList<String>(bol);
            for (int i = 0; i < list.size() && i < 1; ++i) {
                String value = (String)list.get(i);
                map.put(value, index++);
            }
            for (Map.Entry e : response.entrySet()) {
                String k = (String)e.getKey();
                List value = (List)e.getValue();
                if (!map.containsKey(k)) continue;
                int i = (Integer)map.get(k);
                this.setBoxData(i, value);
            }
        }
    }

    private void setBoxData(int i, List<JSONObject> value) {
        HashSet boxnum = Sets.newHashSet();
        HashSet sealno = Sets.newHashSet();
        HashSet size = Sets.newHashSet();
        HashSet type = Sets.newHashSet();
        HashSet qty = Sets.newHashSet();
        HashSet gwgt = Sets.newHashSet();
        IDataModel model = this.getModel();
        model.deleteEntryData("yem_entryentity");
        for (JSONObject data : value) {
            boxnum.add(this.get(data, "ctnrNo"));
            sealno.add(this.get(data, "sealNo"));
            size.add(this.get(data, "ctnrSize"));
            type.add(this.get(data, "ctnrType"));
            qty.add(this.get(data, "pkgs"));
            gwgt.add(this.get(data, "gwgt"));
            int row = model.createNewEntryRow("yem_entryentity");
            model.setValue("yem_poc_xh", (Object)data.getString("ctnrNo"), row);
            model.setValue("yem_poc_dqdt", (Object)data.getString("currentStatus"), row);
            model.setValue("yem_poc_dqsj", (Object)new Date(data.getLong("currentStatusTime")), row);
            model.setValue("yem_poc_dqdd", (Object)data.getString("currentPlace"), row);
        }
        this.set(i, "yem_b_boxnum_", "\u7bb1\u53f7", this.join(boxnum));
        this.set(i, "yem_b_sealno_", "\u94c5\u5c01\u53f7", this.join(sealno));
        this.set(i, "yem_b_size_", "\u5c3a\u5bf8", this.join(size));
        this.set(i, "yem_b_type_", "\u7bb1\u578b", this.join(type));
        this.set(i, "yem_b_qty_", "\u4ef6\u6570", this.join(qty));
        this.set(i, "yem_b_gwgt_", "\u6bdb\u91cd", this.join(gwgt));
        this.set(i, "yem_b_totalqty_", "\u7bb1\u5b50\u603b\u6570", String.valueOf(value.size()));
    }

    private String join(Set<String> set) {
        if ((set = set.stream().filter(StringUtils::hasText).collect(Collectors.toSet())).isEmpty()) {
            return "\u6682\u65e0\u6570\u636e";
        }
        return String.join((CharSequence)",", set);
    }

    private String extractFirstItem(String joinedStr) {
        if (StringUtils.isEmpty((String)joinedStr) || "\u6682\u65e0\u6570\u636e".equals(joinedStr)) {
            return "";
        }
        Set set = Arrays.stream(joinedStr.split(",")).map(String::trim).filter(StringUtils::hasText).collect(Collectors.toSet());
        return set.isEmpty() ? "" : (String)set.iterator().next();
    }

    private String get(JSONObject data, String k) {
        if (data.containsKey((Object)k) && YEM.isNotEmpty((Object)data.get((Object)k))) {
            return data.getString(k);
        }
        return "";
    }

    private void fetchBillInfoByBOL(LinkedHashSet<String> bol) {
        List responseList;
        GsApiUtils api = new GsApiUtils();
        String resp = api.batchQueryBillInfoByBOLNo(bol);
        if (api.validateResponse(resp).booleanValue()) {
            JSONArray response = api.parseResponseArray(resp);
            responseList = response.toJavaList(JSONObject.class);
            ShippingTrackingFormPlugin.sortByReferenceNo(responseList, bol);
            Map<String, Boolean> isRelay = this.fetchIsRelayTransport(bol);
            for (JSONObject resObj : responseList) {
                String referenceNo = resObj.getString("referenceNo");
                if (!isRelay.containsKey(referenceNo)) continue;
                resObj.put("isRelay", (Object)isRelay.get(referenceNo));
            }
        } else {
            throw new KDBizException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
        }
        this.setBillInfo(responseList);
        this.fetchAISInfo(responseList);
    }

    private Map<String, Boolean> fetchIsRelayTransport(LinkedHashSet<String> bol) {
        GsApiUtils api = new GsApiUtils();
        String responseData = api.queryIsRelayTransport(bol);
        if (api.validateResponse(responseData).booleanValue()) {
            JSONObject responseObject = api.parseResponseObject(responseData);
            return (Map)responseObject.toJavaObject((TypeReference)new TypeReference<Map<String, Boolean>>(){});
        }
        return Maps.newHashMap();
    }

    public static List<JSONObject> sortByReferenceNo(List<JSONObject> responseList, LinkedHashSet<String> bol) {
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        int index = 0;
        for (String key : bol) {
            orderMap.put(key, index++);
        }
        responseList.sort((o1, o2) -> {
            String ref1 = o1.getString("referenceNo");
            String ref2 = o2.getString("referenceNo");
            Integer index1 = (Integer)orderMap.get(ref1);
            Integer index2 = (Integer)orderMap.get(ref2);
            if (index1 == null || index2 == null) {
                throw new IllegalArgumentException("referenceNo not found in bol: " + (index1 == null ? ref1 : ref2));
            }
            return Integer.compare(index1, index2);
        });
        return responseList;
    }

    private void setBillInfo(List<JSONObject> data) {
        IFormView view = this.getView();
        for (int idx = 0; idx < data.size() && idx < 1; ++idx) {
            JSONObject response = data.get(idx);
            int i = idx + 1;
            String bol = response.getString("referenceNo");
            this.set(i, "yem_card_title_", "\u63d0\u5355\u53f7", bol);
            this.set(i, "yem_a_shipname_", "\u8239\u540d", response.getString("vesselName"));
            this.set(i, "yem_a_pol_", "\u542f\u8fd0\u6e2f", response.getString("pol"));
            this.set(i, "yem_a_pod_", "\u76ee\u7684\u6e2f", response.getString("pod"));
            this.set(i, "yem_a_eta_", "ETA", DateUtils.getData((Date)response.getDate("etd"), (String)"yyyy-MM-dd HH:mm:ss"));
            this.set(i, "yem_a_etd_", "ETD", DateUtils.getData((Date)response.getDate("eta"), (String)"yyyy-MM-dd HH:mm:ss"));
            this.set(i, "yem_ac_pol_", "", response.getString("pol"));
            this.set(i, "yem_ac_pod_", "", response.getString("pod"));
            this.set(i, "yem_ac_eta_", "", DateUtils.getData((Date)response.getDate("etd"), (String)"yyyy-MM-dd HH:mm:ss"));
            this.set(i, "yem_ac_etd_", "", DateUtils.getData((Date)response.getDate("eta"), (String)"yyyy-MM-dd HH:mm:ss"));
            String isRelay = response.getBoolean("isRelay") != false ? "\u662f" : "\u5426";
            this.set(i, "yem_a_relay_", "\u662f\u5426\u4e2d\u8f6c", isRelay);
            if ("\u662f".equals(isRelay)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"yem_a_relayinfo_" + i});
                continue;
            }
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_a_relayinfo_" + i});
        }
    }

    private void fetchAISInfo(List<JSONObject> data) {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        HashMap dataRelation = Maps.newHashMap();
        for (int idx = 0; idx < data.size() && idx < 1; ++idx) {
            JSONObject response = data.get(idx);
            dataRelation.put(response.getString("vesselName"), idx + 1);
        }
        HashMap responseData = Maps.newHashMap();
        GsApiUtils api = new GsApiUtils();
        String response = api.batchQueryShipLocation(dataRelation.keySet());
        if (api.validateResponse(response).booleanValue()) {
            JSONArray array = api.parseResponseArray(response);
            List list = array.toJavaList(JSONObject.class);
            for (JSONObject obj : list) {
                String vslName = obj.getString("vslName");
                if (!dataRelation.containsKey(vslName)) continue;
                responseData.put(dataRelation.get(vslName), obj);
            }
        }
        cache.put("ais_info", JSON.toJSONString((Object)responseData));
        this.setAISInfo(responseData);
    }

    private void setAISInfo(Map<Integer, JSONObject> responseData) {
        for (Map.Entry<Integer, JSONObject> e : responseData.entrySet()) {
            Integer i = e.getKey();
            JSONObject data = e.getValue();
            Long shipTypeCode = data.getLong("shipType");
            String shipTypeName = SHIP_TYPE_MAP.getOrDefault(shipTypeCode, "\u672a\u77e5");
            String naviStatus = 0L == data.getLong("naviStatus") ? "\u5728\u822a" : "\u9760\u6cca";
            this.set(i, "yem_a_callno_", "\u547c\u53f7", data.getString("callSign"));
            this.set(i, "yem_a_imo_", "IMO", data.getString("imo"));
            this.set(i, "yem_a_mmsi_", "MMSI", data.getString("mmsi"));
            this.set(i, "yem_a_podn_", "\u4e0b\u4e00\u6e2f", data.getString("dest"));
            this.set(i, "yem_ac_shiptype_", "\u8239\u8236\u7c7b\u578b", shipTypeName);
            this.set(i, "yem_ac_bdyear_", "\u5efa\u9020\u5e74\u4efd", data.getString("builtYear"));
            this.set(i, "yem_ac_payload_", "\u8f7d\u91cd", data.getString("dwt"));
            this.set(i, "yem_ac_length_", "\u8239\u8236\u957f\u5ea6", data.getString("length"));
            this.set(i, "yem_ac_width_", "\u8239\u8236\u5bbd\u5ea6", data.getString("width"));
            this.set(i, "yem_ac_cog_", "\u822a\u5411", data.getString("cog"));
            this.set(i, "yem_ac_hdg_", "\u822a\u824f\u5411", data.getString("hdg"));
            this.set(i, "yem_ac_draught_", "\u8239\u8236\u5403\u6c34", data.getString("draught"));
            this.set(i, "yem_ac_longitude_", "", data.getString("longitude"));
            this.set(i, "yem_ac_latitude_", "", data.getString("latitude"));
            this.set(i, "yem_ac_status_", "\u822a\u884c\u72b6\u6001", naviStatus);
            this.set(i, "yem_ac_cstatus_", "", naviStatus);
            this.set(i, "yem_ac_sog_", "\u822a\u901f", data.getString("sog"));
        }
    }

    private void set(int idx, String key, Object v) {
        this.set(idx, key, null, v.toString());
    }

    private void set(int idx, String key, String prefix, String v) {
        String k = key + idx;
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        Label label = (Label)view.getControl(k);
        if (YEM.isEmpty((Object)label)) {
            throw new KDBizException(String.format("\u4e0d\u5b58\u5728\u6807\u7b7e %s \uff0c\u8bf7\u68c0\u67e5\uff01", k));
        }
        if (YEM.isNotEmpty((Object)prefix)) {
            label.setText(prefix + "\uff1a" + v);
        } else {
            label.setText(v);
        }
        cache.put("PREFIX_" + k, v);
    }

    private void set(String k, String v) {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        Label label = (Label)view.getControl(k);
        if (YEM.isEmpty((Object)label)) {
            throw new KDBizException(String.format("\u4e0d\u5b58\u5728\u6807\u7b7e %s \uff0c\u8bf7\u68c0\u67e5\uff01", k));
        }
        label.setText(v);
        cache.put("PREFIX_" + k, v);
    }

    private String get(String k) {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        return cache.get("PREFIX_" + k);
    }

    private String value(String name, String val) {
        return name + "\uff1a" + val;
    }

    private void updateBillStepStatusDataByBOL(String bol) {
        GsApiUtils api = new GsApiUtils();
        String resp = api.queryStatusNodeByRefNumber(bol);
        Wizard wizard = (Wizard)this.getControl("yem_wizardap");
        List stepsOptions = wizard.getStepsOptions();
        stepsOptions.clear();
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        boolean hasSetCurrentStep = false;
        if (api.validateResponse(resp).booleanValue()) {
            JSONArray response = api.parseResponseArray(resp);
            for (Object o : response) {
                LocaleString describe;
                String status;
                JSONObject data = (JSONObject)o;
                String stateDescCn = data.getString("stateDescCn");
                Date actualityTime = data.getDate("actualityTime");
                Date planTime = data.getDate("planTime");
                Date currentTime = new Date();
                if (actualityTime != null) {
                    status = "finish";
                    currentStepMap.put("currentStep", stepsOptions.size());
                    currentStepMap.put("currentStatus", "finish");
                    hasSetCurrentStep = true;
                    long delayDays = 0L;
                    if (planTime != null && actualityTime.after(planTime)) {
                        delayDays = (actualityTime.getTime() - planTime.getTime()) / 86400000L;
                    }
                    describe = delayDays > 0L ? new LocaleString(DateUtil.formatDate((Date)actualityTime) + "\u5ef6" + delayDays + "\u5929") : new LocaleString(DateUtil.formatDate((Date)actualityTime));
                } else if (planTime != null && currentTime.after(planTime)) {
                    status = "process";
                    describe = new LocaleString("\u9884\u8ba1\uff1a" + DateUtil.formatDate((Date)planTime) + "\uff08\u5ef6\u8bef\uff09");
                } else if (planTime != null) {
                    status = "process";
                    describe = new LocaleString("\u9884\u8ba1\uff1a" + DateUtil.formatDate((Date)planTime));
                } else {
                    status = "wait";
                    describe = null;
                }
                stepsOptions.add(new StepsOption(new LocaleString(stateDescCn), describe, status));
            }
        }
        if (!hasSetCurrentStep) {
            currentStepMap.put("currentStep", 1);
            currentStepMap.put("currentStatus", "wait");
        }
        wizard.setWizardStepsOptions(stepsOptions);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    private void loadEmptyMap() {
        IFrame map = this.getMap();
        IFormView view = this.getView();
        if (YEM.isEmpty((Object)map)) {
            throw new KDBizException("\u672a\u627e\u5230IFrame\u63a7\u4ef6\uff01");
        }
        map.setSrc(this.MAP);
    }

    private IFrame getMap() {
        return (IFrame)this.getControl("yem_iframe");
    }

    private void sendPostMessage(MapMessage data) {
        data.setPageId(this.getView().getPageId());
        IFrameMessage message = new IFrameMessage();
        MapMessageType type = data.getType();
        message.setType(type.name());
        message.setContent((Object)data);
        message.setOrigin(this.MAP);
        IFrame map = this.getMap();
        map.postMessage(message);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadEmptyMap();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        String currentFocus = cache.get("current_focus");
        if ("map-init".equals(name)) {
            String responseData;
            GsApiUtils api;
            int value = Integer.parseInt(currentFocus.substring(currentFocus.lastIndexOf("_") + 1));
            this.clearExistData();
            String boxNumber = this.get("yem_b_boxnum_" + value);
            String boxNum = this.extractFirstItem(boxNumber);
            if (YEM.isNotEmpty((Object)boxNum) && (api = new GsApiUtils()).validateResponse(responseData = api.queryBoxStatusByBoxNumber(boxNum)).booleanValue()) {
                JSONArray data = api.parseResponseArray(responseData);
                List<TrajectoryInfo> trajectoryInfos = this.extractTrajectoryInfo(data);
                ArrayList allBoxStatusData = Lists.newArrayList();
                for (Object datum : data) {
                    JSONObject obj = (JSONObject)datum;
                    allBoxStatusData.add(ShippingTrackingFormPlugin.toTrajectoryInfo(obj));
                }
                ArrayList endPoint = Lists.newArrayList();
                for (TrajectoryInfo info2 : trajectoryInfos) {
                    List<TrajectoryPoint> points = this.initPresetTrajectory(info2);
                    if (points.isEmpty()) continue;
                    endPoint.add(points.get(points.size() - 1));
                }
                if (!allBoxStatusData.isEmpty()) {
                    TrajectoryInfo maxEndTimeInfo = Collections.max(allBoxStatusData, Comparator.comparing(info -> {
                        try {
                            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(info.getStartTime());
                        }
                        catch (Exception exp) {
                            throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u89e3\u6790\u9519\u8bef", exp);
                        }
                    }));
                    if (ShippingStatusConstants.isInShipping(maxEndTimeInfo.getStatusCd()).booleanValue()) {
                        this.initPresetShip(maxEndTimeInfo.getShipName());
                    }
                    if (ShippingStatusConstants.isInShipping(maxEndTimeInfo.getStatusCd()).booleanValue() && maxEndTimeInfo.getStatusCd() == ShippingStatusConstants.BDAR) {
                        this.drawADottedLine(maxEndTimeInfo.getBoxNumber(), endPoint);
                    }
                }
            }
        }
        if ("search".equals(name)) {
            this.handleSearch();
        }
        if ("clear".equals(name)) {
            this.initMapCenter();
            this.initMapBoard();
            this.clearExistData();
            this.initStatisticsInfo();
            this.initAISShip();
        }
    }

    private void initMapCenter() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.SET_VIEW);
        SetViewData data = new SetViewData();
        data.setZoom(Integer.valueOf(3));
        data.setLatitude(Double.valueOf(8.564447003325578));
        data.setLongitude(Double.valueOf(84.24720286769));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void initMapBoard() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.FIT_BOUNDS);
        FitBoundsData data = new FitBoundsData();
        data.setLeft(Double.valueOf(-85.0));
        data.setBottom(Double.valueOf(-1000000.0));
        data.setRight(Double.valueOf(85.0));
        data.setTop(Double.valueOf(1000000.0));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void drawADottedLine(String boxNumber, List<TrajectoryPoint> endPoint) {
        GsApiUtils api = new GsApiUtils();
        String descPort = api.queryDescPortInfoByBoxNumber(boxNumber);
        ArrayList dashPoint = Lists.newArrayList();
        if (!endPoint.isEmpty()) {
            TrajectoryPoint latestPoint = endPoint.get(endPoint.size() - 1);
            TrajectoryPoint start = new TrajectoryPoint();
            start.setLatitude(latestPoint.getLatitude());
            start.setLongitude(latestPoint.getLongitude());
            dashPoint.add(start);
        }
        if (api.validateResponse(descPort).booleanValue()) {
            JSONObject port = api.parseResponseObject(descPort);
            Double longitude = port.getDouble("longitude");
            Double latitude = port.getDouble("latitude");
            TrajectoryPoint end = new TrajectoryPoint();
            end.setLongitude(String.valueOf(longitude));
            end.setLatitude(String.valueOf(latitude));
            dashPoint.add(end);
            dashPoint.add(end);
            HashMap endKVB = Maps.newHashMap();
            endKVB.put("\u76ee\u7684\u6e2f", port.getString("name"));
            endKVB.put("\u56fd\u5bb6", port.getString("countryName"));
            end.setPopupData((Map)endKVB);
            end.setPointType("end");
            end.setPopupTitle("\u76ee\u7684\u6e2f");
            end.setMarkerStyle(new MarkerStyle("red", Integer.valueOf(15)));
        }
        if (dashPoint.size() >= 2) {
            this.initDashedTrajectory(dashPoint);
        }
    }

    private void initAISShip() {
        GsApiUtils api = new GsApiUtils();
        String response = api.queryAllOnWayShipInfo();
        if (api.validateResponse(response).booleanValue()) {
            JSONArray array = api.parseResponseArray(response);
            for (Object o : array) {
                JSONObject item = (JSONObject)o;
                this.createShip(item, MapIconEnums.SHIP_LOCATE);
            }
        }
    }

    public List<TrajectoryInfo> extractTrajectoryInfo(JSONArray data) {
        List filteredData = data.stream().filter(obj -> {
            JSONObject jsonObject = (JSONObject)obj;
            return StringUtils.hasText((String)jsonObject.getString("vesselName"));
        }).map(obj -> (JSONObject)obj).collect(Collectors.toList());
        Map<String, List<JSONObject>> groupedByVessel = filteredData.stream().collect(Collectors.groupingBy(obj -> obj.getString("vesselName").trim()));
        ArrayList<TrajectoryInfo> result = new ArrayList<TrajectoryInfo>();
        for (Map.Entry<String, List<JSONObject>> entry : groupedByVessel.entrySet()) {
            List<JSONObject> list = entry.getValue();
            if (list.size() < 2) continue;
            JSONObject minTimeObj = Collections.min(list, Comparator.comparing(obj -> obj.getLong("eventTime")));
            JSONObject maxTimeObj = Collections.max(list, Comparator.comparing(obj -> obj.getLong("eventTime")));
            TrajectoryInfo info = new TrajectoryInfo();
            info.setShipName(entry.getKey());
            info.setStartTime(DateUtil.formatDateHms((Date)new Date(minTimeObj.getLong("eventTime"))));
            info.setEndTime(DateUtil.formatDateHms((Date)new Date(maxTimeObj.getLong("eventTime"))));
            info.setVoyage(minTimeObj.getString("voyage"));
            info.setStatusCd(ShippingStatusConstants.fromShortCode(maxTimeObj.getString("statusCd")));
            info.setBoxNumber(maxTimeObj.getString("ctnrNo"));
            result.add(info);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        result.sort(Comparator.comparing(t -> LocalDateTime.parse(t.getStartTime(), formatter)));
        if (result.size() >= 2) {
            for (int i = 0; i < result.size(); ++i) {
                TrajectoryInfo info = (TrajectoryInfo)result.get(i);
                if (i == 0) {
                    info.setRelayStart(false);
                    info.setRelayEnd(true);
                    continue;
                }
                if (i == result.size() - 1) {
                    info.setRelayStart(true);
                    info.setRelayEnd(false);
                    continue;
                }
                info.setRelayStart(true);
                info.setRelayEnd(true);
            }
        } else {
            for (TrajectoryInfo r : result) {
                r.setRelayEnd(false);
                r.setRelayStart(false);
            }
        }
        return result;
    }

    public static TrajectoryInfo toTrajectoryInfo(JSONObject json) {
        TrajectoryInfo info = new TrajectoryInfo();
        info.setShipName(json.getString("vesselName"));
        info.setVoyage(json.getString("voyage"));
        info.setBoxNumber(json.getString("ctnrNo"));
        info.setStartTime(DateUtil.formatDateHms((Date)new Date(json.getLong("eventTime"))));
        info.setEndTime(DateUtil.formatDateHms((Date)new Date(json.getLong("dateUpdateTime"))));
        String status = json.getString("statusCd");
        if (status != null) {
            info.setStatusCd(ShippingStatusConstants.fromShortCode(status));
        }
        return info;
    }

    private void clearExistData() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.CLEAR_ALL);
        message.setPayload(null);
        this.sendPostMessage(message);
    }

    private List<TrajectoryPoint> initPresetTrajectory(TrajectoryInfo info) {
        String shipname = info.getShipName();
        String startTime = info.getStartTime();
        String endTime = info.getEndTime();
        String voyage = info.getVoyage();
        int idx = this.getCurrentFocusIdx();
        String pod = this.get("yem_ac_pod_" + idx);
        String etd = this.get("yem_ac_etd_" + idx);
        GsApiUtils api = new GsApiUtils();
        String traResp = api.shipTrajectory(shipname, startTime, endTime);
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.DRAW_TRAJECTORY);
        TrajectoryData payload = new TrajectoryData();
        payload.setTrajectoryId(UUID.randomUUID().toString());
        payload.setName(shipname);
        payload.setColor("blue");
        payload.setWeight(Integer.valueOf(2));
        payload.setOpacity(Double.valueOf(100.0));
        payload.setAutoAdjustCenter(Boolean.valueOf(true));
        ArrayList<TrajectoryPoint> trajectory = new ArrayList<TrajectoryPoint>();
        if (api.validateResponse(traResp).booleanValue()) {
            JSONArray data = api.parseResponseArray(traResp);
            if (data.isEmpty() || data.size() < 2) {
                return trajectory;
            }
            try {
                data = ShippingTrackingFormPlugin.sortByUtc(data);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            for (Object datum : data) {
                JSONObject p = (JSONObject)datum;
                trajectory.add(new TrajectoryPoint(p.getString("latitude"), p.getString("longitude")));
            }
            int total = data.size();
            int parts = 10;
            int step = total / parts;
            for (int k = 1; k < parts - 1; ++k) {
                int i = k * step;
                JSONObject p = (JSONObject)data.get(i);
                TrajectoryPoint point = (TrajectoryPoint)trajectory.get(i);
                MarkerStyle markerStyle = new MarkerStyle();
                markerStyle.setColor("blue");
                markerStyle.setSize(Integer.valueOf(12));
                point.setMarkerStyle(markerStyle);
                point.setPointType("waypoint_time");
                HashMap popupData = Maps.newHashMap();
                popupData.put("\u8239\u540d", shipname);
                popupData.put("\u822a\u6b21", voyage);
                popupData.put("\u9884\u62b5\u65f6\u95f4", etd);
                popupData.put("\u9884\u62b5\u76ee\u7684\u6e2f", pod);
                point.setPopupData((Map)popupData);
                point.setShowType(ShowTypeEnums.HOVER);
                point.setTimestamp(p.getString("utc"));
            }
            TrajectoryPoint startPoint = (TrajectoryPoint)trajectory.get(0);
            JSONObject startP = (JSONObject)data.get(0);
            HashMap startKVA = Maps.newHashMap();
            if (info.getRelayStart().booleanValue()) {
                startKVA.put("\u8239\u540d", info.getShipName());
                startKVA.put("\u822a\u6b21", info.getVoyage());
                startKVA.put("\u79bb\u6e2f\u65f6\u95f4(UTC)", startP.getString("utc"));
                startPoint.setPopupData((Map)startKVA);
                startPoint.setPointType("start");
                startPoint.setPopupTitle("\u79bb\u6e2f");
                startPoint.setMarkerStyle(new MarkerStyle("orange", Integer.valueOf(15)));
            } else {
                startKVA.put("\u65f6\u95f4(UTC)", startP.getString("utc"));
                startKVA.put("\u5750\u6807", startP.getDouble("latitude").toString() + ", " + startP.getDouble("longitude").toString());
                startPoint.setPopupData((Map)startKVA);
                startPoint.setPointType("start");
                startPoint.setPopupTitle("\u8d77\u70b9");
                startPoint.setMarkerStyle(new MarkerStyle("green", Integer.valueOf(20)));
            }
            TrajectoryPoint endPoint = (TrajectoryPoint)trajectory.get(trajectory.size() - 1);
            HashMap endKVB = Maps.newHashMap();
            JSONObject endP = (JSONObject)data.get(trajectory.size() - 1);
            if (info.getRelayEnd().booleanValue()) {
                endKVB.put("\u8239\u540d", info.getShipName());
                endKVB.put("\u822a\u6b21", info.getVoyage());
                endKVB.put("\u5230\u6e2f\u65f6\u95f4(UTC)", endP.getString("utc"));
                endPoint.setPopupData((Map)endKVB);
                endPoint.setPointType("start");
                endPoint.setPopupTitle("\u5230\u6e2f");
                endPoint.setMarkerStyle(new MarkerStyle("red", Integer.valueOf(15)));
            } else {
                endKVB.put("\u65f6\u95f4(UTC)", endP.getString("utc"));
                endKVB.put("\u5750\u6807", endP.getDouble("latitude").toString() + ", " + endP.getDouble("longitude").toString());
                endPoint.setPopupData((Map)endKVB);
                endPoint.setPointType("end");
                endPoint.setPopupTitle("\u7ec8\u70b9");
                endPoint.setMarkerStyle(new MarkerStyle("orange", Integer.valueOf(20)));
            }
        }
        payload.setData(trajectory);
        message.setPayload((Object)payload);
        this.sendPostMessage(message);
        return payload.getData();
    }

    private void initDashedTrajectory(List<TrajectoryPoint> dashPoint) {
        TrajectoryData payload = new TrajectoryData();
        MapMessage message = new MapMessage();
        payload.setData(dashPoint);
        payload.setTrajectoryId(UUID.randomUUID().toString());
        payload.setColor("gray");
        payload.setWeight(Integer.valueOf(5));
        payload.setOpacity(Double.valueOf(50.0));
        payload.setAutoAdjustCenter(Boolean.valueOf(false));
        payload.setDashed(Boolean.valueOf(true));
        message.setPayload((Object)payload);
        message.setType(MapMessageType.DRAW_TRAJECTORY);
        this.sendPostMessage(message);
    }

    private void initPresetShip(String shipname) {
        GsApiUtils api = new GsApiUtils();
        String resp = api.shipLocation(shipname);
        if (api.validateResponse(resp).booleanValue()) {
            JSONObject data = api.parseResponseObject(resp);
            this.createShip(data, MapIconEnums.LARGE_SHIP);
        }
    }

    private void createShip(JSONObject data, MapIconEnums icon) {
        double hdg;
        if (data == null) {
            return;
        }
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.DRAW_SHIP);
        MarkData mark = new MarkData();
        mark.setMarkId(UUID.randomUUID().toString());
        mark.setMarkName(data.getString("vslName"));
        mark.setLatitude(data.getString("latitude"));
        mark.setLongitude(data.getString("longitude"));
        ArrayList fields = Lists.newArrayList();
        HashMap group1 = Maps.newHashMap();
        group1.put("\u8239\u540d", data.getString("vslName"));
        group1.put("\u5efa\u9020\u5e74\u4efd", data.getString("builtYear"));
        group1.put("\u8239\u8236\u547c\u53f7", data.getString("callSign"));
        group1.put("\u8239\u8236IMO\u4ee3\u7801", data.getString("imo"));
        group1.put("\u8239\u8236MMSI\u4ee3\u7801", data.getString("mmsi"));
        Long shipTypeCode = data.getLong("shipType");
        String shipTypeName = SHIP_TYPE_MAP.getOrDefault(shipTypeCode, "\u672a\u77e5");
        group1.put("\u8239\u8236\u7c7b\u578b", shipTypeName);
        group1.put("\u8239\u7c4d\u4e8c\u5b57\u7801", data.getString("nationality"));
        fields.add(group1);
        HashMap group2 = Maps.newHashMap();
        group2.put("\u8239\u8236\u957f\u5ea6(\u7c73)", String.valueOf(data.getLong("length")));
        group2.put("\u8239\u8236\u5bbd\u5ea6(\u7c73)", String.valueOf(data.getLong("width")));
        group2.put("\u8239\u8236\u5403\u6c34(\u6beb\u7c73)", String.valueOf(data.getLong("draught")));
        group2.put("\u88c5\u8f7d\u91cf(TEU)", data.getString("capacity"));
        group2.put("\u8f7d\u91cd(KG)", data.getString("dwt"));
        fields.add(group2);
        HashMap group3 = Maps.newHashMap();
        group3.put("\u7eac\u5ea6(\u5ea6)", String.valueOf(data.getDouble("latitude")));
        group3.put("\u7ecf\u5ea6(\u5ea6)", String.valueOf(data.getDouble("longitude")));
        group3.put("\u822a\u901f(\u8282*10)", data.getString("sog"));
        group3.put("\u822a\u5411(\u5ea6*10)", data.getString("cog"));
        group3.put("\u822a\u824f\u5411(\u5ea6)", data.getString("hdg"));
        String naviStatus = 0L == data.getLong("naviStatus") ? "\u5728\u822a" : "\u9760\u6cca";
        group3.put("\u822a\u884c\u72b6\u6001", naviStatus);
        fields.add(group3);
        HashMap group4 = Maps.newHashMap();
        group4.put("\u4e0b\u4e00\u6e2f", data.getString("dest"));
        group4.put("\u4e0b\u4e00\u6e2f\u9884\u8ba1\u5230\u8fbe\u65f6\u95f4(UTC)", data.getString("eta"));
        group4.put("\u66f4\u65b0\u65f6\u95f4(UTC+8)", data.getString("lastTime"));
        fields.add(group4);
        mark.setPopupData((List)fields);
        ArrayList tabData = Lists.newArrayList();
        HashMap titleField = Maps.newHashMap();
        titleField.put("title", "\u4e1a\u52a1\u4fe1\u606f");
        tabData.add(titleField);
        HashMap contractInfo = Maps.newHashMap();
        contractInfo.put("\u5408\u540c\u53f7", "HT-2025-0089");
        contractInfo.put("\u9500\u552e\u7ec4\u7ec7", "\u8fdc\u6d0b\u7269\u6d41\u96c6\u56e2");
        contractInfo.put("\u9500\u552e\u90e8\u95e8", "\u6d77\u8fd0\u90e8");
        contractInfo.put("\u9500\u552e\u5458", "\u5f20\u660e");
        contractInfo.put("\u8ba2\u8d27\u5ba2\u6237", "Global Trade Inc.");
        tabData.add(contractInfo);
        HashMap tradeTerms = Maps.newHashMap();
        tradeTerms.put("\u4ef7\u683c\u6761\u6b3e", "FOB");
        tradeTerms.put("\u8d38\u6613\u56fd\u522b", "\u65b0\u52a0\u5761");
        tradeTerms.put("\u8d38\u6613\u5546\u54c1", "\u7535\u5b50\u4ea7\u54c1");
        tradeTerms.put("\u672c\u4f4d\u5e01", "\u4eba\u6c11\u5e01");
        tradeTerms.put("\u7ed3\u7b97\u5e01", "\u7f8e\u5143");
        tabData.add(tradeTerms);
        HashMap quantityAmount = Maps.newHashMap();
        quantityAmount.put("\u6570\u91cf", "500.0\u5428");
        quantityAmount.put("\u91d1\u989d", "$85000");
        tabData.add(quantityAmount);
        HashMap containerInfo = Maps.newHashMap();
        containerInfo.put("\u7bb1\u53f7", "PCIU1923152,PCIU9283792");
        containerInfo.put("\u94c5\u5c01\u53f7", "SL123456,SL654321");
        containerInfo.put("\u7bb1\u578b", "GP,HQ");
        containerInfo.put("\u5c3a\u5bf8", "40,20");
        containerInfo.put("\u4ef6\u6570", "150,200");
        containerInfo.put("\u7bb1\u5b50\u603b\u6570", "2");
        containerInfo.put("\u6bdb\u91cd", "25000,28000");
        tabData.add(containerInfo);
        mark.setTabData((List)tabData);
        mark.setIconUrl(icon.getUrl());
        mark.setIconWidth(Double.valueOf(icon.getIconWidth()));
        mark.setIconHeight(Double.valueOf(icon.getIconHeight()));
        mark.setIconScale(Double.valueOf(icon.getIconScale()));
        mark.setIconOffsetX(Double.valueOf(icon.getIconOffsetX()));
        mark.setIconOffsetY(Double.valueOf(icon.getIconOffsetY()));
        double d = hdg = YEM.isEmpty((Object)data.getString("hdg")) ? 0.0 : Double.parseDouble(data.getString("hdg"));
        if (icon == MapIconEnums.SHIP_LOCATE) {
            mark.setIconAngle(Double.valueOf(0.0));
        } else {
            mark.setIconAngle(Double.valueOf(hdg + icon.getIconAngle()));
        }
        mark.setDefaultOpenPopup(false);
        mark.setPreviewShowType(ShowTypeEnums.ALWAYS);
        ArrayList previewData = Lists.newArrayList();
        HashMap shipInfo = Maps.newHashMap();
        shipInfo.put("\u8239\u540d", data.getString("vslName"));
        Random random = new Random();
        int num = 1000000 + random.nextInt(9000000);
        String randomBlNo = "SHHP" + num;
        shipInfo.put("\u63d0\u5355\u53f7", randomBlNo);
        previewData.add(shipInfo);
        mark.setPreviewData((List)previewData);
        message.setPayload((Object)mark);
        this.sendPostMessage(message);
    }

    public static JSONArray sortByUtc(JSONArray data) throws ParseException {
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            JSONObject obj = data.getJSONObject(i);
            String utc = obj.getString("utc");
            long time = sdf.parse(utc).getTime();
            list.add(new AbstractMap.SimpleEntry<Long, JSONObject>(time, obj));
        }
        list.sort(Comparator.comparingLong(Map.Entry::getKey));
        JSONArray result = new JSONArray();
        for (Map.Entry entry : list) {
            result.add(entry.getValue());
        }
        return result;
    }

    public void customEvent(CustomEventArgs e) {
        JSONObject content;
        JSONObject args;
        super.customEvent(e);
        IFormView view = this.getView();
        String pageId = view.getPageId();
        String eventName = e.getEventName();
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        if (pageId.equals(key) && "invokeCustomEvent".equals(eventName) && (args = JSON.parseObject((String)eventArgs)).containsKey((Object)"content") && (content = args.getJSONObject("content")).containsKey((Object)"event") && "map-loaded".equals(content.getString("event"))) {
            FormShowParameter fsp = view.getFormShowParameter();
            Map data1 = fsp.getCustomParams();
            this.initMapCenter();
            this.initMapBoard();
            this.initStatisticsInfo();
            if (!data1.containsKey("params")) {
                this.initAISShip();
            }
        }
    }

    static {
        SHIP_TYPE_MAP.put(60L, "\u5ba2\u8f6e");
        SHIP_TYPE_MAP.put(70L, "\u8d27\u8f6e");
        SHIP_TYPE_MAP.put(80L, "\u6cb9\u8f6e");
        SHIP_TYPE_MAP.put(90L, "\u5176\u4ed6");
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

