/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.bill.seafreight.dynamic.enums;

import com.google.common.collect.Sets;
import java.util.Set;

public enum ShippingStatusConstants {
    BKCF("01", "BKCF", "Booked", "\u8ba2\u8231"),
    STSP("02", "STSP", "Empty Pickup", "\u63d0\u7a7a\u7bb1"),
    FDLB("03", "FDLB", "Feeder Vessel Loaded on board", "\u652f\u7ebf\u88c5\u8239"),
    FDDP("04", "FDDP", "Feeder Deprtured", "\u652f\u7ebf\u5f00\u822a"),
    FDBA("05", "FDBA", "Feeder Arrived", "\u652f\u7ebf\u62b5\u6e2f"),
    FDDC("06", "FDDC", "Discharged from Feeder", "\u652f\u7ebf\u5378\u8239"),
    CGGI("07", "CGGI", "Cargo Loaded", "\u88c5\u7bb1"),
    CLOD("08", "CLOD", "Container Sealed", "\u5c01\u7bb1"),
    ERDP("09", "ERDP", "OB INTERMODAL DEPARTED", "\u94c1\u8fd0\u53d1\u8f66"),
    ERAR("10", "ERAR", "OB INTERMODAL ARRIVED", "\u94c1\u8fd0\u5230\u8fbe"),
    FCGI("11", "FCGI", "Cargo Received from Yard", "\u91cd\u7bb1\u8fd4\u573a/\u5165\u8d27"),
    CYTC("12", "CYTC", "Gate out from Yard", "\u96c6\u6e2f"),
    GITM("13", "GITM", "Gate In to POL Terminal", "\u8d77\u8fd0\u6e2f\u8fdb\u573a"),
    PASS("14", "PASS", "Customs Release", "\u6d77\u5173\u653e\u884c"),
    CUIP("15", "CUIP", "Customs Inspection", "\u67e5\u9a8c"),
    SUOT("16", "SUOT", "Outbound Customs Shut Out", "\u9000\u5173"),
    TMPS("17", "TMPS", "Terminal Release", "\u7801\u5934\u653e\u884c"),
    TMUT("18", "TMUT", "Outbound Cancelled", "\u9000\u8f7d"),
    LOBD("19", "LOBD", "Loaded on Board at Port of Loading", "\u88c5\u8239"),
    DLPT("20", "DLPT", "Departure from Port of Loading", "\u79bb\u6e2f"),
    TSBA("21", "TSBA", "Arrived at Transhipment Port", "\u4e2d\u8f6c\u62b5\u6e2f"),
    TSDC("22", "TSDC", "Discharged from Transhipment Port", "\u4e2d\u8f6c\u5378\u8239"),
    TRDP("23", "TRDP", "TRUCK DEPARTURE", "\u5361\u8f66\u79bb\u5f00"),
    TRAR("24", "TRAR", "TRUCK ARRIVAL", "\u5361\u8f66\u62b5\u8fbe"),
    TSLB("25", "TSLB", "Loaded on Board at Transhipment Port", "\u4e2d\u8f6c\u88c5\u8239"),
    TSDP("26", "TSDP", "Departured from Transhipment Port", "\u4e2d\u8f6c\u5f00\u822a"),
    BDAR("27", "BDAR", "Arrived at Port of Discharge", "\u76ee\u7684\u6e2f\u62b5\u6e2f"),
    DSCH("28", "DSCH", "Discharged at Port of Discharge", "\u76ee\u7684\u6e2f\u5378\u8239"),
    DGOT("29", "DGOT", "Gate out from POD", "\u76ee\u7684\u6e2f\u7801\u5934\u51fa\u573a"),
    DCRL("30", "DCRL", "Destination Customs Released", "\u76ee\u7684\u6e2f\u6d77\u5173\u653e\u884c"),
    IRLB("31", "IRLB", "Loaded on Rail at Inbound Rail Origin", "\u8fdb\u53e3\u94c1\u8fd0\u88c5\u7bb1"),
    IRDP("32", "IRDP", "Inbound Rail Departured", "\u8fdb\u53e3\u94c1\u8fd0\u53d1\u8f66"),
    IRAR("33", "IRAR", "Inbound Rail Arrived", "\u8fdb\u53e3\u94c1\u8fd0\u5230\u7ad9"),
    IRDS("34", "IRDS", "Unloaded From Rail at Inbound Rail Destination", "\u8fdb\u53e3\u94c1\u8fd0\u5378\u7bb1"),
    PDAR("35", "PDAR", "Arrived on Place of Delivery", "\u62b5\u8fbe\u4ea4\u8d27\u5730"),
    PDDS("36", "PDDS", "Discharged on Place of Delivery", "\u4ea4\u8d27\u5730\u5378\u7bb1"),
    PDRC("37", "PDRC", "RECEIVED FOR IMPORT TRANSFER", "\u4ea4\u8d27\u5730\u6536\u8d27"),
    CGRL("38", "CGRL", "Carrier Cargo Release", "\u8239\u4e1c\u653e\u8d27"),
    CTUP("39", "CTUP", "Container Unpacking", "\u76ee\u7684\u6e2f\u96c6\u88c5\u7bb1\u62c6\u7bb1"),
    STCS("40", "STCS", "Gate Out from Inbound CY for Delivery to Consignee", "\u8d27\u4e3b\u63d0\u67dc/\u8d27"),
    RCVE("41", "RCVE", "Empty Container Returned", "\u8fd8\u7a7a\u7bb1"),
    END("42", "END", "Tracking Finished", "\u7ed3\u675f\u8ddf\u8e2a");

    private final String code;
    private final String shortCode;
    private final String enName;
    private final String cnName;

    private ShippingStatusConstants(String code, String shortCode, String enName, String cnName) {
        this.code = code;
        this.shortCode = shortCode;
        this.enName = enName;
        this.cnName = cnName;
    }

    public String getCode() {
        return this.code;
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public String getEnName() {
        return this.enName;
    }

    public String getCnName() {
        return this.cnName;
    }

    public static ShippingStatusConstants fromShortCode(String shortCode) {
        for (ShippingStatusConstants status : ShippingStatusConstants.values()) {
            if (!status.getShortCode().equalsIgnoreCase(shortCode)) continue;
            return status;
        }
        return null;
    }

    public static Set<String> getSeaInTransitCodes() {
        return Sets.newHashSet((Object[])new String[]{LOBD.getShortCode(), DLPT.getShortCode(), TSBA.getShortCode(), TSDC.getShortCode(), TSLB.getShortCode(), TSDP.getShortCode(), BDAR.getShortCode()});
    }

    public static Boolean isInShipping(ShippingStatusConstants status) {
        Set<String> sea = ShippingStatusConstants.getSeaInTransitCodes();
        return sea.contains(status.getShortCode());
    }
}

