/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.bill.seafreight.dynamic.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.KDBizException;
import yem.base.common.utils.SystemParamUtil;
import yem.base.common.utils.YEM;
import yem.wm.customs.api.utils.HttpUtil;

public class GsApiUtils {
    private static final String CACHE_KET = "yem.wm.gs.trsnport.bill.seafreight.dynamic.LandCarriageFormPlugin";
    private String apiBase = (String)SystemParamUtil.getAppParam((String)"yem_gs", (String)"yem_apiendpoint");
    private String token = this.initAPIToken();

    private String initAPIToken() {
        long time;
        Date expires;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_KET);
        String token = (String)cache.get("token");
        String expiresTimeLong = (String)cache.get("expiresTimeLong");
        if (YEM.isNotEmpty((Object)token) && YEM.isNotEmpty((Object)expiresTimeLong) && (expires = new Date(time = Long.parseLong(expiresTimeLong))).after(new Date(System.currentTimeMillis() + 600000L))) {
            return token;
        }
        return this.reinitializeToken();
    }

    private String reinitializeToken() {
        JSONObject dataContent;
        String response;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_KET);
        String username = (String)SystemParamUtil.getAppParam((String)"yem_gs", (String)"yem_username");
        String password = (String)SystemParamUtil.getAppParam((String)"yem_gs", (String)"yem_password");
        if (YEM.isEmpty((Object)this.apiBase) || YEM.isEmpty((Object)username) || YEM.isEmpty((Object)password)) {
            throw new KDBizException("\u7cfb\u7edf\u53c2\u6570\u672a\u914d\u7f6e\uff0c\u68c0\u67e5GS_\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u914d\u7f6e\u6b63\u786e\uff01");
        }
        JSONObject body = new JSONObject();
        body.put("username", (Object)username);
        body.put("password", (Object)password);
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/system/auth/login").header("tenant-id", "1").body(body).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (YEM.isEmpty((Object)response)) {
            throw new RuntimeException("\u8fd4\u56debody\u4e3a\u7a7a");
        }
        JSONObject responseContent = JSONObject.parseObject((String)response);
        if (responseContent.containsKey((Object)"code") && responseContent.getIntValue("code") == 0 && responseContent.containsKey((Object)"data") && YEM.isNotEmpty((Object)(dataContent = responseContent.getJSONObject("data"))) && dataContent.containsKey((Object)"accessToken") && dataContent.containsKey((Object)"expiresTime")) {
            String accessToken = dataContent.getString("accessToken");
            Long expiresTimeLong = dataContent.getLong("expiresTime");
            cache.put("token", (Object)accessToken);
            cache.put("expiresTimeLong", (Object)expiresTimeLong.toString());
            return accessToken;
        }
        throw new RuntimeException("\u8fd4\u56de\u53c2\u6570\u65e0\u6548\uff01" + responseContent);
    }

    public Boolean validateResponse(String resp) {
        boolean pass;
        JSONObject response = JSON.parseObject((String)resp);
        boolean bl = pass = response.containsKey((Object)"code") && response.getIntValue("code") == 0;
        if (!pass) {
            throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + resp);
        }
        return true;
    }

    public JSONObject parseResponseObject(String resp) {
        JSONObject data = JSON.parseObject((String)resp);
        return data.getJSONObject("data");
    }

    public JSONArray parseResponseArray(String resp) {
        JSONObject data = JSON.parseObject((String)resp);
        return data.getJSONArray("data");
    }

    public String queryBillInfoByBOLNo(String number) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/bill/landing-bill").token(this.token).query("number", number).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryStatusNodeByRefNumber(String number) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/info/bill-node").token(this.token).query("number", number).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String singleShipSearch(String shipname) {
        String response;
        JSONObject body = new JSONObject();
        body.put("keywords", (Object)shipname);
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/ais/single-ship-search").token(this.token).body(body).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String shipLocation(String shipname) {
        String response;
        JSONObject body = new JSONObject();
        body.put("vessel", (Object)shipname);
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/ais/ship-location").token(this.token).body(body).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String shipTrajectory(String shipname, String startTime, String endTime) {
        String response;
        JSONObject body = new JSONObject();
        body.put("vessel", (Object)shipname);
        body.put("startTime", (Object)startTime);
        body.put("endTime", (Object)endTime);
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/ais/ship-trajectory").token(this.token).body(body).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryBoxInfoByLadingBill(String bol) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/info/box-number").token(this.token).query("number", bol).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String batchQueryBillInfoByBOLNo(LinkedHashSet<String> bol) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/bill/batch/landing-bill").token(this.token).body(JSON.toJSONString(bol)).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String batchQueryShipLocation(Set<String> shipNames) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/ais/batch/ship-location").token(this.token).body(JSON.toJSONString(shipNames)).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String batchQueryBoxInfoByLadingBill(LinkedHashSet<String> bol) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/batch/info/box-number").token(this.token).body(JSON.toJSONString(bol)).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryBoxStatusByBoxNumber(Collection<String> anyBoxNumber) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/batch/info/box-node").token(this.token).body(JSON.toJSONString(anyBoxNumber)).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryBoxStatusByBoxNumber(String boxNum) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/info/box-node").token(this.token).query("number", boxNum).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryIsRelayTransport(LinkedHashSet<String> bol) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/bill/batch/relay-info").token(this.token).body(JSON.toJSONString(bol)).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryStatisticsInfo() {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/sum/count").token(this.token).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryShipVoyageInfo() {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/sum/info").token(this.token).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryAllOnWayShipInfo() {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/sum/ship").token(this.token).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryDescPortInfoByBoxNumber(String boxNumber) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/port/box").token(this.token).query("number", boxNumber).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryRelayInfoByLadingBill(String bol) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/shipping/relay/info").token(this.token).query("number", bol).post().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String queryBoxStatusNode(String boxNumber) {
        String response;
        try {
            response = HttpUtil.create().url(this.apiBase + "/admin-api/gs/ship-ctnr-status/page").token(this.token).query("ctnrNo", boxNumber).query("pageNo", "1").query("pageSize", "1000").execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}

