/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.bill.shipmentdash.dynamic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import yem.base.common.utils.YEM;
import yem.wm.gs.service.map.dal.FitBoundsData;
import yem.wm.gs.service.map.dal.MapMessage;
import yem.wm.gs.service.map.dal.MarkData;
import yem.wm.gs.service.map.dal.SetViewData;
import yem.wm.gs.service.map.enums.MapIconEnums;
import yem.wm.gs.service.map.enums.MapMessageType;
import yem.wm.gs.service.map.enums.ShowTypeEnums;

public class ShipmentDashboardFormPlugin
extends AbstractFormPlugin {
    private String MAP = "https://map.wmyun.com";
    private static final Map<Long, String> SHIP_TYPE_MAP = new HashMap<Long, String>();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFrame map = this.getMap();
        IFormView view = this.getView();
        String pageId = view.getPageId();
        this.MAP = this.MAP + "?pageId=" + pageId;
        if (YEM.isEmpty((Object)map)) {
            throw new KDBizException("\u672a\u627e\u5230IFrame\u63a7\u4ef6\uff01");
        }
        map.setSrc(this.MAP);
        this.initAllPieCharts();
        this.initInTransitVsArrivedBarChart();
        this.initEntryData();
    }

    public static List<Map<String, String>> getPresetDetailData() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        LinkedHashMap<String, String> row1 = new LinkedHashMap<String, String>();
        row1.put("yem_textfield", "2025-12-15");
        row1.put("yem_textfield1", "7");
        row1.put("yem_textfield2", "BL202512001");
        row1.put("yem_textfield3", "HT2025-089");
        row1.put("yem_textfield4", "COSCO SHIPPING ALPS");
        row1.put("yem_textfield5", "\u4e0a\u6d77");
        row1.put("yem_textfield6", "\u6c49\u5821");
        row1.put("yem_textfield7", "2025-12-01");
        row1.put("yem_textfield8", "5");
        list.add(row1);
        LinkedHashMap<String, String> row2 = new LinkedHashMap<String, String>();
        row2.put("yem_textfield", "2025-12-20");
        row2.put("yem_textfield1", "10");
        row2.put("yem_textfield2", "BL202512002");
        row2.put("yem_textfield3", "HT2025-092");
        row2.put("yem_textfield4", "EVER GIVEN");
        row2.put("yem_textfield5", "\u5b81\u6ce2");
        row2.put("yem_textfield6", "\u9e7f\u7279\u4e39");
        row2.put("yem_textfield7", "2025-12-05");
        row2.put("yem_textfield8", "0");
        list.add(row2);
        LinkedHashMap<String, String> row3 = new LinkedHashMap<String, String>();
        row3.put("yem_textfield", "2025-12-25");
        row3.put("yem_textfield1", "15");
        row3.put("yem_textfield2", "BL202512003");
        row3.put("yem_textfield3", "HT2025-101");
        row3.put("yem_textfield4", "MAERSK HONAM");
        row3.put("yem_textfield5", "\u9752\u5c9b");
        row3.put("yem_textfield6", "\u6d1b\u6749\u77f6");
        row3.put("yem_textfield7", "2025-12-08");
        row3.put("yem_textfield8", "2");
        list.add(row3);
        LinkedHashMap<String, String> row4 = new LinkedHashMap<String, String>();
        row4.put("yem_textfield", "2025-12-28");
        row4.put("yem_textfield1", "12");
        row4.put("yem_textfield2", "BL202512004");
        row4.put("yem_textfield3", "HT2025-108");
        row4.put("yem_textfield4", "OOCL GERMANY");
        row4.put("yem_textfield5", "\u5929\u6d25");
        row4.put("yem_textfield6", "\u65b0\u52a0\u5761");
        row4.put("yem_textfield7", "2025-12-10");
        row4.put("yem_textfield8", "0");
        list.add(row4);
        LinkedHashMap<String, String> row5 = new LinkedHashMap<String, String>();
        row5.put("yem_textfield", "2025-12-30");
        row5.put("yem_textfield1", "8");
        row5.put("yem_textfield2", "BL202512005");
        row5.put("yem_textfield3", "HT2025-115");
        row5.put("yem_textfield4", "CMA CGM TENERE");
        row5.put("yem_textfield5", "\u6df1\u5733");
        row5.put("yem_textfield6", "\u8d39\u5229\u514b\u65af\u6258");
        row5.put("yem_textfield7", "2025-12-18");
        row5.put("yem_textfield8", "0");
        list.add(row5);
        return list;
    }

    private void initEntryData() {
        IDataModel model = this.getModel();
        List<Map<String, String>> presetDetailData = ShipmentDashboardFormPlugin.getPresetDetailData();
        int i = 0;
        for (Map<String, String> presetDetailDatum : presetDetailData) {
            for (Map.Entry<String, String> entry : presetDetailDatum.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                model.setValue(key, (Object)value, i);
            }
            ++i;
        }
    }

    private void initInTransitVsArrivedBarChart() {
        HistogramChart barchart = (HistogramChart)this.getControl("yem_barchartap");
        this.setHistogramChartStyle(barchart);
        Axis x = barchart.createXAxis("\u6708\u4efd", AxisType.category);
        Axis y = barchart.createYAxis("\u6570\u91cf", AxisType.value);
        LocalDate today = LocalDate.now();
        String[] months = new String[6];
        for (int i = 5; i >= 0; --i) {
            LocalDate date = today.minusMonths(i);
            months[5 - i] = date.format(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708"));
        }
        x.setPropValue("data", (Object)months);
        Number[] inTransitData = new Number[]{128, 165, 142, 189, 201, 176};
        Number[] arrivedData = new Number[]{142, 158, 176, 172, 195, 208};
        BarSeries series1 = barchart.createBarSeries("\u5f53\u6708\u5728\u9014");
        series1.setData(inTransitData);
        series1.setBarWidth("20%");
        BarSeries series2 = barchart.createBarSeries("\u5f53\u6708\u5230\u8fbe");
        series2.setData(arrivedData);
        series2.setBarWidth("20%");
        barchart.setShowTooltip(true);
        barchart.setShowLegend(false);
        barchart.refresh();
    }

    private void setHistogramChartStyle(HistogramChart barchart) {
        barchart.clearData();
        barchart.setShowTitle(true);
        barchart.setTitlePropValue("text", (Object)"");
        barchart.setShowLegend(true);
        barchart.setLegendVertical(false);
        barchart.setLegendPropValue("bottom", (Object)10);
        barchart.setMargin(Position.left, "15px");
        barchart.setMargin(Position.top, "30px");
        barchart.setShowTooltip(true);
    }

    private void initAllPieCharts() {
        PieChart pie1 = (PieChart)this.getControl("yem_piechart1");
        PieChart pie2 = (PieChart)this.getControl("yem_piechart2");
        PieChart pie3 = (PieChart)this.getControl("yem_piechart3");
        ItemValue[] kfmData = new ItemValue[]{new ItemValue("\u94dc\u77ff\u77f3 42%", (Number)new BigDecimal("4200")), new ItemValue("\u94b4\u7cbe\u77ff 31%", (Number)new BigDecimal("3100")), new ItemValue("\u5e9f\u77f3 19%", (Number)new BigDecimal("1900")), new ItemValue("\u5176\u4ed6 8%", (Number)new BigDecimal("800"))};
        this.setupPieChart(pie1, "KFM-\u77ff\u5c71", kfmData, new String[]{"#E15759", "#F28E2B", "#76B7B2", "#B07AA1"});
        ItemValue[] tfmData = new ItemValue[]{new ItemValue("\u94dc\u7cbe\u77ff 48%", (Number)new BigDecimal("4800")), new ItemValue("\u94b4\u4ea7\u54c1 33%", (Number)new BigDecimal("3300")), new ItemValue("\u786b\u9178 12%", (Number)new BigDecimal("1200")), new ItemValue("\u5176\u4ed6 7%", (Number)new BigDecimal("700"))};
        this.setupPieChart(pie2, "TFM-\u77ff\u5c71", tfmData, new String[]{"#59A14F", "#EDC948", "#B07AA1", "#FF9DA7"});
        ItemValue[] totalData = new ItemValue[]{new ItemValue("TFM\u4ea7\u51fa 46%", (Number)new BigDecimal("9200")), new ItemValue("KFM\u4ea7\u51fa 38%", (Number)new BigDecimal("7600")), new ItemValue("\u5728\u9014/\u6e2f\u53e3 16%", (Number)new BigDecimal("3200"))};
        this.setupPieChart(pie3, "\u6c47\u603b", totalData, new String[]{"#4E79A7", "#F28E2B", "#E15759"});
    }

    private void setupPieChart(PieChart chart, String title, ItemValue[] data, String[] colors) {
        chart.setShowTooltip(true);
        chart.setShowLegend(false);
        PieSeries serie = chart.createPieSeries(title);
        serie.setRadius("80%");
        serie.setCenter("50%", "60%");
        Label label = new Label();
        label.setFontSize("16");
        serie.setLabel(label);
        serie.setData(data);
        HashMap labelMap = new HashMap(8);
        HashMap<String, Object> normalMap = new HashMap<String, Object>(8);
        normalMap.put("show", true);
        normalMap.put("position", "inside");
        normalMap.put("fontSize", 10);
        normalMap.put("fontWeight", "bold");
        normalMap.put("color", "#fff");
        HashMap richMap = new HashMap(8);
        HashMap<String, Object> bMap = new HashMap<String, Object>();
        bMap.put("fontSize", 10);
        bMap.put("color", "#fff");
        bMap.put("fontWeight", "bold");
        richMap.put("b", bMap);
        HashMap<String, Object> hrMap = new HashMap<String, Object>();
        hrMap.put("borderColor", "#fff");
        hrMap.put("width", "100%");
        hrMap.put("borderWidth", 1);
        hrMap.put("height", 0);
        richMap.put("hr", hrMap);
        HashMap<String, Object> cMap = new HashMap<String, Object>();
        cMap.put("fontSize", 8);
        cMap.put("color", "#fff");
        cMap.put("fontWeight", "bold");
        richMap.put("c", cMap);
        HashMap<String, Object> perMap = new HashMap<String, Object>();
        perMap.put("fontSize", 10);
        perMap.put("color", "#fff");
        richMap.put("per", perMap);
        normalMap.put("rich", richMap);
        labelMap.put("normal", normalMap);
        serie.setPropValue("label", labelMap);
        chart.refresh();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        IFormView view = this.getView();
    }

    private void drawShipsOnMap() {
        this.drawShipAtLocation("22.0", "88.0", "COSCO SHIPPING ALPS", MapIconEnums.SHIP_LOCATE);
        this.drawShipAtLocation("30.5", "145.0", "EVER GIVEN", MapIconEnums.SHIP_LOCATE);
        this.drawShipAtLocation("5.0", "100.0", "MAERSK HONAM", MapIconEnums.SHIP_LOCATE);
        this.drawShipAtLocation("15.0", "115.0", "OOCL GERMANY", MapIconEnums.SHIP_LOCATE);
        this.drawShipAtLocation("20.0", "40.0", "CMA CGM TENERE", MapIconEnums.SHIP_LOCATE);
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.SET_VIEW);
        SetViewData data = new SetViewData();
        data.setZoom(Integer.valueOf(3));
        data.setLatitude(Double.valueOf(15.0));
        data.setLongitude(Double.valueOf(100.0));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void drawShipAtLocation(String lat, String lon, String shipName, MapIconEnums icon) {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.DRAW_SHIP);
        MarkData mark = new MarkData();
        mark.setMarkId(UUID.randomUUID().toString());
        mark.setMarkName(shipName);
        mark.setLatitude(lat);
        mark.setLongitude(lon);
        ArrayList fields = Lists.newArrayList();
        HashMap group1 = Maps.newHashMap();
        group1.put("\u8239\u540d", shipName);
        group1.put("\u5efa\u9020\u5e74\u4efd", "2018");
        group1.put("\u8239\u8236\u547c\u53f7", "VRPQ8");
        group1.put("\u8239\u8236IMO\u4ee3\u7801", "9812345");
        group1.put("\u8239\u8236MMSI\u4ee3\u7801", "412345678");
        group1.put("\u8239\u8236\u7c7b\u578b", "\u8d27\u8f6e");
        group1.put("\u8239\u7c4d\u4e8c\u5b57\u7801", "HK");
        fields.add(group1);
        HashMap group2 = Maps.newHashMap();
        group2.put("\u8239\u8236\u957f\u5ea6(\u7c73)", "366");
        group2.put("\u8239\u8236\u5bbd\u5ea6(\u7c73)", "51");
        group2.put("\u8239\u8236\u5403\u6c34(\u6beb\u7c73)", "16000");
        group2.put("\u88c5\u8f7d\u91cf(TEU)", "20000");
        group2.put("\u8f7d\u91cd(KG)", "220000000");
        fields.add(group2);
        HashMap group3 = Maps.newHashMap();
        group3.put("\u7eac\u5ea6(\u5ea6)", lat);
        group3.put("\u7ecf\u5ea6(\u5ea6)", lon);
        group3.put("\u822a\u901f(\u8282*10)", "156");
        group3.put("\u822a\u5411(\u5ea6*10)", "850");
        group3.put("\u822a\u824f\u5411(\u5ea6)", "85");
        group3.put("\u822a\u884c\u72b6\u6001", "\u5728\u822a");
        fields.add(group3);
        HashMap group4 = Maps.newHashMap();
        group4.put("\u4e0b\u4e00\u6e2f", "\u65b0\u52a0\u5761");
        group4.put("\u4e0b\u4e00\u6e2f\u9884\u8ba1\u5230\u8fbe\u65f6\u95f4(UTC)", "2025-12-15 08:00");
        group4.put("\u66f4\u65b0\u65f6\u95f4(UTC+8)", "2025-12-08 14:30");
        fields.add(group4);
        mark.setPopupData((List)fields);
        ArrayList tabData = Lists.newArrayList();
        HashMap titleField = Maps.newHashMap();
        titleField.put("title", "\u4e1a\u52a1\u4fe1\u606f");
        tabData.add(titleField);
        HashMap contractInfo = Maps.newHashMap();
        contractInfo.put("\u5408\u540c\u53f7", "HT-2025-0089");
        contractInfo.put("\u9500\u552e\u7ec4\u7ec7", "\u8fdc\u6d0b\u7269\u6d41\u96c6\u56e2");
        contractInfo.put("\u9500\u552e\u90e8\u95e8", "\u6d77\u8fd0\u90e8");
        contractInfo.put("\u9500\u552e\u5458", "\u5f20\u660e");
        contractInfo.put("\u8ba2\u8d27\u5ba2\u6237", "Global Trade Inc.");
        tabData.add(contractInfo);
        HashMap tradeTerms = Maps.newHashMap();
        tradeTerms.put("\u4ef7\u683c\u6761\u6b3e", "FOB");
        tradeTerms.put("\u8d38\u6613\u56fd\u522b", "\u65b0\u52a0\u5761");
        tradeTerms.put("\u8d38\u6613\u5546\u54c1", "\u7535\u5b50\u4ea7\u54c1");
        tradeTerms.put("\u672c\u4f4d\u5e01", "\u4eba\u6c11\u5e01");
        tradeTerms.put("\u7ed3\u7b97\u5e01", "\u7f8e\u5143");
        tabData.add(tradeTerms);
        HashMap quantityAmount = Maps.newHashMap();
        quantityAmount.put("\u6570\u91cf", "500.0\u5428");
        quantityAmount.put("\u91d1\u989d", "$85000");
        tabData.add(quantityAmount);
        HashMap containerInfo = Maps.newHashMap();
        containerInfo.put("\u7bb1\u53f7", "MSCU1234567,MSCU7654321");
        containerInfo.put("\u94c5\u5c01\u53f7", "SL123456,SL654321");
        containerInfo.put("\u7bb1\u578b", "GP,HQ");
        containerInfo.put("\u5c3a\u5bf8", "40,40");
        containerInfo.put("\u4ef6\u6570", "150,200");
        containerInfo.put("\u7bb1\u5b50\u603b\u6570", "2");
        containerInfo.put("\u6bdb\u91cd", "25000,28000");
        tabData.add(containerInfo);
        mark.setTabData((List)tabData);
        ArrayList previewData = Lists.newArrayList();
        HashMap nameMap = Maps.newHashMap();
        nameMap.put("\u8239\u540d", shipName);
        Random random = new Random();
        int num = 1000000 + random.nextInt(9000000);
        String randomBlNo = "BL" + num;
        nameMap.put("\u63d0\u5355\u53f7", randomBlNo);
        previewData.add(nameMap);
        mark.setPreviewData((List)previewData);
        mark.setPreviewShowType(ShowTypeEnums.ALWAYS);
        mark.setIconUrl(icon.getUrl());
        mark.setIconWidth(Double.valueOf(icon.getIconWidth()));
        mark.setIconHeight(Double.valueOf(icon.getIconHeight()));
        mark.setIconScale(Double.valueOf(icon.getIconScale()));
        mark.setIconOffsetX(Double.valueOf(icon.getIconOffsetX()));
        mark.setIconOffsetY(Double.valueOf(icon.getIconOffsetY()));
        mark.setIconAngle(Double.valueOf(0.0));
        mark.setDefaultOpenPopup(false);
        message.setPayload((Object)mark);
        this.sendPostMessage(message);
    }

    private void initMapCenter() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.SET_VIEW);
        SetViewData data = new SetViewData();
        data.setZoom(Integer.valueOf(3));
        data.setLatitude(Double.valueOf(8.564447003325578));
        data.setLongitude(Double.valueOf(84.24720286769));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void initMapBoard() {
        MapMessage message = new MapMessage();
        message.setType(MapMessageType.FIT_BOUNDS);
        FitBoundsData data = new FitBoundsData();
        data.setLeft(Double.valueOf(-85.0));
        data.setBottom(Double.valueOf(-1000000.0));
        data.setRight(Double.valueOf(85.0));
        data.setTop(Double.valueOf(1000000.0));
        message.setPayload((Object)data);
        this.sendPostMessage(message);
    }

    private void sendPostMessage(MapMessage data) {
        data.setPageId(this.getView().getPageId());
        IFrameMessage message = new IFrameMessage();
        MapMessageType type = data.getType();
        message.setType(type.name());
        message.setContent((Object)data);
        message.setOrigin(this.MAP);
        IFrame map = this.getMap();
        map.postMessage(message);
    }

    private IFrame getMap() {
        return (IFrame)this.getControl("yem_iframe");
    }

    public void customEvent(CustomEventArgs e) {
        JSONObject content;
        JSONObject args;
        super.customEvent(e);
        IFormView view = this.getView();
        String pageId = view.getPageId();
        String eventName = e.getEventName();
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        if (pageId.equals(key) && "invokeCustomEvent".equals(eventName) && (args = JSON.parseObject((String)eventArgs)).containsKey((Object)"content") && (content = args.getJSONObject("content")).containsKey((Object)"event") && "map-loaded".equals(content.getString("event"))) {
            this.initMapBoard();
            this.drawShipsOnMap();
        }
    }

    static {
        SHIP_TYPE_MAP.put(60L, "\u5ba2\u8f6e");
        SHIP_TYPE_MAP.put(70L, "\u8d27\u8f6e");
        SHIP_TYPE_MAP.put(80L, "\u6cb9\u8f6e");
        SHIP_TYPE_MAP.put(90L, "\u5176\u4ed6");
    }
}

