/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.unknow.dynamic;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Random;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.DateUtil;

public class CenterHomeTFM
extends AbstractBillPlugIn
implements Plugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String className = ((Object)((Object)this)).getClass().getName();
        IFormView view = this.getView();
        this.setData(className, view, "TFM");
    }

    public void setData(String className, IFormView view, String param) {
        Date yearFirst = DateUtil.getYearFirst((Date)new Date());
        Date yearLast = DateUtil.getYearLast((Date)new Date());
        DataSet data = ORM.create().queryDataSet(className, "yem_ca_homedate", "yem_needtype,yem_qty", new QFilter[]{new QFilter("yem_diggings", "=", (Object)param), new QFilter("yem_date", ">=", (Object)yearFirst), new QFilter("yem_date", "<=", (Object)yearLast)});
        data = data.groupBy(new String[]{"yem_needtype"}).sum("yem_qty").finish();
        DynamicObjectCollection result = ORM.create().toPlainDynamicObjectCollection(data);
        String[] str = CenterHomeTFM.getRandColor(result);
        PieChart pieChart = (PieChart)this.getControl("yem_piechartap");
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        PieSeries series = pieChart.createPieSeries(param + "\u9700\u6c42\u5360\u6bd4");
        series.setRadius("0", "100");
        ArrayList<ItemValue> dataList = new ArrayList<ItemValue>();
        for (DynamicObject obj : result) {
            String needtype = obj.getString("yem_needtype");
            String msg = needtype.equals("A") ? "\u8fd0\u8425\u7c7b\u9700\u6c42" : "\u9879\u76ee\u7c7b\u9700\u6c42";
            String color = needtype.equals("A") ? "#FFC107" : "#00A0E9";
            int i = result.indexOf((Object)obj);
            ItemValue itemValues = new ItemValue(msg, (Number)obj.getBigDecimal("yem_qty"), color);
            dataList.add(itemValues);
        }
        series.setData(dataList.toArray(new ItemValue[0]));
    }

    public static String[] getRandColor(DynamicObjectCollection dataMap) {
        String[] str = new String[dataMap.size()];
        for (int i = 0; i < str.length; ++i) {
            Random random = new Random();
            String r = Integer.toHexString(random.nextInt(256)).toUpperCase();
            String g = Integer.toHexString(random.nextInt(256)).toUpperCase();
            String b = Integer.toHexString(random.nextInt(256)).toUpperCase();
            r = r.length() == 1 ? "0" + r : r;
            g = g.length() == 1 ? "0" + g : g;
            b = b.length() == 1 ? "0" + b : b;
            str[i] = "#" + r + g + b;
        }
        return str;
    }
}

