/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.unknow.dynamic;

import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;

public class CenterHomebarDynamic
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.archivesCommon();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void archivesCommon() {
        Map<String, Map<String, BigDecimal>> inia = CenterHomebarDynamic.inia();
        this.HistogramChart(inia);
    }

    public static Map<String, Map<String, BigDecimal>> inia() {
        DynamicObject[] load;
        int currentYear = Calendar.getInstance().get(1);
        LinkedHashMap<String, Map<String, BigDecimal>> resultMap = new LinkedHashMap<String, Map<String, BigDecimal>>();
        String[] monthNames = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        String selectfields = DynamicObjectUtil.getSelectfields((String)"yem_ca_homedate", (boolean)false);
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"yem_ca_homedate", (String)selectfields, null)) {
            Date yemDate = dynamicObject.getDate("yem_date");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(yemDate);
            int year = calendar.get(1);
            int month = calendar.get(2);
            if (year != currentYear) continue;
            BigDecimal yemQty = dynamicObject.getBigDecimal("yem_qty");
            String diggings = dynamicObject.getString("yem_diggings");
            String monthName = monthNames[month];
            Map diggingsMap = resultMap.computeIfAbsent(monthName, k -> new HashMap());
            diggingsMap.put(diggings, diggingsMap.getOrDefault(diggings, BigDecimal.ZERO).add(yemQty));
        }
        return resultMap;
    }

    private void HistogramChart(Map<String, Map<String, BigDecimal>> equtypeMap) {
        ArrayList<String> keysList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, BigDecimal>> entry : equtypeMap.entrySet()) {
            keysList.add(entry.getKey());
        }
        this.Correctorder(keysList);
        HistogramChart customchart = (HistogramChart)this.getControl("yem_histogramchartap");
        customchart.clearData();
        customchart.clearGraphic();
        customchart.setMerge(false);
        customchart.setMargin(Position.left, "15px");
        customchart.setMargin(Position.right, "15px");
        customchart.setMargin(Position.top, "55px");
        customchart.setMargin(Position.bottom, "55px");
        customchart.setShowLegend(true);
        customchart.setLegendVertical(false);
        ArrayList<String> materiaName = keysList;
        Map<Group, List<Number>> sortedData = this.getData02(materiaName, equtypeMap);
        sortedData.forEach((group, data) -> this.createBarSeries((Group)group, (List<Number>)data, customchart));
        Axis xAxis = this.createCategoryAxis("", true, customchart);
        xAxis.setCategorys(keysList);
        HashMap xAxisPointer = Maps.newHashMap();
        xAxisPointer.put("show", true);
        xAxisPointer.put("type", "shadow");
        Label xAxisLabel = new Label();
        xAxisLabel.setShow(true);
        xAxisLabel.setBackgroundColor("black");
        xAxisPointer.put("label", xAxisLabel);
        xAxis.setName("\u6708\u4efd");
        xAxis.setPropValue("axisPointer", (Object)xAxisPointer);
        Axis yAxis = this.createValueAxis("", false, customchart);
        HashMap axisLabel1 = Maps.newHashMap();
        axisLabel1.put("formatter", "{value} ");
        yAxis.setPropValue("axisLabel", (Object)axisLabel1);
        yAxis.setPropValue("minInterval", (Object)1);
        HashMap yAxisPointer = Maps.newHashMap();
        yAxisPointer.put("show", true);
        yAxisPointer.put("type", "line");
        Label yAxisLabel = new Label();
        yAxisLabel.setShow(true);
        yAxisLabel.setBackgroundColor("black");
        yAxisPointer.put("label", xAxisLabel);
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        yAxisPointer.put("lineStyle", lineStyle);
        yAxisPointer.put("triggerTooltip", false);
        yAxis.setPropValue("axisPointer", (Object)yAxisPointer);
        customchart.refresh();
    }

    private Axis createValueAxis(String name, boolean isX, HistogramChart customchart) {
        Axis axis = null;
        axis = isX ? customchart.createXAxis(name, AxisType.value) : customchart.createYAxis(name, AxisType.value);
        HashMap axisTick = new HashMap();
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "black");
        customchart.setShowTooltip(true);
        return axis;
    }

    private Map<Group, List<Number>> getData02(List<String> materiaName, Map<String, Map<String, BigDecimal>> equtypeMap) {
        LinkedHashMap<Group, List<Number>> summaryResult = new LinkedHashMap<Group, List<Number>>();
        ArrayList<BigDecimal> list01 = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> list02 = new ArrayList<BigDecimal>();
        List<Group> groups = this.getDefaultGroups();
        this.Correctorder(materiaName);
        for (Map.Entry<String, Map<String, BigDecimal>> outerEntry : equtypeMap.entrySet()) {
            String outerKey = outerEntry.getKey();
            Map<String, BigDecimal> innerMap = outerEntry.getValue();
            for (String innerKey : innerMap.keySet()) {
                BigDecimal value = innerMap.get(innerKey);
                if ("TFM".equals(innerKey)) {
                    list01.add(value);
                }
                if (!"KFM".equals(innerKey)) continue;
                list02.add(value);
            }
        }
        summaryResult.put(groups.get(0), list01);
        summaryResult.put(groups.get(1), list02);
        return summaryResult;
    }

    private List<Group> getDefaultGroups() {
        ArrayList<Group> defaultGroupList = new ArrayList<Group>(2);
        defaultGroupList.add(new Group("\u9879\u76ee", "length", "#22a2c3", true, ChartType.bar, 0));
        defaultGroupList.add(new Group("\u8fd0\u8425", "width", "#57c3c2", true, ChartType.bar, 0));
        return defaultGroupList;
    }

    private Axis createCategoryAxis(String name, boolean isX, HistogramChart customchart) {
        HashMap<String, Boolean> splitLine = new HashMap<String, Boolean>();
        splitLine.put("show", false);
        Axis axis = null;
        axis = isX ? customchart.createXAxis(name, AxisType.category) : customchart.createYAxis(name, AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "black");
        return axis;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void Correctorder(List<String> keysList) {
        List<String> orderedMonths = Arrays.asList("\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708");
        keysList.sort(Comparator.comparingInt(month -> orderedMonths.indexOf(month) == -1 ? Integer.MAX_VALUE : orderedMonths.indexOf(month)));
    }

    private void createBarSeries(Group group, List<Number> data, HistogramChart customchart) {
        BarSeries barSeries = customchart.createBarSeries(group.groupName);
        barSeries.setBarWidth("25px");
        barSeries.setColor(group.color);
        barSeries.setType(group.chartType);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(data.toArray(new Number[0]));
    }

    public class Group {
        private String groupName;
        private String width;
        private String color;
        private boolean isActive;
        private ChartType chartType;
        private int someValue;

        public Group(String name, String width, String color, boolean isActive, ChartType chartType, int someValue) {
            this.groupName = name;
            this.width = width;
            this.color = color;
            this.isActive = isActive;
            this.chartType = chartType;
            this.someValue = someValue;
        }

        public String getName() {
            return this.groupName;
        }

        public void setName(String name) {
            this.groupName = name;
        }
    }
}

