/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.unknow.dynamic;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.DateUtil;
import yem.base.common.utils.DynamicObjectUtil;

public class CenterNeedLineDynamic
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        Map<String, Map<String, BigDecimal>> data = this.getData(this.getView(), this.getModel());
        this.drawChart(data);
    }

    public void drawChart(Map<String, Map<String, BigDecimal>> data) {
        PointLineChart chart = (PointLineChart)this.getControl("yem_needline");
        this.drawChart(chart, data, "", "");
    }

    public void drawChart(PointLineChart pointLineChart, Map<String, Map<String, BigDecimal>> data, String x_name, String y_name) {
        pointLineChart.clearData();
        Axis categoryAxis = CenterNeedLineDynamic.createCategoryAxis(pointLineChart, x_name, true);
        HashMap<String, Object> nametextstyle = new HashMap<String, Object>();
        nametextstyle.put("color", "#000000");
        nametextstyle.put("fontSize", 15);
        categoryAxis.setPropValue("nameTextStyle", nametextstyle);
        categoryAxis.setPropValue("nameLocation", (Object)new String("end"));
        categoryAxis.setPropValue("position", (Object)"bottom");
        HashMap axislabel = new HashMap();
        HashMap<String, String> textstyle = new HashMap<String, String>();
        textstyle.put("color", "#000000");
        textstyle.put("fontSize", "16");
        axislabel.put("textStyle", textstyle);
        categoryAxis.setPropValue("axisLabel", axislabel);
        categoryAxis.setCategorys(this.contructCatetoryData(data));
        Axis ValueAxis = CenterNeedLineDynamic.createValueAxis(pointLineChart, y_name, false);
        HashMap<String, Object> yAxisnametextstyle = new HashMap<String, Object>();
        yAxisnametextstyle.put("color", "#000000");
        yAxisnametextstyle.put("fontSize", 15);
        ValueAxis.setPropValue("nameTextStyle", yAxisnametextstyle);
        List<String> titles = CenterNeedLineDynamic.getTitles(data);
        for (int i = 0; i < titles.size(); ++i) {
            String color = "\u672a\u5b8c\u6210".equals(titles.get(i)) ? "#FFC107" : "#1BC85E";
            CenterNeedLineDynamic.createLineSeries(pointLineChart, titles.get(i), CenterNeedLineDynamic.contructValueData(titles.get(i), data), color);
        }
        pointLineChart.setLegendPropValue("right", (Object)"8%");
        pointLineChart.setLegendPropValue("top", (Object)"8%");
        HashMap<String, Object> legendtextstyle = new HashMap<String, Object>();
        legendtextstyle.put("fontSize", 18);
        legendtextstyle.put("color", "#000000");
        pointLineChart.setLegendPropValue("textStyle", legendtextstyle);
        pointLineChart.refresh();
    }

    public static Axis createValueAxis(PointLineChart pointLineChart, String name, boolean isx) {
        Axis axis = null;
        axis = isx ? pointLineChart.createXAxis(name, AxisType.value) : pointLineChart.createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", true);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        pointLineChart.setShowTooltip(true);
        return axis;
    }

    public static Collection<BigDecimal> contructValueData(String title, Map<String, Map<String, BigDecimal>> data) {
        ArrayList<BigDecimal> valueDatas = new ArrayList<BigDecimal>();
        Collection<Map<String, BigDecimal>> values = data.values();
        for (Map<String, BigDecimal> map : values) {
            BigDecimal totalPrice = map.get(title);
            if (totalPrice != null) {
                valueDatas.add(totalPrice);
                continue;
            }
            valueDatas.add(BigDecimal.ZERO);
        }
        return valueDatas;
    }

    public List<String> contructCatetoryData(Map<String, Map<String, BigDecimal>> data) {
        ArrayList<String> categoryData = new ArrayList<String>(data.keySet());
        this.Correctorder(categoryData);
        return categoryData;
    }

    public void Correctorder(List<String> keysList) {
        List<String> orderedMonths = Arrays.asList("\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708");
        keysList.sort(Comparator.comparingInt(month -> orderedMonths.indexOf(month) == -1 ? Integer.MAX_VALUE : orderedMonths.indexOf(month)));
    }

    public static Axis createCategoryAxis(PointLineChart pointLineChart, String name, boolean isx) {
        Axis axis = null;
        axis = isx ? pointLineChart.createXAxis(name, AxisType.category) : pointLineChart.createYAxis(name, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(true));
        axisTick.put("grid", (Constable)Position.left);
        axis.setPropValue("axisTick", axisTick);
        return axis;
    }

    public static void createLineSeries(PointLineChart chart, String name, Collection<BigDecimal> collection, String color) {
        LineSeries expireSeries = chart.createSeries(name);
        Label label = new Label();
        label.setShow(false);
        label.setColor("#000000");
        expireSeries.setLabel(label);
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(collection.toArray(new Number[0]));
    }

    public static List<String> getTitles(Map<String, Map<String, BigDecimal>> data) {
        ArrayList<String> titles = new ArrayList<String>();
        Collection<Map<String, BigDecimal>> values = data.values();
        for (Map<String, BigDecimal> map : values) {
            Set<String> keySet = map.keySet();
            for (String string : keySet) {
                if (titles.contains(string)) continue;
                titles.add(string);
            }
        }
        return titles;
    }

    public Map<String, Map<String, BigDecimal>> getData(IFormView view, IDataModel model) {
        Date yearFirst = DateUtil.getCurrYearFirst();
        Date yearLast = DateUtil.getCurrYearLast();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("yem_date", ">=", (Object)yearFirst));
        qFilters.add(new QFilter("yem_date", "<=", (Object)yearLast));
        qFilters.add(new QFilter("yem_needtype", "=", (Object)"A"));
        String[] monthNames = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        String selectFields = DynamicObjectUtil.getSelectfields((String)"yem_ca_homedate", (boolean)false);
        DynamicObject[] ca_homedate = BusinessDataServiceHelper.load((String)"yem_ca_homedate", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"yem_date");
        HashMap<String, Map<String, BigDecimal>> datas = new HashMap<String, Map<String, BigDecimal>>();
        for (DynamicObject homedate : ca_homedate) {
            Date yem_date = homedate.getDate("yem_date");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(yem_date);
            int month = calendar.get(2);
            String monthName = monthNames[month];
            String type = homedate.getBoolean("yem_isfinish") ? "\u672a\u5b8c\u6210" : "\u5df2\u5b8c\u6210";
            BigDecimal yem_qty = homedate.getBigDecimal("yem_qty");
            Map diggingsMap = datas.computeIfAbsent(monthName, k -> new HashMap());
            diggingsMap.put(type, diggingsMap.getOrDefault(type, BigDecimal.ZERO).add(yem_qty));
        }
        return datas;
    }
}

