/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.gs.trsnport.unknow.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.DateUtil;

public class UserExecuteTop
extends AbstractBillPlugIn
implements Plugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String className = ((Object)((Object)this)).getClass().getName();
        IFormView view = this.getView();
        List<DynamicObject> data = this.queyData(className, "A");
        HashMap<String, Double> equtypeMap = new HashMap<String, Double>();
        for (DynamicObject object : data) {
            equtypeMap.put(object.getString("yem_operator"), object.getBigDecimal("yem_qty").doubleValue());
        }
        if (equtypeMap.size() > 0) {
            this.HistogramChart(equtypeMap);
        }
    }

    private List<DynamicObject> queyData(String className, String yem_needtype) {
        Date yearFirst = DateUtil.getYearFirst((Date)new Date());
        Date yearLast = DateUtil.getYearLast((Date)new Date());
        String selectFiles = "yem_operator.name yem_operator,yem_qty";
        DataSet data = ORM.create().queryDataSet(className, "yem_ca_homedate", selectFiles, new QFilter[]{new QFilter("yem_needtype", "=", (Object)yem_needtype), new QFilter("yem_isfinish", "=", (Object)true), new QFilter("yem_date", ">=", (Object)yearFirst), new QFilter("yem_date", "<=", (Object)yearLast)});
        data = data.groupBy(new String[]{"yem_operator"}).sum("yem_qty").finish().orderBy(new String[]{"yem_qty"});
        DynamicObjectCollection datas = ORM.create().toPlainDynamicObjectCollection(data.copy());
        List result = datas.subList(0, 10);
        return result;
    }

    private void HistogramChart(Map<String, Double> equtypeMap) {
        ArrayList<String> keysList = new ArrayList<String>();
        ArrayList<Number> valuesList = new ArrayList<Number>();
        for (Map.Entry<String, Double> entry : equtypeMap.entrySet()) {
            keysList.add(entry.getKey());
            valuesList.add(entry.getValue());
        }
        Collections.sort(valuesList, (a, b) -> Double.compare(a.doubleValue(), b.doubleValue()));
        BarChart barchart = (BarChart)this.getControl("yem_barchartap");
        barchart.setShowLegend(true);
        barchart.setLegendVertical(true);
        boolean isLegendVertical = true;
        barchart.setLegendVertical(isLegendVertical);
        HashMap<String, String> titlePropValue = new HashMap<String, String>();
        titlePropValue.put("text", "\u533a\u57df\u4fe1\u606f");
        barchart.addTooltip("trigger", (Object)"axis");
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        String formatter = "{b0}: {c0}";
        barchart.addTooltip("formatter", (Object)formatter);
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        barchart.addFuncPath(toolTipFuncPath);
        barchart.setShowTooltip(true);
        barchart.setLegendAlign(XAlign.center, YAlign.top);
        Axis x = barchart.createYAxis("\u4eba\u5458", AxisType.category);
        Axis y = barchart.createXAxis("\u6570\u91cf", AxisType.value);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        y.setPropValue("minInterval", (Object)1);
        x.setPropValue("data", keysList);
        x.setPropValue("axisTick", axisTick);
        BarSeries barseries = barchart.createSeries("");
        this.createBarSeries(barseries, valuesList);
        barchart.refresh();
    }

    private void createBarSeries(BarSeries barSeries, List<Number> values) {
        barSeries.setAnimationDuration(2000);
        ArrayList<ItemValue> itemValuesList = new ArrayList<ItemValue>();
        for (int i = 0; i < values.size(); ++i) {
            Number num = values.get(i);
            String color = i % 2 == 0 ? "#496283" : "#1BC85E";
            ItemValue data = new ItemValue(num, color);
            itemValuesList.add(data);
        }
        ItemValue[] itemValuesArray = itemValuesList.toArray(new ItemValue[0]);
        barSeries.setData(itemValuesArray);
    }
}

