/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.fuelcardbalance.report;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import yem.base.common.utils.DateUtil;
import yem.base.common.utils.RptUtil;
import yem.base.common.utils.YEM;

public class FuelcardbalanceReptListPlugin
extends AbstractReportListDataPlugin {
    private static final String algoKey = FuelcardbalanceReptListPlugin.class.getName();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        Map<String, Object> params = this.getQueryFilters(reportQueryParam);
        DataSet result = FuelcardbalanceReptListPlugin.getQueryResult(null);
        result = result.orderBy(new String[]{"yem_fuelcardno desc"}).select(RptUtil.getDataSetFiledAlias((DataSet)result));
        if (params.isEmpty()) {
            return result;
        }
        ArrayList<String> sql = new ArrayList<String>();
        if (params.containsKey("yem_fuelcardnum")) {
            sql.add("yem_fuelcardno = yem_fuelcardnum");
        }
        if (params.containsKey("yem_primsecocar")) {
            sql.add("yem_mainorsecondary = yem_primsecocar");
        }
        if (params.containsKey("yem_fuelcardtype")) {
            sql.add("yem_fueltype = yem_fuelcardtype");
        }
        if (params.containsKey("yem_applicationdatee")) {
            sql.add("yem_applydate >= yem_applicationdates  AND yem_applydate < yem_applicationdatee");
        }
        if (params.containsKey("yem_deadlinee")) {
            sql.add("yem_deadlinedate >= yem_deadlines AND yem_deadlinedate < yem_deadlinee");
        }
        result = result.select(RptUtil.getDataSetFiledAlias((DataSet)result)).filter(String.join((CharSequence)" and ", sql), params);
        return result;
    }

    private Map<String, Object> getQueryFilters(ReportQueryParam reportQueryParam) {
        List filterItems = reportQueryParam.getFilter().getFilterItems();
        HashMap<String, Object> params = new HashMap<String, Object>();
        block8: for (FilterItemInfo filterItem : filterItems) {
            String propName = filterItem.getPropName();
            if (YEM.isEmpty((Object)filterItem.getValue())) continue;
            switch (propName) {
                case "yem_applicationdate": {
                    params.put(propName + "s", FuelcardbalanceReptListPlugin.dateToYMDDate((Date)filterItem.getValue()));
                    params.put(propName + "e", DateUtil.addDays((Date)FuelcardbalanceReptListPlugin.dateToYMDDate((Date)filterItem.getValue()), (int)1));
                    continue block8;
                }
                case "yem_deadline": {
                    params.put(propName + "s", FuelcardbalanceReptListPlugin.dateToYMDDate((Date)filterItem.getValue()));
                    params.put(propName + "e", DateUtil.addDays((Date)FuelcardbalanceReptListPlugin.dateToYMDDate((Date)filterItem.getValue()), (int)1));
                    continue block8;
                }
            }
            params.put(propName, filterItem.getValue());
        }
        return params;
    }

    private static DataSet getQueryResult(QFilter[] filters) {
        ArrayList<String> queryFields = new ArrayList<String>();
        queryFields.add("billno yem_fuelcardno");
        queryFields.add("yem_oilcardtype yem_fueltype");
        queryFields.add("yem_lg_yksygl_yksylb.yem_vehiclenumber yem_licenseplateno");
        queryFields.add("yem_lg_yksygl_yksylb.yem_currency yem_currency");
        queryFields.add("yem_lg_yksygl_yksylb.yem_amount yem_consumptionamount");
        queryFields.add("yem_lg_yksygl_yksylb.yem_cardbalance yem_cardbalance");
        DataSet carduse = ORM.create().queryDataSet(algoKey, "yem_lg_carduse", String.join((CharSequence)",", queryFields), filters);
        queryFields.clear();
        queryFields.add("billno");
        queryFields.add("yem_mainorsecondary");
        queryFields.add("yem_remainingamt yem_currentbalance");
        queryFields.add("createtime yem_applydate");
        queryFields.add("yem_deadline yem_deadlinedate");
        DataSet fuelcardset = ORM.create().queryDataSet(algoKey, "yem_lg_fuelcardset", String.join((CharSequence)",", queryFields), null);
        DataSet result = fuelcardset.copy().leftJoin(carduse.copy()).on("billno", "yem_fuelcardno").select(RptUtil.getDataSetFiledAlias((DataSet)fuelcardset), RptUtil.getDataSetFiledAlias((DataSet)carduse)).finish();
        List list = RptUtil.getDataSetAliasList((DataSet)result.copy());
        list.remove("billno");
        result = result.orderBy(new String[]{"yem_fuelcardno"}).select(String.join((CharSequence)",", list));
        return result;
    }

    public static Date dateToYMDDate(Date date) {
        if (date == null) {
            return null;
        }
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

