/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.logistics.convert;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;

public class LogisticsConvertPlugin
extends AbstractConvertPlugIn {
    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        List sourceRows = e.getSourceRows();
        for (DynamicObject sourceRow : sourceRows) {
            long id = sourceRow.getLong("id");
            boolean completedRoute = LogisticsConvertPlugin.isCompletedRoute(sourceRow = BusinessDataServiceHelper.loadSingle((String)"yem_lg_logistics", (QFilter[])new QFilter("id", "=", (Object)id).toArray()));
            if (completedRoute) continue;
            throw new KDBizException("\u5f53\u524d\u7269\u6d41\u59d4\u6258\u5355\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\uff01");
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] targetDataEntities;
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        block0: for (ExtendedDataEntity targetDataEntity : targetDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetEntity = targetDataEntity.getDataEntity();
            long headrouteid = targetEntity.getLong("yem_headrouteid");
            long transportrouteid = targetEntity.getLong("yem_transportrouteid");
            String routetype = targetEntity.getString("yem_routetype");
            DynamicObject transportroutes = targetEntity.getDynamicObject("yem_transportroutes");
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)transportroutes.getPkValue(), (String)"yem_lg_linemanage");
            DynamicObjectCollection ysxlEntry = loadSingle.getDynamicObjectCollection("yem_lg_xlgl_ysxl");
            if (ysxlEntry.size() <= 1) {
                throw new KDBizException("\u4e0d\u662f\u591a\u5f0f\u8054\u8fd0\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\uff01");
            }
            DynamicObjectCollection lxEntry = targetEntity.getDynamicObjectCollection("yem_lg_wlwt_lx");
            boolean sign = false;
            for (DynamicObject ysxlRow : ysxlEntry) {
                long nowHeadrouteid = ysxlRow.getLong("id");
                int index = ysxlEntry.indexOf((Object)ysxlRow);
                if ("A".equals(routetype)) {
                    long corelogisticsid = targetEntity.getLong("yem_corelogisticsid");
                    DynamicObject lxRow = (DynamicObject)lxEntry.get(index);
                    boolean isreplace = lxRow.getBoolean("yem_isreplace");
                    if (isreplace) {
                        boolean completedReplaceRoute = LogisticsConvertPlugin.isCompletedReplaceRoute(corelogisticsid, lxRow.getLong("yem_routeid"));
                        if (!completedReplaceRoute) {
                            throw new KDBizException("\u5f53\u524d\u7269\u6d41\u59d4\u6258\u5355\u4e34\u65f6\u8def\u7ebf\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\uff01");
                        }
                        if (ysxlEntry.size() != index + 1) continue;
                        targetEntity.set("yem_headrouteid", null);
                        targetEntity.set("yem_passingpoint", null);
                        continue;
                    }
                }
                if (sign) {
                    targetEntity.set("yem_headrouteid", (Object)nowHeadrouteid);
                    String originlocats = ysxlRow.getString("yem_originlocats");
                    String destinations = ysxlRow.getString("yem_destinations");
                    targetEntity.set("yem_passingpoint", (Object)(originlocats + " - " + destinations));
                    continue block0;
                }
                if (headrouteid != nowHeadrouteid) continue;
                sign = true;
                if (ysxlEntry.size() != index + 1) continue;
                targetEntity.set("yem_headrouteid", null);
                targetEntity.set("yem_passingpoint", null);
            }
        }
    }

    public static Set<Long> getCompletedRouteId(Long corelogisticsid) {
        QFilter filter = new QFilter("id", "=", (Object)corelogisticsid);
        filter = filter.or(new QFilter("yem_corelogisticsid", "=", (Object)corelogisticsid));
        filter.and(new QFilter("yem_routetype", "=", (Object)"A"));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        String selectfields = DynamicObjectUtil.getSelectfields((String)"yem_lg_logistics");
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"yem_lg_logistics", (String)"yem_lg_materialinfo", (String)"yem_lg_wlwt_cl");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"yem_lg_logistics", (String)selectfields, (QFilter[])filter.toArray());
        HashSet<Long> completedRouteId = new HashSet<Long>();
        for (DynamicObject logistics : load) {
            boolean completedRoute = LogisticsConvertPlugin.isCompletedRoute(logistics);
            if (!completedRoute) continue;
            completedRouteId.add(logistics.getLong("id"));
        }
        return completedRouteId;
    }

    public static boolean isCompletedRoute(DynamicObject logistics) {
        DynamicObjectCollection materialinfoEntry = logistics.getDynamicObjectCollection("yem_lg_materialinfo");
        for (DynamicObject materialinfoRow : materialinfoEntry) {
            DynamicObjectCollection clEntry = materialinfoRow.getDynamicObjectCollection("yem_lg_wlwt_cl");
            BigDecimal arrcarTotalQty = BigDecimal.ZERO;
            boolean isHaveActualdate = false;
            for (DynamicObject clRow : clEntry) {
                arrcarTotalQty = arrcarTotalQty.add(clRow.getBigDecimal("yem_arrcarqty"));
                Date date = clRow.getDate("yem_actualdate");
                if (date == null) continue;
                isHaveActualdate = true;
                break;
            }
            if (arrcarTotalQty.compareTo(BigDecimal.ZERO) != 0 || isHaveActualdate) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompletedReplaceRoute(Long corelogisticsid, Long replaceroutesid) {
        QFilter filter = new QFilter("yem_corelogisticsid", "=", (Object)corelogisticsid);
        filter.and(new QFilter("yem_replaceroutesid", "=", (Object)replaceroutesid));
        filter.and(new QFilter("yem_routetype", "=", (Object)"B"));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        String selectfields = DynamicObjectUtil.getSelectfields((String)"yem_lg_logistics");
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"yem_lg_logistics", (String)"yem_lg_materialinfo", (String)"yem_lg_wlwt_cl");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"yem_lg_logistics", (String)selectfields, (QFilter[])filter.toArray());
        if (load.length == 0) {
            return false;
        }
        boolean sign = false;
        for (DynamicObject logistics : load) {
            boolean completedRoute;
            DynamicObject transportroutes = logistics.getDynamicObject("yem_transportroutes");
            transportroutes = BusinessDataServiceHelper.loadSingle((Object)transportroutes.getPkValue(), (String)"yem_lg_linemanage");
            DynamicObjectCollection lxEnrty = transportroutes.getDynamicObjectCollection("yem_lg_xlgl_ysxl");
            DynamicObject lxlastRow = (DynamicObject)lxEnrty.get(lxEnrty.size() - 1);
            long headrouteid = logistics.getLong("yem_headrouteid");
            long id = lxlastRow.getLong("id");
            if (id == headrouteid) {
                sign = true;
            }
            if (completedRoute = LogisticsConvertPlugin.isCompletedRoute(logistics)) continue;
            return false;
        }
        return sign;
    }
}

