/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.logistics.from;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.lg.common.utils.VehicleUtils;
import yem.wm.lg.trade.shipmentwb.from.ShipmentwbBillPlugin;

public class LogisticsBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        this.setEnableFields(view, model);
    }

    public void registerListener(EventObject e) {
        BasedataEdit yem_vehicle;
        super.registerListener(e);
        BasedataEdit yem_transportroutes = (BasedataEdit)this.getView().getControl("yem_transportroutes");
        if (yem_transportroutes != null) {
            yem_transportroutes.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((yem_vehicle = (BasedataEdit)this.getView().getControl("yem_vehicle")) != null) {
            yem_vehicle.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"yem_replaceroutes"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        switch (key = e.getProperty().getName()) {
            case "yem_transportroutes": {
                this.transportroutesFilter(e, model);
                break;
            }
            case "yem_vehicle": {
                ShipmentwbBillPlugin.carnoFilter(e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "carriageregister": {
                this.dialogbox("yem_lg_carriageregister", "yem_carriageregister", "\u8fd0\u8f93\u767b\u8bb0");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        if ("yem_replaceroutes".equals(key)) {
            DynamicObject corelogistics;
            Long corelogisticsid = (Long)model.getValue("yem_corelogisticsid");
            if (YEM.isEmpty((Object)corelogisticsid)) {
                corelogistics = model.getDataEntity(true);
            } else {
                QFilter filter = new QFilter("id", "=", (Object)corelogisticsid);
                corelogistics = BusinessDataServiceHelper.loadSingle((String)"yem_lg_logistics", (QFilter[])filter.toArray());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("corelogistics", corelogistics.getPkValue());
            VehicleUtils.dialogBox((String)"yem_lg_replaceroute", (String)"yem_replaceroutes", params, (FormShowParameter)new FormShowParameter(), (AbstractFormPlugin)this);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        switch (e.getEntryProp().getName()) {
            case "yem_lg_logistics_cl": {
                this.getModel().setValue("yem_vehiclesd", (Object)this.getModel().getEntryRowCount("yem_lg_logistics_cl"));
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        switch (e.getEntryProp().getName()) {
            case "yem_lg_logistics_cl": {
                this.getModel().setValue("yem_vehiclesd", (Object)this.getModel().getEntryRowCount("yem_lg_logistics_cl"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        switch (name) {
            case "yem_transportroutes": {
                this.transportroutesChanged(newValue, model);
                break;
            }
            case "yem_headrouteid": {
                this.headrouteidChanged(newValue, view, model);
                break;
            }
            case "yem_account": {
                this.accountChanged(newValue, model);
                break;
            }
        }
    }

    private void accountChanged(Object newValue, IDataModel model) {
        DynamicObject account = (DynamicObject)newValue;
        if (YEM.isEmpty((Object)account)) {
            model.setValue("yem_contact", null);
            model.setValue("yem_contactphone", null);
            return;
        }
        String accounttype = (String)model.getValue("yem_accounttype");
        account = BusinessDataServiceHelper.loadSingle((Object)account.getPkValue(), (String)accounttype);
        if ("bd_customer".equals(accounttype) || "bd_supplier".equals(accounttype)) {
            model.setValue("yem_contact", account.get("linkman"));
            model.setValue("yem_contactphone", account.get("bizpartner_phone"));
        }
    }

    private void transportroutesFilter(BeforeF7SelectEvent e, IDataModel model) {
        Long corelogisticsid = (Long)model.getValue("yem_corelogisticsid");
        if (corelogisticsid == 0L) {
            QFilter qFilter = new QFilter("yem_routetype", "=", (Object)"A");
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
        QFilter qFilter = new QFilter("yem_routetype", "=", (Object)"B");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void setEnableFields(IFormView view, IDataModel model) {
        Long headrouteid = (Long)model.getValue("yem_headrouteid");
        DynamicObject transportroutes = (DynamicObject)model.getValue("yem_transportroutes");
        if (YEM.isEmpty((Object)transportroutes)) {
            return;
        }
        transportroutes = BusinessDataServiceHelper.loadSingle((Object)transportroutes.getPkValue(), (String)transportroutes.getDynamicObjectType().getName());
        DynamicObjectCollection ysxlEntry = transportroutes.getDynamicObjectCollection("yem_lg_xlgl_ysxl");
        block10: for (DynamicObject ysxlRow : ysxlEntry) {
            String packagmethod;
            if (ysxlRow.getLong("id") != headrouteid.longValue()) continue;
            switch (packagmethod = ysxlRow.getString("yem_packagmethod")) {
                case "C": {
                    this.setVisibleAFields(view, false);
                    continue block10;
                }
                case "B": {
                    this.setVisibleBFields(view, false);
                    continue block10;
                }
                case "A": {
                    this.setVisibleCFields(view, false);
                    continue block10;
                }
            }
            this.setVisibleBFields(view, true);
            this.setVisibleAFields(view, true);
            this.setVisibleCFields(view, true);
        }
    }

    private void headrouteidChanged(Object newValue, IFormView view, IDataModel model) {
        Long headrouteid = (Long)newValue;
        DynamicObject transportroutes = (DynamicObject)model.getValue("yem_transportroutes");
        if (transportroutes == null) {
            return;
        }
        transportroutes = BusinessDataServiceHelper.loadSingle((Object)transportroutes.getPkValue(), (String)transportroutes.getDynamicObjectType().getName());
        DynamicObjectCollection ysxlEntry = transportroutes.getDynamicObjectCollection("yem_lg_xlgl_ysxl");
        block10: for (DynamicObject ysxlRow : ysxlEntry) {
            String packagmethod;
            if (ysxlRow.getLong("id") != headrouteid.longValue()) continue;
            switch (packagmethod = ysxlRow.getString("yem_packagmethod")) {
                case "C": {
                    this.setVisibleBFields(view, true);
                    this.setVisibleCFields(view, true);
                    this.setVisibleAFields(view, false);
                    continue block10;
                }
                case "B": {
                    this.setVisibleAFields(view, true);
                    this.setVisibleCFields(view, true);
                    this.setVisibleBFields(view, false);
                    continue block10;
                }
                case "A": {
                    this.setVisibleBFields(view, true);
                    this.setVisibleAFields(view, true);
                    this.setVisibleCFields(view, false);
                    continue block10;
                }
            }
            this.setVisibleBFields(view, true);
            this.setVisibleAFields(view, true);
            this.setVisibleCFields(view, true);
        }
    }

    private void setVisibleAFields(IFormView view, boolean visible) {
        view.setVisible(Boolean.valueOf(visible), new String[]{"yem_model", "yem_vehicle", "yem_billladingnumber", "yem_casenumber", "yem_driver", "yem_stackposition"});
    }

    private void setVisibleBFields(IFormView view, boolean visible) {
        view.setVisible(Boolean.valueOf(visible), new String[]{"yem_carriagenumber", "yem_casenumber"});
    }

    private void setVisibleCFields(IFormView view, boolean visible) {
        view.setVisible(Boolean.valueOf(visible), new String[]{"yem_carriagenumber"});
    }

    private void transportroutesChanged(Object newValue, IDataModel model) {
        this.getModel().deleteEntryData("yem_carriage");
        DynamicObject transportroutes = (DynamicObject)newValue;
        if (YEM.isEmpty((Object)transportroutes)) {
            model.deleteEntryData("yem_lg_wlwt_lx");
            model.setValue("yem_transportrouteid", (Object)BigDecimal.ZERO);
            model.setValue("yem_routetype", null);
            model.setValue("yem_headrouteid", (Object)BigDecimal.ZERO);
            return;
        }
        transportroutes = BusinessDataServiceHelper.loadSingle((Object)transportroutes.getPkValue(), (String)transportroutes.getDynamicObjectType().getName());
        Long corelogisticsid = (Long)model.getValue("yem_corelogisticsid");
        Long srclogisticsid = (Long)model.getValue("yem_sourcebillid");
        long srcTransportroutesId = 0L;
        long srcHeadrouteId = 0L;
        long transportroutesId = transportroutes.getLong("id");
        if (corelogisticsid == 0L) {
            model.setValue("yem_transportrouteid", (Object)transportroutesId);
        } else {
            QFilter filter = new QFilter("id", "=", (Object)srclogisticsid);
            DynamicObject srcLogistics = BusinessDataServiceHelper.loadSingle((String)"yem_lg_logistics", (String)"yem_transportroutes, yem_headrouteid", (QFilter[])filter.toArray());
            DynamicObject srcTransportroutes = srcLogistics.getDynamicObject("yem_transportroutes");
            srcTransportroutesId = srcTransportroutes.getLong("id");
            srcHeadrouteId = srcLogistics.getLong("yem_headrouteid");
        }
        DynamicObjectCollection ysxlEntry = transportroutes.getDynamicObjectCollection("yem_lg_xlgl_ysxl");
        if (corelogisticsid != 0L && transportroutesId == srcTransportroutesId) {
            boolean sign = false;
            for (DynamicObject ysxlRow : ysxlEntry) {
                if (sign) {
                    model.setValue("yem_headrouteid", (Object)ysxlRow.getLong("id"));
                    String originlocats = ysxlRow.getString("yem_originlocats");
                    String destinations = ysxlRow.getString("yem_destinations");
                    model.setValue("yem_passingpoint", (Object)(originlocats + " - " + destinations));
                    break;
                }
                if (srcHeadrouteId != ysxlRow.getLong("id")) continue;
                sign = true;
                if (ysxlEntry.size() != ysxlEntry.indexOf((Object)ysxlRow) + 1) continue;
                this.getView().showTipNotification("\u8be5\u8def\u7ebf\u884c\u7a0b\u5df2\u7ed3\u675f\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
                model.setValue("yem_transportroutes", null);
            }
        } else {
            DynamicObject oneYsxlRow = (DynamicObject)ysxlEntry.get(0);
            String originlocats = oneYsxlRow.getString("yem_originlocats");
            String destinations = oneYsxlRow.getString("yem_destinations");
            model.setValue("yem_passingpoint", (Object)(originlocats + " - " + destinations));
            model.setValue("yem_headrouteid", (Object)oneYsxlRow.getLong("id"));
        }
        model.setValue("yem_routetype", (Object)transportroutes.getString("yem_routetype"));
        this.getModel().deleteEntryData("yem_lg_wlwt_lx");
        for (DynamicObject ysxlRow : ysxlEntry) {
            int row = this.getView().getModel().createNewEntryRow("yem_lg_wlwt_lx");
            EntryGrid entry = (EntryGrid)this.getControl("yem_lg_wlwt_lx");
            entry.setPageIndex(1);
            List s = entry.getFieldEdits();
            for (FieldEdit fieldEdit : s) {
                String logo = fieldEdit.getKey();
                if (!("yem_pricingscope".equals(logo) || "yem_remarklx".equals(logo) || "yem_routeid".equals(logo) || "yem_isreplace".equals(logo) || "yem_isfinish".equals(logo))) {
                    this.getModel().setValue(logo, ysxlRow.get(logo), row);
                }
                if (!"yem_routeid".equals(logo)) continue;
                this.getModel().setValue(logo, (Object)ysxlRow.getLong("id"), row);
            }
        }
        this.getView().updateView();
    }

    private void dialogbox(String dynamicform, final String button, String dynamicname) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(dynamicname);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams((Map)new HashMap<String, Object>(){
            {
                this.put("button", button);
                this.put("data", 0L);
            }
        });
        showParameter.setFormId(dynamicform);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, button));
        DynamicObject yem_lg_linemanage = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("yem_transportrouteid"), (String)"yem_lg_linemanage");
        DynamicObjectCollection yem_lg_xlgl_ysxl = yem_lg_linemanage.getDynamicObjectCollection("yem_lg_xlgl_ysxl");
        String yem_headrouteid = this.getModel().getValue("yem_headrouteid").toString();
        ArrayList<String> contents = new ArrayList<String>();
        for (DynamicObject yem_linemanage : yem_lg_xlgl_ysxl) {
            if (!yem_linemanage.get("id").toString().equals(yem_headrouteid)) continue;
            DynamicObjectCollection yem_trackpoints = yem_linemanage.getDynamicObjectCollection("yem_trackpoint");
            for (DynamicObject yemTrackpoint : yem_trackpoints) {
                DynamicObject dynamicObject = yemTrackpoint.getDynamicObject(1);
                contents.add(dynamicObject.getString("name"));
            }
            showParameter.setCustomParam("contents", contents);
        }
        ArrayList existPoints = new ArrayList();
        DynamicObjectCollection yemCarriage = (DynamicObjectCollection)this.getModel().getValue("yem_carriage");
        yemCarriage.forEach(item -> existPoints.add(item.getString(2)));
        showParameter.setCustomParam("existPoints", existPoints);
        this.getView().showForm(showParameter);
    }
}

