/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.logistics.from;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.lg.trade.logistics.convert.LogisticsConvertPlugin;

public class ReplacerouteBackFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.formInitialization(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel model = view.getModel();
        IDataModel parentModel = parentView.getModel();
        if (!"yem_lg_logistics".equals(parentView.getEntityId())) {
            return;
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object corelogisticsPK = formShowParameter.getCustomParam("corelogistics");
        DynamicObject corelogistics = BusinessDataServiceHelper.loadSingle((Object)corelogisticsPK, (String)"yem_lg_logistics");
        switch (operateKey) {
            case "btnok": {
                this.backFillData(model, parentModel, corelogistics);
                parentView.updateView("yem_replaceroutes");
                view.close();
            }
        }
    }

    private void backFillData(IDataModel model, IDataModel parentModel, DynamicObject corelogistics) {
        DynamicObjectCollection yslxEntry = model.getEntryEntity("yem_lg_thlx_yslx");
        DynamicObjectCollection lxEntry = corelogistics.getDynamicObjectCollection("yem_lg_wlwt_lx");
        String startPlace = "";
        String endPlace = "";
        Long routeid = 0L;
        for (DynamicObject yslxRow : yslxEntry) {
            boolean isreplace = yslxRow.getBoolean("yem_isreplace");
            DynamicObject lxRow = (DynamicObject)lxEntry.get(yslxEntry.indexOf((Object)yslxRow));
            lxRow.set("yem_isreplace", (Object)isreplace);
            if (!isreplace) continue;
            if (YEM.isEmpty((Object)startPlace)) {
                startPlace = yslxRow.getString("yem_originlocats");
            }
            endPlace = yslxRow.getString("yem_destinations");
            routeid = yslxRow.getLong("yem_routeid");
        }
        if (!YEM.isEmpty((Object)startPlace) && !YEM.isEmpty((Object)endPlace)) {
            parentModel.setValue("yem_replaceroutesid", (Object)routeid);
            parentModel.setValue("yem_replaceroutes", (Object)(startPlace + "-" + endPlace));
        }
        SaveServiceHelper.saveOperate((String)"yem_lg_logistics", (DynamicObject[])new DynamicObject[]{corelogistics}, (OperateOption)OperateOption.create());
    }

    private void formInitialization(EventObject e) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel model = view.getModel();
        IDataModel parentModel = parentView.getModel();
        if (!"yem_lg_logistics".equals(parentView.getEntityId())) {
            return;
        }
        Long corelogisticsid = (Long)parentModel.getValue("yem_corelogisticsid");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object corelogisticsPK = formShowParameter.getCustomParam("corelogistics");
        DynamicObject corelogistics = BusinessDataServiceHelper.loadSingle((Object)corelogisticsPK, (String)"yem_lg_logistics");
        EntryGrid yslxControl = (EntryGrid)view.getControl("yem_lg_thlx_yslx");
        List fieldEdits = yslxControl.getFieldEdits();
        String[] fields = (String[])fieldEdits.stream().map(Control::getKey).toArray(String[]::new);
        DynamicObjectCollection yslxEntry = model.getEntryEntity("yem_lg_thlx_yslx");
        yslxEntry.clear();
        DynamicObjectCollection lxEntry = corelogistics.getDynamicObjectCollection("yem_lg_wlwt_lx");
        for (DynamicObject lxRow : lxEntry) {
            int rowIndex = model.createNewEntryRow("yem_lg_thlx_yslx");
            for (String field : fields) {
                model.setValue(field, lxRow.get(field), rowIndex);
            }
        }
        Set<Long> completedIds = LogisticsConvertPlugin.getCompletedRouteId(corelogisticsid);
        HashSet<Long> completedRouteIds = new HashSet<Long>();
        for (Long completedId : completedIds) {
            DynamicObject completed = BusinessDataServiceHelper.loadSingle((Object)completedId, (String)"yem_lg_logistics", (String)"yem_headrouteid");
            long routeid = completed.getLong("yem_headrouteid");
            completedRouteIds.add(routeid);
        }
        boolean sign = false;
        for (int i = yslxEntry.size() - 1; i >= 0; --i) {
            DynamicObject yslxRow = (DynamicObject)yslxEntry.get(i);
            long routeid = yslxRow.getLong("yem_routeid");
            if (sign) {
                view.setEnable(Boolean.valueOf(false), yslxEntry.indexOf((Object)yslxRow), fields);
                continue;
            }
            if (!completedRouteIds.contains(routeid)) continue;
            sign = true;
            view.setEnable(Boolean.valueOf(false), yslxEntry.indexOf((Object)yslxRow), fields);
        }
    }
}

