/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.registration.op;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;

public class RegistrationOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)this.billEntityType.getName(), (boolean)true));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObject yemOilcardno = dataEntity.getDynamicObject("yem_oilcardno");
            long oilcardnoId = yemOilcardno != null ? yemOilcardno.getLong("id") : 0L;
            QFilter filter = new QFilter("yem_fuelcardid", "=", (Object)oilcardnoId);
            String usetype = dataEntity.getString("yem_usetype");
            if ("A".equals(usetype)) {
                DynamicObject vehicleId = dataEntity.getDynamicObject("yem_vehicleprofile");
                filter.and(new QFilter("yem_vehicleprofile", "=", vehicleId.get("id")));
            }
            DynamicObject carduse = BusinessDataServiceHelper.loadSingle((String)"yem_lg_carduse", (QFilter[])new QFilter[]{filter});
            DynamicObject fuelcards = BusinessDataServiceHelper.loadSingle((String)"yem_lg_fuelcardset", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)oilcardnoId)});
            BigDecimal remainingamt = fuelcards.getBigDecimal("yem_remainingamt");
            switch (operationKey) {
                case "audit": {
                    if (carduse != null) {
                        DynamicObjectCollection carduseList = carduse.getDynamicObjectCollection("yem_lg_yksygl_yksylb");
                        DynamicObject carduserow = carduseList.addNew();
                        this.setCardUseRowAttributes(carduserow, dataEntity, remainingamt);
                    }
                    BigDecimal amt = remainingamt.subtract(dataEntity.getBigDecimal("yem_amount"));
                    fuelcards.set("yem_remainingamt", (Object)amt);
                    BigDecimal mixamt = fuelcards.getBigDecimal("yem_mixamt");
                    if (mixamt.compareTo(amt) <= 0) break;
                    this.sendsendMessage(oilcardnoId);
                    break;
                }
                case "unaudit": {
                    long id = dataEntity.getLong("id");
                    BigDecimal amount = remainingamt.add(dataEntity.getBigDecimal("yem_amount"));
                    this.delrow(id, carduse);
                    fuelcards.set("yem_remainingamt", (Object)amount);
                    break;
                }
            }
            this.saveBill(fuelcards, carduse);
        }
    }

    private void saveBill(DynamicObject fuelcards, DynamicObject carduse) {
        OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_fuelcardset", (DynamicObject[])new DynamicObject[]{fuelcards}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_carduse", (DynamicObject[])new DynamicObject[]{carduse}, (OperateOption)OperateOption.create());
    }

    private void delrow(long id, DynamicObject carduse) {
        DynamicObjectCollection yemcarduse = carduse.getDynamicObjectCollection("yem_lg_yksygl_yksylb");
        ArrayList<DynamicObject> dellist = new ArrayList<DynamicObject>();
        if (!YEM.isEmpty((Object)yemcarduse)) {
            for (DynamicObject carduserow : yemcarduse) {
                long yemVfuelcmid = carduserow.getLong("yem_vfuelcmid");
                if (yemVfuelcmid != id) continue;
                dellist.add(carduserow);
            }
        }
        for (DynamicObject carduserow : dellist) {
            yemcarduse.remove((Object)carduserow);
        }
    }

    private void setCardUseRowAttributes(DynamicObject carduserow, DynamicObject dataEntity, BigDecimal remainingamt) {
        carduserow.set("yem_vehiclenumber", (Object)dataEntity.getDynamicObject("yem_vehiclecardno"));
        carduserow.set("yem_servicee", (Object)dataEntity.getDynamicObject("yem_service"));
        carduserow.set("yem_driver", (Object)dataEntity.getDynamicObject("yem_driver"));
        carduserow.set("yem_addoildate", (Object)dataEntity.getDate("yem_bizdate"));
        carduserow.set("yem_oiltypes", (Object)dataEntity.getDynamicObject("yem_refuelingtype"));
        carduserow.set("yem_beforeaddoil", (Object)dataEntity.getBigDecimal("yem_beforeaddoilweight"));
        carduserow.set("yem_addoil", (Object)dataEntity.getBigDecimal("yem_addoilweight"));
        carduserow.set("yem_currency", (Object)dataEntity.getDynamicObject("yem_currency"));
        carduserow.set("yem_price", (Object)dataEntity.getBigDecimal("yem_price"));
        carduserow.set("yem_amount", (Object)dataEntity.getBigDecimal("yem_amount"));
        carduserow.set("yem_gasstation", (Object)dataEntity.getString("yem_gasstation"));
        carduserow.set("yem_vfuelcmnum", (Object)dataEntity.getString("billno"));
        carduserow.set("yem_vfuelcmid", (Object)dataEntity.getLong("id"));
        carduserow.set("yem_cardbalance", (Object)remainingamt);
    }

    private void sendsendMessage(Long oilcardnoId) {
        DynamicObject[] fuelcards;
        for (DynamicObject fuelcard : fuelcards = BusinessDataServiceHelper.load((String)"yem_lg_fuelcardset", (String)String.join((CharSequence)",", DynamicObjectUtil.addFieldKey((String)"yem_lg_fuelcardset", (boolean)true)), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)oilcardnoId)})) {
            String number = fuelcard.getString("billno");
            DynamicObject creator = (DynamicObject)fuelcard.get("creator");
            Long name = null != creator ? creator.getLong("id") : 0L;
            YEM.sendMessage(Arrays.asList(name), (String)"message", (String)"\u6cb9\u5361\u4f7f\u7528\u9884\u8b66", (String)("\u6cb9\u5361" + number + "\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u53ca\u65f6\u5145\u503c"), (String)"\u6cb9\u5361\u8bbe\u5b9a");
        }
    }
}

