/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.shipmentwb.from;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.lg.common.utils.VehicleUtils;
import yem.wm.lg.trade.transportation.form.TransportationBillPlugin;

public class ShipmentwbBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final List<TransportationBillPlugin.WriteBackData> writeBackDataList = new ArrayList<TransportationBillPlugin.WriteBackData>();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String s = this.getPageCache().get("import");
        if ("yem_lg_materialinfo".equals(s) && !writeBackDataList.isEmpty()) {
            for (TransportationBillPlugin.WriteBackData writeBackData : writeBackDataList) {
                this.importWriteBackInfo(model, writeBackData);
            }
            this.getView().invokeOperation("save", YEM.getOptionNoMsg());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit yem_carno = (BasedataEdit)this.getView().getControl("yem_carno");
        if (yem_carno != null) {
            yem_carno.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IFormView view = this.getView();
        String key = e.getOperateKey();
        DynamicObject entity = this.getModel().getDataEntity(true);
        switch (key) {
            case "ysrwgzt_rwxf": {
                EntryGrid materialinfo = (EntryGrid)view.getControl("yem_lg_materialinfo");
                int[] selectRowIds = materialinfo.getSelectRows();
                int rowCount = this.getModel().getEntryRowCount("yem_lg_materialinfo");
                if (rowCount > 0) {
                    this.pushGenerateTransportation(entity, selectRowIds, "yem_lg_materialinfo");
                    this.writeBackRelatedInfo(selectRowIds);
                    view.invokeOperation("save", YEM.getOptionNoMsg());
                    view.invokeOperation("refresh");
                    break;
                }
                view.showMessage("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\uff01\uff01\uff01");
            }
        }
    }

    public void beforeImportEntry(BeforeImportEntryEventArgs e) {
        super.beforeImportEntry(e);
        Map entryImportData = VehicleUtils.getEntryImportData((BeforeImportEntryEventArgs)e, (String)"yem_lg_materialinfo", (String)"yem_lg_ysrwgzt_ysrw");
        if (entryImportData == null || entryImportData.isEmpty()) {
            return;
        }
        DynamicObjectCollection materialinfo = this.getModel().getEntryEntity("yem_lg_materialinfo");
        for (DynamicObject materialRow : materialinfo) {
            long srcbillid = materialRow.getLong("yem_srcbillid");
            long srcentryid = materialRow.getLong("yem_srcentryid");
            DynamicObjectCollection ysrw = materialRow.getDynamicObjectCollection("yem_lg_ysrwgzt_ysrw");
            HashMap<Long, HashMap<String, Object>> infoMap = new HashMap<Long, HashMap<String, Object>>();
            for (DynamicObject ysrwRow : ysrw) {
                long id = ysrwRow.getLong("id");
                if (!entryImportData.containsKey(id)) continue;
                JSONObject rowData = (JSONObject)entryImportData.get(id);
                BigDecimal vehicleweight = ysrwRow.getBigDecimal("yem_vehicleweight");
                BigDecimal qty = rowData.getBigDecimal("yem_actualarrivalqty");
                Date date = rowData.getDate("yem_actualarrivaltime");
                ysrwRow.set("yem_landdamage", (Object)vehicleweight.subtract(qty));
                if (qty.compareTo(BigDecimal.ZERO) <= 0 || date == null) continue;
                HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
                ysrwRow.set("yem_status", (Object)"C");
                map.put("qty", qty);
                map.put("date", date);
                infoMap.put(id, map);
            }
            writeBackDataList.add(new TransportationBillPlugin.WriteBackData(srcbillid, srcentryid, infoMap));
        }
        this.getPageCache().put("import", "yem_lg_materialinfo");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        switch (e.getEntryProp().getName()) {
            case "yem_lg_ysrwgzt_ysrw": {
                int insertRow = e.getRowDataEntities()[0].getRowIndex();
                int parentRowIndex = e.getRowDataEntities()[0].getParentRowIndex();
                this.carryMaterialEntryInfo(model, insertRow, parentRowIndex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "yem_carno": {
                ShipmentwbBillPlugin.carnoFilter(e);
            }
        }
    }

    public static void carnoFilter(BeforeF7SelectEvent e) {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("\u8fd0\u8f93\u4e2d");
        statusList.add("\u5f85\u5378");
        statusList.add("\u68c0\u4fee");
        statusList.add("\u5ba1\u9a8c");
        statusList.add("\u4e8b\u6545");
        QFilter filter = new QFilter("yem_vehiclearchive.yem_vehiclestatus.name", "not in", statusList);
        filter.and(new QFilter("yem_vehiclearchive.yem_vehiclestatus.name", "!=", null));
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private void carryMaterialEntryInfo(IDataModel model, int insertRow, int parentRowIndex) {
        DynamicObject wlmxRow = model.getEntryRowEntity("yem_lg_materialinfo", parentRowIndex);
        DynamicObject material = wlmxRow.getDynamicObject("yem_material");
        DynamicObject measureunit = wlmxRow.getDynamicObject("yem_baseunit");
        model.setValue("yem_status", (Object)"A", insertRow);
        model.setValue("yem_cargoname", (Object)material, insertRow);
        model.setValue("yem_unit", (Object)measureunit, insertRow);
    }

    private boolean vehicleStatusVerify(IFormView view) {
        EntryGrid ysrw = (EntryGrid)view.getControl("yem_lg_ysrwgzt_ysrw");
        int[] selectRows = ysrw.getSelectRows();
        if (selectRows.length == 0) {
            view.showTipNotification("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
            return false;
        }
        IDataModel model = view.getModel();
        ArrayList<Integer> errIndexs = new ArrayList<Integer>();
        for (int selectRow : selectRows) {
            DynamicObject ysrwRow = model.getEntryRowEntity("yem_lg_ysrwgzt_ysrw", selectRow);
            String carStatus = ysrwRow.getString("yem_status");
            if ("D".equals(carStatus)) continue;
            errIndexs.add(selectRow);
        }
        if (!errIndexs.isEmpty()) {
            String errInfo = errIndexs.stream().map(index -> String.valueOf(index + 1)).collect(Collectors.joining("\uff0c"));
            view.showTipNotification(String.format("\u8fd0\u8f93\u4efb\u52a1\u5206\u5f55\u7b2c%s\u884c\uff0c\u8f66\u8f86\u72b6\u6001\u4e0d\u662f\u5728\u9014\u6216\u8005\u56de\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u8f66\u8f86\u8fd4\u56de\u64cd\u4f5c\uff01", errInfo));
            return false;
        }
        return true;
    }

    private void carToBack(IFormView view) {
        EntryGrid ysrw = (EntryGrid)view.getControl("yem_lg_ysrwgzt_ysrw");
        int[] selectRows = ysrw.getSelectRows();
        IDataModel model = view.getModel();
        long entityId = (Long)model.getValue("id");
        DynamicObjectCollection ysrwEntry = model.getEntryEntity("yem_lg_ysrwgzt_ysrw");
        DynamicObject materialRow = (DynamicObject)ysrwEntry.getParent();
        long materialRowId = materialRow.getLong("id");
        HashSet<Long> vehicleNumbers = new HashSet<Long>();
        ArrayList<DynamicObject> vehicleprofileList = new ArrayList<DynamicObject>();
        for (int selectRow : selectRows) {
            DynamicObject ysrwRow = (DynamicObject)ysrwEntry.get(selectRow);
            ysrwRow.set("yem_status", (Object)"D");
            vehicleNumbers.add(ysrwRow.getLong("id"));
            DynamicObject vehicleprofile = ysrwRow.getDynamicObject("yem_vehicleprofile");
            vehicleprofile = BusinessDataServiceHelper.loadSingle((Object)vehicleprofile.getPkValue(), (String)vehicleprofile.getDynamicObjectType().getName());
            DynamicObject carStatus = VehicleUtils.getCarStatus((String)"\u5f85\u8fd0\u8f93");
            vehicleprofile.set("yem_vehiclestatus", (Object)carStatus);
            vehicleprofileList.add(vehicleprofile);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model.getDataEntity(true)});
        view.updateView();
        SaveServiceHelper.save((DynamicObject[])vehicleprofileList.toArray(new DynamicObject[0]));
        QFilter filter = new QFilter("yem_sourcebillid", "=", (Object)entityId).and(new QFilter("yem_lg_materialinfo.yem_srcentryid", "=", (Object)materialRowId));
        DynamicObject ysdEntity = BusinessDataServiceHelper.loadSingle((String)"yem_lg_transportation", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection materialEntry = ysdEntity.getDynamicObjectCollection("yem_lg_materialinfo");
        DynamicObjectCollection ysdYsrwRow = ((DynamicObject)materialEntry.get(0)).getDynamicObjectCollection("yem_lg_ysd_ysrw");
        ysdYsrwRow.forEach(row -> {
            if (vehicleNumbers.contains(row.getLong("yem_srcentrytryid"))) {
                row.set("yem_status", (Object)"D");
            }
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ysdEntity});
    }

    private void writeBackRelatedInfo(int[] selectRowIds) {
        DynamicObjectCollection ysrwSonEntry;
        IDataModel model = this.getModel();
        DynamicObject logistics = BusinessDataServiceHelper.loadSingle((String)"yem_lg_logistics", (QFilter[])new QFilter[]{new QFilter("id", "=", model.getValue("yem_sourcebillid"))});
        DynamicObject inTransitStatus = BusinessDataServiceHelper.loadSingle((String)"yem_lg_carstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)"\u5728\u9014")});
        DynamicObjectCollection srcMaterialinfo = logistics.getDynamicObjectCollection("yem_lg_materialinfo");
        DynamicObjectCollection materialinfo = model.getEntryEntity("yem_lg_materialinfo");
        HashMap<Long, DynamicObjectCollection> ysrwSelectEntryInfo = new HashMap<Long, DynamicObjectCollection>();
        for (int selectRowId : selectRowIds) {
            DynamicObject materialRow = (DynamicObject)materialinfo.get(selectRowId);
            ysrwSonEntry = materialRow.getDynamicObjectCollection("yem_lg_ysrwgzt_ysrw");
            long srcentryid = materialRow.getLong("yem_srcentryid");
            ysrwSelectEntryInfo.put(srcentryid, ysrwSonEntry);
        }
        Object object = srcMaterialinfo.iterator();
        while (object.hasNext()) {
            DynamicObject srcMaterialRow = (DynamicObject)object.next();
            long rowId = srcMaterialRow.getLong("id");
            if (!ysrwSelectEntryInfo.containsKey(rowId)) continue;
            DynamicObjectCollection clEntry = srcMaterialRow.getDynamicObjectCollection("yem_lg_wlwt_cl");
            clEntry.clear();
            ysrwSonEntry = (DynamicObjectCollection)ysrwSelectEntryInfo.get(rowId);
            for (DynamicObject ysrwRow : ysrwSonEntry) {
                model.setValue("yem_status", (Object)"B", ysrwSonEntry.indexOf((Object)ysrwRow));
                DynamicObject vehicleprofile = ysrwRow.getDynamicObject("yem_vehicleprofile");
                DynamicObject trailerprofile = ysrwRow.getDynamicObject("yem_trailerprofile");
                this.updateVehicleArchiveData(vehicleprofile, trailerprofile, inTransitStatus);
                DynamicObject clNewRow = clEntry.addNew();
                clNewRow.set("yem_service", model.getValue("yem_suppliers"));
                clNewRow.set("yem_vehicle", ysrwRow.get("yem_carno"));
                clNewRow.set("yem_vehiclefile", ysrwRow.get("yem_vehicleprofile"));
                clNewRow.set("yem_statuscar", (Object)"B");
                clNewRow.set("yem_driver", (Object)ysrwRow.getDynamicObject("yem_driverprofile"));
                BigDecimal yemVehicleweight = ysrwRow.getBigDecimal("yem_vehicleweight");
                clNewRow.set("yem_carqty", (Object)yemVehicleweight);
                clNewRow.set("yem_estimatedate", (Object)ysrwRow.getDate("yem_estimatedate"));
                BigDecimal yemActualarrivalqty = ysrwRow.getBigDecimal("yem_actualarrivalqty");
                clNewRow.set("yem_arrcarqty", (Object)yemActualarrivalqty);
                clNewRow.set("yem_actualdate", (Object)ysrwRow.getDate("yem_actualarrivaltime"));
                clNewRow.set("yem_injure", (Object)yemVehicleweight.subtract(yemActualarrivalqty));
                clNewRow.set("yem_srcentrytryid", (Object)ysrwRow.getLong("id"));
            }
        }
        logistics.set("yem_logisticsstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logistics});
    }

    private void updateVehicleArchiveData(DynamicObject vehicleprofile, DynamicObject trailerprofile, DynamicObject inTransitStatus) {
        if (vehicleprofile != null && trailerprofile != null) {
            long vId = vehicleprofile.getLong("id");
            long tId = trailerprofile.getLong("id");
            DynamicObject vehicleArchive = BusinessDataServiceHelper.loadSingle((String)"yem_lg_vehiclefile", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)vId)});
            vehicleArchive.set("yem_vehiclestatus", (Object)inTransitStatus);
            DynamicObjectCollection glgcxxEntry = vehicleArchive.getDynamicObjectCollection("yem_lg_cldagl_glgcxx");
            DynamicObject addNewRow = glgcxxEntry.addNew();
            addNewRow.set("yem_trailerno", (Object)trailerprofile);
            DynamicObject trailerNo = BusinessDataServiceHelper.loadSingle((String)"yem_lg_carno", (QFilter[])new QFilter[]{new QFilter("yem_vehiclearchive.id", "=", (Object)tId)});
            if (trailerNo != null) {
                addNewRow.set("yem_trailercardnum", (Object)trailerNo);
            }
            addNewRow.set("yem_associateddate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{vehicleArchive});
        }
    }

    private void importWriteBackInfo(IDataModel model, TransportationBillPlugin.WriteBackData writeBackData) {
        Long srcbillid = writeBackData.getSrcbillid();
        Long srcentryid = writeBackData.getSrcentryid();
        Map<Long, HashMap<String, Object>> infoMap = writeBackData.getInfoMap();
        DynamicObject logistics = BusinessDataServiceHelper.loadSingle((String)"yem_lg_logistics", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcbillid)});
        DynamicObjectCollection srcMaterialEntry = logistics.getDynamicObjectCollection("yem_lg_materialinfo");
        for (DynamicObject srcMaterialRow : srcMaterialEntry) {
            long srcRowId = srcMaterialRow.getLong("id");
            if (srcRowId != srcentryid) continue;
            DynamicObjectCollection wlwtSonEntry = srcMaterialRow.getDynamicObjectCollection("yem_lg_wlwt_cl");
            for (DynamicObject wlwtSonRow : wlwtSonEntry) {
                long gztId = wlwtSonRow.getLong("yem_srcentrytryid");
                if (!infoMap.containsKey(gztId)) continue;
                HashMap<String, Object> map = infoMap.get(gztId);
                BigDecimal qty = (BigDecimal)map.get("qty");
                Date date = (Date)map.get("date");
                wlwtSonRow.set("yem_arrcarqty", (Object)qty);
                wlwtSonRow.set("yem_actualdate", (Object)date);
                wlwtSonRow.set("yem_injure", (Object)wlwtSonRow.getBigDecimal("yem_carqty").subtract(qty));
                if (YEM.isEmpty((Object)qty) || !Objects.nonNull(date)) continue;
                wlwtSonRow.set("yem_statuscar", (Object)"C");
            }
        }
        SaveServiceHelper.saveOperate((String)"yem_lg_logistics", (DynamicObject[])new DynamicObject[]{logistics}, (OperateOption)OperateOption.create());
        DynamicObjectCollection materialEntry = model.getEntryEntity("yem_lg_materialinfo");
        for (DynamicObject materialRow : materialEntry) {
            DynamicObject transportation;
            DynamicObjectCollection ysdMaterialEntry;
            String transportationNo;
            long verifyId = materialRow.getLong("yem_srcentryid");
            if (verifyId != srcentryid || YEM.isEmpty((Object)(transportationNo = materialRow.getString("yem_shippingnumber"))) || (ysdMaterialEntry = (transportation = BusinessDataServiceHelper.loadSingle((String)"yem_lg_transportation", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)transportationNo)})).getDynamicObjectCollection("yem_lg_materialinfo")).isEmpty()) continue;
            DynamicObjectCollection ysdYsrwEntry = ((DynamicObject)ysdMaterialEntry.get(0)).getDynamicObjectCollection("yem_lg_ysd_ysrw");
            for (DynamicObject ysdYsrwRow : ysdYsrwEntry) {
                long gztEntryId = ysdYsrwRow.getLong("yem_srcentrytryid");
                if (!infoMap.containsKey(gztEntryId)) continue;
                HashMap<String, Object> map = infoMap.get(gztEntryId);
                BigDecimal qty = (BigDecimal)map.get("qty");
                Date date = (Date)map.get("date");
                ysdYsrwRow.set("yem_actualarrivalqty", (Object)qty);
                ysdYsrwRow.set("yem_actualarrivaltime", (Object)date);
                ysdYsrwRow.set("yem_landdamage", (Object)ysdYsrwRow.getBigDecimal("yem_vehicleweight").subtract(qty));
                if (YEM.isEmpty((Object)qty) || !Objects.nonNull(date)) continue;
                ysdYsrwRow.set("yem_status", (Object)"C");
            }
            SaveServiceHelper.saveOperate((String)"yem_lg_transportation", (DynamicObject[])new DynamicObject[]{transportation}, (OperateOption)OperateOption.create());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushGenerateTransportation(DynamicObject dataEntity, int[] selectRows, String entryKey) {
        Long billId = dataEntity.getLong("id");
        DynamicObjectCollection materialEntry = dataEntity.getDynamicObjectCollection(entryKey);
        for (int selectRowId : selectRows) {
            DynamicObject materialRow = (DynamicObject)materialEntry.get(selectRowId);
            if (!YEM.isEmpty((Object)materialRow.getString("yem_shippingnumber"))) throw new KDBizException("\u5f53\u524d\u884c\u5df2\u5b58\u5728\u8fd0\u8f93\u5355");
            ListSelectedRow srcBillRows = new ListSelectedRow((Object)billId);
            srcBillRows.setEntryPrimaryKeyValue(materialRow.getPkValue());
            srcBillRows.setEntryEntityKey(entryKey);
            ArrayList<ListSelectedRow> comp_selectedRows = new ArrayList<ListSelectedRow>();
            comp_selectedRows.add(srcBillRows);
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("yem_lg_shipmentwb");
            pushArgs.setTargetEntityNumber("yem_lg_transportation");
            pushArgs.setHasRight(false);
            pushArgs.setRuleId("2273983445187196928");
            pushArgs.setBuildConvReport(true);
            pushArgs.setSelectedRows(comp_selectedRows);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (pushResult.isSuccess()) {
                MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"yem_lg_transportation");
                List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
                OperateOption saveOption = OperateOption.create();
                saveOption.setVariableValue("ignorewarn", String.valueOf(true));
                saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
                saveOption.setVariableValue("strictvalidation", String.valueOf(true));
                for (DynamicObject target : targetBillObjs) {
                    OperationResult saveResult = SaveServiceHelper.saveOperate((String)"yem_lg_transportation", (DynamicObject[])new DynamicObject[]{target}, (OperateOption)saveOption);
                    if (!saveResult.isSuccess()) {
                        throw new KDBizException("\u751f\u6210\u7684\u8fd0\u8f93\u5355\u4fdd\u5b58\u5931\u8d25\uff1a" + saveResult.getMessage());
                    }
                    materialRow.set("yem_shippingnumber", (Object)target.getString("billno"));
                    this.getView().showMessage("\u751f\u6210\u6210\u529f\uff01\uff01");
                }
            } else {
                String message = pushResult.getMessage();
                throw new KDBizException("\u4e0b\u63a8\u5931\u8d25\uff1a" + message);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        }
    }
}

