/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.shipmentwb.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import yem.base.common.utils.YEM;

public class VehicleNonRepeatValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        String operateKey = this.getOperateKey();
        if (!"submit".equals(operateKey)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.VehicleNonRepeatVerify(dataEntity);
        }
    }

    private void VehicleNonRepeatVerify(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection materialinfo = entity.getDynamicObjectCollection("yem_lg_materialinfo");
        for (DynamicObject materialRow : materialinfo) {
            int count = 0;
            HashSet<Long> vehicleNumbers = new HashSet<Long>();
            HashMap<Integer, String> repeatVehicleNumbers = new HashMap<Integer, String>();
            DynamicObjectCollection ysrwEntry = materialRow.getDynamicObjectCollection("yem_lg_ysrwgzt_ysrw");
            for (DynamicObject ysrwRow : ysrwEntry) {
                DynamicObject carno = ysrwRow.getDynamicObject("yem_carno");
                if (YEM.isEmpty((Object)carno)) continue;
                long carId = carno.getLong("id");
                vehicleNumbers.add(carId);
                if (++count == vehicleNumbers.size()) continue;
                repeatVehicleNumbers.put(ysrwEntry.indexOf((Object)ysrwRow), carno.getString("number"));
            }
            if (repeatVehicleNumbers.isEmpty()) continue;
            String errInfo = repeatVehicleNumbers.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
                int index = (Integer)entry.getKey() + 1;
                String number = (String)entry.getValue();
                return String.format("\u8fd0\u8f93\u4efb\u52a1\u7b2c%d\u884c\u8f66\u724c\u53f7%s", index, number);
            }).collect(Collectors.joining("\uff0c"));
            this.addFatalErrorMessage(dataEntity, String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%s\u884c, \u8f66\u8f86\u91cd\u590d\uff1a" + errInfo + "\u3002", materialinfo.indexOf((Object)materialRow) + 1));
        }
    }
}

