/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.transportation.form;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.lg.common.utils.VehicleUtils;

public class TransportationBillPlugin
extends AbstractBillPlugIn {
    private static final List<WriteBackData> writeBackDataList = new ArrayList<WriteBackData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String s = this.getPageCache().get("import");
        if ("yem_lg_materialinfo".equals(s) && !writeBackDataList.isEmpty()) {
            try {
                for (WriteBackData writeBackData : writeBackDataList) {
                    Long srcbillid = writeBackData.srcbillid;
                    Long srcentryid = writeBackData.srcentryid;
                    Map infoMap = writeBackData.infoMap;
                    this.gztwlwtWriteBack(srcbillid, srcentryid, infoMap);
                }
            }
            finally {
                this.getView().invokeOperation("save", YEM.getOptionNoMsg());
                this.getPageCache().remove("import");
                writeBackDataList.clear();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"yem_ysrw_ysrwtool"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            default: 
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "yem_ysrw_backfillarrival": {
                this.dialogbox("yem_lg_transportationform", "yem_ysrw_backfillarrival");
            }
        }
    }

    public void beforeImportEntry(BeforeImportEntryEventArgs e) {
        super.beforeImportEntry(e);
        Map ysrwMap = VehicleUtils.getEntryImportData((BeforeImportEntryEventArgs)e, (String)"yem_lg_materialinfo", (String)"yem_lg_ysd_ysrw");
        if (ysrwMap == null || ysrwMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection materialinfo = this.getModel().getEntryEntity("yem_lg_materialinfo");
        for (DynamicObject materialRow : materialinfo) {
            long srcbillid = materialRow.getLong("yem_srcbillid");
            long srcentryid = materialRow.getLong("yem_srcentryid");
            HashMap<Long, HashMap<String, Object>> infoMap = new HashMap<Long, HashMap<String, Object>>();
            DynamicObjectCollection ysrw = materialRow.getDynamicObjectCollection("yem_lg_ysd_ysrw");
            for (DynamicObject ysrwRow : ysrw) {
                long id = ysrwRow.getLong("id");
                if (!ysrwMap.containsKey(id)) continue;
                JSONObject rowData = (JSONObject)ysrwMap.get(id);
                if ("B".equals(ysrwRow.getString("yem_status"))) {
                    rowData.put("yem_vehicleweight", ysrwRow.get("yem_vehicleweight"));
                    rowData.put("yem_actualarrivalqty", ysrwRow.get("yem_actualarrivalqty"));
                    rowData.put("yem_actualarrivaltime", ysrwRow.get("yem_actualarrivaltime"));
                    continue;
                }
                BigDecimal vehicleweight = ysrwRow.getBigDecimal("yem_vehicleweight");
                BigDecimal qty = rowData.getBigDecimal("yem_actualarrivalqty");
                Date date = rowData.getDate("yem_actualarrivaltime");
                ysrwRow.set("yem_landdamage", (Object)vehicleweight.subtract(qty));
                if (qty.compareTo(BigDecimal.ZERO) <= 0 || date == null) continue;
                HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
                map.put("qty", qty);
                map.put("date", date);
                infoMap.put(ysrwRow.getLong("yem_srcentrytryid"), map);
                ysrwRow.set("yem_status", (Object)"C");
            }
            writeBackDataList.add(new WriteBackData(srcbillid, srcentryid, infoMap));
        }
        this.getPageCache().put("import", "yem_lg_materialinfo");
    }

    private void arrive(int[] selectRows) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (selectRows.length > 0) {
            for (int selectRow : selectRows) {
                this.getModel().setValue("yem_status", (Object)"B", selectRow);
                this.getModel().setValue("yem_arrivaltime", (Object)new Date(), selectRow);
                Long id = (Long)this.getModel().getValue("yem_srcentrytryid", selectRow);
                list.add(id);
            }
            DynamicObject gztEntity = BusinessDataServiceHelper.loadSingle((String)"yem_lg_shipmentwb", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("yem_sourcebillid"))});
            if (gztEntity != null) {
                DynamicObjectCollection spmxEntry = gztEntity.getDynamicObjectCollection("yem_lg_materialinfo");
                for (DynamicObject spmxRow : spmxEntry) {
                    DynamicObjectCollection ysrwEntry = spmxRow.getDynamicObjectCollection("yem_lg_ysrwgzt_ysrw");
                    for (DynamicObject ysrwRow : ysrwEntry) {
                        long ysrwRowId = ysrwRow.getLong("id");
                        if (!list.contains(ysrwRowId)) continue;
                        ysrwRow.set("yem_status", (Object)"B");
                    }
                }
                SaveServiceHelper.update((DynamicObject)gztEntity);
            }
            this.getView().invokeOperation("save");
        } else {
            this.getView().showMessage("\u8bf7\u9009\u62e9\u8fbe\u5230\u7684\u5206\u5f55\u884c\uff01\uff01\uff01");
        }
    }

    private void gztwlwtWriteBack(long srcbillid, long srcentryid, Map<Long, HashMap<String, Object>> infoMap) {
        OperationResult result;
        DynamicObject gztEntity = BusinessDataServiceHelper.loadSingle((String)"yem_lg_shipmentwb", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcbillid)});
        DynamicObjectCollection gztEntry = gztEntity.getDynamicObjectCollection("yem_lg_materialinfo");
        for (DynamicObject gztRow : gztEntry) {
            if (gztRow.getLong("id") != srcentryid) continue;
            srcbillid = gztRow.getLong("yem_srcbillid");
            srcentryid = gztRow.getLong("yem_srcentryid");
            DynamicObjectCollection gztSonEntry = gztRow.getDynamicObjectCollection("yem_lg_ysrwgzt_ysrw");
            gztSonEntry.forEach(row -> {
                HashMap map = (HashMap)infoMap.get(row.getLong("id"));
                if (map != null) {
                    row.set("yem_actualarrivalqty", map.get("qty"));
                    row.set("yem_actualarrivaltime", map.get("date"));
                    row.set("yem_landdamage", (Object)row.getBigDecimal("yem_vehicleweight").subtract((BigDecimal)map.get("qty")));
                    if (!YEM.isEmpty(map.get("qty")) && Objects.nonNull(map.get("date"))) {
                        row.set("yem_status", (Object)"C");
                    }
                }
            });
            break;
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_shipmentwb", (DynamicObject[])new DynamicObject[]{gztEntity}, (OperateOption)OperateOption.create())).isSuccess()) {
            throw new KDBizException("\u53cd\u5199\u8fd0\u8f93\u4efb\u52a1\u5de5\u4f5c\u53f0\u6570\u636e\u5931\u8d25\uff01");
        }
        DynamicObject wlwtEntity = BusinessDataServiceHelper.loadSingle((String)"yem_lg_logistics", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcbillid)});
        if (YEM.isEmpty((Object)wlwtEntity)) {
            throw new KDBizException("\u4e0a\u6e38\u4e0d\u5b58\u5728\u7269\u6d41\u59d4\u6258\u5355\uff01");
        }
        DynamicObjectCollection wlwtEntry = wlwtEntity.getDynamicObjectCollection("yem_lg_materialinfo");
        for (DynamicObject wlwtRow : wlwtEntry) {
            if (wlwtRow.getLong("id") != srcentryid) continue;
            DynamicObjectCollection wlwtSonEntry = wlwtRow.getDynamicObjectCollection("yem_lg_wlwt_cl");
            wlwtSonEntry.forEach(row -> {
                HashMap map = (HashMap)infoMap.get(row.getLong("yem_srcentrytryid"));
                if (map != null) {
                    row.set("yem_arrcarqty", map.get("qty"));
                    row.set("yem_actualdate", map.get("date"));
                    row.set("yem_injure", (Object)row.getBigDecimal("yem_carqty").subtract((BigDecimal)map.get("qty")));
                    row.set("yem_statuscar", (Object)"C");
                }
            });
            break;
        }
        wlwtEntity.set("yem_logisticsstatus", (Object)"C");
        result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_logistics", (DynamicObject[])new DynamicObject[]{wlwtEntity}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException("\u53cd\u5199\u7269\u6d41\u59d4\u6258\u5355\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    public void dialogbox(String dynamicform, String button) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(dynamicform);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billno", this.getModel().getValue("billno"));
        DynamicObjectCollection ysrwSonEntry = this.getModel().getEntryEntity("yem_lg_ysd_ysrw");
        DynamicObject parentRow = (DynamicObject)ysrwSonEntry.getParent();
        map.put("srcEntryRowId", parentRow.getPkValue());
        showParameter.setCustomParams(map);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, button));
        this.getView().showForm(showParameter);
    }

    public static class WriteBackData {
        private final Long srcbillid;
        private final Long srcentryid;
        private final Map<Long, HashMap<String, Object>> infoMap;

        public WriteBackData(Long srcbillid, Long srcentryid, Map<Long, HashMap<String, Object>> infoMap) {
            this.srcbillid = srcbillid;
            this.srcentryid = srcentryid;
            this.infoMap = infoMap;
        }

        public Long getSrcbillid() {
            return this.srcbillid;
        }

        public Long getSrcentryid() {
            return this.srcentryid;
        }

        public Map<Long, HashMap<String, Object>> getInfoMap() {
            return this.infoMap;
        }
    }
}

