/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.transportation.form;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.YEM;

public class TransportationFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.EntryInitialization(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                this.callBackFields();
                this.getView().close();
            }
        }
    }

    private void EntryInitialization(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object srcEntryRowId = showParameter.getCustomParam("srcEntryRowId");
        if (srcEntryRowId == null) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        DynamicObjectCollection srcEntry = parentView.getModel().getEntryEntity("yem_lg_materialinfo");
        Optional<DynamicObjectCollection> srcSonEntry = srcEntry.stream().filter(row -> row.getPkValue().equals(srcEntryRowId)).map(row -> row.getDynamicObjectCollection("yem_lg_ysd_ysrw")).findFirst();
        DynamicObjectCollection sonEntry = srcSonEntry.orElse(new DynamicObjectCollection());
        this.getModel().setValue("yem_lg_ysdhtbd_ysrw", (Object)sonEntry);
    }

    private void callBackFields() {
        DynamicObjectCollection sonEntry = this.getModel().getEntryEntity("yem_lg_ysdhtbd_ysrw");
        if (sonEntry.isEmpty()) {
            return;
        }
        HashMap changMap = new HashMap();
        sonEntry.forEach(row -> {
            HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
            map.put("qty", row.getBigDecimal("yem_actualarrivalqty"));
            map.put("date", row.getDate("yem_actualarrivaltime"));
            changMap.put(row.getLong("id"), map);
        });
        IFormView parentView = this.getView().getParentView();
        HashMap infoMap = new HashMap();
        DynamicObjectCollection faEntry = parentView.getModel().getEntryEntity("yem_lg_ysd_ysrw");
        DynamicObject entry = (DynamicObject)faEntry.getParent();
        long srcbillid = entry.getLong("yem_srcbillid");
        long srcentryid = entry.getLong("yem_srcentryid");
        faEntry.forEach(row -> {
            HashMap map = (HashMap)changMap.get(row.getLong("id"));
            if (map != null) {
                row.set("yem_actualarrivalqty", map.get("qty"));
                row.set("yem_actualarrivaltime", map.get("date"));
                row.set("yem_landdamage", (Object)row.getBigDecimal("yem_vehicleweight").subtract((BigDecimal)map.get("qty")));
                if (!YEM.isEmpty(map.get("qty")) && Objects.nonNull(map.get("date"))) {
                    row.set("yem_status", (Object)"C");
                }
                infoMap.put(row.getLong("yem_srcentrytryid"), map);
            }
        });
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_transportation", (DynamicObject[])new DynamicObject[]{parentView.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException("\u56de\u586b\u6570\u636e\u5931\u8d25\uff01");
        }
        parentView.updateView();
        DynamicObject gztEntity = BusinessDataServiceHelper.loadSingle((String)"yem_lg_shipmentwb", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcbillid)});
        DynamicObjectCollection gztEntry = gztEntity.getDynamicObjectCollection("yem_lg_materialinfo");
        for (DynamicObject gztRow : gztEntry) {
            if (gztRow.getLong("id") != srcentryid) continue;
            srcbillid = gztRow.getLong("yem_srcbillid");
            srcentryid = gztRow.getLong("yem_srcentryid");
            DynamicObjectCollection gztSonEntry = gztRow.getDynamicObjectCollection("yem_lg_ysrwgzt_ysrw");
            gztSonEntry.forEach(row -> {
                HashMap map = (HashMap)infoMap.get(row.getLong("id"));
                if (map != null) {
                    row.set("yem_actualarrivalqty", map.get("qty"));
                    row.set("yem_actualarrivaltime", map.get("date"));
                    row.set("yem_landdamage", (Object)row.getBigDecimal("yem_vehicleweight").subtract((BigDecimal)map.get("qty")));
                    if (!YEM.isEmpty(map.get("qty")) && Objects.nonNull(map.get("date"))) {
                        row.set("yem_status", (Object)"C");
                    }
                }
            });
            break;
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_shipmentwb", (DynamicObject[])new DynamicObject[]{gztEntity}, (OperateOption)OperateOption.create())).isSuccess()) {
            throw new KDBizException("\u53cd\u5199\u8fd0\u8f93\u4efb\u52a1\u5de5\u4f5c\u53f0\u6570\u636e\u5931\u8d25\uff01");
        }
        DynamicObject wlwtEntity = BusinessDataServiceHelper.loadSingle((String)"yem_lg_logistics", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcbillid)});
        DynamicObjectCollection wlwtEntry = wlwtEntity.getDynamicObjectCollection("yem_lg_materialinfo");
        for (DynamicObject wlwtRow : wlwtEntry) {
            if (wlwtRow.getLong("id") != srcentryid) continue;
            DynamicObjectCollection wlwtSonEntry = wlwtRow.getDynamicObjectCollection("yem_lg_wlwt_cl");
            wlwtSonEntry.forEach(row -> {
                HashMap map = (HashMap)infoMap.get(row.getLong("yem_srcentrytryid"));
                if (map != null) {
                    row.set("yem_arrcarqty", map.get("qty"));
                    row.set("yem_actualdate", map.get("date"));
                    row.set("yem_injure", (Object)row.getBigDecimal("yem_carqty").subtract((BigDecimal)map.get("qty")));
                }
            });
            break;
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_logistics", (DynamicObject[])new DynamicObject[]{wlwtEntity}, (OperateOption)OperateOption.create())).isSuccess()) {
            throw new KDBizException("\u53cd\u5199\u7269\u6d41\u59d4\u6258\u5355\u6570\u636e\u5931\u8d25\uff01");
        }
    }
}

