/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.transportation.opplugin.op;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;

public class TransportationOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)this.billEntityType.getName(), (boolean)true));
        e.getFieldKeys().add("yem_lg_ysd_ysrw.yem_srcentrytryid");
        e.getFieldKeys().add("yem_lg_ysd_ysrw.yem_vehicleprofile");
        e.getFieldKeys().add("yem_lg_ysd_ysrw.yem_mileage");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        switch (e.getOperationKey()) {
            case "save": {
                break;
            }
            case "delete": {
                this.delInfoData(e.getDataEntities());
            }
        }
    }

    private void delInfoData(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("yem_lg_materialinfo");
            if (entry.isEmpty()) continue;
            AtomicLong srcbillid = new AtomicLong();
            AtomicLong srcentryid = new AtomicLong();
            HashSet infoMap = new HashSet();
            for (DynamicObject row2 : entry) {
                srcbillid.set(row2.getLong("yem_srcbillid"));
                srcentryid.set(row2.getLong("yem_srcentryid"));
                DynamicObjectCollection sonEntry = row2.getDynamicObjectCollection("yem_lg_ysd_ysrw");
                if (sonEntry.isEmpty()) continue;
                sonEntry.forEach(sonRow -> {
                    DynamicObject vehicleprofile;
                    infoMap.add(sonRow.getLong("yem_srcentrytryid"));
                    BigDecimal mileage = sonRow.getBigDecimal("yem_mileage");
                    if (mileage.compareTo(BigDecimal.ZERO) > 0 && (vehicleprofile = sonRow.getDynamicObject("yem_vehicleprofile")) != null) {
                        DynamicObject vehiclefile = BusinessDataServiceHelper.loadSingle((Object)vehicleprofile.getPkValue(), (String)"yem_lg_vehiclefile");
                        if (vehiclefile == null) {
                            return;
                        }
                        BigDecimal totalmileage = vehiclefile.getBigDecimal("yem_totalmileage");
                        vehiclefile.set("yem_totalmileage", (Object)totalmileage.subtract(mileage));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{vehiclefile});
                    }
                });
            }
            if (infoMap.isEmpty()) continue;
            DynamicObject gztEntity = BusinessDataServiceHelper.loadSingle((String)"yem_lg_shipmentwb", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcbillid)});
            DynamicObjectCollection gztEntry = gztEntity.getDynamicObjectCollection("yem_lg_materialinfo");
            long gztEntryid = srcentryid.get();
            gztEntry.stream().filter(row -> row.getLong("id") == gztEntryid).forEach(row -> {
                srcbillid.set(row.getLong("yem_srcbillid"));
                srcentryid.set(row.getLong("yem_srcentryid"));
                row.set("yem_shippingnumber", null);
                DynamicObjectCollection gztSonEntry = row.getDynamicObjectCollection("yem_lg_ysrwgzt_ysrw");
                gztSonEntry.forEach(sonRow -> {
                    if (infoMap.contains(sonRow.getLong("id"))) {
                        sonRow.set("yem_actualarrivalqty", (Object)BigDecimal.ZERO);
                        sonRow.set("yem_actualarrivaltime", null);
                        sonRow.set("yem_landdamage", (Object)BigDecimal.ZERO);
                        sonRow.set("yem_status", (Object)"A");
                    }
                });
            });
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_shipmentwb", (DynamicObject[])new DynamicObject[]{gztEntity}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException("\u5220\u9664\u8fd0\u8f93\u4efb\u52a1\u5de5\u4f5c\u53f0\u6570\u636e\u5931\u8d25\uff01");
            }
            DynamicObject wlwtEntity = BusinessDataServiceHelper.loadSingle((String)"yem_lg_logistics", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcbillid)});
            DynamicObjectCollection wlwtEntry = wlwtEntity.getDynamicObjectCollection("yem_lg_materialinfo");
            long wlwtEntryid = srcentryid.get();
            wlwtEntry.stream().filter(row -> row.getLong("id") == wlwtEntryid).forEach(row -> {
                DynamicObjectCollection wlwtSonEntry = row.getDynamicObjectCollection("yem_lg_wlwt_cl");
                wlwtSonEntry.forEach(sonRow -> {
                    if (infoMap.contains(sonRow.getLong("yem_srcentrytryid"))) {
                        sonRow.set("yem_arrcarqty", (Object)BigDecimal.ZERO);
                        sonRow.set("yem_actualdate", null);
                        sonRow.set("yem_injure", (Object)BigDecimal.ZERO);
                    }
                });
            });
            wlwtEntity.set("yem_logisticsstatus", (Object)"A");
            result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_logistics", (DynamicObject[])new DynamicObject[]{wlwtEntity}, (OperateOption)OperateOption.create());
            if (result.isSuccess()) continue;
            throw new KDBizException("\u5220\u9664\u7269\u6d41\u59d4\u6258\u5355\u6570\u636e\u5931\u8d25\uff01");
        }
    }
}

