/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.trade.vehiclefile.opplugin.op;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class VehiclefileOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("yem_provincialcode");
        fieldKeys.add("yem_vehiclenumber");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                for (DynamicObject dataEntity : dataEntities) {
                    String name = dataEntity.getDataEntityType().getName();
                    String vehiclenumber = VehiclefileOpPlugin.getVehiclenumber(dataEntity, "yem_provincialcode", "yem_vehiclenumber");
                    DynamicObject carno = BusinessDataServiceHelper.loadSingle((String)"yem_lg_carno", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)vehiclenumber)});
                    if (null == carno) {
                        DynamicObject carnos = VehiclefileOpPlugin.getCarno(vehiclenumber, name, dataEntity, list);
                        list.add(carnos);
                        continue;
                    }
                    carno.set("enable", (Object)"1");
                    list.add(carno);
                }
                if (list.size() <= 0) break;
                OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_carno", (DynamicObject[])list.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                break;
            }
            case "unaudit": {
                this.deleteCarno(dataEntities);
                break;
            }
        }
    }

    private void deleteCarno(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        DynamicObjectType type = null;
        for (DynamicObject dataEntity : dataEntities) {
            String vehiclenumber = VehiclefileOpPlugin.getVehiclenumber(dataEntity, "yem_provincialcode", "yem_vehiclenumber");
            DynamicObject carno = BusinessDataServiceHelper.loadSingle((String)"yem_lg_carno", (QFilter[])new QFilter("number", "=", (Object)vehiclenumber).toArray());
            carno.set("enable", (Object)"0");
            list.add(carno);
            if (null != type) continue;
            type = carno.getDynamicObjectType();
        }
        if (type != null) {
            SaveServiceHelper.save(type, (Object[])list.toArray());
        }
    }

    public static String getVehiclenumber(DynamicObject dataEntity, String yemProvincialcode, String yemVehiclenumber) {
        DynamicObject Provincialcode = dataEntity.getDynamicObject(yemProvincialcode);
        String provincialcode = null != Provincialcode ? Provincialcode.getLocaleString("name").getLocaleValue() : "";
        String vehiclenumber = provincialcode + dataEntity.getString(yemVehiclenumber);
        return vehiclenumber;
    }

    public static DynamicObject getCarno(String yemVehiclenumber, String name, DynamicObject dataEntity, List<DynamicObject> list) {
        DynamicObject carno = BusinessDataServiceHelper.newDynamicObject((String)"yem_lg_carno");
        carno.set("status", (Object)"C");
        carno.set("enable", (Object)"1");
        carno.set("yem_vehicletype", (Object)name);
        carno.set("yem_vehiclearchive", (Object)dataEntity);
        carno.set("number", (Object)yemVehiclenumber);
        carno.set("name", (Object)yemVehiclenumber);
        list.add(carno);
        return carno;
    }
}

