/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.websocket;

import com.apusic.aas.websocket.Authenticator;
import com.apusic.aas.websocket.BasicAuthenticator;
import com.apusic.aas.websocket.DigestAuthenticator;
import java.util.ServiceLoader;

public class AuthenticatorFactory {
    public static Authenticator getAuthenticator(String authScheme) {
        Authenticator auth = null;
        switch (authScheme.toLowerCase()) {
            case "basic": {
                auth = new BasicAuthenticator();
                break;
            }
            case "digest": {
                auth = new DigestAuthenticator();
                break;
            }
            default: {
                auth = AuthenticatorFactory.loadAuthenticators(authScheme);
            }
        }
        return auth;
    }

    private static Authenticator loadAuthenticators(String authScheme) {
        ServiceLoader<Authenticator> serviceLoader = ServiceLoader.load(Authenticator.class);
        for (Authenticator auth : serviceLoader) {
            if (!auth.getSchemeName().equalsIgnoreCase(authScheme)) continue;
            return auth;
        }
        return null;
    }
}

