/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.websocket;

import com.apusic.aas.InstanceManager;
import com.apusic.aas.util.res.StringManager;
import com.apusic.aas.websocket.ClientEndpointHolder;
import com.apusic.aas.websocket.pojo.PojoEndpointClient;
import javax.naming.NamingException;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;

public class PojoHolder
implements ClientEndpointHolder {
    private static final StringManager sm = StringManager.getManager(PojoHolder.class);
    private final Object pojo;
    private final ClientEndpointConfig clientEndpointConfig;

    public PojoHolder(Object pojo, ClientEndpointConfig clientEndpointConfig) {
        this.pojo = pojo;
        this.clientEndpointConfig = clientEndpointConfig;
    }

    @Override
    public String getClassName() {
        return this.pojo.getClass().getName();
    }

    @Override
    public Endpoint getInstance(InstanceManager instanceManager) throws DeploymentException {
        if (instanceManager != null) {
            try {
                instanceManager.newInstance(this.pojo);
            }
            catch (ReflectiveOperationException | NamingException e) {
                throw new DeploymentException(sm.getString("clientEndpointHolder.instanceRegistrationFailed"), e);
            }
        }
        return new PojoEndpointClient(this.pojo, this.clientEndpointConfig.getDecoders(), instanceManager);
    }
}

