/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.websocket.server;

import com.apusic.aas.util.net.AbstractEndpoint;
import com.apusic.aas.util.net.SSLSupport;
import com.apusic.aas.util.net.SocketEvent;
import com.apusic.aas.util.net.SocketWrapperBase;
import com.apusic.aas.util.res.StringManager;
import com.apusic.aas.websocket.Transformation;
import com.apusic.aas.websocket.WsIOException;
import com.apusic.aas.websocket.WsSession;
import com.apusic.aas.websocket.server.WsFrameServer;
import com.apusic.aas.websocket.server.WsHandshakeRequest;
import com.apusic.aas.websocket.server.WsRemoteEndpointImplServer;
import com.apusic.aas.websocket.server.WsServerContainer;
import com.apusic.connector.http11.upgrade.InternalHttpUpgradeHandler;
import com.apusic.connector.http11.upgrade.UpgradeInfo;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.WebConnection;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;

public class WsHttpUpgradeHandler
implements InternalHttpUpgradeHandler {
    private final Log log = LogFactory.getLog(WsHttpUpgradeHandler.class);
    private static final StringManager sm = StringManager.getManager(WsHttpUpgradeHandler.class);
    private final ClassLoader applicationClassLoader;
    private SocketWrapperBase<?> socketWrapper;
    private UpgradeInfo upgradeInfo = new UpgradeInfo();
    private Endpoint ep;
    private ServerEndpointConfig serverEndpointConfig;
    private WsServerContainer webSocketContainer;
    private WsHandshakeRequest handshakeRequest;
    private List<Extension> negotiatedExtensions;
    private String subProtocol;
    private Transformation transformation;
    private Map<String, String> pathParameters;
    private boolean secure;
    private WebConnection connection;
    private WsRemoteEndpointImplServer wsRemoteEndpointServer;
    private WsFrameServer wsFrame;
    private WsSession wsSession;

    public WsHttpUpgradeHandler() {
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void setSocketWrapper(SocketWrapperBase<?> socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    public void preInit(ServerEndpointConfig serverEndpointConfig, WsServerContainer wsc, WsHandshakeRequest handshakeRequest, List<Extension> negotiatedExtensionsPhase2, String subProtocol, Transformation transformation, Map<String, String> pathParameters, boolean secure) {
        this.serverEndpointConfig = serverEndpointConfig;
        this.webSocketContainer = wsc;
        this.handshakeRequest = handshakeRequest;
        this.negotiatedExtensions = negotiatedExtensionsPhase2;
        this.subProtocol = subProtocol;
        this.transformation = transformation;
        this.pathParameters = pathParameters;
        this.secure = secure;
    }

    public void init(WebConnection connection) {
        this.connection = connection;
        if (this.serverEndpointConfig == null) {
            throw new IllegalStateException(sm.getString("wsHttpUpgradeHandler.noPreInit"));
        }
        String httpSessionId = null;
        Object session = this.handshakeRequest.getHttpSession();
        if (session != null) {
            httpSessionId = ((HttpSession)session).getId();
        }
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.wsRemoteEndpointServer = new WsRemoteEndpointImplServer(this.socketWrapper, this.upgradeInfo, this.webSocketContainer);
            this.wsSession = new WsSession(this.wsRemoteEndpointServer, this.webSocketContainer, this.handshakeRequest.getRequestURI(), this.handshakeRequest.getParameterMap(), this.handshakeRequest.getQueryString(), this.handshakeRequest.getUserPrincipal(), httpSessionId, this.negotiatedExtensions, this.subProtocol, this.pathParameters, this.secure, this.serverEndpointConfig);
            this.ep = this.wsSession.getLocal();
            this.wsFrame = new WsFrameServer(this.socketWrapper, this.upgradeInfo, this.wsSession, this.transformation, this.applicationClassLoader);
            this.wsRemoteEndpointServer.setTransformation(this.wsFrame.getTransformation());
            this.ep.onOpen(this.wsSession, this.serverEndpointConfig);
            this.webSocketContainer.registerSession(this.serverEndpointConfig.getPath(), this.wsSession);
        }
        catch (DeploymentException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    public UpgradeInfo getUpgradeInfo() {
        return this.upgradeInfo;
    }

    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketEvent status) {
        switch (status) {
            case OPEN_READ: {
                try {
                    return this.wsFrame.notifyDataAvailable();
                }
                catch (WsIOException ws) {
                    this.close(ws.getCloseReason());
                }
                catch (IOException ioe) {
                    this.onError(ioe);
                    CloseReason cr = new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, ioe.getMessage());
                    this.close(cr);
                }
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            case OPEN_WRITE: {
                this.wsRemoteEndpointServer.onWritePossible(false);
                break;
            }
            case STOP: {
                CloseReason cr = new CloseReason(CloseReason.CloseCodes.GOING_AWAY, sm.getString("wsHttpUpgradeHandler.serverStop"));
                try {
                    this.wsSession.close(cr);
                    break;
                }
                catch (IOException ioe) {
                    this.onError(ioe);
                    cr = new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, ioe.getMessage());
                    this.close(cr);
                    return AbstractEndpoint.Handler.SocketState.CLOSED;
                }
            }
            case ERROR: {
                String msg = sm.getString("wsHttpUpgradeHandler.closeOnError");
                this.wsSession.doClose(new CloseReason(CloseReason.CloseCodes.GOING_AWAY, msg), new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, msg));
            }
            case DISCONNECT: 
            case TIMEOUT: 
            case CONNECT_FAIL: {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
        }
        if (this.wsFrame.isOpen()) {
            return AbstractEndpoint.Handler.SocketState.UPGRADED;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    public void timeoutAsync(long now) {
    }

    public void pause() {
    }

    public void destroy() {
        WebConnection connection = this.connection;
        if (connection != null) {
            this.connection = null;
            try {
                connection.close();
            }
            catch (Exception e) {
                this.log.error((Object)sm.getString("wsHttpUpgradeHandler.destroyFailed"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable throwable) {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.ep.onError(this.wsSession, throwable);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    private void close(CloseReason cr) {
        this.wsSession.onClose(cr);
    }

    public void setSslSupport(SSLSupport sslSupport) {
    }
}

