/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util;

import com.apusic.util.Base64;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class MacMain {
    private static String defaultType = System.getProperty("apusic.md.type");
    private static String[] ALL_TYPES = new String[]{defaultType, "SHA-512", "SHA-256", "MD5"};
    private static String type = null;
    private static final String PREFIX = "hmac:";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] args) {
        String ip;
        if (args.length == 0) {
            System.out.println("please input a valid ip as an arg,such as 192.168.101.38!");
            System.exit(1);
        }
        if ((ip = args[0]).equals("test")) {
            MacMain.testMACAddress();
        } else {
            try {
                InetAddress ia = InetAddress.getByName(ip);
                if (ia.isLoopbackAddress() || ia.isAnyLocalAddress() || ia.isMulticastAddress()) {
                    throw new Exception();
                }
                ServerSocket _ss = new ServerSocket(0, 1, ia);
                _ss.close();
                System.out.println("The Result is :" + ip + " " + MacMain.getMACAddress(ia));
            }
            catch (Exception e) {
                System.err.println("ip is illegal!please input a valid ip.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResut(String result) {
        String dir = System.getProperty("user.dir");
        File file = new File(dir, "license.txt");
        FilterOutputStream out = null;
        System.out.println(file.getAbsolutePath());
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            out.write(result.getBytes());
            ((BufferedOutputStream)out).flush();
        }
        catch (Exception ex) {
            System.err.println("3:" + ex.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String digest(String result, String alg) {
        MessageDigest md = null;
        try {
            if (alg != null) {
                try {
                    md = MessageDigest.getInstance(alg);
                    type = alg;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            for (String ttype : ALL_TYPES) {
                try {
                    if (ttype == null) continue;
                    md = MessageDigest.getInstance(ttype);
                    type = ttype;
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            byte[] bts = md.digest(result.getBytes());
            String string = Base64.encode(bts);
            return string;
        }
        catch (Exception ex) {
            System.err.println("2:" + ex.getMessage());
        }
        return null;
    }

    private static String getResut() {
        String result = null;
        try {
            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
            while (all.hasMoreElements()) {
                NetworkInterface nw = all.nextElement();
                if (nw.isLoopback() || !nw.isUp()) continue;
                Enumeration<InetAddress> iparray = nw.getInetAddresses();
                while (iparray.hasMoreElements()) {
                    InetAddress addr = iparray.nextElement();
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || addr.getHostAddress().equals("127.0.0.1")) continue;
                    result = MacMain.getMACAddress(nw.getHardwareAddress());
                    return result;
                }
            }
        }
        catch (Exception e) {
            System.err.println("1:" + e.getMessage());
        }
        return result;
    }

    private static String getMACAddress(byte[] mac) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return sb.toString().toUpperCase();
    }

    public static void checkResult(String result) throws Exception {
        if (result.startsWith(PREFIX)) {
            result = result.substring(PREFIX.length());
        }
        int flag = result.indexOf(":");
        String alg = result.substring(0, flag);
        result = result.substring(flag + 1);
        Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
        while (all.hasMoreElements()) {
            NetworkInterface nw = all.nextElement();
            if (nw.isLoopback() || !nw.isUp()) continue;
            Enumeration<InetAddress> iparray = nw.getInetAddresses();
            while (iparray.hasMoreElements()) {
                String result0;
                InetAddress addr = iparray.nextElement();
                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || addr.getHostAddress().equals("127.0.0.1") || !result.equals(MacMain.digest(result0 = MacMain.getMACAddress(nw.getHardwareAddress()), alg))) continue;
                return;
            }
        }
        throw new Exception("e");
    }

    private static String getMACAddress(InetAddress ia) throws Exception {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() != 1 ? s : String.valueOf(0) + s);
        }
        return sb.toString().toUpperCase();
    }

    private static void testMACAddress() {
        try {
            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
            while (all.hasMoreElements()) {
                byte[] mac;
                NetworkInterface nw = all.nextElement();
                if (nw.isLoopback() || !nw.isUp() || (mac = nw.getHardwareAddress()) == null) continue;
                Enumeration<InetAddress> iparray = nw.getInetAddresses();
                while (iparray.hasMoreElements()) {
                    InetAddress addr = iparray.nextElement();
                    byte[] binAddr = addr.getAddress();
                    if (binAddr.length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress()) continue;
                    System.out.println(addr.getHostAddress().endsWith(".1"));
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static List<String> getLocalIPs() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
            while (all.hasMoreElements()) {
                NetworkInterface nw = all.nextElement();
                if (nw.isLoopback() || !nw.isUp()) continue;
                Enumeration<InetAddress> iparray = nw.getInetAddresses();
                while (iparray.hasMoreElements()) {
                    String[] ips;
                    InetAddress addr = iparray.nextElement();
                    String hostaddr = addr.getHostAddress();
                    if (hostaddr == null || hostaddr.equals("127.0.0.1") || (ips = hostaddr.split("\\.")).length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress()) continue;
                    list.add(hostaddr);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return list;
    }

    public static String getSoftCode(String ip) {
        String encode = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(ip.getBytes("ISO8859-1"));
            byte[] str = md5.digest();
            encode = MacMain.encode(str);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (encode.length() > 15) {
            return encode.substring(0, 16);
        }
        return encode.substring(0);
    }

    private static String encode(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(MacMain.encode(bytes[i]));
        }
        return sb.toString();
    }

    private static char[] encode(byte bt) {
        char[] array = new char[]{hexDigit[bt >> 4 & 0xF], hexDigit[bt & 0xF]};
        return array;
    }
}

