/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util;

import com.apusic.util.Base64;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtil {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String KEY_ALGORITHM = "RSA";
    private static final String KEY_ALG_SIGN = "MD5withRSA";

    public static String sign(String data, String privateKey) throws Exception {
        Signature signature = Signature.getInstance(KEY_ALG_SIGN);
        signature.initSign((PrivateKey)RSAUtil.getPrivateKey(privateKey));
        signature.update(data.getBytes("UTF-8"));
        return Base64.encode(signature.sign());
    }

    public static boolean verify(String data, String publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(KEY_ALG_SIGN);
        signature.initVerify((PublicKey)RSAUtil.getPublicKey(publicKey));
        signature.update(data.getBytes("UTF-8"));
        return signature.verify(Base64.decodeBase64(sign.getBytes("UTF-8")));
    }

    public static String publicEncrypt(String data, String publicKey) throws Exception {
        return RSAUtil.encrypt(data, RSAUtil.getPublicKey(publicKey));
    }

    public static String privateDecrypt(String data, String privateKey) throws Exception {
        return RSAUtil.decrypt(data, RSAUtil.getPrivateKey(privateKey));
    }

    public static String privateEncrypt(String data, String privateKey) throws Exception {
        return RSAUtil.encrypt(data, RSAUtil.getPrivateKey(privateKey));
    }

    public static String publicDecrypt(String data, String publicKey) throws Exception {
        return RSAUtil.decrypt(data, RSAUtil.getPublicKey(publicKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encrypt(String data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, key);
        int inputLen = data.getBytes("UTF-8").length;
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data.getBytes("UTF-8"), offset, 117) : cipher.doFinal(data.getBytes("UTF-8"), offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            String string = Base64.encode(encryptedData);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String decrypt(String data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, key);
        byte[] dataBytes = Base64.decode(data);
        int inputLen = dataBytes.length;
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 128 ? cipher.doFinal(dataBytes, offset, 128) : cipher.doFinal(dataBytes, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            String string = new String(decryptedData, "UTF-8");
            return string;
        }
    }

    private static String byte2hex(byte[] b) {
        StringBuilder str = new StringBuilder();
        String zero = "0";
        for (int n = 0; b != null && n < b.length; ++n) {
            String tmp = Integer.toHexString(b[n] & 0xFF);
            if (tmp.length() == 1) {
                str.append(zero);
            }
            str.append(tmp);
        }
        return str.toString();
    }

    public static KeyPair getKeyPair(int keySize) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        generator.initialize(keySize);
        return generator.generateKeyPair();
    }

    public static String getPrivateKey(KeyPair keyPair) {
        return Base64.encode(keyPair.getPrivate().getEncoded());
    }

    public static String getPublicKey(KeyPair keyPair) {
        return Base64.encode(keyPair.getPublic().getEncoded());
    }

    private static Key getPrivateKey(String privateKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        byte[] decodedKey = Base64.decodeBase64(privateKey.getBytes("UTF-8"));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
        return keyFactory.generatePrivate(keySpec);
    }

    private static Key getPublicKey(String publicKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        byte[] decodedKey = Base64.decodeBase64(publicKey.getBytes("UTF-8"));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        return keyFactory.generatePublic(keySpec);
    }
}

