/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

public class Utils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Utils() {
    }

    public static File getLicFile(String lic) {
        File lic_file = new File(Utils.getApusicHome(), lic);
        if (!lic_file.exists()) {
            lic_file = new File(System.getProperty("user.dir"), lic);
        }
        return lic_file;
    }

    public static String getApusicHome() {
        return Utils.getApusicHome("apusic.home");
    }

    public static String getApusicHome(String proName) {
        String apusicHome = System.getProperty(proName);
        return apusicHome;
    }

    public static String getServerRoot() {
        return Utils.getServerRoot("apusic.base");
    }

    public static String getServerRoot(String proName) {
        String serverHome = System.getProperty(proName);
        return serverHome;
    }

    public static byte[] analyseAgentResponse(byte[] buffers) {
        int pos = 0;
        int len = 0;
        int off = pos;
        int count = buffers.length;
        int resLen = 0;
        while (pos < count) {
            String str;
            if (buffers[pos] == 13) {
                if (pos + 1 < count && buffers[pos + 1] == 10) {
                    ++pos;
                }
                ++pos;
                str = new String(buffers, 0, off, len);
                if (str.indexOf("Content-Length:") > -1) {
                    resLen = Integer.parseInt(str.substring(15).trim());
                }
                off = pos;
                len = 0;
                if (!"".equals(str)) continue;
                break;
            }
            if (buffers[pos] == 10) {
                ++pos;
                str = new String(buffers, 0, off, len);
                if (str.indexOf("Content-Length:") > -1) {
                    resLen = Integer.parseInt(str.substring(15).trim());
                }
                off = pos;
                len = 0;
                if (!"".equals(str)) continue;
                break;
            }
            ++pos;
            ++len;
        }
        byte[] respBuffer = new byte[resLen];
        System.arraycopy(buffers, pos, respBuffer, 0, resLen);
        return respBuffer;
    }

    public static String getServeIPAddress() throws Exception {
        return Utils.getServeIPAddress("com.apusic.serverAddress");
    }

    public static String getServeIPAddress(String proName) throws Exception {
        String serverAddr = System.getProperty(proName == null ? "com.apusic.serverAddress" : proName);
        if (serverAddr != null && !serverAddr.trim().equals("")) {
            return serverAddr;
        }
        InetAddress addr = InetAddress.getLocalHost();
        if (addr instanceof Inet4Address && !addr.getHostAddress().startsWith("127")) {
            return addr.getHostAddress();
        }
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> nii = ni.getInetAddresses();
            while (nii.hasMoreElements()) {
                String strIP;
                InetAddress ip = nii.nextElement();
                if (ip == null || !(ip instanceof Inet4Address) || (strIP = ip.getHostAddress()) == null || strIP.startsWith("127")) continue;
                return ip.getHostAddress();
            }
        }
        return null;
    }

    public static boolean isStringEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().equals("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checkSum(File file) throws IOException {
        FileInputStream fis = null;
        FilterInputStream checksum = null;
        try {
            long l;
            fis = new FileInputStream(file);
            checksum = new CheckedInputStream(fis, new Adler32());
            byte[] bytes = new byte[8192];
            while (checksum.read(bytes) >= 0) {
            }
            long l2 = l = ((CheckedInputStream)checksum).getChecksum().getValue();
            return l2;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (checksum != null) {
                checksum.close();
            }
        }
    }

    public static final String md5(InputStream inputStream) throws IOException {
        try {
            BufferedInputStream in = new BufferedInputStream(inputStream);
            int len = 8192;
            byte[] bytes = new byte[len];
            MessageDigest digest = MessageDigest.getInstance("MD5");
            int read = -1;
            while ((read = inputStream.read(bytes, 0, len)) != -1) {
                digest.update(bytes, 0, read);
            }
            byte[] md = digest.digest();
            return Utils.getHexDigitsString(md);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String md5(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = Utils.md5(fis);
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final String getHexDigitsString(byte[] data) {
        int length = data.length;
        char[] str = new char[length * 2];
        int k = 0;
        for (int i = 0; i < length; ++i) {
            byte byte0 = data[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    public static final String lineToHump(String str) {
        Pattern linePattern = Pattern.compile("_(\\w)");
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

