/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.broker;

import com.apusic.util.Base64;
import com.apusic.util.Utils;
import com.apusic.util.broker.BrokerMgr;
import com.apusic.util.broker.BrokerMgrFac;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.Key;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class BrokerMgrZK
implements BrokerMgr {
    private static String SERVERDIR = "/root/apusic/serverList";
    private static String cacheServer = null;
    private static BrokerMgrZK inst = new BrokerMgrZK();
    private static Properties pro = new Properties();
    private static int add_wait_time = 10;
    private static int session_timeout = 10000;
    private static int maxRetries = 2;
    private static int retries_Sleep = 1000;
    private static int connect_timeout = 2000;
    private static String connect_addr;
    private static boolean useDirect;
    private static List<String> directAddress;
    private static String user;
    private static String userPass;
    private static String AAS_HOME;
    private boolean useable = false;

    public static BrokerMgr getInstance() {
        return inst;
    }

    private BrokerMgrZK() {
    }

    private void init() {
        connect_addr = pro.getProperty("connect_addr");
        try {
            String temp = pro.getProperty("add_wait_time");
            if (temp != null) {
                add_wait_time = Integer.parseInt(temp);
            }
            if ((temp = pro.getProperty("maxRetries")) != null) {
                maxRetries = Integer.parseInt(temp);
            }
            if ((temp = pro.getProperty("session_timeout")) != null) {
                session_timeout = Integer.parseInt(temp);
            }
            if ((temp = pro.getProperty("connect_timeout")) != null) {
                connect_timeout = Integer.parseInt(temp);
            }
            if ((temp = pro.getProperty("retries_Sleep")) != null) {
                retries_Sleep = Integer.parseInt(temp);
            }
            user = pro.getProperty("user");
            userPass = pro.getProperty("userPass");
            String connect_type = pro.getProperty("connect_type");
            if (connect_addr == null || connect_addr.trim().equals("")) {
                connect_addr = BrokerMgrFac.getBrokerFromLicense();
                connect_type = "direct";
            }
            if (connect_type == null || connect_type.equals("direct")) {
                directAddress = Arrays.asList(connect_addr.split(","));
                this.useable = true;
                useDirect = true;
                return;
            }
            if (connect_addr == null || connect_addr.trim().equals("")) {
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (user == null) {
            user = "admin";
        }
        if (userPass == null) {
            userPass = "admin";
        }
        this.useable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBrokerAddress(String hostID) {
        try {
            int size;
            this.init();
            if (!this.isUseable()) {
                String string = null;
                return string;
            }
            List<String> servers = null;
            if (useDirect) {
                servers = directAddress;
            }
            int n = size = servers == null ? 0 : servers.size();
            if (size > 0) {
                int dest = hostID.hashCode() % size;
                cacheServer = servers.get(Math.abs(dest));
                if (useDirect) {
                    boolean isok = false;
                    int count = -1;
                    while (!isok && count < size) {
                        try {
                            String[] ipPorts = cacheServer.split(":");
                            Socket socket = new Socket();
                            InetSocketAddress address = new InetSocketAddress(ipPorts[0], Integer.parseInt(ipPorts[1]));
                            socket.connect(address, connect_timeout / 2);
                            isok = true;
                        }
                        catch (Exception ex) {
                            cacheServer = servers.get(++count < size ? count : size - 1);
                        }
                    }
                }
                BrokerMgrZK.saveCache(cacheServer);
                String string = cacheServer;
                return string;
            }
        }
        catch (Exception ex) {
            if (cacheServer == null) {
                cacheServer = BrokerMgrZK.getCache();
            }
            System.out.println("use cache:" + cacheServer);
            if (Boolean.getBoolean("apusic.debug")) {
                ex.printStackTrace();
            }
            String string = cacheServer;
            return string;
        }
        finally {
            this.close();
        }
        return null;
    }

    @Override
    public boolean isUseable() {
        return this.useable;
    }

    @Override
    public boolean close() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCache(String value) {
        File cacheFile = new File(AAS_HOME + "/cacheServer");
        Properties p = new Properties();
        p.setProperty("server", value);
        FileOutputStream out = null;
        try {
            if (!cacheFile.exists()) {
                cacheFile.createNewFile();
            }
            out = new FileOutputStream(cacheFile);
            p.store(out, null);
        }
        catch (Exception exception) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCache() {
        File cacheFile = new File(AAS_HOME + "/cacheServer");
        if (cacheFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(cacheFile);
                Properties p = new Properties();
                p.load(fis);
                String string = p.getProperty("server");
                return string;
            }
            catch (Exception exception) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private static String serial(String src) {
        try {
            Key key = BrokerMgrZK.getSKey();
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, key);
            byte[] result = cipher.doFinal(src.getBytes());
            return Base64.encode(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return src;
        }
    }

    private static String deSerial(String dest) {
        try {
            Key key = BrokerMgrZK.getSKey();
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(Base64.decode(dest.getBytes()));
            return new String(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return dest;
        }
    }

    private static Key getSKey() {
        StringBuffer sb = new StringBuffer("-115:-48:59:-61:-110:84:-94:18:-86:-78:90:-8:-91:-105:66:76:");
        byte[] result = new byte[16];
        for (int i = 0; i < result.length; ++i) {
            int j = sb.indexOf(":");
            String s = sb.substring(0, j);
            result[i] = new Byte(s);
            sb = sb.delete(0, j + 1);
        }
        SecretKeySpec key = new SecretKeySpec(result, "AES");
        return key;
    }

    static {
        useDirect = false;
        directAddress = null;
        AAS_HOME = Utils.getApusicHome();
        File brokerFile = new File(AAS_HOME + "/broker.list");
        if (brokerFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(brokerFile);
                pro.load(fis);
            }
            catch (Exception exception) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

