/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.os;

import com.apusic.util.os.CommandExecListener;
import com.apusic.util.os.DaemonThreadFactory;
import com.apusic.util.os.SystemProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class CommandUtil {
    private static ScheduledThreadPoolExecutor threadPoolService = new ScheduledThreadPoolExecutor(100, new DaemonThreadFactory());
    private static final int MAX_WAIT_TIME = 10000;
    private static final int CHECK_INTERVAL = 100;
    private static String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private boolean printResult = false;

    public static CommandUtil newInstanceWithPrint() {
        CommandUtil util = new CommandUtil();
        util.setPrintResult(true);
        return util;
    }

    public static CommandUtil newInstance() {
        return new CommandUtil();
    }

    private CommandUtil() {
    }

    public static boolean isProcessTerminate(Process proc) {
        try {
            proc.exitValue();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Process executeCmd(String cmd, String[] evp, File workDir) {
        return this.executeCmd(cmd, evp, workDir, null);
    }

    public String executeCmdWithResult(String cmd, String[] evp, File workDir) throws IOException {
        ResultListener resultListener = new ResultListener();
        try {
            this.execute(cmd, evp, workDir, true, resultListener);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        resultListener.waitFor();
        if (resultListener.isError()) {
            throw new IOException(resultListener.getError());
        }
        return resultListener.getResult();
    }

    public Process executeCmd(String cmd, String[] evp, File workDir, CommandExecListener listener) {
        String content;
        String suffix;
        String prefix = UUID.randomUUID().toString();
        SystemProperties sysPro = SystemProperties.getInstance();
        if (sysPro.isWindows()) {
            suffix = ".bat";
            content = CommandUtil.getCmdExe() + " " + cmd;
        } else if (sysPro.isLinux()) {
            suffix = ".sh";
            content = cmd;
        } else {
            suffix = "";
            content = cmd;
        }
        return this.executeInFile(prefix, suffix, content, evp, workDir, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process executeInFile(String prefix, String suffix, String content, String[] evp, File workDir, CommandExecListener listener) {
        File file = null;
        try {
            file = this.createTempExecuteFile(prefix, suffix, content);
            Process process = this.execute(file.getAbsolutePath(), evp, workDir, false, listener);
            return process;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempExecuteFile(String prefix, String suffix, String content) throws IOException {
        File file = null;
        try (OutputStreamWriter out = null;){
            file = File.createTempFile(prefix, suffix);
            file.deleteOnExit();
            out = new FileWriter(file);
            StringBuilder sb = new StringBuilder();
            sb.append(content);
            out.write(sb.toString());
            out.flush();
        }
        file.setExecutable(true);
        return file;
    }

    private static String getCmdExe() {
        if (SystemProperties.getInstance().isWindows98Series()) {
            return "command.exe /c ";
        }
        return "cmd.exe /c ";
    }

    public Process executeFile(File file, boolean threadFock) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("it's not a legal executable file:" + file);
        }
        return this.execute(file.getAbsolutePath(), null, null, threadFock, null);
    }

    public Process execute(String cmd, String[] evp, File workDir, boolean threadFock) throws IOException {
        return this.execute(cmd, evp, workDir, threadFock, null);
    }

    public Process execute(String cmd, String[] evp, File workDir, boolean threadFock, CommandExecListener listener) throws IOException {
        Process pro = null;
        if (evp == null) {
            ArrayList<String> evpList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if ("CLASSPATH".equalsIgnoreCase(key)) {
                    evpList.add(key + "=");
                    continue;
                }
                evpList.add(key + "=" + (value == null ? "" : value));
            }
            evp = evpList.toArray(new String[evpList.size()]);
        }
        pro = Runtime.getRuntime().exec(cmd, evp, workDir);
        InputStreamThread in = new InputStreamThread(pro.getInputStream(), listener, this.printResult);
        ErrorStreamThread error = new ErrorStreamThread(pro.getErrorStream(), listener, this.printResult);
        if (threadFock) {
            threadPoolService.execute(in);
            threadPoolService.execute(error);
        } else {
            in.run();
        }
        return pro;
    }

    public boolean isPrintResult() {
        return this.printResult;
    }

    public void setPrintResult(boolean printResult) {
        this.printResult = printResult;
    }

    static class ErrorStreamThread
    extends PrintStreamThread {
        public ErrorStreamThread(InputStream inputStream, CommandExecListener lis, boolean printResult) {
            super(inputStream, lis, printResult);
        }

        @Override
        public void pushEnd() {
            this.listener.errorStreamEnd();
        }

        @Override
        public void pushLine(String line) {
            this.listener.newErrorStreamLine(line);
        }
    }

    static class InputStreamThread
    extends PrintStreamThread {
        public InputStreamThread(InputStream inputStream, CommandExecListener lis, boolean printResult) {
            super(inputStream, lis, printResult);
        }

        @Override
        public void pushEnd() {
            this.listener.inputStreamEnd();
        }

        @Override
        public void pushLine(String line) {
            this.listener.newInputStreamLine(line);
        }
    }

    static abstract class PrintStreamThread
    implements Runnable {
        private BufferedReader inputNumberReader;
        protected CommandExecListener listener;
        protected boolean printResult;

        public PrintStreamThread(InputStream inputStream, CommandExecListener lis, boolean printResult) {
            this.listener = lis;
            this.printResult = printResult;
            try {
                this.inputNumberReader = new BufferedReader(new InputStreamReader(inputStream, SystemProperties.getInstance().getSystemEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.inputNumberReader.readLine()) != null) {
                    line = line + LINE_SEPARATOR;
                    if (this.printResult) {
                        System.out.print(line);
                    }
                    if (this.listener == null) continue;
                    this.pushLine(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.inputNumberReader != null) {
                    try {
                        this.inputNumberReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.listener != null) {
                    this.pushEnd();
                }
            }
        }

        protected abstract void pushLine(String var1);

        protected abstract void pushEnd();
    }

    static class ResultListener
    implements CommandExecListener {
        private volatile boolean isError = false;
        private volatile AtomicInteger end = new AtomicInteger(0);
        private StringBuilder result = new StringBuilder();
        private StringBuilder error = new StringBuilder();

        ResultListener() {
        }

        @Override
        public void newErrorStreamLine(String line) {
            this.isError = true;
            this.error.append(line);
        }

        @Override
        public void newInputStreamLine(String line) {
            this.result.append(line);
        }

        public boolean isError() {
            return this.isError;
        }

        public String getResult() {
            String tmp = this.result.toString();
            if (tmp.endsWith(LINE_SEPARATOR)) {
                tmp = tmp.substring(0, tmp.length() - LINE_SEPARATOR.length());
            }
            return tmp;
        }

        public String getError() {
            return this.error.toString();
        }

        @Override
        public void inputStreamEnd() {
            this.end.addAndGet(1);
            this.checkEnd();
        }

        @Override
        public void errorStreamEnd() {
            this.end.addAndGet(1);
            this.checkEnd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkEnd() {
            if (this.end.get() >= 2) {
                ResultListener resultListener = this;
                synchronized (resultListener) {
                    this.notifyAll();
                }
            }
        }

        public void waitFor() {
            while (this.end.get() < 2) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

