/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.os;

import com.apusic.util.os.CommandExecListenerAdapter;
import com.apusic.util.os.CommandUtil;
import com.apusic.util.os.Netstat;
import com.apusic.util.os.NetstatLine;
import com.apusic.util.os.SystemProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxNetstat
implements Netstat {
    private CommandUtil util = CommandUtil.newInstance();
    private static String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();

    @Override
    public boolean isListen(int port) {
        try {
            NetstatParser parser = this.executeNetstat();
            for (NetstatLine line : parser.getNetstatLines()) {
                if (line.getLocalPort() != port || !"LISTEN".equals(line.getState())) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isUsing(int port) {
        try {
            NetstatParser parser = this.executeNetstat();
            for (NetstatLine line : parser.getNetstatLines()) {
                if (line.getLocalPort() != port) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private NetstatParser executeNetstat() throws IOException {
        NetstatParser parser = new NetstatParser();
        StringBuilder sb = new StringBuilder();
        sb.append("#! /bin/sh" + LINE_SEPARATOR);
        sb.append("export LANG=en_US " + LINE_SEPARATOR);
        sb.append("netstat -nlptu" + LINE_SEPARATOR);
        this.util.executeCmd(sb.toString(), null, null, parser);
        return parser;
    }

    @Override
    public String getPidByPort(int port) {
        try {
            NetstatParser parser = this.executeNetstat();
            for (NetstatLine line : parser.getNetstatLines()) {
                if (line.getLocalPort() != port) continue;
                return line.getPid();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        LinuxNetstat stat = new LinuxNetstat();
        System.out.println(stat.isListen(Integer.valueOf(args[0])));
    }

    static class NetstatParser
    extends CommandExecListenerAdapter {
        private static Pattern titlePattern = Pattern.compile(".*(Proto).+(Local Address).+(Foreign Address).+(State).+(PID).*");
        List<NetstatLine> netstatLines = new ArrayList<NetstatLine>();
        private boolean beignParser;
        private boolean endParser;
        private int protoIndex = -1;
        private int localAddrIndex = -1;
        private int foreignAddrIndex = -1;
        private int stateIndex = -1;
        private int pidIndex = -1;

        NetstatParser() {
        }

        @Override
        public void newInputStreamLine(String line) {
            if (this.endParser) {
                return;
            }
            line = line.trim();
            if (!this.beignParser) {
                Matcher matcher = titlePattern.matcher(line);
                if (matcher.matches()) {
                    this.markKeyIndex(line);
                    this.beignParser = true;
                }
            } else if (line.equals("") || line.startsWith("Active")) {
                this.endParser = true;
            } else {
                NetstatLine netstatLine = this.parseLine(line);
                this.netstatLines.add(netstatLine);
            }
        }

        private NetstatLine parseLine(String line) {
            char[] chs = line.toCharArray();
            String proto = this.findSeriesString(chs, this.protoIndex);
            String localAddrAndPort = this.findSeriesString(chs, this.localAddrIndex);
            String foreignAddrAndPort = this.findSeriesString(chs, this.foreignAddrIndex);
            String state = this.findSeriesString(chs, this.stateIndex);
            String pid = this.findSeriesString(chs, this.pidIndex);
            NetstatLine netstatLine = this.createLine(proto, localAddrAndPort, foreignAddrAndPort, state, pid);
            return netstatLine;
        }

        private NetstatLine createLine(String proto, String localAddrAndPort, String foreignAddrAndPort, String state, String pid) {
            NetstatLine netstatLine = new NetstatLine();
            netstatLine.setProto(proto);
            netstatLine.setState(state);
            netstatLine.setPid(pid);
            int lastColonIndex = localAddrAndPort.lastIndexOf(":");
            String localAddr = localAddrAndPort.substring(0, lastColonIndex);
            String localPort = localAddrAndPort.substring(lastColonIndex + 1);
            netstatLine.setLocalAddr(localAddr);
            if ("*".equals(localPort)) {
                netstatLine.setLocalPort(-1);
            } else {
                netstatLine.setLocalPort(Integer.valueOf(localPort));
            }
            int lastColonIndex2 = foreignAddrAndPort.lastIndexOf(":");
            String foreignddr = foreignAddrAndPort.substring(0, lastColonIndex2);
            String foreignPort = foreignAddrAndPort.substring(lastColonIndex2 + 1);
            netstatLine.setForeignAddr(foreignddr);
            if ("*".equals(foreignPort)) {
                netstatLine.setForeignPort(-1);
            } else {
                netstatLine.setForeignPort(Integer.valueOf(foreignPort));
            }
            return netstatLine;
        }

        private String findSeriesString(char[] chs, int startIndex) {
            StringBuilder sb = new StringBuilder();
            for (int i = startIndex; i < chs.length && !Character.isSpaceChar(chs[i]) && chs[i] != '/'; ++i) {
                sb.append(chs[i]);
            }
            return sb.toString();
        }

        @Override
        public void inputStreamEnd() {
            this.endParser = true;
        }

        private void markKeyIndex(String line) {
            this.protoIndex = line.indexOf("Proto");
            this.localAddrIndex = line.indexOf("Local Address");
            this.foreignAddrIndex = line.indexOf("Foreign Address");
            this.stateIndex = line.indexOf("State");
            this.pidIndex = line.indexOf("PID");
        }

        public List<NetstatLine> getNetstatLines() {
            return this.netstatLines;
        }
    }
}

