/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.os;

import com.apusic.util.os.CommandUtil;
import com.apusic.util.os.NetworkConfigurator;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class LinuxNetworkConfigurator
implements NetworkConfigurator {
    private NetworkConfigurator.OSSeries osSeries = NetworkConfigurator.OSSeries.LINUX_REDHAT_SERIES;

    @Override
    public String getHostName() throws IOException {
        String hostname = this.executeHostName(new String[0]);
        return hostname;
    }

    private String executeHostName(String ... args) throws IOException {
        CommandUtil util = CommandUtil.newInstance();
        String cmd = "hostname";
        if (args != null) {
            for (String arg : args) {
                cmd = cmd + " " + arg;
            }
        }
        return util.executeCmdWithResult(cmd, null, null);
    }

    @Override
    public void restartNetworkService() throws IOException {
        CommandUtil.newInstance().executeCmdWithResult("/etc/init.d/network restart", null, null);
    }

    @Override
    public void setOSSeries(NetworkConfigurator.OSSeries osSeries) {
        this.osSeries = osSeries;
    }

    @Override
    public List<String> getNIFNames() {
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> nifNames = new ArrayList<String>();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                if (nif.isLoopback()) continue;
                nifNames.add(nif.getName());
            }
            return nifNames;
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setHostName(String hostName, String mappingIp) throws IOException {
    }
}

