/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.os;

import com.apusic.util.os.CommandExecListenerAdapter;
import com.apusic.util.os.CommandUtil;
import com.apusic.util.os.OSService;
import com.apusic.util.os.ServiceState;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxOSService
implements OSService {
    private String serviceName;
    private Pattern pattern = Pattern.compile("[\\S&&\\w]+");
    private CommandUtil util = CommandUtil.newInstance();

    public LinuxOSService(String name) {
        this.serviceName = name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public ServiceState query() {
        final ServiceState state = new ServiceState();
        try {
            this.util.execute("service " + this.getServiceName() + " status", null, null, false, new CommandExecListenerAdapter(){

                @Override
                public void newInputStreamLine(String line) {
                    Matcher match = LinuxOSService.this.pattern.matcher(line);
                    while (match.find()) {
                        String status = match.group();
                        if ("running".equals(status)) {
                            state.setState(4);
                            return;
                        }
                        if (!"stopped".equals(status)) continue;
                        state.setState(1);
                        return;
                    }
                    state.setState(5);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return state;
    }

    @Override
    public Process start() {
        try {
            return this.util.execute("service " + this.getServiceName() + " start", null, null, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Process stop() {
        try {
            return this.util.execute("service " + this.getServiceName() + " stop", null, null, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

