/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.os;

import java.io.PrintWriter;
import java.io.StringWriter;

public class SystemProperties {
    private String userDir = this.getPropety("user.dir");
    private String fileSeparator = this.getPropety("file.separator");
    private String pathSeparator = this.getPropety("path.separator");
    private String lineSeparator;
    private String osName;
    private String osVersion;
    private String osArch;
    private String jvmVendor;
    private String jvmVersion;
    private String systemEncoding;
    private String fileEncoding;
    private static SystemProperties pro = new SystemProperties();

    public static SystemProperties getInstance() {
        return pro;
    }

    private SystemProperties() {
        StringWriter buf = new StringWriter(4);
        PrintWriter out = new PrintWriter(buf);
        out.println();
        this.lineSeparator = buf.toString();
        this.osName = this.getPropety("os.name");
        this.osVersion = this.getPropety("os.version");
        this.osArch = this.getPropety("os.arch");
        this.jvmVendor = this.getPropety("java.vm.vendor");
        this.jvmVersion = this.getPropety("java.vm.version");
        this.fileEncoding = this.getPropety("file.encoding");
        this.systemEncoding = this.isSunJVM() ? this.getPropety("sun.jnu.encoding") : (this.isIBMJVM() ? this.getPropety("ibm.system.encoding") : this.fileEncoding);
    }

    private String getPropety(String name) {
        return System.getProperty(name);
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public void setFileSeparator(String fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    public String getJvmVendor() {
        return this.jvmVendor;
    }

    public void setJvmVendor(String jvmVendor) {
        this.jvmVendor = jvmVendor;
    }

    public String getJvmVersion() {
        return this.jvmVersion;
    }

    public void setJvmVersion(String jvmVersion) {
        this.jvmVersion = jvmVersion;
    }

    public boolean isWindows() {
        return this.getOsName().toLowerCase().indexOf("windows") != -1;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public String getSystemEncoding() {
        return this.systemEncoding;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public boolean isSunJVM() {
        return this.getJvmVendor().toLowerCase().indexOf("sun") != -1;
    }

    public boolean isIBMJVM() {
        return this.getJvmVendor().toLowerCase().indexOf("ibm") != -1;
    }

    public boolean isWindows98Series() {
        if (!this.isWindows()) {
            return false;
        }
        String osName = this.getOsName().toLowerCase();
        return osName.indexOf("95") != -1 || osName.indexOf("98") != -1 || osName.indexOf("me") != -1;
    }

    public boolean isWindowsNTSeries() {
        if (!this.isWindows()) {
            return false;
        }
        String osName = this.getOsName().toLowerCase();
        return osName.indexOf("xp") != -1 || osName.indexOf("nt") != -1 || osName.indexOf("2000") != -1 || osName.indexOf("2003") != -1;
    }

    public boolean isLinux() {
        String osName = this.getOsName().toLowerCase();
        return osName.indexOf("linux") != -1;
    }
}

