/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.os;

import com.apusic.util.os.CommandExecListenerAdapter;
import com.apusic.util.os.CommandUtil;
import com.apusic.util.os.OSService;
import com.apusic.util.os.ServiceState;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Win32OSService
implements OSService {
    private String serviceName;
    private Pattern pattern = Pattern.compile("[\\S&&[^:]]+");
    private CommandUtil util = CommandUtil.newInstance();

    public String getServiceName() {
        return this.serviceName;
    }

    public Win32OSService(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public ServiceState query() {
        final ServiceState state = new ServiceState();
        this.util.executeCmd("sc query " + this.getServiceName(), null, null, new CommandExecListenerAdapter(){

            @Override
            public void newInputStreamLine(String line) {
                Matcher match = Win32OSService.this.pattern.matcher(line);
                if (match.find()) {
                    String type = match.group();
                    if (!match.find()) {
                        return;
                    }
                    String str = match.group();
                    if ("STATE".equals(type)) {
                        Integer value = Integer.valueOf(str);
                        state.setState(value);
                    } else if ("SERVICE_EXIT_CODE".equals(type)) {
                        Integer value = Integer.valueOf(str);
                        state.setServiceExitCode(value);
                    }
                }
            }
        });
        return state;
    }

    @Override
    public Process start() {
        return this.util.executeCmd("sc start " + this.getServiceName(), null, null);
    }

    @Override
    public Process stop() {
        return this.util.executeCmd("sc stop " + this.getServiceName(), null, null);
    }
}

