/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.os;

import com.apusic.util.os.CommandExecListenerAdapter;
import com.apusic.util.os.CommandUtil;
import com.apusic.util.os.Netstat;
import com.apusic.util.os.NetstatLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WinNetstat
implements Netstat {
    private CommandUtil util = CommandUtil.newInstance();

    @Override
    public boolean isListen(int port) {
        try {
            NetstatParser parser = this.executeNetstat(port);
            for (NetstatLine line : parser.getNetstatLines()) {
                if (line.getLocalPort() != port || !"LISTENING".equals(line.getState())) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isUsing(int port) {
        try {
            NetstatParser parser = this.executeNetstat(port);
            for (NetstatLine line : parser.getNetstatLines()) {
                if (line.getLocalPort() != port) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private NetstatParser executeNetstat(int port) throws IOException {
        NetstatParser parser = new NetstatParser();
        this.util.execute("cmd.exe /C netstat -nao | find \"" + port + "\"", null, null, false, parser);
        return parser;
    }

    @Override
    public String getPidByPort(int port) {
        try {
            NetstatParser parser = this.executeNetstat(port);
            for (NetstatLine line : parser.getNetstatLines()) {
                if (line.getLocalPort() != port || !line.getState().equalsIgnoreCase("LISTENING")) continue;
                return line.getPid();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        WinNetstat winNetstat = new WinNetstat();
        String pid = winNetstat.getPidByPort(6888);
        System.out.println(pid);
    }

    static class NetstatParser
    extends CommandExecListenerAdapter {
        List<NetstatLine> netstatLines = new ArrayList<NetstatLine>();

        NetstatParser() {
        }

        @Override
        public void newInputStreamLine(String line) {
            if (!(line = line.trim()).equals("")) {
                NetstatLine netstatLine = this.parseLine(line);
                this.netstatLines.add(netstatLine);
            }
        }

        private NetstatLine parseLine(String line) {
            String[] templine = line.split("\\s+");
            if (templine.length <= 0) {
                return null;
            }
            String proto = templine[0];
            String localAddrAndPort = null;
            String foreignAddrAndPort = null;
            String state = null;
            String pid = null;
            if ("TCP".equalsIgnoreCase(proto)) {
                localAddrAndPort = templine[1];
                foreignAddrAndPort = templine[2];
                state = templine[3];
                pid = templine[4];
            } else if ("UDP".equalsIgnoreCase(proto)) {
                localAddrAndPort = templine[1];
                foreignAddrAndPort = templine[2];
                state = null;
                pid = templine[3];
            }
            NetstatLine netstatLine = this.createLine(proto, localAddrAndPort, foreignAddrAndPort, state, pid);
            return netstatLine;
        }

        private NetstatLine createLine(String proto, String localAddrAndPort, String foreignAddrAndPort, String state, String pid) {
            NetstatLine netstatLine = new NetstatLine();
            netstatLine.setProto(proto);
            netstatLine.setState(state);
            netstatLine.setPid(pid);
            int index = localAddrAndPort.lastIndexOf(":");
            String address = localAddrAndPort.substring(0, index);
            String port = localAddrAndPort.substring(index + 1, localAddrAndPort.length());
            netstatLine.setLocalAddr(address);
            if ("*".equals(port)) {
                netstatLine.setLocalPort(-1);
            } else {
                netstatLine.setLocalPort(Integer.valueOf(port));
            }
            int index2 = foreignAddrAndPort.lastIndexOf(":");
            String address2 = foreignAddrAndPort.substring(0, index2);
            String port2 = foreignAddrAndPort.substring(index2 + 1, foreignAddrAndPort.length());
            netstatLine.setForeignAddr(address2);
            if ("*".equals(port2)) {
                netstatLine.setForeignPort(-1);
            } else {
                netstatLine.setForeignPort(Integer.valueOf(port2));
            }
            return netstatLine;
        }

        public List<NetstatLine> getNetstatLines() {
            return this.netstatLines;
        }
    }
}

