/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.util.os;

import com.apusic.util.os.CommandExecListenerAdapter;
import com.apusic.util.os.CommandUtil;
import com.apusic.util.os.NetworkConfigurator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class WindowsNetworkConfigurator
implements NetworkConfigurator {
    private static final String SET_HOST_NAME_BAT = "setHostName.bat";
    private static final String SET_IP_BAT = "setip.bat";
    private static final String SET_NTP_SERVER = "setNtpServer.bat";
    private NetworkConfigurator.OSSeries osSeries;

    @Override
    public String getHostName() throws IOException {
        return CommandUtil.newInstance().executeCmdWithResult("hostname", null, null);
    }

    @Override
    public void setHostName(String hostName, String mappingIp) throws IOException {
        URL batUrl = this.getClass().getClassLoader().getResource(SET_HOST_NAME_BAT);
        File batFile = this.writeToTempFile(batUrl.openStream());
        String cmd = batFile.getAbsolutePath();
        cmd = cmd + " " + hostName + " " + mappingIp + " " + this.getLmhostLocal();
        CommandUtil.newInstance().executeCmdWithResult(cmd, null, null);
    }

    private String getLmhostLocal() {
        if (this.osSeries == NetworkConfigurator.OSSeries.WINDOWS_98_SERIES) {
            return "c:\\Windows";
        }
        return "C:\\WINDOWS\\system32\\drivers\\etc\\lmhosts";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeToTempFile(InputStream in) {
        File temp = null;
        FileOutputStream out = null;
        try {
            temp = File.createTempFile(UUID.randomUUID().toString(), ".bat");
            temp.setExecutable(true);
            out = new FileOutputStream(temp);
            byte[] buf = new byte[8192];
            int len = -1;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return temp;
    }

    @Override
    public List<String> getNIFNames() {
        final ArrayList<String> nifNames = new ArrayList<String>();
        CommandUtil.newInstance().executeCmd("ipconfig /all", null, null, new CommandExecListenerAdapter(){

            @Override
            public void newInputStreamLine(String line) {
                String prefix = "Ethernet adapter ";
                if (line.startsWith(prefix)) {
                    int startIndex = prefix.length();
                    int endIndex = line.indexOf(":", startIndex);
                    String name = line.substring(startIndex, endIndex);
                    nifNames.add(name);
                }
            }
        });
        return nifNames;
    }

    @Override
    public void setOSSeries(NetworkConfigurator.OSSeries osSeries) {
        this.osSeries = osSeries;
    }

    @Override
    public void restartNetworkService() {
    }

    public static void main(String[] args) {
        WindowsNetworkConfigurator config = new WindowsNetworkConfigurator();
        for (String name : config.getNIFNames()) {
            System.out.println(name);
        }
    }
}

