/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.connector;

import com.apusic.aas.util.res.StringManager;
import com.apusic.ams.connector.OutputBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class ConnectorOutputStream
extends ServletOutputStream {
    protected static final StringManager sm = StringManager.getManager(ConnectorOutputStream.class);
    protected OutputBuffer ob;

    protected ConnectorOutputStream(OutputBuffer ob) {
        this.ob = ob;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ob = null;
    }

    @Override
    public void write(int i) throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        this.ob.writeByte(i);
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        this.ob.write(b, off, len);
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    public void write(ByteBuffer from) throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        this.ob.write(from);
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        this.ob.flush();
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    private boolean checkNonBlockingWrite() {
        boolean nonBlocking;
        boolean bl = nonBlocking = !this.ob.isBlocking();
        if (nonBlocking && !this.ob.isReady()) {
            throw new IllegalStateException(sm.getString("connectorOutputStream.nbNotready"));
        }
        return nonBlocking;
    }

    private void checkRegisterForWrite() {
        this.ob.checkRegisterForWrite();
    }

    @Override
    public void close() throws IOException {
        this.ob.close();
    }

    @Override
    public boolean isReady() {
        return this.ob.isReady();
    }

    @Override
    public void setWriteListener(WriteListener listener) {
        this.ob.setWriteListener(listener);
    }
}

