/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.core;

import com.apusic.aas.util.res.StringManager;
import com.apusic.aas.util.threads.ResizableExecutor;
import com.apusic.aas.util.threads.TaskQueue;
import com.apusic.aas.util.threads.TaskThreadFactory;
import com.apusic.aas.util.threads.ThreadPoolExecutor;
import com.apusic.ams.Executor;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.LifecycleState;
import com.apusic.ams.util.LifecycleMBeanBase;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class StandardThreadExecutor
extends LifecycleMBeanBase
implements Executor,
ResizableExecutor {
    protected static final StringManager sm = StringManager.getManager(StandardThreadExecutor.class);
    protected int threadPriority = 5;
    protected boolean daemon = true;
    protected String namePrefix = "aas-exec-";
    protected int maxThreads = 200;
    protected int minSpareThreads = 25;
    protected int maxIdleTime = 60000;
    protected ThreadPoolExecutor executor = null;
    protected String name;
    protected boolean prestartminSpareThreads = false;
    protected int maxQueueSize = Integer.MAX_VALUE;
    protected long threadRenewalDelay = 1000L;
    private TaskQueue taskqueue = null;

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.taskqueue = new TaskQueue(this.maxQueueSize);
        TaskThreadFactory tf = new TaskThreadFactory(this.namePrefix, this.daemon, this.getThreadPriority());
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), (long)this.maxIdleTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.taskqueue, tf);
        this.executor.setThreadRenewalDelay(this.threadRenewalDelay);
        if (this.prestartminSpareThreads) {
            this.executor.prestartAllCoreThreads();
        }
        this.taskqueue.setParent(this.executor);
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
        this.taskqueue = null;
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        super.destroyInternal();
    }

    @Override
    @Deprecated
    public void execute(Runnable command, long timeout, TimeUnit unit) {
        if (this.executor == null) {
            throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
        }
        this.executor.execute(command, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.executor == null) {
            throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
        }
        this.executor.execute(command);
    }

    public void contextStopping() {
        if (this.executor != null) {
            this.executor.contextStopping();
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isPrestartminSpareThreads() {
        return this.prestartminSpareThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
        if (this.executor != null) {
            this.executor.setKeepAliveTime(maxIdleTime, TimeUnit.MILLISECONDS);
        }
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (this.executor != null) {
            this.executor.setMaximumPoolSize(maxThreads);
        }
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
        if (this.executor != null) {
            this.executor.setCorePoolSize(minSpareThreads);
        }
    }

    public void setPrestartminSpareThreads(boolean prestartminSpareThreads) {
        this.prestartminSpareThreads = prestartminSpareThreads;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMaxQueueSize(int size) {
        this.maxQueueSize = size;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public long getThreadRenewalDelay() {
        return this.threadRenewalDelay;
    }

    public void setThreadRenewalDelay(long threadRenewalDelay) {
        this.threadRenewalDelay = threadRenewalDelay;
        if (this.executor != null) {
            this.executor.setThreadRenewalDelay(threadRenewalDelay);
        }
    }

    @Override
    public int getActiveCount() {
        return this.executor != null ? this.executor.getActiveCount() : 0;
    }

    public long getCompletedTaskCount() {
        return this.executor != null ? this.executor.getCompletedTaskCount() : 0L;
    }

    public int getCorePoolSize() {
        return this.executor != null ? this.executor.getCorePoolSize() : 0;
    }

    public int getLargestPoolSize() {
        return this.executor != null ? this.executor.getLargestPoolSize() : 0;
    }

    @Override
    public int getPoolSize() {
        return this.executor != null ? this.executor.getPoolSize() : 0;
    }

    public int getQueueSize() {
        return this.executor != null ? this.executor.getQueue().size() : -1;
    }

    @Override
    public boolean resizePool(int corePoolSize, int maximumPoolSize) {
        if (this.executor == null) {
            return false;
        }
        this.executor.setCorePoolSize(corePoolSize);
        this.executor.setMaximumPoolSize(maximumPoolSize);
        return true;
    }

    @Override
    public boolean resizeQueue(int capacity) {
        return false;
    }

    @Override
    protected String getDomainInternal() {
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return "type=Executor,name=" + this.getName();
    }
}

