/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.security;

import com.apusic.ams.startup.ApusicProperties;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.security.Security;

public final class SecurityConfig {
    private static final Object singletonLock = new Object();
    private static volatile SecurityConfig singleton = null;
    private static final Log log = LogFactory.getLog(SecurityConfig.class);
    private static final String PACKAGE_ACCESS = "sun.,com.apusic.ams.,com.apusic.jasper.,com.apusic.connector.,com.apusic.aas.";
    private static final String PACKAGE_DEFINITION = "java.,sun.,com.apusic.ams.,com.apusic.connector.,com.apusic.aas.,com.apusic.jasper.";
    private final String packageDefinition;
    private final String packageAccess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityConfig() {
        String definition = null;
        String access = null;
        try {
            definition = ApusicProperties.getProperty("package.definition");
            access = ApusicProperties.getProperty("package.access");
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to load properties using ApusicProperties", ex);
            }
        }
        finally {
            this.packageDefinition = definition;
            this.packageAccess = access;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityConfig newInstance() {
        if (singleton == null) {
            Object object = singletonLock;
            synchronized (object) {
                if (singleton == null) {
                    singleton = new SecurityConfig();
                }
            }
        }
        return singleton;
    }

    public void setPackageAccess() {
        if (this.packageAccess == null) {
            this.setSecurityProperty("package.access", PACKAGE_ACCESS);
        } else {
            this.setSecurityProperty("package.access", this.packageAccess);
        }
    }

    public void setPackageDefinition() {
        if (this.packageDefinition == null) {
            this.setSecurityProperty("package.definition", PACKAGE_DEFINITION);
        } else {
            this.setSecurityProperty("package.definition", this.packageDefinition);
        }
    }

    private final void setSecurityProperty(String properties, String packageList) {
        if (System.getSecurityManager() != null) {
            String definition = Security.getProperty(properties);
            if (definition != null && definition.length() > 0) {
                if (packageList.length() > 0) {
                    definition = definition + ',' + packageList;
                }
            } else {
                definition = packageList;
            }
            Security.setProperty(properties, definition);
        }
    }
}

