/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.session;

import com.apusic.ams.LifecycleException;
import com.apusic.ams.LifecycleState;
import com.apusic.ams.Session;
import com.apusic.ams.session.InMemorySession;
import com.apusic.ams.session.ManagerBase;
import com.apusic.ams.session.StandardSession;
import com.apusic.ams.util.ConcurrentDirectDeque;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.io.IOException;
import java.util.Deque;

public class InMemorySessionManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(InMemorySessionManager.class);
    private ConcurrentDirectDeque<String> evictionQueue = null;
    private boolean expireOldestUnusedSessionOnMax = true;

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        ConcurrentDirectDeque evictionQueue = null;
        if (this.getMaxActiveSessions() > 0) {
            evictionQueue = ConcurrentDirectDeque.newInstance();
        }
        this.evictionQueue = evictionQueue;
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session createSession(String sessionId) {
        if (this.evictionQueue != null && this.expireOldestUnusedSessionOnMax) {
            int maxSize = this.getMaxActiveSessions();
            while (this.sessions.size() >= maxSize && !this.evictionQueue.isEmpty()) {
                String key = (String)this.evictionQueue.poll();
                this.log.debug(String.format("Removing session %s as max size has been hit", key));
                Session toRemove = (Session)this.sessions.get(key);
                if (toRemove == null) continue;
                toRemove.expire();
            }
        }
        InMemorySession session = (InMemorySession)this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.getContext().getSessionTimeout() * 60);
        String id = sessionId;
        if (id == null) {
            id = this.generateSessionId();
        }
        session.setId(id);
        if (this.evictionQueue != null) {
            session.setEvictionToken(this.evictionQueue.offerLastAndReturnToken(id));
        }
        ManagerBase.SessionTiming timing = new ManagerBase.SessionTiming(session.getCreationTime(), 0);
        Deque deque = this.sessionCreationTiming;
        synchronized (deque) {
            this.sessionCreationTiming.add(timing);
            this.sessionCreationTiming.poll();
        }
        return session;
    }

    @Override
    protected StandardSession getNewSession() {
        StandardSession session = this.evictionQueue != null ? new InMemorySession(this) : super.getNewSession();
        return session;
    }

    @Override
    public void remove(Session session, boolean update) {
        Object evictionToken;
        super.remove(session, update);
        if (session instanceof InMemorySession && (evictionToken = ((InMemorySession)session).getEvictionToken()) != null) {
            this.evictionQueue.removeToken(evictionToken);
        }
    }

    public boolean isExpireOldestUnusedSessionOnMax() {
        return this.expireOldestUnusedSessionOnMax;
    }

    public void setExpireOldestUnusedSessionOnMax(boolean expireOldestUnusedSessionOnMax) {
        this.expireOldestUnusedSessionOnMax = expireOldestUnusedSessionOnMax;
    }

    public ConcurrentDirectDeque<String> getEvictionQueue() {
        return this.evictionQueue;
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
    }

    @Override
    public void unload() throws IOException {
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        super.stopInternal();
    }
}

