/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.startup;

import com.apusic.aas.util.ExceptionUtils;
import com.apusic.aas.util.buf.UriUtil;
import com.apusic.aas.util.compat.JreCompat;
import com.apusic.aas.util.descriptor.web.LoginConfig;
import com.apusic.aas.util.file.ConfigFileLoader;
import com.apusic.aas.util.file.ConfigurationSource;
import com.apusic.aas.util.modeler.Registry;
import com.apusic.aas.util.res.StringManager;
import com.apusic.ams.Container;
import com.apusic.ams.Context;
import com.apusic.ams.Engine;
import com.apusic.ams.Host;
import com.apusic.ams.LifecycleEvent;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.LifecycleListener;
import com.apusic.ams.Realm;
import com.apusic.ams.Server;
import com.apusic.ams.Service;
import com.apusic.ams.Wrapper;
import com.apusic.ams.authenticator.NonLoginAuthenticator;
import com.apusic.ams.connector.Connector;
import com.apusic.ams.core.ContainerBase;
import com.apusic.ams.core.NamingContextListener;
import com.apusic.ams.core.StandardContext;
import com.apusic.ams.core.StandardEngine;
import com.apusic.ams.core.StandardHost;
import com.apusic.ams.core.StandardServer;
import com.apusic.ams.core.StandardService;
import com.apusic.ams.core.StandardWrapper;
import com.apusic.ams.realm.GenericPrincipal;
import com.apusic.ams.realm.RealmBase;
import com.apusic.ams.security.SecurityClassLoad;
import com.apusic.ams.startup.Apusic;
import com.apusic.ams.startup.ApusicBaseConfigurationSource;
import com.apusic.ams.startup.ContextConfig;
import com.apusic.ams.startup.WebAnnotationSet;
import com.apusic.ams.util.ContextName;
import com.apusic.ams.util.IOTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.annotation.WebServlet;

public class Aas {
    private static final StringManager sm = StringManager.getManager(Aas.class);
    private final Map<String, Logger> pinnedLoggers = new HashMap<String, Logger>();
    protected Server server;
    protected int port = 8080;
    protected String hostname = "localhost";
    protected String basedir;
    protected boolean defaultConnectorCreated = false;
    private final Map<String, String> userPass = new HashMap<String, String>();
    private final Map<String, List<String>> userRoles = new HashMap<String, List<String>>();
    private final Map<String, Principal> userPrincipals = new HashMap<String, Principal>();
    private boolean addDefaultWebXmlToWebapp = true;
    static final String[] silences = new String[]{"com.apusic.connector.http11.Http11NioProtocol", "com.apusic.ams.core.StandardService", "com.apusic.ams.core.StandardEngine", "com.apusic.ams.startup.ContextConfig", "com.apusic.ams.core.ApplicationContext", "com.apusic.ams.core.AprLifecycleListener"};
    private boolean silent = false;

    public Aas() {
        ExceptionUtils.preload();
    }

    public void setBaseDir(String basedir) {
        this.basedir = basedir;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostname(String s) {
        this.hostname = s;
    }

    public Context addWebapp(String contextPath, String docBase) {
        return this.addWebapp(this.getHost(), contextPath, docBase);
    }

    public Context addWebapp(String contextPath, URL source) throws IOException {
        ContextName cn = new ContextName(contextPath, null);
        Host h = this.getHost();
        if (h.findChild(cn.getName()) != null) {
            throw new IllegalArgumentException(sm.getString("aas.addWebapp.conflictChild", source, contextPath, cn.getName()));
        }
        File targetWar = new File(h.getAppBaseFile(), cn.getBaseName() + ".war");
        File targetDir = new File(h.getAppBaseFile(), cn.getBaseName());
        if (targetWar.exists()) {
            throw new IllegalArgumentException(sm.getString("aas.addWebapp.conflictFile", source, contextPath, targetWar.getAbsolutePath()));
        }
        if (targetDir.exists()) {
            throw new IllegalArgumentException(sm.getString("aas.addWebapp.conflictFile", source, contextPath, targetDir.getAbsolutePath()));
        }
        URLConnection uConn = source.openConnection();
        try (InputStream is = uConn.getInputStream();
             FileOutputStream os = new FileOutputStream(targetWar);){
            IOTools.flow(is, os);
        }
        return this.addWebapp(contextPath, targetWar.getAbsolutePath());
    }

    public Context addContext(String contextPath, String docBase) {
        return this.addContext(this.getHost(), contextPath, docBase);
    }

    public Wrapper addServlet(String contextPath, String servletName, String servletClass) {
        Container ctx = this.getHost().findChild(contextPath);
        return Aas.addServlet((Context)ctx, servletName, servletClass);
    }

    public static Wrapper addServlet(Context ctx, String servletName, String servletClass) {
        Wrapper sw = ctx.createWrapper();
        sw.setServletClass(servletClass);
        sw.setName(servletName);
        ctx.addChild(sw);
        return sw;
    }

    public Wrapper addServlet(String contextPath, String servletName, Servlet servlet) {
        Container ctx = this.getHost().findChild(contextPath);
        return Aas.addServlet((Context)ctx, servletName, servlet);
    }

    public static Wrapper addServlet(Context ctx, String servletName, Servlet servlet) {
        ExistingStandardWrapper sw = new ExistingStandardWrapper(servlet);
        sw.setName(servletName);
        ctx.addChild(sw);
        return sw;
    }

    public void init(ConfigurationSource source) {
        this.init(source, null);
    }

    public void init(ConfigurationSource source, String[] apusicArguments) {
        ConfigFileLoader.setSource(source);
        this.addDefaultWebXmlToWebapp = false;
        Apusic apusic = new Apusic();
        if (apusicArguments == null) {
            apusic.load();
        } else {
            apusic.load(apusicArguments);
        }
        this.server = apusic.getServer();
    }

    public void init() throws LifecycleException {
        this.getServer();
        this.server.init();
    }

    public void start() throws LifecycleException {
        this.getServer();
        this.server.start();
    }

    public void stop() throws LifecycleException {
        this.getServer();
        this.server.stop();
    }

    public void destroy() throws LifecycleException {
        this.getServer();
        this.server.destroy();
    }

    public void addUser(String user, String pass) {
        this.userPass.put(user, pass);
    }

    public void addRole(String user, String role) {
        List<String> roles = this.userRoles.get(user);
        if (roles == null) {
            roles = new ArrayList<String>();
            this.userRoles.put(user, roles);
        }
        roles.add(role);
    }

    public Connector getConnector() {
        Service service = this.getService();
        if (service.findConnectors().length > 0) {
            return service.findConnectors()[0];
        }
        if (this.defaultConnectorCreated) {
            return null;
        }
        Connector connector = new Connector("HTTP/1.1");
        connector.setPort(this.port);
        service.addConnector(connector);
        return connector;
    }

    public void setConnector(Connector connector) {
        Service service = this.getService();
        boolean found = false;
        for (Connector serviceConnector : service.findConnectors()) {
            if (connector != serviceConnector) continue;
            found = true;
            break;
        }
        if (!found) {
            service.addConnector(connector);
        }
    }

    public Service getService() {
        return this.getServer().findServices()[0];
    }

    public void setHost(Host host) {
        Engine engine = this.getEngine();
        boolean found = false;
        for (Container engineHost : engine.findChildren()) {
            if (engineHost != host) continue;
            found = true;
            break;
        }
        if (!found) {
            engine.addChild(host);
        }
    }

    public Host getHost() {
        Engine engine = this.getEngine();
        if (engine.findChildren().length > 0) {
            return (Host)engine.findChildren()[0];
        }
        StandardHost host = new StandardHost();
        host.setName(this.hostname);
        this.getEngine().addChild(host);
        return host;
    }

    public Engine getEngine() {
        Service service = this.getServer().findServices()[0];
        if (service.getContainer() != null) {
            return service.getContainer();
        }
        StandardEngine engine = new StandardEngine();
        engine.setName("Aas");
        engine.setDefaultHost(this.hostname);
        engine.setRealm(this.createDefaultRealm());
        service.setContainer(engine);
        return engine;
    }

    public Server getServer() {
        if (this.server != null) {
            return this.server;
        }
        System.setProperty("apusic.useNaming", "false");
        this.server = new StandardServer();
        this.initBaseDir();
        ConfigFileLoader.setSource(new ApusicBaseConfigurationSource(new File(this.basedir), null));
        this.server.setPort(-1);
        StandardService service = new StandardService();
        service.setName("Aas");
        this.server.addService(service);
        return this.server;
    }

    public Context addContext(Host host, String contextPath, String dir) {
        return this.addContext(host, contextPath, contextPath, dir);
    }

    public Context addContext(Host host, String contextPath, String contextName, String dir) {
        this.silence(host, contextName);
        Context ctx = this.createContext(host, contextPath);
        ctx.setName(contextName);
        ctx.setPath(contextPath);
        ctx.setDocBase(dir);
        ctx.addLifecycleListener(new FixContextListener());
        if (host == null) {
            this.getHost().addChild(ctx);
        } else {
            host.addChild(ctx);
        }
        return ctx;
    }

    public Context addWebapp(Host host, String contextPath, String docBase) {
        LifecycleListener listener = null;
        try {
            Class<?> clazz = Class.forName(this.getHost().getConfigClass());
            listener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
        return this.addWebapp(host, contextPath, docBase, listener);
    }

    public Context addWebapp(Host host, String contextPath, String docBase, LifecycleListener config) {
        this.silence(host, contextPath);
        Context ctx = this.createContext(host, contextPath);
        ctx.setPath(contextPath);
        ctx.setDocBase(docBase);
        if (this.addDefaultWebXmlToWebapp) {
            ctx.addLifecycleListener(this.getDefaultWebXmlListener());
        }
        ctx.setConfigFile(this.getWebappConfigFile(docBase, contextPath));
        ctx.addLifecycleListener(config);
        if (this.addDefaultWebXmlToWebapp && config instanceof ContextConfig) {
            ((ContextConfig)config).setDefaultWebXml(this.noDefaultWebXmlPath());
        }
        if (host == null) {
            this.getHost().addChild(ctx);
        } else {
            host.addChild(ctx);
        }
        return ctx;
    }

    public LifecycleListener getDefaultWebXmlListener() {
        return new DefaultWebXmlListener();
    }

    public String noDefaultWebXmlPath() {
        return "com/apusic/ams/startup/NO_DEFAULT_XML";
    }

    protected Realm createDefaultRealm() {
        return new SimpleRealm();
    }

    protected void initBaseDir() {
        File baseFile;
        String apusicHome = System.getProperty("apusic.home");
        if (this.basedir == null) {
            this.basedir = System.getProperty("apusic.base");
        }
        if (this.basedir == null) {
            this.basedir = apusicHome;
        }
        if (this.basedir == null) {
            this.basedir = System.getProperty("user.dir") + "/aas." + this.port;
        }
        if ((baseFile = new File(this.basedir)).exists()) {
            if (!baseFile.isDirectory()) {
                throw new IllegalArgumentException(sm.getString("aas.baseDirNotDir", baseFile));
            }
        } else if (!baseFile.mkdirs()) {
            throw new IllegalStateException(sm.getString("aas.baseDirMakeFail", baseFile));
        }
        try {
            baseFile = baseFile.getCanonicalFile();
        }
        catch (IOException e) {
            baseFile = baseFile.getAbsoluteFile();
        }
        this.server.setApusicBase(baseFile);
        System.setProperty("apusic.base", baseFile.getPath());
        this.basedir = baseFile.getPath();
        if (apusicHome == null) {
            this.server.setApusicHome(baseFile);
        } else {
            File homeFile = new File(apusicHome);
            if (!homeFile.isDirectory() && !homeFile.mkdirs()) {
                throw new IllegalStateException(sm.getString("aas.homeDirMakeFail", homeFile));
            }
            try {
                homeFile = homeFile.getCanonicalFile();
            }
            catch (IOException e) {
                homeFile = homeFile.getAbsoluteFile();
            }
            this.server.setApusicHome(homeFile);
        }
        System.setProperty("apusic.home", this.server.getApusicHome().getPath());
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        for (String s : silences) {
            Logger logger = Logger.getLogger(s);
            this.pinnedLoggers.put(s, logger);
            if (silent) {
                logger.setLevel(Level.WARNING);
                continue;
            }
            logger.setLevel(Level.INFO);
        }
    }

    private void silence(Host host, String contextPath) {
        String loggerName = this.getLoggerName(host, contextPath);
        Logger logger = Logger.getLogger(loggerName);
        this.pinnedLoggers.put(loggerName, logger);
        if (this.silent) {
            logger.setLevel(Level.WARNING);
        } else {
            logger.setLevel(Level.INFO);
        }
    }

    public void setAddDefaultWebXmlToWebapp(boolean addDefaultWebXmlToWebapp) {
        this.addDefaultWebXmlToWebapp = addDefaultWebXmlToWebapp;
    }

    private String getLoggerName(Host host, String contextName) {
        if (host == null) {
            host = this.getHost();
        }
        StringBuilder loggerName = new StringBuilder();
        loggerName.append(ContainerBase.class.getName());
        loggerName.append(".[");
        loggerName.append(host.getParent().getName());
        loggerName.append("].[");
        loggerName.append(host.getName());
        loggerName.append("].[");
        if (contextName == null || contextName.equals("")) {
            loggerName.append('/');
        } else if (contextName.startsWith("##")) {
            loggerName.append('/');
            loggerName.append(contextName);
        }
        loggerName.append(']');
        return loggerName.toString();
    }

    private Context createContext(Host host, String url) {
        String defaultContextClass = StandardContext.class.getName();
        String contextClass = StandardContext.class.getName();
        if (host == null) {
            host = this.getHost();
        }
        if (host instanceof StandardHost) {
            contextClass = ((StandardHost)host).getContextClass();
        }
        try {
            if (defaultContextClass.equals(contextClass)) {
                return new StandardContext();
            }
            return (Context)Class.forName(contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new IllegalArgumentException(sm.getString("aas.noContextClass", contextClass, host, url), e);
        }
    }

    public void enableNaming() {
        this.getServer();
        this.server.addLifecycleListener(new NamingContextListener());
        System.setProperty("apusic.useNaming", "true");
        String value = "com.apusic.naming";
        String oldValue = System.getProperty("java.naming.factory.url.pkgs");
        if (oldValue != null) {
            value = oldValue.contains(value) ? oldValue : value + ":" + oldValue;
        }
        System.setProperty("java.naming.factory.url.pkgs", value);
        value = System.getProperty("java.naming.factory.initial");
        if (value == null) {
            System.setProperty("java.naming.factory.initial", "com.apusic.naming.java.javaURLContextFactory");
        }
    }

    public void initWebappDefaults(String contextPath) {
        Container ctx = this.getHost().findChild(contextPath);
        Aas.initWebappDefaults((Context)ctx);
    }

    public static void initWebappDefaults(Context ctx) {
        Wrapper servlet = Aas.addServlet(ctx, "default", "com.apusic.ams.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        servlet = Aas.addServlet(ctx, "jsp", "com.apusic.jasper.servlet.JspServlet");
        servlet.addInitParameter("fork", "false");
        servlet.setLoadOnStartup(3);
        servlet.setOverridable(true);
        ctx.addServletMappingDecoded("/", "default");
        ctx.addServletMappingDecoded("*.jsp", "jsp");
        ctx.addServletMappingDecoded("*.jspx", "jsp");
        ctx.setSessionTimeout(30);
        Aas.addDefaultMimeTypeMappings(ctx);
        ctx.addWelcomeFile("index.html");
        ctx.addWelcomeFile("index.htm");
        ctx.addWelcomeFile("index.jsp");
    }

    public static void addDefaultMimeTypeMappings(Context context) {
        Properties defaultMimeMappings = new Properties();
        try (InputStream is = Aas.class.getResourceAsStream("MimeTypeMappings.properties");){
            defaultMimeMappings.load(is);
            for (Map.Entry<Object, Object> entry : defaultMimeMappings.entrySet()) {
                context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(sm.getString("aas.defaultMimeTypeMappingsFail"), e);
        }
    }

    protected URL getWebappConfigFile(String path, String contextName) {
        File docBase = new File(path);
        if (docBase.isDirectory()) {
            return this.getWebappConfigFileFromDirectory(docBase, contextName);
        }
        return this.getWebappConfigFileFromWar(docBase, contextName);
    }

    private URL getWebappConfigFileFromDirectory(File docBase, String contextName) {
        URL result = null;
        File webAppContextXml = new File(docBase, "META-INF/context.xml");
        if (webAppContextXml.exists()) {
            try {
                result = webAppContextXml.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Logger.getLogger(this.getLoggerName(this.getHost(), contextName)).log(Level.WARNING, sm.getString("aas.noContextXml", docBase), e);
            }
        }
        return result;
    }

    private URL getWebappConfigFileFromWar(File docBase, String contextName) {
        URL result = null;
        try (JarFile jar = new JarFile(docBase);){
            JarEntry entry = jar.getJarEntry("META-INF/context.xml");
            if (entry != null) {
                result = UriUtil.buildJarUrl(docBase, "META-INF/context.xml");
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getLoggerName(this.getHost(), contextName)).log(Level.WARNING, sm.getString("aas.noContextXml", docBase), e);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String[] apusicArguments = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--no-jmx")) {
                Registry.disableRegistry();
                continue;
            }
            if (!args[i].equals("--apusic")) continue;
            ArrayList<String> result = new ArrayList<String>();
            for (int j = i + 1; j < args.length; ++j) {
                result.add(args[j]);
            }
            apusicArguments = result.toArray(new String[0]);
            break;
        }
        SecurityClassLoad.securityClassLoad(Thread.currentThread().getContextClassLoader());
        Aas aas = new Aas();
        aas.init(null, apusicArguments);
        boolean await = false;
        String path = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--war")) {
                if (++i >= args.length) {
                    throw new IllegalArgumentException(sm.getString("aas.invalidCommandLine", args[i - 1]));
                }
                File war = new File(args[i]);
                aas.addWebapp(path, war.getAbsolutePath());
                continue;
            }
            if (args[i].equals("--path")) {
                if (++i >= args.length) {
                    throw new IllegalArgumentException(sm.getString("aas.invalidCommandLine", args[i - 1]));
                }
                path = args[i];
                continue;
            }
            if (args[i].equals("--await")) {
                await = true;
                continue;
            }
            if (args[i].equals("--no-jmx")) continue;
            if (args[i].equals("--apusic")) break;
            throw new IllegalArgumentException(sm.getString("aas.invalidCommandLine", args[i]));
        }
        aas.start();
        if (await) {
            aas.getServer().await();
        }
    }

    public void setDefaultConnectorCreated(boolean defaultConnectorCreated) {
        this.defaultConnectorCreated = defaultConnectorCreated;
    }

    static {
        if (JreCompat.isGraalAvailable()) {
            try (FileInputStream is = new FileInputStream(new File(System.getProperty("java.util.logging.config.file", "conf/logging.properties")));){
                LogManager.getLogManager().readConfiguration(is);
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static class ExistingStandardWrapper
    extends StandardWrapper {
        private final Servlet existing;

        public ExistingStandardWrapper(Servlet existing) {
            this.existing = existing;
            if (existing instanceof SingleThreadModel) {
                this.singleThreadModel = true;
                this.instancePool = new Stack();
            }
            this.asyncSupported = ExistingStandardWrapper.hasAsync(existing);
        }

        private static boolean hasAsync(Servlet existing) {
            boolean result = false;
            Class<?> clazz = existing.getClass();
            WebServlet ws = clazz.getAnnotation(WebServlet.class);
            if (ws != null) {
                result = ws.asyncSupported();
            }
            return result;
        }

        @Override
        public synchronized Servlet loadServlet() throws ServletException {
            if (this.singleThreadModel) {
                Servlet instance;
                try {
                    instance = (Servlet)this.existing.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new ServletException(e);
                }
                instance.init(this.facade);
                return instance;
            }
            if (!this.instanceInitialized) {
                this.existing.init(this.facade);
                this.instanceInitialized = true;
            }
            return this.existing;
        }

        @Override
        public long getAvailable() {
            return 0L;
        }

        @Override
        public boolean isUnavailable() {
            return false;
        }

        @Override
        public Servlet getServlet() {
            return this.existing;
        }

        @Override
        public String getServletClass() {
            return this.existing.getClass().getName();
        }
    }

    public static class DefaultWebXmlListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            if ("before_start".equals(event.getType())) {
                Aas.initWebappDefaults((Context)event.getLifecycle());
            }
        }
    }

    public static class FixContextListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            try {
                Context context = (Context)event.getLifecycle();
                if (event.getType().equals("configure_start")) {
                    context.setConfigured(true);
                    if (!JreCompat.isGraalAvailable()) {
                        WebAnnotationSet.loadApplicationAnnotations(context);
                    }
                    if (context.getLoginConfig() == null) {
                        context.setLoginConfig(new LoginConfig("NONE", null, null, null));
                        context.getPipeline().addValve(new NonLoginAuthenticator());
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private class SimpleRealm
    extends RealmBase {
        private SimpleRealm() {
        }

        @Override
        protected String getPassword(String username) {
            return (String)Aas.this.userPass.get(username);
        }

        @Override
        protected Principal getPrincipal(String username) {
            String pass;
            Principal p = (Principal)Aas.this.userPrincipals.get(username);
            if (p == null && (pass = (String)Aas.this.userPass.get(username)) != null) {
                p = new GenericPrincipal(username, pass, (List)Aas.this.userRoles.get(username));
                Aas.this.userPrincipals.put(username, p);
            }
            return p;
        }
    }
}

