/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.startup;

import com.apusic.aas.util.buf.UriUtil;
import com.apusic.aas.util.file.ConfigurationSource;
import com.apusic.aas.util.res.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ApusicBaseConfigurationSource
implements ConfigurationSource {
    protected static final StringManager sm = StringManager.getManager("com.apusic.ams.startup");
    private final String serverXmlPath;
    private final File apusicBaseFile;
    private final URI apusicBaseUri;

    public ApusicBaseConfigurationSource(File apusicBaseFile, String serverXmlPath) {
        this.apusicBaseFile = apusicBaseFile;
        this.apusicBaseUri = apusicBaseFile.toURI();
        this.serverXmlPath = serverXmlPath;
    }

    @Override
    public ConfigurationSource.Resource getServerXml() throws IOException {
        InputStream stream;
        IOException ioe = null;
        ConfigurationSource.Resource result = null;
        try {
            result = this.serverXmlPath == null || this.serverXmlPath.equals("conf/apusic.conf") ? ConfigurationSource.super.getServerXml() : this.getResource(this.serverXmlPath);
        }
        catch (IOException e) {
            ioe = e;
        }
        if (result == null && (stream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml")) != null) {
            try {
                result = new ConfigurationSource.Resource(stream, this.getClass().getClassLoader().getResource("server-embed.xml").toURI());
            }
            catch (URISyntaxException e) {
                stream.close();
            }
        }
        if (result == null && ioe != null) {
            throw ioe;
        }
        return result;
    }

    @Override
    public ConfigurationSource.Resource getResource(String name) throws IOException {
        if (!UriUtil.isAbsoluteURI(name)) {
            File f = new File(name);
            if (!f.isAbsolute()) {
                f = new File(this.apusicBaseFile, name);
            }
            if (f.isFile()) {
                FileInputStream fis = new FileInputStream(f);
                return new ConfigurationSource.Resource(fis, f.toURI());
            }
            InputStream stream = null;
            try {
                stream = this.getClass().getClassLoader().getResourceAsStream(name);
                if (stream != null) {
                    return new ConfigurationSource.Resource(stream, this.getClass().getClassLoader().getResource(name).toURI());
                }
            }
            catch (URISyntaxException e) {
                stream.close();
                throw new IOException(sm.getString("apusicConfigurationSource.cannotObtainURL", name), e);
            }
        }
        URI uri = null;
        try {
            uri = this.getURIInternal(name);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(sm.getString("apusicConfigurationSource.cannotObtainURL", name));
        }
        try {
            URL url = uri.toURL();
            return new ConfigurationSource.Resource(url.openConnection().getInputStream(), uri);
        }
        catch (MalformedURLException e) {
            throw new IOException(sm.getString("apusicConfigurationSource.cannotObtainURL", name), e);
        }
    }

    @Override
    public URI getURI(String name) {
        if (!UriUtil.isAbsoluteURI(name)) {
            File f = new File(name);
            if (!f.isAbsolute()) {
                f = new File(this.apusicBaseFile, name);
            }
            if (f.isFile()) {
                return f.toURI();
            }
            try {
                URL resource = this.getClass().getClassLoader().getResource(name);
                if (resource != null) {
                    return resource.toURI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getURIInternal(name);
    }

    private URI getURIInternal(String name) {
        URI uri = this.apusicBaseUri != null ? this.apusicBaseUri.resolve(name) : URI.create(name);
        return uri;
    }
}

