/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.startup;

import com.apusic.ams.security.SecurityClassLoad;
import com.apusic.ams.startup.ApusicProperties;
import com.apusic.ams.startup.ClassLoaderFactory;
import com.apusic.com.google.gson.Gson;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import com.apusic.util.CryptUtilAuthData;
import com.apusic.util.MacMain;
import com.apusic.util.RSAUtil;
import com.apusic.util.Utils;
import com.apusic.util.broker.BrokerMgrFac;
import com.apusic.util.os.Netstat;
import com.apusic.util.os.OSUtil;
import com.apusic.util.os.OSUtilFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class Bootstrap {
    private static final Log log;
    private static final Object daemonLock;
    private static volatile Bootstrap daemon;
    private static final File apusicBaseFile;
    private static final File apusicHomeFile;
    private static final Pattern PATH_PATTERN;
    private Object apusicDaemon = null;
    ClassLoader commonLoader = null;
    ClassLoader apusicLoader = null;
    ClassLoader sharedLoader = null;

    private void initClassLoaders() {
        try {
            this.commonLoader = this.createClassLoader("common", null);
            if (this.commonLoader == null) {
                this.commonLoader = this.getClass().getClassLoader();
            }
            this.apusicLoader = this.createClassLoader("server", this.commonLoader);
            this.sharedLoader = this.createClassLoader("shared", this.commonLoader);
        }
        catch (Throwable t) {
            Bootstrap.handleThrowable(t);
            log.error("Class loader creation threw exception", t);
            System.exit(1);
        }
    }

    private ClassLoader createClassLoader(String name, ClassLoader parent) throws Exception {
        String[] repositoryPaths;
        String value = ApusicProperties.getProperty(name + ".loader");
        if (value == null || value.equals("")) {
            return parent;
        }
        value = this.replace(value);
        ArrayList<ClassLoaderFactory.Repository> repositories = new ArrayList<ClassLoaderFactory.Repository>();
        for (String repository : repositoryPaths = Bootstrap.getPaths(value)) {
            try {
                URL url = new URL(repository);
                repositories.add(new ClassLoaderFactory.Repository(repository, ClassLoaderFactory.RepositoryType.URL));
            }
            catch (MalformedURLException malformedURLException) {
                if (repository.endsWith("*.jar")) {
                    repository = repository.substring(0, repository.length() - "*.jar".length());
                    repositories.add(new ClassLoaderFactory.Repository(repository, ClassLoaderFactory.RepositoryType.GLOB));
                    continue;
                }
                if (repository.endsWith(".jar")) {
                    repositories.add(new ClassLoaderFactory.Repository(repository, ClassLoaderFactory.RepositoryType.JAR));
                    continue;
                }
                repositories.add(new ClassLoaderFactory.Repository(repository, ClassLoaderFactory.RepositoryType.DIR));
            }
        }
        return ClassLoaderFactory.createClassLoader(repositories, parent);
    }

    protected String replace(String str) {
        String result = str;
        int pos_start = str.indexOf("${");
        if (pos_start >= 0) {
            StringBuilder builder = new StringBuilder();
            int pos_end = -1;
            while (pos_start >= 0) {
                builder.append(str, pos_end + 1, pos_start);
                pos_end = str.indexOf(125, pos_start + 2);
                if (pos_end < 0) {
                    pos_end = pos_start - 1;
                    break;
                }
                String propName = str.substring(pos_start + 2, pos_end);
                String replacement = propName.length() == 0 ? null : ("apusic.home".equals(propName) ? Bootstrap.getApusicHome() : ("apusic.base".equals(propName) ? Bootstrap.getApusicBase() : System.getProperty(propName)));
                if (replacement != null) {
                    builder.append(replacement);
                } else {
                    builder.append(str, pos_start, pos_end + 1);
                }
                pos_start = str.indexOf("${", pos_end + 1);
            }
            builder.append(str, pos_end + 1, str.length());
            result = builder.toString();
        }
        return result;
    }

    public void init() throws Exception {
        this.initClassLoaders();
        Thread.currentThread().setContextClassLoader(this.apusicLoader);
        SecurityClassLoad.securityClassLoad(this.apusicLoader);
        if (log.isDebugEnabled()) {
            log.debug("Loading startup class");
        }
        Class<?> startupClass = this.apusicLoader.loadClass("com.apusic.ams.startup.Apusic");
        Object startupInstance = startupClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug("Setting startup class properties");
        }
        String methodName = "setParentClassLoader";
        Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
        Object[] paramValues = new Object[]{this.sharedLoader};
        Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
        method.invoke(startupInstance, paramValues);
        this.apusicDaemon = startupInstance;
    }

    private void load(String[] arguments) throws Exception {
        Object[] param;
        Class[] paramTypes;
        String methodName = "load";
        if (arguments == null || arguments.length == 0) {
            paramTypes = null;
            param = null;
        } else {
            paramTypes = new Class[]{arguments.getClass()};
            param = new Object[]{arguments};
        }
        Method method = this.apusicDaemon.getClass().getMethod(methodName, paramTypes);
        if (log.isDebugEnabled()) {
            log.debug("Calling startup class " + method);
        }
        method.invoke(this.apusicDaemon, param);
    }

    private Object getServer() throws Exception {
        String methodName = "getServer";
        Method method = this.apusicDaemon.getClass().getMethod(methodName, new Class[0]);
        return method.invoke(this.apusicDaemon, new Object[0]);
    }

    public void init(String[] arguments) throws Exception {
        this.init();
        this.load(arguments);
    }

    public void start() throws Exception {
        if (this.apusicDaemon == null) {
            this.init();
        }
        Method method = this.apusicDaemon.getClass().getMethod("start", null);
        method.invoke(this.apusicDaemon, (Object[])null);
    }

    public void stop() throws Exception {
        block153: {
            int lic_version = 0;
            String lic_sn = null;
            String lic_cdkey = null;
            String lic_prodname = null;
            String lic_edition = null;
            String lic_editionAlias = null;
            String lic_prodversion = null;
            String lic_licensee = null;
            String lic_addressStr = "";
            String lic_authAddStr = "";
            String lic_authBy = "";
            String lic_aowedIPs = "";
            boolean lic_center = false;
            int lic_address = 0;
            int lic_connections = 0;
            long lic_datefrom = 0L;
            long lic_dateend = 0L;
            int lic_durationDays = 0;
            int lic_licenses = 0;
            Map lic_extraAttrs = null;
            String lic_ip = null;
            int lic_port = -1;
            String lic_id = "0000000000";
            String signature = null;
            byte[] lic_input = null;
            File lic_file = null;
            InputStream lic_is = null;
            int lic_granted = 2130706433;
            try {
                boolean isNormal;
                Object in;
                int _i;
                String verfile = new StringBuffer("com/apusic/").append("web/WebSe").append("rviceUtil.cl").append("ass").toString();
                byte[] lic_name = new byte[16];
                byte[] share_lic_name = new byte[16];
                byte[] share_lic_dir = new byte[16];
                long _xx = 7105912L;
                long _yy = 3343205216377071980L;
                for (_i = 8; _i > 0; --_i) {
                    lic_name[16 - _i] = (byte)_xx;
                    lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0L;
                _yy = 29401359424121196L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_name[16 - _i] = (byte)_xx;
                    share_lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0x303030L;
                _yy = 3487320404452927852L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_dir[16 - _i] = (byte)_xx;
                    share_lic_dir[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                String keypath = System.getProperty(new String(share_lic_name, 0, 0, 7));
                if (keypath != null && !keypath.equals("") && !(lic_file = new File(keypath)).exists()) {
                    lic_file = Utils.getLicFile((String)keypath);
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)(new String(share_lic_dir, 0, 0, 7) + "/" + new String(share_lic_dir, 0, 0, 7)));
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)new String(lic_name, 0, 0, 11));
                }
                lic_is = lic_file.exists() ? new FileInputStream(lic_file) : this.getClass().getClassLoader().getResourceAsStream(new String(lic_name, 0, 0, 11));
                String fileCharset = System.getProperty(new StringBuffer("lice").append("nse.en").append("coding").toString(), "UTF-8");
                StringBuffer sb = new StringBuffer();
                boolean isnew = false;
                BufferedReader ps = null;
                ps = new BufferedReader(new InputStreamReader(lic_is, fileCharset));
                ps.mark(1024);
                String line = ps.readLine();
                if (line.trim().startsWith("{")) {
                    isnew = true;
                }
                if (isnew) {
                    while (line != null) {
                        sb.append(line);
                        line = ps.readLine();
                    }
                    Gson gson = new Gson();
                    Map map0 = (Map)gson.fromJson(sb.toString(), Map.class);
                    String sign = (String)map0.get("sign");
                    String data = (String)map0.get("license");
                    boolean baomiOK = RSAUtil.verify((String)data, (String)"noMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnNs5ZCQkps9nadZnaFoMAgLyHzKHZ5Zla4YmKQfduhmqhGO6kKk+BaHaFCVQVYXeCw9o7icmyzunF0uZhh+Pgyulsuo9CcSy93hZz6Lu7RBsMufLx2Gc1xzrJykbE1VuM/HcR7UV/mRDesIR3YhYb+6Qj4x6+lALv5Rs3bY8PJwIDAQAB", (String)sign);
                    if (!baomiOK) {
                        throw new Exception("m");
                    }
                    lic_version = 1;
                    Map map = (Map)gson.fromJson(data, Map.class);
                    lic_licensee = (String)map.get("code");
                    lic_prodversion = (String)map.get("productVersion");
                    lic_datefrom = ((Double)map.get("createDate")).longValue();
                    lic_dateend = ((Double)map.get("expireDate")).longValue();
                    lic_addressStr = (String)map.get("deviceId");
                    Map groupMap = (Map)((List)map.get("groups")).get(0);
                    String connstr = (String)groupMap.get("count");
                    lic_connections = Integer.parseInt(connstr);
                    Map moduleMap = (Map)((List)groupMap.get("modules")).get(0);
                    lic_licenses = ((Double)moduleMap.get("count")).intValue();
                    String extStr = (String)map.get("extraData");
                    Map extMap = (Map)gson.fromJson(extStr, Map.class);
                    lic_extraAttrs = (Map)((Map)extMap.get("licExtProp")).get("propList");
                    lic_edition = (String)lic_extraAttrs.get("specification");
                    lic_prodname = (String)lic_extraAttrs.get("productEnName");
                    lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                    lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                    lic_id = (String)lic_extraAttrs.get("id");
                    lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                    lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                }
                if (!isnew) {
                    int _keySize;
                    ps.reset();
                    InputSource is = new InputSource(ps);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element root = doc.getDocumentElement();
                    signature = root.getAttribute("signature");
                    Class<?> base64Class = null;
                    try {
                        base64Class = Class.forName("com.apusic.util.Base64");
                    }
                    catch (Throwable t) {
                        base64Class = Class.forName("com.apusic.license.util.Base64");
                    }
                    Method decodeBase64Method = base64Class.getMethod("decodeBase64", byte[].class);
                    lic_input = (byte[])decodeBase64Method.invoke(null, new Object[]{signature.getBytes("UTF-8")});
                    byte[] _key = new byte[]{0, 65, 0, 3, 0, -116, 87, -92, -53, -71, 14, -123, 121, 41, 47, -3, -98, 60, 96, 83, 2, -102, -74, -6, 6, 33, -92, 20, -123, -28, -68, 11, 99, -94, -9, 29, -43, -34, -128, 94, -34, 39, -62, -21, -97, -116, 77, 3, -4, -60, 28, 93, -94, 6, 121, 8, 5, 20, 14, 48, 42, 19, -21, -62, -112, 31, 92, 31, -107, 1, 0, 1};
                    int _nlen = (_key[0] & 0xFF) << 8 | _key[1] & 0xFF;
                    int _elen = (_key[2] & 0xFF) << 8 | _key[3] & 0xFF;
                    byte[] _nbytes = new byte[_nlen];
                    byte[] _ebytes = new byte[_elen];
                    System.arraycopy(_key, 4, _nbytes, 0, _nlen);
                    System.arraycopy(_key, 4 + _nlen, _ebytes, 0, _elen);
                    BigInteger _n = new BigInteger(1, _nbytes);
                    BigInteger _e = new BigInteger(1, _ebytes);
                    int _inputBlockSize = _keySize = (_n.bitLength() + 7) / 8;
                    int _outputBlockSize = _keySize - 1;
                    int _outSize = (lic_input.length + _inputBlockSize - 1) / _inputBlockSize * _outputBlockSize;
                    byte[] _output = new byte[_outSize];
                    int _inputOffset = 0;
                    int _outputOffset = 0;
                    while (_inputOffset < lic_input.length) {
                        byte[] _block = new byte[_inputBlockSize];
                        int _remainder = lic_input.length - _inputOffset;
                        if (_remainder > _inputBlockSize) {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _inputBlockSize);
                        } else {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _remainder);
                        }
                        BigInteger _x = new BigInteger(1, _block);
                        BigInteger _y = _x.modPow(_e, _n);
                        _block = _y.toByteArray();
                        if (_block.length <= _outputBlockSize) {
                            System.arraycopy(_block, 0, _output, _outputOffset + _outputBlockSize - _block.length, _block.length);
                        } else {
                            System.arraycopy(_block, _block.length - _outputBlockSize, _output, _outputOffset, _outputBlockSize);
                        }
                        _inputOffset += _inputBlockSize;
                        _outputOffset += _outputBlockSize;
                    }
                    int lic_len = (_output[0] & 0xFF) << 8 | _output[1] & 0xFF;
                    int lic_off = (_output[2] & 0xFF) << 8 | _output[3] & 0xFF;
                    byte[] lic_data = new byte[lic_len];
                    for (int _i2 = 0; _i2 < lic_len; ++_i2) {
                        lic_data[_i2] = _output[lic_off];
                        lic_off = (_output[lic_off + 1] & 0xFF) << 8 | _output[lic_off + 2] & 0xFF;
                    }
                    ByteArrayInputStream _bis = new ByteArrayInputStream(lic_data);
                    DataInputStream _in = new DataInputStream(_bis);
                    lic_version = _in.readShort();
                    lic_sn = _in.readUTF();
                    lic_cdkey = _in.readUTF();
                    lic_prodname = _in.readUTF();
                    if (lic_version >= 4) {
                        String lic_extraAttrsStr;
                        lic_edition = _in.readUTF();
                        lic_editionAlias = _in.readUTF();
                        lic_prodversion = _in.readUTF();
                        lic_licensee = _in.readUTF();
                        if (lic_version == 32 || lic_version > 49) {
                            lic_addressStr = _in.readUTF();
                        } else {
                            lic_address = _in.readInt();
                        }
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_licenses = _in.readInt();
                        if (_in.available() > 0 && (lic_extraAttrsStr = _in.readUTF()) != null && !"".equals(lic_extraAttrsStr)) {
                            try {
                                Gson gson = new Gson();
                                lic_extraAttrs = (Map)gson.fromJson(lic_extraAttrsStr, Map.class);
                                lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                                lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                                lic_id = (String)lic_extraAttrs.get("id");
                                lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                                lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                            }
                            catch (Exception gson) {}
                        }
                    } else if (lic_version == 3) {
                        lic_licenses = _in.readInt();
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_address = _in.readInt();
                        if (_in.available() != 0) {
                            lic_licensee = _in.readUTF();
                        }
                    } else {
                        String _cpus = _in.readUTF();
                        lic_licenses = _cpus.endsWith("CPU") ? Integer.parseInt(_cpus.substring(0, _cpus.length() - 3)) : Integer.parseInt(_cpus);
                        lic_datefrom = _in.readLong();
                        lic_address = _in.readInt();
                        if (lic_address == -1) {
                            lic_connections = 5;
                            lic_durationDays = 15;
                        } else {
                            lic_connections = 0;
                            lic_durationDays = 0;
                        }
                    }
                    lic_ip = (lic_address >>> 24 & 0xFF) + "." + (lic_address >>> 16 & 0xFF) + "." + (lic_address >>> 8 & 0xFF) + "." + (lic_address >>> 0 & 0xFF);
                }
                boolean iscenter = lic_center;
                if ("Virtual Edition".equals(lic_edition) || iscenter) {
                    try {
                        long _timediff;
                        block152: {
                            if (!"D".equals("I")) {
                                int respLen;
                                String[] signMethods;
                                Serializable ipList;
                                SecureRandom rand;
                                FilterOutputStream out;
                                String licVersion;
                                Object reqMsg;
                                String pathid;
                                InetAddress addr;
                                Enumeration<InetAddress> iparray;
                                NetworkInterface nw;
                                Object hwmac;
                                if (lic_durationDays > 0) {
                                    long _timediff2 = System.currentTimeMillis() - lic_datefrom;
                                    if (_timediff2 >= 0L && _timediff2 < (long)lic_durationDays * 86400L * 1000L) {
                                        lic_granted = 0;
                                    } else {
                                        lic_granted = 2130706434;
                                        Socket socket = null;
                                        FilterOutputStream out2 = null;
                                        BufferedInputStream in2 = null;
                                        SecureRandom rand2 = new SecureRandom();
                                        try {
                                            StringBuffer ipList2 = new StringBuffer();
                                            hwmac = null;
                                            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                            while (all.hasMoreElements()) {
                                                byte[] mac;
                                                nw = all.nextElement();
                                                if (nw.isLoopback() || (mac = nw.getHardwareAddress()) == null) continue;
                                                iparray = nw.getInetAddresses();
                                                while (iparray.hasMoreElements()) {
                                                    addr = iparray.nextElement();
                                                    String testaddr = addr.getHostAddress();
                                                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                    ipList2.append(testaddr);
                                                    ipList2.append(",");
                                                    if (hwmac != null) continue;
                                                    StringBuffer sb2 = new StringBuffer();
                                                    byte[] tmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                                    for (int i = 0; i < tmac.length; ++i) {
                                                        String s;
                                                        if (i != 0) {
                                                            sb2.append("-");
                                                        }
                                                        sb2.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                                    }
                                                    hwmac = sb2.toString().toUpperCase();
                                                }
                                            }
                                            if (ipList2.length() == 0) {
                                                throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                            }
                                            pathid = Utils.getServerRoot();
                                            long nonce = rand2.nextLong();
                                            String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                            int authPort = lic_port;
                                            BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                            boolean usebroker = BrokerMgrFac.useBroker();
                                            if (usebroker) {
                                                String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(ipList2.toString());
                                                String[] ipPorts = ipPort.split(":");
                                                authIP = ipPorts[0];
                                                authPort = Integer.parseInt(ipPorts[1]);
                                            }
                                            StringBuilder reqData = new StringBuilder();
                                            reqData.append("version").append("=").append("2.0").append("&");
                                            reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                            reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                            reqData.append("actionFlag").append("=").append("D").append("&");
                                            reqData.append("id").append("=").append(lic_id).append("&");
                                            reqData.append("ipList").append("=").append(ipList2.toString()).append("&");
                                            reqData.append("mac").append("=").append((String)hwmac).append("&");
                                            reqData.append("signature").append("=").append(signature).append("&");
                                            reqData.append("pathID").append("=").append(pathid).append("&");
                                            reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                            String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                            reqMsg = new StringBuilder();
                                            ((StringBuilder)reqMsg).append("POST ").append("/update").append(" HTTP/1.1\r\n");
                                            ((StringBuilder)reqMsg).append("Cache-Control: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("Pragma: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Host: ").append(authIP).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Accept: text/html\r\n");
                                            ((StringBuilder)reqMsg).append("Connection: close\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                            ((StringBuilder)reqMsg).append("\r\n");
                                            ((StringBuilder)reqMsg).append(encry_reqData);
                                            socket = new Socket(authIP, authPort);
                                            out2 = new BufferedOutputStream(socket.getOutputStream());
                                            in2 = new BufferedInputStream(socket.getInputStream());
                                            out2.write(((StringBuilder)reqMsg).toString().getBytes());
                                            ((BufferedOutputStream)out2).flush();
                                            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                            byte[] buffer = new byte[1000];
                                            int len = -1;
                                            while ((len = in2.read(buffer)) != -1) {
                                                bytesOut.write(buffer, 0, len);
                                            }
                                            byte[] response = bytesOut.toByteArray();
                                            byte[] respBuffer0 = Utils.analyseAgentResponse((byte[])response);
                                            byte[] respBuffer = CryptUtilAuthData.getDecryptByte((byte[])respBuffer0);
                                            String result = new String(respBuffer, 0, 5);
                                            if ("error".equals(result)) {
                                                System.out.println(result);
                                            } else if ("okkkk".equals(result)) {
                                                int _i3;
                                                byte[] licname0 = new byte[16];
                                                byte[] licname1 = new byte[16];
                                                long _xx2 = 7105912L;
                                                long _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname1[16 - _i3] = (byte)_xx2;
                                                    licname1[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                _xx2 = 28266723269176696L;
                                                _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname0[16 - _i3] = (byte)_xx2;
                                                    licname0[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                File file0 = Utils.getLicFile((String)new String(licname0, 0, 0, 15));
                                                File file1 = Utils.getLicFile((String)new String(licname1, 0, 0, 11));
                                                if (file0.exists()) {
                                                    file0.delete();
                                                }
                                                file1.renameTo(file0);
                                                FileOutputStream fw = new FileOutputStream(file1);
                                                fw.write(respBuffer, 5, respBuffer.length - 5);
                                                fw.close();
                                                if ("M".equals("D")) {
                                                    lic_granted = 0;
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            throw ex;
                                        }
                                        finally {
                                            if (out2 != null) {
                                                try {
                                                    out2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (in2 != null) {
                                                try {
                                                    in2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (socket != null) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                        }
                                    }
                                }
                                if ("1.0".equals(licVersion = System.getProperty(new StringBuffer("com.a").append("pusic.licen").append("se.version").toString()))) {
                                    Socket socket = null;
                                    out = null;
                                    in = null;
                                    rand = new SecureRandom();
                                    try {
                                        int loopNum;
                                        int len;
                                        ipList = new ArrayList();
                                        int ipLen = 0;
                                        hwmac = null;
                                        Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                        while (all.hasMoreElements()) {
                                            byte[] mac;
                                            nw = all.nextElement();
                                            if (nw.isLoopback() || !nw.isUp() || (mac = nw.getHardwareAddress()) == null) continue;
                                            iparray = nw.getInetAddresses();
                                            while (iparray.hasMoreElements()) {
                                                addr = iparray.nextElement();
                                                String testaddr = addr.getHostAddress();
                                                byte[] binAddr = addr.getAddress();
                                                if (binAddr.length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                ipLen += 4;
                                                ipList.add(binAddr);
                                                if (hwmac != null) continue;
                                                hwmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                            }
                                        }
                                        if (ipList.isEmpty()) {
                                            throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                        }
                                        pathid = Utils.getServerRoot();
                                        BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                        boolean usebroker = BrokerMgrFac.useBroker();
                                        if (!usebroker) {
                                            socket = new Socket(lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip, lic_port);
                                        } else {
                                            String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(new String((byte[])ipList.get(0)));
                                            String[] ipPorts = ipPort.split(":");
                                            socket = new Socket(ipPorts[0], Integer.parseInt(ipPorts[1]));
                                        }
                                        out = new BufferedOutputStream(socket.getOutputStream());
                                        byte[] pre = new byte[]{77, 85, 88, 32, 97, 99, 115, 99, 13, 10};
                                        byte[] OKReply = new byte[]{43, 79, 75, 13, 10};
                                        int waittime = Integer.getInteger(new StringBuffer("com.a").append("pusic.licen").append("se.wait").toString(), 300);
                                        ByteBuffer buff = ByteBuffer.allocate(8);
                                        out.write(pre);
                                        out.write("1.0".getBytes());
                                        long nonce = rand.nextLong();
                                        out.write(buff.putLong(nonce).array());
                                        buff.clear();
                                        out.write(buff.putLong(System.currentTimeMillis()).array());
                                        out.write("D".getBytes());
                                        out.write(lic_id.getBytes());
                                        buff.clear();
                                        out.write(buff.putLong(lic_input.length).array());
                                        out.write(lic_input);
                                        buff.clear();
                                        out.write(buff.putLong(ipLen).array());
                                        reqMsg = ipList.iterator();
                                        while (reqMsg.hasNext()) {
                                            byte[] ipAddr = (byte[])reqMsg.next();
                                            out.write(ipAddr);
                                        }
                                        buff.clear();
                                        out.write(buff.putLong(((Object)hwmac).length).array());
                                        out.write((byte[])hwmac);
                                        buff.clear();
                                        out.write(buff.putLong(pathid.length()).array());
                                        out.write(pathid.getBytes());
                                        ((BufferedOutputStream)out).flush();
                                        signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                        String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                        Mac mac = Mac.getInstance(methodName);
                                        mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                        byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                        respLen = expectedResponse.length;
                                        byte[] response = new byte[respLen];
                                        byte[] resTmp = new byte[5];
                                        in = new BufferedInputStream(socket.getInputStream());
                                        int offset = len = ((FilterInputStream)in).read(resTmp);
                                        for (loopNum = 3; len < resTmp.length && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(resTmp, offset, resTmp.length - offset);
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (Arrays.equals(resTmp, OKReply)) {
                                            len = ((FilterInputStream)in).read(response);
                                        } else {
                                            System.arraycopy(resTmp, 0, response, 0, 5);
                                            len = ((BufferedInputStream)in).read(response, 5, respLen - 5);
                                            len += 5;
                                        }
                                        offset = len;
                                        for (loopNum = 3; len < respLen && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(response, offset, respLen - offset);
                                            len += count;
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (len == expectedResponse.length && Arrays.equals(response, expectedResponse)) {
                                            break block152;
                                        }
                                        throw new Exception(new String(response));
                                    }
                                    catch (IOException ex) {
                                        throw ex;
                                    }
                                    finally {
                                        if (out != null) {
                                            try {
                                                out.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (in != null) {
                                            try {
                                                ((BufferedInputStream)in).close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (socket != null) {
                                            try {
                                                socket.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                Socket socket = null;
                                out = null;
                                in = null;
                                rand = new SecureRandom();
                                try {
                                    ipList = new StringBuffer();
                                    String hwmac2 = null;
                                    Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                    while (all.hasMoreElements()) {
                                        byte[] mac;
                                        NetworkInterface nw2 = all.nextElement();
                                        if (nw2.isLoopback() || !nw2.isUp() || (mac = nw2.getHardwareAddress()) == null) continue;
                                        Enumeration<InetAddress> iparray2 = nw2.getInetAddresses();
                                        while (iparray2.hasMoreElements()) {
                                            InetAddress addr2 = iparray2.nextElement();
                                            String testaddr = addr2.getHostAddress();
                                            if (addr2.isLoopbackAddress() || addr2.isAnyLocalAddress() || addr2.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                            ((StringBuffer)ipList).append(testaddr);
                                            ((StringBuffer)ipList).append(",");
                                            if (hwmac2 != null) continue;
                                            StringBuffer sb3 = new StringBuffer();
                                            byte[] tmac = NetworkInterface.getByInetAddress(addr2).getHardwareAddress();
                                            for (int i = 0; i < tmac.length; ++i) {
                                                String s;
                                                if (i != 0) {
                                                    sb3.append("-");
                                                }
                                                sb3.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                            }
                                            hwmac2 = sb3.toString().toUpperCase();
                                        }
                                    }
                                    if (((StringBuffer)ipList).length() == 0) {
                                        throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                    }
                                    String pathid2 = Utils.getServerRoot();
                                    long nonce = rand.nextLong();
                                    String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                    int authPort = lic_port;
                                    BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                    boolean usebroker = BrokerMgrFac.useBroker();
                                    if (usebroker) {
                                        String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(((StringBuffer)ipList).toString());
                                        String[] ipPorts = ipPort.split(":");
                                        authIP = ipPorts[0];
                                        authPort = Integer.parseInt(ipPorts[1]);
                                    }
                                    StringBuilder reqData = new StringBuilder();
                                    reqData.append("version").append("=").append("2.0").append("&");
                                    reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                    reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                    reqData.append("actionFlag").append("=").append("D").append("&");
                                    reqData.append("id").append("=").append(lic_id).append("&");
                                    reqData.append("ipList").append("=").append(((StringBuffer)ipList).toString()).append("&");
                                    reqData.append("mac").append("=").append(hwmac2).append("&");
                                    reqData.append("pathID").append("=").append(pathid2).append("&");
                                    reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                    String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                    StringBuilder reqMsg2 = new StringBuilder();
                                    reqMsg2.append("POST ").append("/").append(" HTTP/1.1\r\n");
                                    reqMsg2.append("Cache-Control: no-cache\r\n");
                                    reqMsg2.append("Pragma: no-cache\r\n");
                                    reqMsg2.append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                    reqMsg2.append("Host: ").append(authIP).append("\r\n");
                                    reqMsg2.append("Accept: text/html\r\n");
                                    reqMsg2.append("Connection: close\r\n");
                                    reqMsg2.append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                    reqMsg2.append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                    reqMsg2.append("\r\n");
                                    reqMsg2.append(encry_reqData);
                                    socket = new Socket(authIP, authPort);
                                    out = new BufferedOutputStream(socket.getOutputStream());
                                    in = new BufferedInputStream(socket.getInputStream());
                                    out.write(reqMsg2.toString().getBytes());
                                    ((BufferedOutputStream)out).flush();
                                    signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                    String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                    Mac mac = Mac.getInstance(methodName);
                                    mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                    byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                    respLen = expectedResponse.length;
                                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                    byte[] buffer = new byte[100];
                                    int len = -1;
                                    while ((len = ((FilterInputStream)in).read(buffer)) != -1) {
                                        bytesOut.write(buffer, 0, len);
                                    }
                                    byte[] respBuffer = bytesOut.toByteArray();
                                    byte[] response = Utils.analyseAgentResponse((byte[])respBuffer);
                                    if (Arrays.equals(response, expectedResponse)) {
                                        break block152;
                                    }
                                    throw new Exception(new String(response));
                                }
                                catch (IOException ex) {
                                    throw ex;
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (in != null) {
                                        try {
                                            ((BufferedInputStream)in).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (socket != null) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                        }
                        lic_granted = lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0;
                        lic_address = -1;
                    }
                    catch (Throwable _ex) {
                        lic_granted = -1;
                        System.out.println(_ex.getMessage());
                        _ex.printStackTrace();
                    }
                }
                boolean bl = isNormal = !lic_center;
                if (!isNormal || "Virtual Edition".equals(lic_edition)) break block153;
                Throwable taddr = null;
                try {
                    lic_granted = 2130706435;
                    if (lic_version >= 2) {
                        boolean ck = false;
                        if (lic_aowedIPs != null && !"".equals(lic_aowedIPs)) {
                            in = lic_aowedIPs;
                            String regEx = new StringBuffer("^").append((String)in).append("\\.").append(".*$").toString();
                            Pattern p = Pattern.compile(regEx);
                            InetAddress lh = InetAddress.getLocalHost();
                            String ip = lh.getHostAddress();
                            byte[] adds = lh.getAddress();
                            if (p.matcher(ip).matches()) {
                                ck = true;
                            } else {
                                Enumeration<NetworkInterface> netInts = NetworkInterface.getNetworkInterfaces();
                                while (netInts.hasMoreElements() && !ck) {
                                    NetworkInterface networkInterface = netInts.nextElement();
                                    Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                                    while (ips.hasMoreElements() && !ck) {
                                        lh = ips.nextElement();
                                        adds = lh.getAddress();
                                        String tip = lh.getHostAddress();
                                        if (!p.matcher(tip).matches()) continue;
                                        ck = true;
                                    }
                                }
                            }
                            if (!ck) {
                                lic_address = ((adds[0] & 0xFF) << 24) + ((adds[1] & 0xFF) << 16) + ((adds[2] & 0xFF) << 8) + ((adds[3] & 0xFF) << 0);
                                throw new Exception("error");
                            }
                        }
                        if (lic_address != -1 && !lic_addressStr.equals("255.255.255.255")) {
                            lic_ip = lic_address == 0 ? lic_addressStr : lic_ip;
                            InetAddress _addr = InetAddress.getByName(lic_ip);
                            ServerSocket _ss = new ServerSocket(0, 1, _addr);
                            _ss.close();
                        }
                    }
                    if (lic_version == 1) {
                        boolean ck = false;
                        List ips = MacMain.getLocalIPs();
                        ips.add(new StringBuffer("255").append(".255").append(".255").append(".255").toString());
                        for (String ip : ips) {
                            if (!lic_addressStr.equals(MacMain.getSoftCode((String)ip))) continue;
                            ck = true;
                            break;
                        }
                        if (!"10.1.2".startsWith(lic_prodversion)) {
                            System.out.println("v");
                            ck = false;
                        }
                        if (!ck) {
                            throw new Exception("rror");
                        }
                    }
                }
                catch (Throwable _ex) {
                    taddr = _ex;
                }
                if (taddr == null) {
                    long _timediff;
                    lic_granted = lic_version == 1 ? (lic_dateend > 0L ? (System.currentTimeMillis() >= lic_datefrom && System.currentTimeMillis() <= lic_dateend ? 0 : 2130706434) : 0) : (lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0);
                }
            }
            catch (Throwable _ex0) {
                System.out.println(_ex0.getMessage());
            }
        }
        Method method = this.apusicDaemon.getClass().getMethod("stop", null);
        method.invoke(this.apusicDaemon, (Object[])null);
    }

    public void stopServer() throws Exception {
        block153: {
            int lic_version = 0;
            String lic_sn = null;
            String lic_cdkey = null;
            String lic_prodname = null;
            String lic_edition = null;
            String lic_editionAlias = null;
            String lic_prodversion = null;
            String lic_licensee = null;
            String lic_addressStr = "";
            String lic_authAddStr = "";
            String lic_authBy = "";
            String lic_aowedIPs = "";
            boolean lic_center = false;
            int lic_address = 0;
            int lic_connections = 0;
            long lic_datefrom = 0L;
            long lic_dateend = 0L;
            int lic_durationDays = 0;
            int lic_licenses = 0;
            Map lic_extraAttrs = null;
            String lic_ip = null;
            int lic_port = -1;
            String lic_id = "0000000000";
            String signature = null;
            byte[] lic_input = null;
            File lic_file = null;
            InputStream lic_is = null;
            int lic_granted = 2130706433;
            try {
                boolean isNormal;
                Object in;
                int _i;
                String verfile = new StringBuffer("com/apusic/").append("web/WebSe").append("rviceUtil.cl").append("ass").toString();
                byte[] lic_name = new byte[16];
                byte[] share_lic_name = new byte[16];
                byte[] share_lic_dir = new byte[16];
                long _xx = 7105912L;
                long _yy = 3343205216377071980L;
                for (_i = 8; _i > 0; --_i) {
                    lic_name[16 - _i] = (byte)_xx;
                    lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0L;
                _yy = 29401359424121196L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_name[16 - _i] = (byte)_xx;
                    share_lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0x303030L;
                _yy = 3487320404452927852L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_dir[16 - _i] = (byte)_xx;
                    share_lic_dir[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                String keypath = System.getProperty(new String(share_lic_name, 0, 0, 7));
                if (keypath != null && !keypath.equals("") && !(lic_file = new File(keypath)).exists()) {
                    lic_file = Utils.getLicFile((String)keypath);
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)(new String(share_lic_dir, 0, 0, 7) + "/" + new String(share_lic_dir, 0, 0, 7)));
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)new String(lic_name, 0, 0, 11));
                }
                lic_is = lic_file.exists() ? new FileInputStream(lic_file) : this.getClass().getClassLoader().getResourceAsStream(new String(lic_name, 0, 0, 11));
                String fileCharset = System.getProperty(new StringBuffer("lice").append("nse.en").append("coding").toString(), "UTF-8");
                StringBuffer sb = new StringBuffer();
                boolean isnew = false;
                BufferedReader ps = null;
                ps = new BufferedReader(new InputStreamReader(lic_is, fileCharset));
                ps.mark(1024);
                String line = ps.readLine();
                if (line.trim().startsWith("{")) {
                    isnew = true;
                }
                if (isnew) {
                    while (line != null) {
                        sb.append(line);
                        line = ps.readLine();
                    }
                    Gson gson = new Gson();
                    Map map0 = (Map)gson.fromJson(sb.toString(), Map.class);
                    String sign = (String)map0.get("sign");
                    String data = (String)map0.get("license");
                    boolean baomiOK = RSAUtil.verify((String)data, (String)"noMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnNs5ZCQkps9nadZnaFoMAgLyHzKHZ5Zla4YmKQfduhmqhGO6kKk+BaHaFCVQVYXeCw9o7icmyzunF0uZhh+Pgyulsuo9CcSy93hZz6Lu7RBsMufLx2Gc1xzrJykbE1VuM/HcR7UV/mRDesIR3YhYb+6Qj4x6+lALv5Rs3bY8PJwIDAQAB", (String)sign);
                    if (!baomiOK) {
                        throw new Exception("m");
                    }
                    lic_version = 1;
                    Map map = (Map)gson.fromJson(data, Map.class);
                    lic_licensee = (String)map.get("code");
                    lic_prodversion = (String)map.get("productVersion");
                    lic_datefrom = ((Double)map.get("createDate")).longValue();
                    lic_dateend = ((Double)map.get("expireDate")).longValue();
                    lic_addressStr = (String)map.get("deviceId");
                    Map groupMap = (Map)((List)map.get("groups")).get(0);
                    String connstr = (String)groupMap.get("count");
                    lic_connections = Integer.parseInt(connstr);
                    Map moduleMap = (Map)((List)groupMap.get("modules")).get(0);
                    lic_licenses = ((Double)moduleMap.get("count")).intValue();
                    String extStr = (String)map.get("extraData");
                    Map extMap = (Map)gson.fromJson(extStr, Map.class);
                    lic_extraAttrs = (Map)((Map)extMap.get("licExtProp")).get("propList");
                    lic_edition = (String)lic_extraAttrs.get("specification");
                    lic_prodname = (String)lic_extraAttrs.get("productEnName");
                    lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                    lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                    lic_id = (String)lic_extraAttrs.get("id");
                    lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                    lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                }
                if (!isnew) {
                    int _keySize;
                    ps.reset();
                    InputSource is = new InputSource(ps);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element root = doc.getDocumentElement();
                    signature = root.getAttribute("signature");
                    Class<?> base64Class = null;
                    try {
                        base64Class = Class.forName("com.apusic.util.Base64");
                    }
                    catch (Throwable t) {
                        base64Class = Class.forName("com.apusic.license.util.Base64");
                    }
                    Method decodeBase64Method = base64Class.getMethod("decodeBase64", byte[].class);
                    lic_input = (byte[])decodeBase64Method.invoke(null, new Object[]{signature.getBytes("UTF-8")});
                    byte[] _key = new byte[]{0, 65, 0, 3, 0, -116, 87, -92, -53, -71, 14, -123, 121, 41, 47, -3, -98, 60, 96, 83, 2, -102, -74, -6, 6, 33, -92, 20, -123, -28, -68, 11, 99, -94, -9, 29, -43, -34, -128, 94, -34, 39, -62, -21, -97, -116, 77, 3, -4, -60, 28, 93, -94, 6, 121, 8, 5, 20, 14, 48, 42, 19, -21, -62, -112, 31, 92, 31, -107, 1, 0, 1};
                    int _nlen = (_key[0] & 0xFF) << 8 | _key[1] & 0xFF;
                    int _elen = (_key[2] & 0xFF) << 8 | _key[3] & 0xFF;
                    byte[] _nbytes = new byte[_nlen];
                    byte[] _ebytes = new byte[_elen];
                    System.arraycopy(_key, 4, _nbytes, 0, _nlen);
                    System.arraycopy(_key, 4 + _nlen, _ebytes, 0, _elen);
                    BigInteger _n = new BigInteger(1, _nbytes);
                    BigInteger _e = new BigInteger(1, _ebytes);
                    int _inputBlockSize = _keySize = (_n.bitLength() + 7) / 8;
                    int _outputBlockSize = _keySize - 1;
                    int _outSize = (lic_input.length + _inputBlockSize - 1) / _inputBlockSize * _outputBlockSize;
                    byte[] _output = new byte[_outSize];
                    int _inputOffset = 0;
                    int _outputOffset = 0;
                    while (_inputOffset < lic_input.length) {
                        byte[] _block = new byte[_inputBlockSize];
                        int _remainder = lic_input.length - _inputOffset;
                        if (_remainder > _inputBlockSize) {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _inputBlockSize);
                        } else {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _remainder);
                        }
                        BigInteger _x = new BigInteger(1, _block);
                        BigInteger _y = _x.modPow(_e, _n);
                        _block = _y.toByteArray();
                        if (_block.length <= _outputBlockSize) {
                            System.arraycopy(_block, 0, _output, _outputOffset + _outputBlockSize - _block.length, _block.length);
                        } else {
                            System.arraycopy(_block, _block.length - _outputBlockSize, _output, _outputOffset, _outputBlockSize);
                        }
                        _inputOffset += _inputBlockSize;
                        _outputOffset += _outputBlockSize;
                    }
                    int lic_len = (_output[0] & 0xFF) << 8 | _output[1] & 0xFF;
                    int lic_off = (_output[2] & 0xFF) << 8 | _output[3] & 0xFF;
                    byte[] lic_data = new byte[lic_len];
                    for (int _i2 = 0; _i2 < lic_len; ++_i2) {
                        lic_data[_i2] = _output[lic_off];
                        lic_off = (_output[lic_off + 1] & 0xFF) << 8 | _output[lic_off + 2] & 0xFF;
                    }
                    ByteArrayInputStream _bis = new ByteArrayInputStream(lic_data);
                    DataInputStream _in = new DataInputStream(_bis);
                    lic_version = _in.readShort();
                    lic_sn = _in.readUTF();
                    lic_cdkey = _in.readUTF();
                    lic_prodname = _in.readUTF();
                    if (lic_version >= 4) {
                        String lic_extraAttrsStr;
                        lic_edition = _in.readUTF();
                        lic_editionAlias = _in.readUTF();
                        lic_prodversion = _in.readUTF();
                        lic_licensee = _in.readUTF();
                        if (lic_version == 32 || lic_version > 49) {
                            lic_addressStr = _in.readUTF();
                        } else {
                            lic_address = _in.readInt();
                        }
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_licenses = _in.readInt();
                        if (_in.available() > 0 && (lic_extraAttrsStr = _in.readUTF()) != null && !"".equals(lic_extraAttrsStr)) {
                            try {
                                Gson gson = new Gson();
                                lic_extraAttrs = (Map)gson.fromJson(lic_extraAttrsStr, Map.class);
                                lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                                lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                                lic_id = (String)lic_extraAttrs.get("id");
                                lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                                lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                            }
                            catch (Exception gson) {}
                        }
                    } else if (lic_version == 3) {
                        lic_licenses = _in.readInt();
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_address = _in.readInt();
                        if (_in.available() != 0) {
                            lic_licensee = _in.readUTF();
                        }
                    } else {
                        String _cpus = _in.readUTF();
                        lic_licenses = _cpus.endsWith("CPU") ? Integer.parseInt(_cpus.substring(0, _cpus.length() - 3)) : Integer.parseInt(_cpus);
                        lic_datefrom = _in.readLong();
                        lic_address = _in.readInt();
                        if (lic_address == -1) {
                            lic_connections = 5;
                            lic_durationDays = 15;
                        } else {
                            lic_connections = 0;
                            lic_durationDays = 0;
                        }
                    }
                    lic_ip = (lic_address >>> 24 & 0xFF) + "." + (lic_address >>> 16 & 0xFF) + "." + (lic_address >>> 8 & 0xFF) + "." + (lic_address >>> 0 & 0xFF);
                }
                boolean iscenter = lic_center;
                if ("Virtual Edition".equals(lic_edition) || iscenter) {
                    try {
                        long _timediff;
                        block152: {
                            if (!"D".equals("I")) {
                                int respLen;
                                String[] signMethods;
                                Serializable ipList;
                                SecureRandom rand;
                                FilterOutputStream out;
                                String licVersion;
                                Object reqMsg;
                                String pathid;
                                InetAddress addr;
                                Enumeration<InetAddress> iparray;
                                NetworkInterface nw;
                                Object hwmac;
                                if (lic_durationDays > 0) {
                                    long _timediff2 = System.currentTimeMillis() - lic_datefrom;
                                    if (_timediff2 >= 0L && _timediff2 < (long)lic_durationDays * 86400L * 1000L) {
                                        lic_granted = 0;
                                    } else {
                                        lic_granted = 2130706434;
                                        Socket socket = null;
                                        FilterOutputStream out2 = null;
                                        BufferedInputStream in2 = null;
                                        SecureRandom rand2 = new SecureRandom();
                                        try {
                                            StringBuffer ipList2 = new StringBuffer();
                                            hwmac = null;
                                            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                            while (all.hasMoreElements()) {
                                                byte[] mac;
                                                nw = all.nextElement();
                                                if (nw.isLoopback() || (mac = nw.getHardwareAddress()) == null) continue;
                                                iparray = nw.getInetAddresses();
                                                while (iparray.hasMoreElements()) {
                                                    addr = iparray.nextElement();
                                                    String testaddr = addr.getHostAddress();
                                                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                    ipList2.append(testaddr);
                                                    ipList2.append(",");
                                                    if (hwmac != null) continue;
                                                    StringBuffer sb2 = new StringBuffer();
                                                    byte[] tmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                                    for (int i = 0; i < tmac.length; ++i) {
                                                        String s;
                                                        if (i != 0) {
                                                            sb2.append("-");
                                                        }
                                                        sb2.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                                    }
                                                    hwmac = sb2.toString().toUpperCase();
                                                }
                                            }
                                            if (ipList2.length() == 0) {
                                                throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                            }
                                            pathid = Utils.getServerRoot();
                                            long nonce = rand2.nextLong();
                                            String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                            int authPort = lic_port;
                                            BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                            boolean usebroker = BrokerMgrFac.useBroker();
                                            if (usebroker) {
                                                String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(ipList2.toString());
                                                String[] ipPorts = ipPort.split(":");
                                                authIP = ipPorts[0];
                                                authPort = Integer.parseInt(ipPorts[1]);
                                            }
                                            StringBuilder reqData = new StringBuilder();
                                            reqData.append("version").append("=").append("2.0").append("&");
                                            reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                            reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                            reqData.append("actionFlag").append("=").append("D").append("&");
                                            reqData.append("id").append("=").append(lic_id).append("&");
                                            reqData.append("ipList").append("=").append(ipList2.toString()).append("&");
                                            reqData.append("mac").append("=").append((String)hwmac).append("&");
                                            reqData.append("signature").append("=").append(signature).append("&");
                                            reqData.append("pathID").append("=").append(pathid).append("&");
                                            reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                            String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                            reqMsg = new StringBuilder();
                                            ((StringBuilder)reqMsg).append("POST ").append("/update").append(" HTTP/1.1\r\n");
                                            ((StringBuilder)reqMsg).append("Cache-Control: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("Pragma: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Host: ").append(authIP).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Accept: text/html\r\n");
                                            ((StringBuilder)reqMsg).append("Connection: close\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                            ((StringBuilder)reqMsg).append("\r\n");
                                            ((StringBuilder)reqMsg).append(encry_reqData);
                                            socket = new Socket(authIP, authPort);
                                            out2 = new BufferedOutputStream(socket.getOutputStream());
                                            in2 = new BufferedInputStream(socket.getInputStream());
                                            out2.write(((StringBuilder)reqMsg).toString().getBytes());
                                            ((BufferedOutputStream)out2).flush();
                                            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                            byte[] buffer = new byte[1000];
                                            int len = -1;
                                            while ((len = in2.read(buffer)) != -1) {
                                                bytesOut.write(buffer, 0, len);
                                            }
                                            byte[] response = bytesOut.toByteArray();
                                            byte[] respBuffer0 = Utils.analyseAgentResponse((byte[])response);
                                            byte[] respBuffer = CryptUtilAuthData.getDecryptByte((byte[])respBuffer0);
                                            String result = new String(respBuffer, 0, 5);
                                            if ("error".equals(result)) {
                                                System.out.println(result);
                                            } else if ("okkkk".equals(result)) {
                                                int _i3;
                                                byte[] licname0 = new byte[16];
                                                byte[] licname1 = new byte[16];
                                                long _xx2 = 7105912L;
                                                long _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname1[16 - _i3] = (byte)_xx2;
                                                    licname1[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                _xx2 = 28266723269176696L;
                                                _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname0[16 - _i3] = (byte)_xx2;
                                                    licname0[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                File file0 = Utils.getLicFile((String)new String(licname0, 0, 0, 15));
                                                File file1 = Utils.getLicFile((String)new String(licname1, 0, 0, 11));
                                                if (file0.exists()) {
                                                    file0.delete();
                                                }
                                                file1.renameTo(file0);
                                                FileOutputStream fw = new FileOutputStream(file1);
                                                fw.write(respBuffer, 5, respBuffer.length - 5);
                                                fw.close();
                                                if ("M".equals("D")) {
                                                    lic_granted = 0;
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            throw ex;
                                        }
                                        finally {
                                            if (out2 != null) {
                                                try {
                                                    out2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (in2 != null) {
                                                try {
                                                    in2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (socket != null) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                        }
                                    }
                                }
                                if ("1.0".equals(licVersion = System.getProperty(new StringBuffer("com.a").append("pusic.licen").append("se.version").toString()))) {
                                    Socket socket = null;
                                    out = null;
                                    in = null;
                                    rand = new SecureRandom();
                                    try {
                                        int loopNum;
                                        int len;
                                        ipList = new ArrayList();
                                        int ipLen = 0;
                                        hwmac = null;
                                        Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                        while (all.hasMoreElements()) {
                                            byte[] mac;
                                            nw = all.nextElement();
                                            if (nw.isLoopback() || !nw.isUp() || (mac = nw.getHardwareAddress()) == null) continue;
                                            iparray = nw.getInetAddresses();
                                            while (iparray.hasMoreElements()) {
                                                addr = iparray.nextElement();
                                                String testaddr = addr.getHostAddress();
                                                byte[] binAddr = addr.getAddress();
                                                if (binAddr.length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                ipLen += 4;
                                                ipList.add(binAddr);
                                                if (hwmac != null) continue;
                                                hwmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                            }
                                        }
                                        if (ipList.isEmpty()) {
                                            throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                        }
                                        pathid = Utils.getServerRoot();
                                        BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                        boolean usebroker = BrokerMgrFac.useBroker();
                                        if (!usebroker) {
                                            socket = new Socket(lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip, lic_port);
                                        } else {
                                            String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(new String((byte[])ipList.get(0)));
                                            String[] ipPorts = ipPort.split(":");
                                            socket = new Socket(ipPorts[0], Integer.parseInt(ipPorts[1]));
                                        }
                                        out = new BufferedOutputStream(socket.getOutputStream());
                                        byte[] pre = new byte[]{77, 85, 88, 32, 97, 99, 115, 99, 13, 10};
                                        byte[] OKReply = new byte[]{43, 79, 75, 13, 10};
                                        int waittime = Integer.getInteger(new StringBuffer("com.a").append("pusic.licen").append("se.wait").toString(), 300);
                                        ByteBuffer buff = ByteBuffer.allocate(8);
                                        out.write(pre);
                                        out.write("1.0".getBytes());
                                        long nonce = rand.nextLong();
                                        out.write(buff.putLong(nonce).array());
                                        buff.clear();
                                        out.write(buff.putLong(System.currentTimeMillis()).array());
                                        out.write("D".getBytes());
                                        out.write(lic_id.getBytes());
                                        buff.clear();
                                        out.write(buff.putLong(lic_input.length).array());
                                        out.write(lic_input);
                                        buff.clear();
                                        out.write(buff.putLong(ipLen).array());
                                        reqMsg = ipList.iterator();
                                        while (reqMsg.hasNext()) {
                                            byte[] ipAddr = (byte[])reqMsg.next();
                                            out.write(ipAddr);
                                        }
                                        buff.clear();
                                        out.write(buff.putLong(((Object)hwmac).length).array());
                                        out.write((byte[])hwmac);
                                        buff.clear();
                                        out.write(buff.putLong(pathid.length()).array());
                                        out.write(pathid.getBytes());
                                        ((BufferedOutputStream)out).flush();
                                        signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                        String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                        Mac mac = Mac.getInstance(methodName);
                                        mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                        byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                        respLen = expectedResponse.length;
                                        byte[] response = new byte[respLen];
                                        byte[] resTmp = new byte[5];
                                        in = new BufferedInputStream(socket.getInputStream());
                                        int offset = len = ((FilterInputStream)in).read(resTmp);
                                        for (loopNum = 3; len < resTmp.length && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(resTmp, offset, resTmp.length - offset);
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (Arrays.equals(resTmp, OKReply)) {
                                            len = ((FilterInputStream)in).read(response);
                                        } else {
                                            System.arraycopy(resTmp, 0, response, 0, 5);
                                            len = ((BufferedInputStream)in).read(response, 5, respLen - 5);
                                            len += 5;
                                        }
                                        offset = len;
                                        for (loopNum = 3; len < respLen && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(response, offset, respLen - offset);
                                            len += count;
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (len == expectedResponse.length && Arrays.equals(response, expectedResponse)) {
                                            break block152;
                                        }
                                        throw new Exception(new String(response));
                                    }
                                    catch (IOException ex) {
                                        throw ex;
                                    }
                                    finally {
                                        if (out != null) {
                                            try {
                                                out.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (in != null) {
                                            try {
                                                ((BufferedInputStream)in).close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (socket != null) {
                                            try {
                                                socket.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                Socket socket = null;
                                out = null;
                                in = null;
                                rand = new SecureRandom();
                                try {
                                    ipList = new StringBuffer();
                                    String hwmac2 = null;
                                    Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                    while (all.hasMoreElements()) {
                                        byte[] mac;
                                        NetworkInterface nw2 = all.nextElement();
                                        if (nw2.isLoopback() || !nw2.isUp() || (mac = nw2.getHardwareAddress()) == null) continue;
                                        Enumeration<InetAddress> iparray2 = nw2.getInetAddresses();
                                        while (iparray2.hasMoreElements()) {
                                            InetAddress addr2 = iparray2.nextElement();
                                            String testaddr = addr2.getHostAddress();
                                            if (addr2.isLoopbackAddress() || addr2.isAnyLocalAddress() || addr2.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                            ((StringBuffer)ipList).append(testaddr);
                                            ((StringBuffer)ipList).append(",");
                                            if (hwmac2 != null) continue;
                                            StringBuffer sb3 = new StringBuffer();
                                            byte[] tmac = NetworkInterface.getByInetAddress(addr2).getHardwareAddress();
                                            for (int i = 0; i < tmac.length; ++i) {
                                                String s;
                                                if (i != 0) {
                                                    sb3.append("-");
                                                }
                                                sb3.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                            }
                                            hwmac2 = sb3.toString().toUpperCase();
                                        }
                                    }
                                    if (((StringBuffer)ipList).length() == 0) {
                                        throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                    }
                                    String pathid2 = Utils.getServerRoot();
                                    long nonce = rand.nextLong();
                                    String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                    int authPort = lic_port;
                                    BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                    boolean usebroker = BrokerMgrFac.useBroker();
                                    if (usebroker) {
                                        String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(((StringBuffer)ipList).toString());
                                        String[] ipPorts = ipPort.split(":");
                                        authIP = ipPorts[0];
                                        authPort = Integer.parseInt(ipPorts[1]);
                                    }
                                    StringBuilder reqData = new StringBuilder();
                                    reqData.append("version").append("=").append("2.0").append("&");
                                    reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                    reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                    reqData.append("actionFlag").append("=").append("D").append("&");
                                    reqData.append("id").append("=").append(lic_id).append("&");
                                    reqData.append("ipList").append("=").append(((StringBuffer)ipList).toString()).append("&");
                                    reqData.append("mac").append("=").append(hwmac2).append("&");
                                    reqData.append("pathID").append("=").append(pathid2).append("&");
                                    reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                    String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                    StringBuilder reqMsg2 = new StringBuilder();
                                    reqMsg2.append("POST ").append("/").append(" HTTP/1.1\r\n");
                                    reqMsg2.append("Cache-Control: no-cache\r\n");
                                    reqMsg2.append("Pragma: no-cache\r\n");
                                    reqMsg2.append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                    reqMsg2.append("Host: ").append(authIP).append("\r\n");
                                    reqMsg2.append("Accept: text/html\r\n");
                                    reqMsg2.append("Connection: close\r\n");
                                    reqMsg2.append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                    reqMsg2.append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                    reqMsg2.append("\r\n");
                                    reqMsg2.append(encry_reqData);
                                    socket = new Socket(authIP, authPort);
                                    out = new BufferedOutputStream(socket.getOutputStream());
                                    in = new BufferedInputStream(socket.getInputStream());
                                    out.write(reqMsg2.toString().getBytes());
                                    ((BufferedOutputStream)out).flush();
                                    signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                    String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                    Mac mac = Mac.getInstance(methodName);
                                    mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                    byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                    respLen = expectedResponse.length;
                                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                    byte[] buffer = new byte[100];
                                    int len = -1;
                                    while ((len = ((FilterInputStream)in).read(buffer)) != -1) {
                                        bytesOut.write(buffer, 0, len);
                                    }
                                    byte[] respBuffer = bytesOut.toByteArray();
                                    byte[] response = Utils.analyseAgentResponse((byte[])respBuffer);
                                    if (Arrays.equals(response, expectedResponse)) {
                                        break block152;
                                    }
                                    throw new Exception(new String(response));
                                }
                                catch (IOException ex) {
                                    throw ex;
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (in != null) {
                                        try {
                                            ((BufferedInputStream)in).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (socket != null) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                        }
                        lic_granted = lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0;
                        lic_address = -1;
                    }
                    catch (Throwable _ex) {
                        lic_granted = -1;
                        System.out.println(_ex.getMessage());
                        _ex.printStackTrace();
                    }
                }
                boolean bl = isNormal = !lic_center;
                if (!isNormal || "Virtual Edition".equals(lic_edition)) break block153;
                Throwable taddr = null;
                try {
                    lic_granted = 2130706435;
                    if (lic_version >= 2) {
                        boolean ck = false;
                        if (lic_aowedIPs != null && !"".equals(lic_aowedIPs)) {
                            in = lic_aowedIPs;
                            String regEx = new StringBuffer("^").append((String)in).append("\\.").append(".*$").toString();
                            Pattern p = Pattern.compile(regEx);
                            InetAddress lh = InetAddress.getLocalHost();
                            String ip = lh.getHostAddress();
                            byte[] adds = lh.getAddress();
                            if (p.matcher(ip).matches()) {
                                ck = true;
                            } else {
                                Enumeration<NetworkInterface> netInts = NetworkInterface.getNetworkInterfaces();
                                while (netInts.hasMoreElements() && !ck) {
                                    NetworkInterface networkInterface = netInts.nextElement();
                                    Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                                    while (ips.hasMoreElements() && !ck) {
                                        lh = ips.nextElement();
                                        adds = lh.getAddress();
                                        String tip = lh.getHostAddress();
                                        if (!p.matcher(tip).matches()) continue;
                                        ck = true;
                                    }
                                }
                            }
                            if (!ck) {
                                lic_address = ((adds[0] & 0xFF) << 24) + ((adds[1] & 0xFF) << 16) + ((adds[2] & 0xFF) << 8) + ((adds[3] & 0xFF) << 0);
                                throw new Exception("error");
                            }
                        }
                        if (lic_address != -1 && !lic_addressStr.equals("255.255.255.255")) {
                            lic_ip = lic_address == 0 ? lic_addressStr : lic_ip;
                            InetAddress _addr = InetAddress.getByName(lic_ip);
                            ServerSocket _ss = new ServerSocket(0, 1, _addr);
                            _ss.close();
                        }
                    }
                    if (lic_version == 1) {
                        boolean ck = false;
                        List ips = MacMain.getLocalIPs();
                        ips.add(new StringBuffer("255").append(".255").append(".255").append(".255").toString());
                        for (String ip : ips) {
                            if (!lic_addressStr.equals(MacMain.getSoftCode((String)ip))) continue;
                            ck = true;
                            break;
                        }
                        if (!"10.1.2".startsWith(lic_prodversion)) {
                            System.out.println("v");
                            ck = false;
                        }
                        if (!ck) {
                            throw new Exception("rror");
                        }
                    }
                }
                catch (Throwable _ex) {
                    taddr = _ex;
                }
                if (taddr == null) {
                    long _timediff;
                    lic_granted = lic_version == 1 ? (lic_dateend > 0L ? (System.currentTimeMillis() >= lic_datefrom && System.currentTimeMillis() <= lic_dateend ? 0 : 2130706434) : 0) : (lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0);
                }
            }
            catch (Throwable _ex0) {
                System.out.println(_ex0.getMessage());
            }
        }
        Method method = this.apusicDaemon.getClass().getMethod("stopServer", null);
        method.invoke(this.apusicDaemon, (Object[])null);
    }

    public void stopServer(String[] arguments) throws Exception {
        Object[] param;
        Class[] paramTypes;
        block155: {
            int lic_version = 0;
            String lic_sn = null;
            String lic_cdkey = null;
            String lic_prodname = null;
            String lic_edition = null;
            String lic_editionAlias = null;
            String lic_prodversion = null;
            String lic_licensee = null;
            String lic_addressStr = "";
            String lic_authAddStr = "";
            String lic_authBy = "";
            String lic_aowedIPs = "";
            boolean lic_center = false;
            int lic_address = 0;
            int lic_connections = 0;
            long lic_datefrom = 0L;
            long lic_dateend = 0L;
            int lic_durationDays = 0;
            int lic_licenses = 0;
            Map lic_extraAttrs = null;
            String lic_ip = null;
            int lic_port = -1;
            String lic_id = "0000000000";
            String signature = null;
            byte[] lic_input = null;
            File lic_file = null;
            InputStream lic_is = null;
            int lic_granted = 2130706433;
            try {
                boolean isNormal;
                Object in;
                int _i;
                String verfile = new StringBuffer("com/apusic/").append("web/WebSe").append("rviceUtil.cl").append("ass").toString();
                byte[] lic_name = new byte[16];
                byte[] share_lic_name = new byte[16];
                byte[] share_lic_dir = new byte[16];
                long _xx = 7105912L;
                long _yy = 3343205216377071980L;
                for (_i = 8; _i > 0; --_i) {
                    lic_name[16 - _i] = (byte)_xx;
                    lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0L;
                _yy = 29401359424121196L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_name[16 - _i] = (byte)_xx;
                    share_lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0x303030L;
                _yy = 3487320404452927852L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_dir[16 - _i] = (byte)_xx;
                    share_lic_dir[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                String keypath = System.getProperty(new String(share_lic_name, 0, 0, 7));
                if (keypath != null && !keypath.equals("") && !(lic_file = new File(keypath)).exists()) {
                    lic_file = Utils.getLicFile((String)keypath);
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)(new String(share_lic_dir, 0, 0, 7) + "/" + new String(share_lic_dir, 0, 0, 7)));
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)new String(lic_name, 0, 0, 11));
                }
                lic_is = lic_file.exists() ? new FileInputStream(lic_file) : this.getClass().getClassLoader().getResourceAsStream(new String(lic_name, 0, 0, 11));
                String fileCharset = System.getProperty(new StringBuffer("lice").append("nse.en").append("coding").toString(), "UTF-8");
                StringBuffer sb = new StringBuffer();
                boolean isnew = false;
                BufferedReader ps = null;
                ps = new BufferedReader(new InputStreamReader(lic_is, fileCharset));
                ps.mark(1024);
                String line = ps.readLine();
                if (line.trim().startsWith("{")) {
                    isnew = true;
                }
                if (isnew) {
                    while (line != null) {
                        sb.append(line);
                        line = ps.readLine();
                    }
                    Gson gson = new Gson();
                    Map map0 = (Map)gson.fromJson(sb.toString(), Map.class);
                    String sign = (String)map0.get("sign");
                    String data = (String)map0.get("license");
                    boolean baomiOK = RSAUtil.verify((String)data, (String)"noMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnNs5ZCQkps9nadZnaFoMAgLyHzKHZ5Zla4YmKQfduhmqhGO6kKk+BaHaFCVQVYXeCw9o7icmyzunF0uZhh+Pgyulsuo9CcSy93hZz6Lu7RBsMufLx2Gc1xzrJykbE1VuM/HcR7UV/mRDesIR3YhYb+6Qj4x6+lALv5Rs3bY8PJwIDAQAB", (String)sign);
                    if (!baomiOK) {
                        throw new Exception("m");
                    }
                    lic_version = 1;
                    Map map = (Map)gson.fromJson(data, Map.class);
                    lic_licensee = (String)map.get("code");
                    lic_prodversion = (String)map.get("productVersion");
                    lic_datefrom = ((Double)map.get("createDate")).longValue();
                    lic_dateend = ((Double)map.get("expireDate")).longValue();
                    lic_addressStr = (String)map.get("deviceId");
                    Map groupMap = (Map)((List)map.get("groups")).get(0);
                    String connstr = (String)groupMap.get("count");
                    lic_connections = Integer.parseInt(connstr);
                    Map moduleMap = (Map)((List)groupMap.get("modules")).get(0);
                    lic_licenses = ((Double)moduleMap.get("count")).intValue();
                    String extStr = (String)map.get("extraData");
                    Map extMap = (Map)gson.fromJson(extStr, Map.class);
                    lic_extraAttrs = (Map)((Map)extMap.get("licExtProp")).get("propList");
                    lic_edition = (String)lic_extraAttrs.get("specification");
                    lic_prodname = (String)lic_extraAttrs.get("productEnName");
                    lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                    lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                    lic_id = (String)lic_extraAttrs.get("id");
                    lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                    lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                }
                if (!isnew) {
                    int _keySize;
                    ps.reset();
                    InputSource is = new InputSource(ps);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element root = doc.getDocumentElement();
                    signature = root.getAttribute("signature");
                    Class<?> base64Class = null;
                    try {
                        base64Class = Class.forName("com.apusic.util.Base64");
                    }
                    catch (Throwable t) {
                        base64Class = Class.forName("com.apusic.license.util.Base64");
                    }
                    Method decodeBase64Method = base64Class.getMethod("decodeBase64", byte[].class);
                    lic_input = (byte[])decodeBase64Method.invoke(null, new Object[]{signature.getBytes("UTF-8")});
                    byte[] _key = new byte[]{0, 65, 0, 3, 0, -116, 87, -92, -53, -71, 14, -123, 121, 41, 47, -3, -98, 60, 96, 83, 2, -102, -74, -6, 6, 33, -92, 20, -123, -28, -68, 11, 99, -94, -9, 29, -43, -34, -128, 94, -34, 39, -62, -21, -97, -116, 77, 3, -4, -60, 28, 93, -94, 6, 121, 8, 5, 20, 14, 48, 42, 19, -21, -62, -112, 31, 92, 31, -107, 1, 0, 1};
                    int _nlen = (_key[0] & 0xFF) << 8 | _key[1] & 0xFF;
                    int _elen = (_key[2] & 0xFF) << 8 | _key[3] & 0xFF;
                    byte[] _nbytes = new byte[_nlen];
                    byte[] _ebytes = new byte[_elen];
                    System.arraycopy(_key, 4, _nbytes, 0, _nlen);
                    System.arraycopy(_key, 4 + _nlen, _ebytes, 0, _elen);
                    BigInteger _n = new BigInteger(1, _nbytes);
                    BigInteger _e = new BigInteger(1, _ebytes);
                    int _inputBlockSize = _keySize = (_n.bitLength() + 7) / 8;
                    int _outputBlockSize = _keySize - 1;
                    int _outSize = (lic_input.length + _inputBlockSize - 1) / _inputBlockSize * _outputBlockSize;
                    byte[] _output = new byte[_outSize];
                    int _inputOffset = 0;
                    int _outputOffset = 0;
                    while (_inputOffset < lic_input.length) {
                        byte[] _block = new byte[_inputBlockSize];
                        int _remainder = lic_input.length - _inputOffset;
                        if (_remainder > _inputBlockSize) {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _inputBlockSize);
                        } else {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _remainder);
                        }
                        BigInteger _x = new BigInteger(1, _block);
                        BigInteger _y = _x.modPow(_e, _n);
                        _block = _y.toByteArray();
                        if (_block.length <= _outputBlockSize) {
                            System.arraycopy(_block, 0, _output, _outputOffset + _outputBlockSize - _block.length, _block.length);
                        } else {
                            System.arraycopy(_block, _block.length - _outputBlockSize, _output, _outputOffset, _outputBlockSize);
                        }
                        _inputOffset += _inputBlockSize;
                        _outputOffset += _outputBlockSize;
                    }
                    int lic_len = (_output[0] & 0xFF) << 8 | _output[1] & 0xFF;
                    int lic_off = (_output[2] & 0xFF) << 8 | _output[3] & 0xFF;
                    byte[] lic_data = new byte[lic_len];
                    for (int _i2 = 0; _i2 < lic_len; ++_i2) {
                        lic_data[_i2] = _output[lic_off];
                        lic_off = (_output[lic_off + 1] & 0xFF) << 8 | _output[lic_off + 2] & 0xFF;
                    }
                    ByteArrayInputStream _bis = new ByteArrayInputStream(lic_data);
                    DataInputStream _in = new DataInputStream(_bis);
                    lic_version = _in.readShort();
                    lic_sn = _in.readUTF();
                    lic_cdkey = _in.readUTF();
                    lic_prodname = _in.readUTF();
                    if (lic_version >= 4) {
                        String lic_extraAttrsStr;
                        lic_edition = _in.readUTF();
                        lic_editionAlias = _in.readUTF();
                        lic_prodversion = _in.readUTF();
                        lic_licensee = _in.readUTF();
                        if (lic_version == 32 || lic_version > 49) {
                            lic_addressStr = _in.readUTF();
                        } else {
                            lic_address = _in.readInt();
                        }
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_licenses = _in.readInt();
                        if (_in.available() > 0 && (lic_extraAttrsStr = _in.readUTF()) != null && !"".equals(lic_extraAttrsStr)) {
                            try {
                                Gson gson = new Gson();
                                lic_extraAttrs = (Map)gson.fromJson(lic_extraAttrsStr, Map.class);
                                lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                                lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                                lic_id = (String)lic_extraAttrs.get("id");
                                lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                                lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                            }
                            catch (Exception gson) {}
                        }
                    } else if (lic_version == 3) {
                        lic_licenses = _in.readInt();
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_address = _in.readInt();
                        if (_in.available() != 0) {
                            lic_licensee = _in.readUTF();
                        }
                    } else {
                        String _cpus = _in.readUTF();
                        lic_licenses = _cpus.endsWith("CPU") ? Integer.parseInt(_cpus.substring(0, _cpus.length() - 3)) : Integer.parseInt(_cpus);
                        lic_datefrom = _in.readLong();
                        lic_address = _in.readInt();
                        if (lic_address == -1) {
                            lic_connections = 5;
                            lic_durationDays = 15;
                        } else {
                            lic_connections = 0;
                            lic_durationDays = 0;
                        }
                    }
                    lic_ip = (lic_address >>> 24 & 0xFF) + "." + (lic_address >>> 16 & 0xFF) + "." + (lic_address >>> 8 & 0xFF) + "." + (lic_address >>> 0 & 0xFF);
                }
                boolean iscenter = lic_center;
                if ("Virtual Edition".equals(lic_edition) || iscenter) {
                    try {
                        long _timediff;
                        block154: {
                            if (!"D".equals("I")) {
                                int respLen;
                                String[] signMethods;
                                Serializable ipList;
                                SecureRandom rand;
                                FilterOutputStream out;
                                String licVersion;
                                Object reqMsg;
                                String pathid;
                                InetAddress addr;
                                Enumeration<InetAddress> iparray;
                                NetworkInterface nw;
                                Object hwmac;
                                if (lic_durationDays > 0) {
                                    long _timediff2 = System.currentTimeMillis() - lic_datefrom;
                                    if (_timediff2 >= 0L && _timediff2 < (long)lic_durationDays * 86400L * 1000L) {
                                        lic_granted = 0;
                                    } else {
                                        lic_granted = 2130706434;
                                        Socket socket = null;
                                        FilterOutputStream out2 = null;
                                        BufferedInputStream in2 = null;
                                        SecureRandom rand2 = new SecureRandom();
                                        try {
                                            StringBuffer ipList2 = new StringBuffer();
                                            hwmac = null;
                                            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                            while (all.hasMoreElements()) {
                                                byte[] mac;
                                                nw = all.nextElement();
                                                if (nw.isLoopback() || (mac = nw.getHardwareAddress()) == null) continue;
                                                iparray = nw.getInetAddresses();
                                                while (iparray.hasMoreElements()) {
                                                    addr = iparray.nextElement();
                                                    String testaddr = addr.getHostAddress();
                                                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                    ipList2.append(testaddr);
                                                    ipList2.append(",");
                                                    if (hwmac != null) continue;
                                                    StringBuffer sb2 = new StringBuffer();
                                                    byte[] tmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                                    for (int i = 0; i < tmac.length; ++i) {
                                                        String s;
                                                        if (i != 0) {
                                                            sb2.append("-");
                                                        }
                                                        sb2.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                                    }
                                                    hwmac = sb2.toString().toUpperCase();
                                                }
                                            }
                                            if (ipList2.length() == 0) {
                                                throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                            }
                                            pathid = Utils.getServerRoot();
                                            long nonce = rand2.nextLong();
                                            String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                            int authPort = lic_port;
                                            BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                            boolean usebroker = BrokerMgrFac.useBroker();
                                            if (usebroker) {
                                                String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(ipList2.toString());
                                                String[] ipPorts = ipPort.split(":");
                                                authIP = ipPorts[0];
                                                authPort = Integer.parseInt(ipPorts[1]);
                                            }
                                            StringBuilder reqData = new StringBuilder();
                                            reqData.append("version").append("=").append("2.0").append("&");
                                            reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                            reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                            reqData.append("actionFlag").append("=").append("D").append("&");
                                            reqData.append("id").append("=").append(lic_id).append("&");
                                            reqData.append("ipList").append("=").append(ipList2.toString()).append("&");
                                            reqData.append("mac").append("=").append((String)hwmac).append("&");
                                            reqData.append("signature").append("=").append(signature).append("&");
                                            reqData.append("pathID").append("=").append(pathid).append("&");
                                            reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                            String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                            reqMsg = new StringBuilder();
                                            ((StringBuilder)reqMsg).append("POST ").append("/update").append(" HTTP/1.1\r\n");
                                            ((StringBuilder)reqMsg).append("Cache-Control: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("Pragma: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Host: ").append(authIP).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Accept: text/html\r\n");
                                            ((StringBuilder)reqMsg).append("Connection: close\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                            ((StringBuilder)reqMsg).append("\r\n");
                                            ((StringBuilder)reqMsg).append(encry_reqData);
                                            socket = new Socket(authIP, authPort);
                                            out2 = new BufferedOutputStream(socket.getOutputStream());
                                            in2 = new BufferedInputStream(socket.getInputStream());
                                            out2.write(((StringBuilder)reqMsg).toString().getBytes());
                                            ((BufferedOutputStream)out2).flush();
                                            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                            byte[] buffer = new byte[1000];
                                            int len = -1;
                                            while ((len = in2.read(buffer)) != -1) {
                                                bytesOut.write(buffer, 0, len);
                                            }
                                            byte[] response = bytesOut.toByteArray();
                                            byte[] respBuffer0 = Utils.analyseAgentResponse((byte[])response);
                                            byte[] respBuffer = CryptUtilAuthData.getDecryptByte((byte[])respBuffer0);
                                            String result = new String(respBuffer, 0, 5);
                                            if ("error".equals(result)) {
                                                System.out.println(result);
                                            } else if ("okkkk".equals(result)) {
                                                int _i3;
                                                byte[] licname0 = new byte[16];
                                                byte[] licname1 = new byte[16];
                                                long _xx2 = 7105912L;
                                                long _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname1[16 - _i3] = (byte)_xx2;
                                                    licname1[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                _xx2 = 28266723269176696L;
                                                _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname0[16 - _i3] = (byte)_xx2;
                                                    licname0[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                File file0 = Utils.getLicFile((String)new String(licname0, 0, 0, 15));
                                                File file1 = Utils.getLicFile((String)new String(licname1, 0, 0, 11));
                                                if (file0.exists()) {
                                                    file0.delete();
                                                }
                                                file1.renameTo(file0);
                                                FileOutputStream fw = new FileOutputStream(file1);
                                                fw.write(respBuffer, 5, respBuffer.length - 5);
                                                fw.close();
                                                if ("M".equals("D")) {
                                                    lic_granted = 0;
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            throw ex;
                                        }
                                        finally {
                                            if (out2 != null) {
                                                try {
                                                    out2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (in2 != null) {
                                                try {
                                                    in2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (socket != null) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                        }
                                    }
                                }
                                if ("1.0".equals(licVersion = System.getProperty(new StringBuffer("com.a").append("pusic.licen").append("se.version").toString()))) {
                                    Socket socket = null;
                                    out = null;
                                    in = null;
                                    rand = new SecureRandom();
                                    try {
                                        int loopNum;
                                        int len;
                                        ipList = new ArrayList();
                                        int ipLen = 0;
                                        hwmac = null;
                                        Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                        while (all.hasMoreElements()) {
                                            byte[] mac;
                                            nw = all.nextElement();
                                            if (nw.isLoopback() || !nw.isUp() || (mac = nw.getHardwareAddress()) == null) continue;
                                            iparray = nw.getInetAddresses();
                                            while (iparray.hasMoreElements()) {
                                                addr = iparray.nextElement();
                                                String testaddr = addr.getHostAddress();
                                                byte[] binAddr = addr.getAddress();
                                                if (binAddr.length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                ipLen += 4;
                                                ipList.add(binAddr);
                                                if (hwmac != null) continue;
                                                hwmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                            }
                                        }
                                        if (ipList.isEmpty()) {
                                            throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                        }
                                        pathid = Utils.getServerRoot();
                                        BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                        boolean usebroker = BrokerMgrFac.useBroker();
                                        if (!usebroker) {
                                            socket = new Socket(lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip, lic_port);
                                        } else {
                                            String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(new String((byte[])ipList.get(0)));
                                            String[] ipPorts = ipPort.split(":");
                                            socket = new Socket(ipPorts[0], Integer.parseInt(ipPorts[1]));
                                        }
                                        out = new BufferedOutputStream(socket.getOutputStream());
                                        byte[] pre = new byte[]{77, 85, 88, 32, 97, 99, 115, 99, 13, 10};
                                        byte[] OKReply = new byte[]{43, 79, 75, 13, 10};
                                        int waittime = Integer.getInteger(new StringBuffer("com.a").append("pusic.licen").append("se.wait").toString(), 300);
                                        ByteBuffer buff = ByteBuffer.allocate(8);
                                        out.write(pre);
                                        out.write("1.0".getBytes());
                                        long nonce = rand.nextLong();
                                        out.write(buff.putLong(nonce).array());
                                        buff.clear();
                                        out.write(buff.putLong(System.currentTimeMillis()).array());
                                        out.write("D".getBytes());
                                        out.write(lic_id.getBytes());
                                        buff.clear();
                                        out.write(buff.putLong(lic_input.length).array());
                                        out.write(lic_input);
                                        buff.clear();
                                        out.write(buff.putLong(ipLen).array());
                                        reqMsg = ipList.iterator();
                                        while (reqMsg.hasNext()) {
                                            byte[] ipAddr = (byte[])reqMsg.next();
                                            out.write(ipAddr);
                                        }
                                        buff.clear();
                                        out.write(buff.putLong(((Object)hwmac).length).array());
                                        out.write((byte[])hwmac);
                                        buff.clear();
                                        out.write(buff.putLong(pathid.length()).array());
                                        out.write(pathid.getBytes());
                                        ((BufferedOutputStream)out).flush();
                                        signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                        String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                        Mac mac = Mac.getInstance(methodName);
                                        mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                        byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                        respLen = expectedResponse.length;
                                        byte[] response = new byte[respLen];
                                        byte[] resTmp = new byte[5];
                                        in = new BufferedInputStream(socket.getInputStream());
                                        int offset = len = ((FilterInputStream)in).read(resTmp);
                                        for (loopNum = 3; len < resTmp.length && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(resTmp, offset, resTmp.length - offset);
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (Arrays.equals(resTmp, OKReply)) {
                                            len = ((FilterInputStream)in).read(response);
                                        } else {
                                            System.arraycopy(resTmp, 0, response, 0, 5);
                                            len = ((BufferedInputStream)in).read(response, 5, respLen - 5);
                                            len += 5;
                                        }
                                        offset = len;
                                        for (loopNum = 3; len < respLen && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(response, offset, respLen - offset);
                                            len += count;
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (len == expectedResponse.length && Arrays.equals(response, expectedResponse)) {
                                            break block154;
                                        }
                                        throw new Exception(new String(response));
                                    }
                                    catch (IOException ex) {
                                        throw ex;
                                    }
                                    finally {
                                        if (out != null) {
                                            try {
                                                out.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (in != null) {
                                            try {
                                                ((BufferedInputStream)in).close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (socket != null) {
                                            try {
                                                socket.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                Socket socket = null;
                                out = null;
                                in = null;
                                rand = new SecureRandom();
                                try {
                                    ipList = new StringBuffer();
                                    String hwmac2 = null;
                                    Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                    while (all.hasMoreElements()) {
                                        byte[] mac;
                                        NetworkInterface nw2 = all.nextElement();
                                        if (nw2.isLoopback() || !nw2.isUp() || (mac = nw2.getHardwareAddress()) == null) continue;
                                        Enumeration<InetAddress> iparray2 = nw2.getInetAddresses();
                                        while (iparray2.hasMoreElements()) {
                                            InetAddress addr2 = iparray2.nextElement();
                                            String testaddr = addr2.getHostAddress();
                                            if (addr2.isLoopbackAddress() || addr2.isAnyLocalAddress() || addr2.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                            ((StringBuffer)ipList).append(testaddr);
                                            ((StringBuffer)ipList).append(",");
                                            if (hwmac2 != null) continue;
                                            StringBuffer sb3 = new StringBuffer();
                                            byte[] tmac = NetworkInterface.getByInetAddress(addr2).getHardwareAddress();
                                            for (int i = 0; i < tmac.length; ++i) {
                                                String s;
                                                if (i != 0) {
                                                    sb3.append("-");
                                                }
                                                sb3.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                            }
                                            hwmac2 = sb3.toString().toUpperCase();
                                        }
                                    }
                                    if (((StringBuffer)ipList).length() == 0) {
                                        throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                    }
                                    String pathid2 = Utils.getServerRoot();
                                    long nonce = rand.nextLong();
                                    String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                    int authPort = lic_port;
                                    BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                    boolean usebroker = BrokerMgrFac.useBroker();
                                    if (usebroker) {
                                        String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(((StringBuffer)ipList).toString());
                                        String[] ipPorts = ipPort.split(":");
                                        authIP = ipPorts[0];
                                        authPort = Integer.parseInt(ipPorts[1]);
                                    }
                                    StringBuilder reqData = new StringBuilder();
                                    reqData.append("version").append("=").append("2.0").append("&");
                                    reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                    reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                    reqData.append("actionFlag").append("=").append("D").append("&");
                                    reqData.append("id").append("=").append(lic_id).append("&");
                                    reqData.append("ipList").append("=").append(((StringBuffer)ipList).toString()).append("&");
                                    reqData.append("mac").append("=").append(hwmac2).append("&");
                                    reqData.append("pathID").append("=").append(pathid2).append("&");
                                    reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                    String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                    StringBuilder reqMsg2 = new StringBuilder();
                                    reqMsg2.append("POST ").append("/").append(" HTTP/1.1\r\n");
                                    reqMsg2.append("Cache-Control: no-cache\r\n");
                                    reqMsg2.append("Pragma: no-cache\r\n");
                                    reqMsg2.append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                    reqMsg2.append("Host: ").append(authIP).append("\r\n");
                                    reqMsg2.append("Accept: text/html\r\n");
                                    reqMsg2.append("Connection: close\r\n");
                                    reqMsg2.append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                    reqMsg2.append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                    reqMsg2.append("\r\n");
                                    reqMsg2.append(encry_reqData);
                                    socket = new Socket(authIP, authPort);
                                    out = new BufferedOutputStream(socket.getOutputStream());
                                    in = new BufferedInputStream(socket.getInputStream());
                                    out.write(reqMsg2.toString().getBytes());
                                    ((BufferedOutputStream)out).flush();
                                    signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                    String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                    Mac mac = Mac.getInstance(methodName);
                                    mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                    byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                    respLen = expectedResponse.length;
                                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                    byte[] buffer = new byte[100];
                                    int len = -1;
                                    while ((len = ((FilterInputStream)in).read(buffer)) != -1) {
                                        bytesOut.write(buffer, 0, len);
                                    }
                                    byte[] respBuffer = bytesOut.toByteArray();
                                    byte[] response = Utils.analyseAgentResponse((byte[])respBuffer);
                                    if (Arrays.equals(response, expectedResponse)) {
                                        break block154;
                                    }
                                    throw new Exception(new String(response));
                                }
                                catch (IOException ex) {
                                    throw ex;
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (in != null) {
                                        try {
                                            ((BufferedInputStream)in).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (socket != null) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                        }
                        lic_granted = lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0;
                        lic_address = -1;
                    }
                    catch (Throwable _ex) {
                        lic_granted = -1;
                        System.out.println(_ex.getMessage());
                        _ex.printStackTrace();
                    }
                }
                boolean bl = isNormal = !lic_center;
                if (!isNormal || "Virtual Edition".equals(lic_edition)) break block155;
                Throwable taddr = null;
                try {
                    lic_granted = 2130706435;
                    if (lic_version >= 2) {
                        boolean ck = false;
                        if (lic_aowedIPs != null && !"".equals(lic_aowedIPs)) {
                            in = lic_aowedIPs;
                            String regEx = new StringBuffer("^").append((String)in).append("\\.").append(".*$").toString();
                            Pattern p = Pattern.compile(regEx);
                            InetAddress lh = InetAddress.getLocalHost();
                            String ip = lh.getHostAddress();
                            byte[] adds = lh.getAddress();
                            if (p.matcher(ip).matches()) {
                                ck = true;
                            } else {
                                Enumeration<NetworkInterface> netInts = NetworkInterface.getNetworkInterfaces();
                                while (netInts.hasMoreElements() && !ck) {
                                    NetworkInterface networkInterface = netInts.nextElement();
                                    Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                                    while (ips.hasMoreElements() && !ck) {
                                        lh = ips.nextElement();
                                        adds = lh.getAddress();
                                        String tip = lh.getHostAddress();
                                        if (!p.matcher(tip).matches()) continue;
                                        ck = true;
                                    }
                                }
                            }
                            if (!ck) {
                                lic_address = ((adds[0] & 0xFF) << 24) + ((adds[1] & 0xFF) << 16) + ((adds[2] & 0xFF) << 8) + ((adds[3] & 0xFF) << 0);
                                throw new Exception("error");
                            }
                        }
                        if (lic_address != -1 && !lic_addressStr.equals("255.255.255.255")) {
                            lic_ip = lic_address == 0 ? lic_addressStr : lic_ip;
                            InetAddress _addr = InetAddress.getByName(lic_ip);
                            ServerSocket _ss = new ServerSocket(0, 1, _addr);
                            _ss.close();
                        }
                    }
                    if (lic_version == 1) {
                        boolean ck = false;
                        List ips = MacMain.getLocalIPs();
                        ips.add(new StringBuffer("255").append(".255").append(".255").append(".255").toString());
                        for (String ip : ips) {
                            if (!lic_addressStr.equals(MacMain.getSoftCode((String)ip))) continue;
                            ck = true;
                            break;
                        }
                        if (!"10.1.2".startsWith(lic_prodversion)) {
                            System.out.println("v");
                            ck = false;
                        }
                        if (!ck) {
                            throw new Exception("rror");
                        }
                    }
                }
                catch (Throwable _ex) {
                    taddr = _ex;
                }
                if (taddr == null) {
                    long _timediff;
                    lic_granted = lic_version == 1 ? (lic_dateend > 0L ? (System.currentTimeMillis() >= lic_datefrom && System.currentTimeMillis() <= lic_dateend ? 0 : 2130706434) : 0) : (lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0);
                }
            }
            catch (Throwable _ex0) {
                System.out.println(_ex0.getMessage());
            }
        }
        if (arguments == null || arguments.length == 0) {
            paramTypes = null;
            param = null;
        } else {
            paramTypes = new Class[]{arguments.getClass()};
            param = new Object[]{arguments};
        }
        Method method = this.apusicDaemon.getClass().getMethod("stopServer", paramTypes);
        method.invoke(this.apusicDaemon, param);
    }

    public void setAwait(boolean await) throws Exception {
        Class[] paramTypes = new Class[]{Boolean.TYPE};
        Object[] paramValues = new Object[]{await};
        Method method = this.apusicDaemon.getClass().getMethod("setAwait", paramTypes);
        method.invoke(this.apusicDaemon, paramValues);
    }

    public boolean getAwait() throws Exception {
        Class[] paramTypes = new Class[]{};
        Object[] paramValues = new Object[]{};
        Method method = this.apusicDaemon.getClass().getMethod("getAwait", paramTypes);
        Boolean b = (Boolean)method.invoke(this.apusicDaemon, paramValues);
        return b;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Object object = daemonLock;
        synchronized (object) {
            if (daemon == null) {
                Bootstrap bootstrap = new Bootstrap();
                try {
                    bootstrap.init();
                }
                catch (Throwable t) {
                    Bootstrap.handleThrowable(t);
                    t.printStackTrace();
                    return;
                }
                daemon = bootstrap;
            } else {
                Thread.currentThread().setContextClassLoader(Bootstrap.daemon.apusicLoader);
            }
        }
        try {
            String command = "start";
            if (args.length > 0) {
                command = args[args.length - 1];
            }
            if (command.equals("startd")) {
                args[args.length - 1] = "start";
                daemon.load(args);
                daemon.start();
            } else if (command.equals("stopd")) {
                args[args.length - 1] = "stop";
                if (!daemon.stop(args)) {
                    daemon.stop();
                }
            } else if (command.equals("start")) {
                daemon.setAwait(true);
                daemon.load(args);
                daemon.start();
                if (null == daemon.getServer()) {
                    System.exit(1);
                }
            } else if (command.equals("stop")) {
                if (!daemon.stop(args)) {
                    daemon.stopServer(args);
                }
            } else if (command.equals("configtest")) {
                daemon.load(args);
                if (null == daemon.getServer()) {
                    System.exit(1);
                }
                System.exit(0);
            } else {
                if (command.equals("startApp")) {
                    daemon.doAppsAction(args, "start");
                    return;
                }
                if (command.equals("stopApp")) {
                    daemon.doAppsAction(args, "stop");
                    return;
                }
                log.warn("Bootstrap: command \"" + command + "\" does not exist.");
            }
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException && t.getCause() != null) {
                t = t.getCause();
            }
            Bootstrap.handleThrowable(t);
            t.printStackTrace();
            System.exit(1);
        }
    }

    private boolean stop(String[] args) {
        boolean result = false;
        JMXConnector connector = null;
        try {
            block15: {
                block14: {
                    connector = this.getJMXConnector(args);
                    if (connector != null) {
                        try {
                            MBeanServerConnection mbsConn = connector.getMBeanServerConnection();
                            ObjectName serverPattern = new ObjectName("*:type=Server");
                            Set<ObjectName> objectNames = mbsConn.queryNames(serverPattern, null);
                            if (!objectNames.isEmpty()) {
                                ObjectName server = objectNames.iterator().next();
                                mbsConn.invoke(server, "stopAwait", new Object[0], new String[0]);
                                log.info("Stopped server by JMX.");
                                result = true;
                            }
                        }
                        catch (Exception e) {
                            if (!log.isInfoEnabled()) break block14;
                            log.info("Can't stop AAMS by JMX, trying to kill it.", e);
                        }
                    }
                }
                if (!result) {
                    String pid = null;
                    try {
                        OSUtil os = OSUtilFactory.createOSUtil();
                        Method httpM = this.apusicDaemon.getClass().getDeclaredMethod("getHTTPPort", new Class[0]);
                        String port = (String)httpM.invoke(this.apusicDaemon, null);
                        if (port != null) {
                            Netstat netstat = os.createNetstat();
                            pid = netstat.getPidByPort(Integer.parseInt(port));
                            if (connector != null) {
                                Thread.currentThread();
                                Thread.sleep(3000L);
                            }
                            if (pid != null && !pid.isEmpty()) {
                                os.createKiller().kill(pid);
                                log.info("Stopped Server by killed.");
                                result = true;
                            } else {
                                log.info("Could not find the PID for the listen port, AAS may not be running");
                                result = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log.isInfoEnabled()) break block15;
                        log.info("Error in killing process " + pid == null ? "" : pid, e);
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info("Error in stop AAS.", e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAppsAction(String[] args, final String action) {
        boolean find = false;
        final ArrayList<String> appNames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--appName")) continue;
            String app = args[++i];
            while (!app.startsWith("--") && i != args.length - 1) {
                find = true;
                appNames.add(app);
                app = args[++i];
            }
        }
        if (!find) {
            log.warn("need appName parameter.");
            return;
        }
        final JMXConnector connector = this.getJMXConnector(args);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> f = null;
        try {
            Callable<Boolean> ft = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    MBeanServerConnection mbsConn = connector.getMBeanServerConnection();
                    for (String name : appNames) {
                        ObjectName searchPattern = new ObjectName(String.format("*:j2eeType=WebModule,name=//*/%s,*", name));
                        Set<ObjectName> searchResult = mbsConn.queryNames(searchPattern, null);
                        if (!searchResult.isEmpty()) {
                            ObjectName appMBean = searchResult.iterator().next();
                            mbsConn.invoke(appMBean, action, new Object[0], new String[0]);
                            log.warn(action + " " + name + " has Finished!");
                            continue;
                        }
                        if (!action.equals("start") || (searchResult = mbsConn.queryNames(searchPattern = new ObjectName("*:type=Deployer,*"), null)).isEmpty()) continue;
                        for (ObjectName deployMBean : searchResult) {
                            mbsConn.invoke(deployMBean, "check", new Object[]{name}, new String[]{String.class.getName()});
                        }
                        log.warn(action + " " + name + " has Finished!");
                    }
                    return true;
                }
            };
            f = executor.submit(ft);
            f.get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException to) {
            log.warn("Timeout!");
            f.cancel(true);
        }
        catch (Exception e) {
            log.warn(connector == null ? "JMX must be open!" : e.getMessage());
        }
        finally {
            if (connector != null) {
                try {
                    connector.close();
                }
                catch (IOException to) {}
            }
            executor.shutdownNow();
            System.exit(-1);
        }
    }

    private JMXConnector getJMXConnector(String[] args) {
        String port = null;
        String userName = null;
        String userPass = null;
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--port")) {
                port = args[++i];
            }
            if (args[i].equals("--userName")) {
                userName = args[++i];
            }
            if (args[i].equals("--userPass")) {
                userPass = args[++i];
            }
            if (!args[i].equals("--debug")) continue;
            debug = true;
        }
        JMXConnector connector = null;
        try {
            Method jmxM;
            if (port == null && (port = (String)(jmxM = this.apusicDaemon.getClass().getDeclaredMethod("getJMXPort", new Class[0])).invoke(this.apusicDaemon, null)) == null) {
                return null;
            }
            String conUrl = String.format("service:jmx:rmi:///jndi/rmi://localhost:%s/jmxrmi", port);
            JMXServiceURL url = new JMXServiceURL(conUrl);
            HashMap<String, String[]> environment = new HashMap<String, String[]>();
            String[] credentials = new String[]{userName, userPass};
            environment.put("jmx.remote.credentials", credentials);
            connector = JMXConnectorFactory.newJMXConnector(url, environment);
            connector.connect(environment);
        }
        catch (SecurityException se) {
            if (debug) {
                se.printStackTrace();
            }
            log.warn(se.getMessage());
            connector = null;
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            connector = null;
        }
        return connector;
    }

    public static String getApusicHome() {
        return apusicHomeFile.getPath();
    }

    public static String getApusicBase() {
        return apusicBaseFile.getPath();
    }

    public static File getApusicHomeFile() {
        return apusicHomeFile;
    }

    public static File getApusicBaseFile() {
        return apusicBaseFile;
    }

    static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof StackOverflowError) {
            return;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }

    static Throwable unwrapInvocationTargetException(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    protected static String[] getPaths(String value) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = PATH_PATTERN.matcher(value);
        while (matcher.find()) {
            String path = value.substring(matcher.start(), matcher.end());
            if ((path = path.trim()).length() == 0) continue;
            char first = path.charAt(0);
            char last = path.charAt(path.length() - 1);
            if (first == '\"' && last == '\"' && path.length() > 1) {
                path = path.substring(1, path.length() - 1);
                if ((path = path.trim()).length() == 0) {
                    continue;
                }
            } else if (path.contains("\"")) {
                throw new IllegalArgumentException("The double quote [\"] character can only be used to quote paths. It must not appear in a path. This loader path is not valid: [" + value + "]");
            }
            result.add(path);
        }
        return result.toArray(new String[0]);
    }

    static {
        File bootstrapJar;
        File f;
        log = LogFactory.getLog(Bootstrap.class);
        daemonLock = new Object();
        daemon = null;
        PATH_PATTERN = Pattern.compile("(\"[^\"]*\")|(([^,])*)");
        String userDir = System.getProperty("user.dir");
        String home = System.getProperty("apusic.home");
        File homeFile = null;
        if (home != null) {
            f = new File(home);
            try {
                homeFile = f.getCanonicalFile();
            }
            catch (IOException ioe) {
                homeFile = f.getAbsoluteFile();
            }
        }
        if (homeFile == null && (bootstrapJar = new File(userDir, "bootstrap.jar")).exists()) {
            File f2 = new File(userDir, "..");
            try {
                homeFile = f2.getCanonicalFile();
            }
            catch (IOException ioe) {
                homeFile = f2.getAbsoluteFile();
            }
        }
        if (homeFile == null) {
            f = new File(userDir);
            try {
                homeFile = f.getCanonicalFile();
            }
            catch (IOException ioe) {
                homeFile = f.getAbsoluteFile();
            }
        }
        apusicHomeFile = homeFile;
        System.setProperty("apusic.home", apusicHomeFile.getPath());
        String base = System.getProperty("apusic.base");
        if (base == null) {
            apusicBaseFile = apusicHomeFile;
        } else {
            File baseFile = new File(base);
            try {
                baseFile = baseFile.getCanonicalFile();
            }
            catch (IOException ioe) {
                baseFile = baseFile.getAbsoluteFile();
            }
            apusicBaseFile = baseFile;
        }
        System.setProperty("apusic.base", apusicBaseFile.getPath());
    }
}

