/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.startup;

import com.apusic.ams.startup.Bootstrap;
import com.apusic.ams.startup.ClassLoaderFactory;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class Tool {
    private static final Log log = LogFactory.getLog(Tool.class);
    private static boolean ant = false;
    private static final String apusicHome = System.getProperty("apusic.home");
    private static boolean common = false;
    private static boolean server = false;
    private static boolean shared = false;

    public static void main(String[] args) {
        if (apusicHome == null) {
            log.error("Must set 'apusic.home' system property");
            System.exit(1);
        }
        int index = 0;
        while (true) {
            if (index == args.length) {
                Tool.usage();
                System.exit(1);
            }
            if ("-ant".equals(args[index])) {
                ant = true;
            } else if ("-common".equals(args[index])) {
                common = true;
            } else if ("-server".equals(args[index])) {
                server = true;
            } else {
                if (!"-shared".equals(args[index])) break;
                shared = true;
            }
            ++index;
        }
        if (index > args.length) {
            Tool.usage();
            System.exit(1);
        }
        if (ant) {
            System.setProperty("ant.home", apusicHome);
        }
        ClassLoader classLoader = null;
        try {
            ArrayList<File> packed = new ArrayList<File>();
            ArrayList<File> unpacked = new ArrayList<File>();
            unpacked.add(new File(apusicHome, "classes"));
            packed.add(new File(apusicHome, "lib"));
            if (common) {
                unpacked.add(new File(apusicHome, "common" + File.separator + "classes"));
                packed.add(new File(apusicHome, "common" + File.separator + "lib"));
            }
            if (server) {
                unpacked.add(new File(apusicHome, "server" + File.separator + "classes"));
                packed.add(new File(apusicHome, "server" + File.separator + "lib"));
            }
            if (shared) {
                unpacked.add(new File(apusicHome, "shared" + File.separator + "classes"));
                packed.add(new File(apusicHome, "shared" + File.separator + "lib"));
            }
            classLoader = ClassLoaderFactory.createClassLoader(unpacked.toArray(new File[0]), packed.toArray(new File[0]), null);
        }
        catch (Throwable t) {
            Bootstrap.handleThrowable(t);
            log.error("Class loader creation threw exception", t);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> clazz = null;
        String className = args[index++];
        try {
            if (log.isDebugEnabled()) {
                log.debug("Loading application class " + className);
            }
            clazz = classLoader.loadClass(className);
        }
        catch (Throwable t) {
            Bootstrap.handleThrowable(t);
            log.error("Exception creating instance of " + className, t);
            System.exit(1);
        }
        Method method = null;
        String[] params = new String[args.length - index];
        System.arraycopy(args, index, params, 0, params.length);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Identifying main() method");
            }
            String methodName = "main";
            Class[] paramTypes = new Class[]{params.getClass()};
            method = clazz.getMethod(methodName, paramTypes);
        }
        catch (Throwable t) {
            Bootstrap.handleThrowable(t);
            log.error("Exception locating main() method", t);
            System.exit(1);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Calling main() method");
            }
            Object[] paramValues = new Object[]{params};
            method.invoke(null, paramValues);
        }
        catch (Throwable t) {
            t = Bootstrap.unwrapInvocationTargetException(t);
            Bootstrap.handleThrowable(t);
            log.error("Exception calling main() method", t);
            System.exit(1);
        }
    }

    private static void usage() {
        log.info("Usage:  java com.apusic.ams.startup.Tool [<options>] <class> [<arguments>]");
    }
}

