/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.connector;

import com.apusic.aas.util.net.JMXRMIEndPoint;
import com.apusic.aas.util.net.SSLHostConfig;
import com.apusic.aas.util.net.SocketWrapperBase;
import com.apusic.connector.AbstractProtocol;
import com.apusic.connector.Processor;
import com.apusic.connector.UpgradeProtocol;
import com.apusic.connector.UpgradeToken;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import com.apusic.util.Utils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class JMXRMIProtocol
extends AbstractProtocol<String> {
    private static final Log log = LogFactory.getLog(JMXRMIProtocol.class);
    private int port = 6868;
    private boolean auth = false;
    private String passFile = "conf/jmxremote.password";
    private String accessFile = "conf/jmxremote.access";
    private String hostName = "localhost";
    private String name = "ams-jmx";
    private String authClass = null;
    JMXConnectorServer connector = null;

    public JMXRMIProtocol() {
        super(new JMXRMIEndPoint());
        AbstractProtocol.ConnectionHandler<String> cHandler = new AbstractProtocol.ConnectionHandler<String>(this);
        this.setHandler(cHandler);
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return null;
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return null;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected String getNamePrefix() {
        return "";
    }

    @Override
    protected String getProtocolName() {
        return "JMXRMI/2.0";
    }

    @Override
    protected UpgradeProtocol getNegotiatedProtocol(String name) {
        return null;
    }

    @Override
    protected UpgradeProtocol getUpgradeProtocol(String name) {
        return null;
    }

    @Override
    protected Processor createProcessor() {
        return null;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase socket, UpgradeToken upgradeToken) {
        return null;
    }

    @Override
    public void start() throws Exception {
        if (this.getPort() == -1) {
            return;
        }
        Registry mRegistry = LocateRegistry.createRegistry(this.getPort(), null, null);
        String name = "jmxrmi";
        String hostname = this.getHostName();
        String jmxHostPort = hostname + ":" + this.getPort();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.jndi.rebind", "true");
        if (this.isAuth()) {
            JMXAuthenticator authenticator = this.getAccessController();
            if (authenticator != null) {
                env.put("jmx.remote.authenticator", authenticator);
            } else {
                File acessfile;
                String base = Utils.getServerRoot();
                File passfile = new File(this.getPassFile());
                if (!passfile.exists() && !passfile.isAbsolute()) {
                    passfile = new File(base, this.getPassFile());
                }
                if (!(acessfile = new File(this.getAccessFile())).exists() && !acessfile.isAbsolute()) {
                    acessfile = new File(base, this.getAccessFile());
                }
                if (!passfile.exists()) {
                    log.warn("no password.file,please set passFile parameter.");
                    return;
                }
                if (!acessfile.exists()) {
                    log.warn("no access.file,please set accessFile parameter.");
                    return;
                }
                env.put("jmx.remote.x.password.file", passfile.getAbsolutePath());
                env.put("jmx.remote.x.access.file", acessfile.getAbsolutePath());
            }
        }
        String urlStr = "service:jmx:rmi://" + jmxHostPort + "/jndi/rmi://" + jmxHostPort + "/" + "jmxrmi";
        this.connector = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(urlStr), env, ManagementFactory.getPlatformMBeanServer());
        this.connector.start();
        log.info(urlStr);
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.connector != null) {
            this.connector.stop();
        }
    }

    public JMXAuthenticator getAccessController() {
        try {
            if (this.getAuthClass() != null) {
                Class<?> clazz = Class.forName(this.getAuthClass());
                return (JMXAuthenticator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    public void setHostName(String address) {
        this.hostName = address;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public String getPassFile() {
        return this.passFile;
    }

    public String getAccessFile() {
        return this.accessFile;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public void setPassFile(String passFile) {
        this.passFile = passFile;
    }

    public String getAuthClass() {
        return this.authClass;
    }

    public void setAuthClass(String authClass) {
        this.authClass = authClass;
    }

    public void setAccessFile(String accessFile) {
        this.accessFile = accessFile;
    }

    public void setParseBodyMethods(String methods) {
        System.out.println(methods);
    }
}

