/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.connector;

import com.apusic.aas.util.net.SSLHostConfig;
import com.apusic.connector.Adapter;
import com.apusic.connector.JMXRMIProtocol;
import com.apusic.connector.UpgradeProtocol;
import com.apusic.connector.ajp.AjpAprProtocol;
import com.apusic.connector.ajp.AjpNioProtocol;
import com.apusic.connector.http11.Http11AprProtocol;
import com.apusic.connector.http11.Http11NioProtocol;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public interface ProtocolHandler {
    public Adapter getAdapter();

    public void setAdapter(Adapter var1);

    public Executor getExecutor();

    public void setExecutor(Executor var1);

    public ScheduledExecutorService getUtilityExecutor();

    public void setUtilityExecutor(ScheduledExecutorService var1);

    public void init() throws Exception;

    public void start() throws Exception;

    public void pause() throws Exception;

    public void resume() throws Exception;

    public void stop() throws Exception;

    public void destroy() throws Exception;

    public void closeServerSocketGraceful();

    public long awaitConnectionsClose(long var1);

    public boolean isAprRequired();

    public boolean isSendfileSupported();

    public void addSslHostConfig(SSLHostConfig var1);

    public SSLHostConfig[] findSslHostConfigs();

    public void addUpgradeProtocol(UpgradeProtocol var1);

    public UpgradeProtocol[] findUpgradeProtocols();

    default public int getDesiredBufferSize() {
        return -1;
    }

    default public String getId() {
        return null;
    }

    public static ProtocolHandler create(String protocol, boolean apr) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (protocol == null || "HTTP/1.1".equals(protocol) || !apr && Http11NioProtocol.class.getName().equals(protocol) || apr && Http11AprProtocol.class.getName().equals(protocol)) {
            if (apr) {
                return new Http11AprProtocol();
            }
            return new Http11NioProtocol();
        }
        if ("AJP/1.3".equals(protocol) || !apr && AjpNioProtocol.class.getName().equals(protocol) || apr && AjpAprProtocol.class.getName().equals(protocol)) {
            if (apr) {
                return new AjpAprProtocol();
            }
            return new AjpNioProtocol();
        }
        if ("JMXRMI/2.0".equals(protocol)) {
            return new JMXRMIProtocol();
        }
        Class<?> clazz = Class.forName(protocol);
        return (ProtocolHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

